<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
                              xmlns:wnu="http://www.govtalk.gov.uk/taxation/WNU"
							  xmlns:xalan="http://xml.apache.org/xalan"
							  xmlns:ext="xalan://com.selima.fbi.webserver.XalanExtension"							  
							  extension-element-prefixes="ext"							
							  >
<ext:cuttingRules>
	<rules>
		<exclude path="/IRenvelope/*">
			<exception path="/IRenvelope/WorksNumberUpdate"/>
		</exclude>
		<exclude path="/IRenvelope/WorksNumberUpdate/*">
			<exception path="/IRenvelope/WorksNumberUpdate/Employee"/>		
		</exclude>
		<exclude path="/IRenvelope/WorksNumberUpdate/Employee/*"/>
	</rules>
</ext:cuttingRules>							  							  							 							  
							  
<xsl:output method="xml" encoding="UTF-8"/>	

<xsl:template match="/">
<pages>
	<xsl:for-each select="//wnu:IRenvelope/wnu:WorksNumberUpdate/wnu:Employee">		
		<xsl:choose>
			<xsl:when test="position()=1">
				<page id="1">
					<keys>
						<key name="Name" default="true">Page 1 (title)</key>
					</keys>
					<rules>
						<exclude path='/IRenvelope/WorksNumberUpdate/Employee[position() >= 25]'/>
					</rules>
				</page>
			</xsl:when>
			<xsl:when test="(position() - 24) mod 66 = 1">
				<xsl:comment><xsl:value-of select="position()"/></xsl:comment>			
				<xsl:variable name="pageNum" select="2*floor((position()-24) div 66)+2"/>
				<page id="{$pageNum}">
					<keys>
						<key name="Name" default="true">Page <xsl:value-of select="$pageNum"/> (cs)</key>
					</keys>
					<rules>
						<exclude path='/IRenvelope/IRheader/*'>
							<exception path='/IRenvelope/IRheader/TestMessage'/>
						</exclude>
						<exclude path='/IRenvelope/WorksNumberUpdate/Employer'/>
						<exclude path='/IRenvelope/WorksNumberUpdate/Employee[position() &gt;= {position() + 32}]'/>						
						<exclude path='/IRenvelope/WorksNumberUpdate/Employee[position() &lt;= {position() - 1}]/*'/>
					</rules>
				</page>
			</xsl:when>
			<xsl:when test="(position() - 24) mod 66 = 33">
				<xsl:variable name="pageNum" select="2*floor((position()-24) div 66)+3"/>
				<page id="{$pageNum}">
					<keys>				
						<key name="Name" default="true">Page <xsl:value-of select="$pageNum"/> (cs)</key>
					</keys>
					<rules>
						<exclude path='/IRenvelope/IRheader/*'>
							<exception path='/IRenvelope/IRheader/TestMessage'/>
						</exclude>
						<exclude path='/IRenvelope/WorksNumberUpdate/Employer'/>
						<exclude path='/IRenvelope/WorksNumberUpdate/Employee[position() &gt;= {position() + 34}]'/>						
						<exclude path='/IRenvelope/WorksNumberUpdate/Employee[position() &lt;= {position() - 1}]/*'/>
					</rules>
				</page>
			</xsl:when>
		</xsl:choose>
	</xsl:for-each>
</pages>
</xsl:template>			  
</xsl:stylesheet>
