<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
							  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
                              xmlns:mov="http://www.govtalk.gov.uk/taxation/MOV"
							  xmlns:ext="xalan://com.selima.fbi.webserver.XalanExtension"							  
							  extension-element-prefixes="ext"
							  >
<ext:annotation
	metadata="PENNOT(2006).metadata.xsl"	
/>								  							  
<xsl:output method="html" encoding="UTF-8"/>	
<!-- These should be supplied by external stylesheet user-->
<xsl:param name="page">1</xsl:param>
<xsl:param name="issueDate.day">30</xsl:param>
<xsl:param name="issueDate.month">3</xsl:param>
<xsl:param name="issueDate.year">2006</xsl:param>


<xsl:template match="/">
<xsl:variable name="pennot" select="//mov:IRenvelope/mov:InYearMovements/mov:PensionNotification[position() = $page]"/>
<xsl:variable name="employer" select="//mov:IRenvelope/mov:InYearMovements/mov:Employer"/>
<html>
	<head>
		<title>PENNOT(2006)</title>
		<style type="text/css">
				body {
					margin: 0px;
					padding: 0px;
					color: blue;
					font: normal normal bold 11pt monospace;				
				}
					
				div {
					background: transparent none no-repeat scroll top left;
				}
				
				body * div {
					border: 1px dotted transparent;
					position: absolute;		
					text-transform: uppercase;
				}
				
				div.checkbox {
					font-family:sans-serif;text-align:center
				}
				
				div.large-text {
					font-size: 32pt
				}			
		</style>		
	</head>
	<body>
		<div style="background-image: url(images/p160_p1.png);width:790px;height:1119px">
			<div style="width:791px;height:1179px">
			
			<xsl:comment> Employee details </xsl:comment>
			<xsl:comment> Full name </xsl:comment>
			<div style="left: 180px;top: 428px;width: 425px">
				<xsl:for-each select="$pennot/mov:Name/mov:*[name()!='Ttl']">
					<xsl:value-of select="."/>&#160;
				</xsl:for-each>
				&#160;
			</div>
			
			<xsl:comment> *Mr/Mrs/Miss/Ms </xsl:comment>
			<div style="left: 622px;top: 422px;width: 20px;text-align:center">				
			<xsl:choose>
				<xsl:when test="$pennot/mov:Name/mov:Ttl != 'Mr'">
					<xsl:text>__</xsl:text>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>					
			<div style="left: 648px;top: 422px;width: 24px;font-weight:900">
				<xsl:choose>
				<xsl:when test="$pennot/mov:Name/mov:Ttl != 'Mrs'">
					<xsl:text>___</xsl:text>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>				
			</div>				
			<div style="left: 680px;top: 422px;width: 27px;">
				<xsl:choose>
				<xsl:when test="$pennot/mov:Name/mov:Ttl != 'Miss'">
					<xsl:text>____</xsl:text>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>				
			<div style="left: 715px;top: 422px;width: 20px;">
				<xsl:choose>
				<xsl:when test="$pennot/mov:Name/mov:Ttl != 'Ms'">
					<xsl:text>__</xsl:text>				
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>	
			
			<xsl:comment> Home address </xsl:comment>
			
			<div style="left: 215px;top: 466px;width: 530px;">
				<xsl:for-each select="$pennot/mov:Address/mov:Line[position() = 1]">
					<xsl:value-of select="."/>&#160;
				</xsl:for-each>
				&#160;				
			</div>		
			<div style="left: 100px;top: 502px;width: 645px;">
				<xsl:for-each select="$pennot/mov:Address/mov:Line[position() &gt; 1 and position() &lt; 4]">
					<xsl:value-of select="."/>&#160;
				</xsl:for-each>
				&#160;				
			</div>		
			<div style="left: 100px;top: 537px;width: 375px;">
				<xsl:for-each select="$pennot/mov:Address/mov:*[name() = 'Line' and position() &gt; 3 or name() = 'Country']">
					<xsl:value-of select="."/>&#160;
				</xsl:for-each>
				&#160;				
			</div>			
			
			<xsl:comment> Postcode </xsl:comment>
			<div style="left: 572px;top: 537px;width: 165px;">
				<xsl:for-each select="$pennot/mov:Address/mov:PostCode">
					<xsl:value-of select="."/>&#160;
				</xsl:for-each>
				&#160;				
			</div>			
			
			<xsl:comment> Employee's National Insurance number </xsl:comment>
			<div style="left: 445px;top: 585px;width: 25px;text-align:center">
				<xsl:choose>
					<xsl:when test="$pennot/mov:NINO">
						<xsl:value-of select="substring($pennot/mov:NINO,1,1)"/>
					</xsl:when>
					<xsl:otherwise>&#160;</xsl:otherwise>					
				</xsl:choose>
			</div>		
			<div style="left: 477px;top: 585px;width: 25px;text-align:center">
				<xsl:choose>
					<xsl:when test="$pennot/mov:NINO">
						<xsl:value-of select="substring($pennot/mov:NINO,2,1)"/>
					</xsl:when>
					<xsl:otherwise>&#160;</xsl:otherwise>					
				</xsl:choose>
			</div>
			<div style="left: 509px;top: 585px;width: 25px;text-align:center">
				<xsl:choose>
					<xsl:when test="$pennot/mov:NINO">
						<xsl:value-of select="substring($pennot/mov:NINO,3,1)"/>
					</xsl:when>
					<xsl:otherwise>&#160;</xsl:otherwise>					
				</xsl:choose>
			</div>	
			<div style="left: 541px;top: 585px;width: 25px;text-align:center">
				<xsl:choose>
					<xsl:when test="$pennot/mov:NINO">
						<xsl:value-of select="substring($pennot/mov:NINO,4,1)"/>
					</xsl:when>
					<xsl:otherwise>&#160;</xsl:otherwise>					
				</xsl:choose>
			</div>	
			<div style="left: 573px;top: 585px;width: 25px;text-align:center">
				<xsl:choose>
					<xsl:when test="$pennot/mov:NINO">
						<xsl:value-of select="substring($pennot/mov:NINO,5,1)"/>
					</xsl:when>
					<xsl:otherwise>&#160;</xsl:otherwise>					
				</xsl:choose>
			</div>	
			<div style="left: 605px;top: 585px;width: 25px;text-align:center">
				<xsl:choose>
					<xsl:when test="$pennot/mov:NINO">
						<xsl:value-of select="substring($pennot/mov:NINO,6,1)"/>
					</xsl:when>
					<xsl:otherwise>&#160;</xsl:otherwise>					
				</xsl:choose>
			</div>	
			<div style="left: 637px;top: 585px;width: 25px;text-align:center">
				<xsl:choose>
					<xsl:when test="$pennot/mov:NINO">
						<xsl:value-of select="substring($pennot/mov:NINO,7,1)"/>
					</xsl:when>
					<xsl:otherwise>&#160;</xsl:otherwise>					
				</xsl:choose>
			</div>	
			<div style="left: 669px;top: 585px;width: 25px;text-align:center">
				<xsl:choose>
					<xsl:when test="$pennot/mov:NINO">
						<xsl:value-of select="substring($pennot/mov:NINO,8,1)"/>
					</xsl:when>
					<xsl:otherwise>&#160;</xsl:otherwise>					
				</xsl:choose>
			</div>	
			<div style="left: 702px;top: 585px;width: 25px;text-align:center">
				<xsl:choose>
					<xsl:when test="$pennot/mov:NINO">
						<xsl:value-of select="substring($pennot/mov:NINO,9,1)"/>
					</xsl:when>
					<xsl:otherwise>&#160;</xsl:otherwise>					
				</xsl:choose>
			</div>	

			<xsl:comment> Employer PAYE reference </xsl:comment>			
			
			<div style="left: 295px;top: 620px;width: 180px;text-align:center">
				<xsl:value-of select="//mov:IRenvelope/mov:IRheader/mov:Keys/mov:Key[@Type='TaxOfficeNumber']"/>			
				/
				<xsl:value-of select="//mov:IRenvelope/mov:IRheader/mov:Keys/mov:Key[@Type='TaxOfficeReference']"/>								
			</div>				
			
			<xsl:comment> Date of retirement </xsl:comment>

			<div style="left: 642px;top: 620px;width: 22px;text-align:center">
				<xsl:choose>
				<xsl:when test="$pennot/mov:LeavingDate"> 
					<xsl:value-of select="substring($pennot/mov:LeavingDate,9,2)"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>				
			<div style="left: 678px;top: 620px;width: 22px;text-align:center">
				<xsl:choose>
				<xsl:when test="$pennot/mov:LeavingDate"> 			
					<xsl:value-of select="substring($pennot/mov:LeavingDate,6,2)"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>				
			</div>				
			<div style="left: 716px;top: 620px;width: 35px;text-align:center">
				<xsl:choose>
				<xsl:when test="$pennot/mov:LeavingDate"> 			
					<xsl:value-of select="substring($pennot/mov:LeavingDate,1,4)"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>				
			</div>					
			
			<xsl:comment> Total pay to date of retirement as shown on deductions working sheet </xsl:comment>
			
			<div style="left: 560px;top: 685px;width: 135px;text-align:right">
				<xsl:choose>
				<xsl:when test="$pennot/mov:LastEntries/mov:TotalPayToDate"> 
				<xsl:value-of select="format-number(floor($pennot/mov:LastEntries/mov:TotalPayToDate),'#0')"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>
			<div style="left: 706px;top: 685px;width: 34px;text-align:left">
				<xsl:choose>
				<xsl:when test="$pennot/mov:LastEntries/mov:TotalPayToDate"> 
				<xsl:value-of select="substring-after(format-number($pennot/mov:LastEntries/mov:TotalPayToDate,'0.00'),'.')"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>			
			
			<xsl:comment> Total tax in this employement to date of retirement </xsl:comment>
			<div style="left: 560px;top: 770px;width: 135px;text-align:right">
				<xsl:choose>
				<xsl:when test="$pennot/mov:LastEntries/mov:TotalTaxToDate"> 
				<xsl:value-of select="format-number(floor($pennot/mov:LastEntries/mov:TotalTaxToDate),'#0')"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>
			<div style="left: 706px;top: 770px;width: 34px;text-align:left">
				<xsl:choose>
				<xsl:when test="$pennot/mov:LastEntries/mov:TotalTaxToDate"> 
				<xsl:value-of select="substring-after(format-number($pennot/mov:LastEntries/mov:TotalTaxToDate,'0.00'),'.')"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>		
			
			<xsl:comment> Amount of pension each * week/four weeks/month/year </xsl:comment>
			<xsl:comment> Delete as appropriate or specify if interval differs </xsl:comment>
			
			<div style="left: 295px;top: 790px;width: 180px;">
				<xsl:text>____________________</xsl:text>
			</div>		
			<div style="left: 560px;top: 812px;width: 135px;text-align:right">
				<xsl:choose>
				<xsl:when test="$pennot/mov:AnnualPension"> 
				<xsl:value-of select="format-number(floor($pennot/mov:AnnualPension),'#0')"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>
			<div style="left: 706px;top: 812px;width: 34px;text-align:left">
				<xsl:choose>
				<xsl:when test="$pennot/mov:AnnualPension"> 
				<xsl:value-of select="substring-after(format-number($pennot/mov:AnnualPension,'0.00'),'.')"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>
			
			<xsl:comment> Pension payroll number, if any </xsl:comment>
			<div style="left: 335px;top: 848px;width: 409px;text-align:left">
				<xsl:choose>
				<xsl:when test="$pennot/mov:PensionNumber"> 
				<xsl:value-of select="$pennot/mov:PensionNumber"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>			

			<xsl:comment> Employer's name </xsl:comment>
			<div style="left: 230px;top: 940px;width: 512px;text-align:left">
				<xsl:choose>
				<xsl:when test="$employer/mov:Name"> 
				<xsl:value-of select="$employer/mov:Name"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>		
			
			<xsl:comment> Address </xsl:comment>
			
			<div style="left: 165px;top: 976px;width: 530px;">
				<xsl:for-each select="$employer/mov:Address/mov:Line[position() = 1]">
					<xsl:value-of select="."/>&#160;
				</xsl:for-each>
				&#160;
			</div>		
			<div style="left: 100px;top: 1009px;width: 645px;">
				<xsl:for-each select="$employer/mov:Address/mov:Line[position() &gt; 1 and position() &lt; 4]">
					<xsl:value-of select="."/>&#160;
				</xsl:for-each>
				&#160;
			</div>		
			<div style="left: 100px;top: 1042px;width: 375px;">
				<xsl:for-each select="$employer/mov:Address/mov:*[name() = 'Line' and position() &gt; 3 or name() = 'Country']">
					<xsl:value-of select="."/>&#160;
				</xsl:for-each>
				&#160;
			</div>			
			
			<xsl:comment> Postcode </xsl:comment>
			<div style="left: 572px;top: 1042px;width: 165px;">
				<xsl:for-each select="$employer/mov:Address/mov:PostCode">
					<xsl:value-of select="."/>&#160;
				</xsl:for-each>
				&#160;
			</div>			
			
			</div>
		</div>	
	</body>
</html>	
</xsl:template>			  
</xsl:stylesheet>
