<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
                              xmlns:mov="http://www.govtalk.gov.uk/taxation/MOV"
							  xmlns:ext="xalan://com.selima.fbi.webserver.XalanExtension"							  
							  extension-element-prefixes="ext"							
							  >
<ext:cuttingRules>
	<rules>
		<exclude path="/IRenvelope/IRheader"/>
		<exclude path="/IRenvelope/InYearMovements/*">
			<exception path="/IRenvelope/InYearMovements/PensionNotification"/>
		</exclude>
		<exclude path="/IRenvelope/InYearMovements/PensionNotification/*">
			<exception path="/IRenvelope/InYearMovements/PensionNotification/Name"/>
		</exclude>
	</rules>
</ext:cuttingRules>

<xsl:output method="xml" encoding="UTF-8"/>	

<xsl:template match="/">
<pages>
		<xsl:for-each select="//mov:IRenvelope/mov:InYearMovements/mov:PensionNotification">
			<page id="{position()}">
				<exception path="/IRenvelope/InYearMovements/PENNOT/Name"/>
				<keys>
					<key name="Name" default="true"><xsl:value-of select="mov:Name/mov:Sur"/> 
						<xsl:for-each select="mov:Name/mov:Fore">
								<xsl:if test="position() != 1">,</xsl:if>
								<xsl:value-of select="concat(' ',string(.))"/>
						</xsl:for-each>
					</key>
				</keys>				
				<rules>
					<exclude path='/IRenvelope/InYearMovements/PensionNotification[position() &gt;= {position() + 1}]'/>
					<exclude path='/IRenvelope/InYearMovements/PensionNotification/*'>
						<exception path='/IRenvelope/InYearMovements/PensionNotification[{position()}]/*'/>
					</exclude>						
				</rules>				
			</page>	
		</xsl:for-each>
</pages>
</xsl:template>

</xsl:stylesheet>
