<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
							  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
                              xmlns:mov="selima:FBI Rendering"
							  xmlns:ext="xalan://com.selima.fbi.webserver.XalanExtension"
							  extension-element-prefixes="ext"
							  >
<ext:annotation
	metadata="P46(base).metadata.xsl"
	rewrite_from_ns="http://www.govtalk.gov.uk/taxation/PAYE/MOV/09-10/1"
    rewrite_to_ns="selima:FBI Rendering"
/>								  							  							 							  
							  
<xsl:output method="html" encoding="UTF-8"/>	
<!-- These should be supplied by external stylesheet user-->
<xsl:param name="page">2</xsl:param>
<xsl:param name="issueDate.day">30</xsl:param>
<xsl:param name="issueDate.month">03</xsl:param>
<xsl:param name="issueDate.year">2010</xsl:param>

<xsl:template match="/">

<xsl:variable name="p46" select="//mov:IRenvelope/mov:InYearMovements/mov:P46[position() = floor(($page+1) div 2)]"/>
<html>
	<head>
		<title>P46(2010)</title>
		<style type="text/css">
				body {
					margin: 0px;
					padding: 0px;
					color: blue;
					font: normal normal bold 11pt monospace;
				}
					
				div {
					background: transparent none no-repeat scroll top left;
				}
				
				body * div {
					position: absolute;
					border: 1px dotted transparent;
				}
				
				div.checkbox {
					font-family:sans-serif;text-align:center
				}
				
				div.large-text {
					font-size: 32pt
				}
		</style>
	</head>
	<body>
		<xsl:choose>
		<xsl:when test="$page mod 2 = 1 ">
		<div style="background-image: url(images/p46_2009_p1.png);width:794px;height:1123px">
			<div style="width:794px;height:1123px">
			<xsl:comment> Your details</xsl:comment>
			<xsl:comment> 
					National Insurance number 
					This is very important in getting your tax and benefits right.
			</xsl:comment>

			<ext:boxText text="{substring($p46/mov:NINO,1,2)}" left="60" top="293" size="20"/>
			<ext:boxText text="{substring($p46/mov:NINO,3,2)}" left="111" top="293" size="20"/>
			<ext:boxText text="{substring($p46/mov:NINO,5,2)}" left="162" top="293" size="20"/>
			<ext:boxText text="{substring($p46/mov:NINO,7,2)}" left="213" top="293" size="20"/>
			<ext:boxText text="{substring($p46/mov:NINO,9,1)}" left="265" top="293" size="20"/>
				
			<xsl:comment> Date of birth	DD MM YYYY</xsl:comment>
			<ext:boxText text="{substring($p46/mov:BirthDate,9,2)}" left="416" top="273" size="20"/>
			<ext:boxText text="{substring($p46/mov:BirthDate,6,2)}" left="466" top="273" size="20"/>
			<ext:boxText text="{substring($p46/mov:BirthDate,1,4)}" left="517" top="273" size="20.5"/>

			<xsl:comment> Title - enter MR, MRS, MISS, MS or other title </xsl:comment>
			<div style="left:62px;top:348px;width:287px;text-transform:uppercase">
				<xsl:choose>
				<xsl:when test="$p46/mov:Name/mov:Ttl">
					<xsl:value-of select="$p46/mov:Name/mov:Ttl"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>

			<xsl:comment> Address </xsl:comment>
			<xsl:comment> House or flat number </xsl:comment>

			<xsl:comment> Surname or family name </xsl:comment>
			<xsl:if test="$p46/mov:Name/mov:Sur">
				<xsl:for-each select="ext:multiLineBoxes($p46/mov:Name/mov:Sur,61,402,33.5,20.75,2,14,7)">
					<xsl:copy-of select="."/>
				</xsl:for-each>	
			</xsl:if>

			<xsl:comment> Rest of address including house name or flat name </xsl:comment>
			<xsl:if test="$p46/mov:Address/mov:Line">
				<xsl:for-each select="ext:multiLineBoxes($p46/mov:Address/mov:Line,416,414,33.9,20.5,5,14,0)">							
					<xsl:copy-of select="."/>
				</xsl:for-each>
			</xsl:if>

			<xsl:comment> First or given name(s) </xsl:comment>
			<xsl:if test="$p46/mov:Name/mov:Fore">
				<xsl:for-each select="ext:multiLineBoxes($p46/mov:Name/mov:Fore,61,523,33,20.5,2,14,7)">							
					<xsl:copy-of select="."/>
				</xsl:for-each>
			</xsl:if>

			<xsl:comment> Postcode </xsl:comment>
			<xsl:if test="$p46/mov:Address/mov:PostCode">
				<ext:boxText text="{substring($p46/mov:Address/mov:PostCode,1,4)}" left="415" top="602" size="20.5"/>
				<ext:boxText text="{substring($p46/mov:Address/mov:PostCode,5,4)}" left="508" top="602" size="20.5"/>	
			</xsl:if>

			<xsl:comment> Gender. Enter 'X' in the appropriate box </xsl:comment>
			<xsl:comment> Male </xsl:comment>
			<div style="left:97px;top:656px;width:20px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p46/mov:Gender='male'">X</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>
			<xsl:comment> Female </xsl:comment>
			<div style="left:187px;top:656px;width:20px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p46/mov:Gender='female'">X</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>	
			
			<xsl:comment> Your present circumstances </xsl:comment>
			
			<xsl:comment> 
					Please read all the following statements carefully and enter 'X'
					in the one box that applies to you. 
			</xsl:comment>
		
			<xsl:comment>		
					A - This is my first job since last 6 April and
						I have not been receiving taxable Jobseeker's
						Allowance or taxable Incapacity Benefit
						or a state or occupational pension.			
			</xsl:comment>
			
			<div style="left:351px;top:804px;width:20px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p46/@Statement='A'">X</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>
			
			<xsl:comment>
				OR
					B - This is now my only job, but since last 6 April
					I have had another job, or have received
					taxable Jobseeker's Allowance or Incapacity
					Benefit. I do not receive a state or
					occupational pension.
			</xsl:comment>
			
			<div style="left:351px;top:905px;width:20px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p46/@Statement='B'">X</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>			
			
			<xsl:comment>
			
				OR
					C - I have another job or receive a state or
					occupational pension.			
			</xsl:comment>
			
			<div style="left:351px;top:955px;width:20px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p46/@Statement='C'">X</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>
			
			<xsl:comment> Student Loans </xsl:comment>
			<xsl:comment>
					If you left a course of Higher Education before last
					6 April and received your first Student Loan
					instalment on or after 1 September 1998 and
					you have not fully repaid your student loan,
					enter 'X' in box D. (If you are required to repay your
					Student Loan through your bank or building
					society account do not enter an 'X' in box D.)						
			</xsl:comment>
			<div style="left:708px;top:817px;width:20px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p46/mov:StudentLoanIndicator">X</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>			
			
			
			<xsl:comment> Signature and date </xsl:comment>			
			<xsl:comment> I can confirm that this information is correct </xsl:comment>
			<xsl:comment> Signature </xsl:comment>
			<div style="left:420px;top: 933px;width: 284px;text-align:center">
				Not Applicable
			</div>				
			<xsl:comment> Date </xsl:comment>
			
			<xsl:if test="$issueDate.day != '&#160;'">
				<ext:boxText text="{format-number($issueDate.day,'00')}" left="418" top="1009" size="20"/>
				<ext:boxText text="{format-number($issueDate.month,'00')}" left="469" top="1009" size="20"/>
				<ext:boxText text="{$issueDate.year}" left="520" top="1009" size="20"/>
			</xsl:if>
			
			</div>
		</div>
		
		</xsl:when>
		<xsl:otherwise>
		<div style="background-image: url(images/p46_2009_p2.png);width:794px;height:1124px">
			<div style="width:794px;height:1124px">

			<xsl:comment> Employee's details </xsl:comment>
			<xsl:comment> Date employment started </xsl:comment>
			
			<xsl:if test="$p46/mov:StartDate">
				<ext:boxText text="{substring($p46/mov:StartDate,9,2)}" left="60" top="242" size="20"/>
				<ext:boxText text="{substring($p46/mov:StartDate,6,2)}" left="111" top="242" size="20"/>
				<ext:boxText text="{substring($p46/mov:StartDate,1,4)}" left="162" top="242" size="20.5"/>
			</xsl:if>				
			
			<xsl:comment> Works/payroll number and department or branch (if any) </xsl:comment>
			
			<div style="left:418px;top:243px;width:286px;text-transform:uppercase">
				<xsl:choose>
				<xsl:when test="$p46/mov:WorksNumber">
					<xsl:value-of select="$p46/mov:WorksNumber"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>				

			<xsl:comment> Job title </xsl:comment>
			
			<xsl:if test="$p46/mov:JobTitle">			
				<xsl:for-each select="ext:multiLineBoxes($p46/mov:JobTitle,62,309,33,20.5,1,14,5)">
					<xsl:copy-of select="."/>
				</xsl:for-each>
			</xsl:if>				

			<xsl:comment> Employer's details </xsl:comment>
			
			<xsl:comment> Employer PAYE reference </xsl:comment>
			<xsl:comment> Office number</xsl:comment>			
			<ext:boxText text="{//mov:IRenvelope/mov:IRheader/mov:Keys/mov:Key[@Type='TaxOfficeNumber']}" left="61" top="467" size="20"/>
			<xsl:comment> Reference number</xsl:comment>
			<ext:boxText text="{//mov:IRenvelope/mov:IRheader/mov:Keys/mov:Key[@Type='TaxOfficeReference']}" left="144" top="467" size="20.5"/>

			<xsl:comment> Address </xsl:comment>
			<xsl:comment> Building number</xsl:comment>
			<xsl:comment> Rest of address</xsl:comment>
			
			<xsl:comment> Employer's name </xsl:comment>
			<xsl:for-each select="ext:multiLineBoxes(//mov:IRenvelope/mov:InYearMovements/mov:EmployerName,61,534,33.75,20.5,2,14,8)">							
				<xsl:copy-of select="."/>
			</xsl:for-each>
			<xsl:comment> Postcode </xsl:comment>
			
			<xsl:comment> Tax code used </xsl:comment>
			<xsl:comment>
				If you do not know the tax code to use or the current National Insurance contributions (NICs) 
				lower earnings limit, go to	www.hmrc.gov.uk/employers/rates_and_limits.htm 
			</xsl:comment>
			<xsl:comment> Enter 'X' in the appropriate box</xsl:comment>
			<xsl:comment> Box A</xsl:comment>
			<xsl:comment> Emergency code on a cumulative basis </xsl:comment>
			
			<div style="left:294px;top:828px;width:18px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p46/@Statement='A'">X</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>

			<xsl:comment> Box B</xsl:comment>
			<xsl:comment> Emergency code on a non-cumulative Week 1/Month 1 basis </xsl:comment>

			<div style="left:294px;top:895px;width:18px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p46/@Statement='B'">X</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>
			
			<xsl:comment> Box C</xsl:comment>
			<xsl:comment> Code BR </xsl:comment>
			
			<div style="left:294px;top:945px;width:18px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p46/@Statement='C'">X</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>
			
			<xsl:comment> Tax code used </xsl:comment>
			<ext:boxText text="{$p46/mov:TaxCodeInUse}" left="556" top="810" size="20.75"/>
			
			<xsl:comment> If week 1 or month 1 applies, enter 'X' in this box</xsl:comment>
			<div style="left: 524px;top: 865px;width: 20px;text-align:center">
				<xsl:choose>
					<xsl:when test="$p46/mov:TaxCodeInUse/@Week1Month1Indicator">
						<xsl:value-of select="$p46/mov:TaxCodeInUse/@Week1Month1Indicator"/>
					 </xsl:when>
					 <xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>
			
			</div>
		</div>		
		</xsl:otherwise>
		</xsl:choose>		
	</body>
</html>	

</xsl:template>			  
</xsl:stylesheet>
