<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
							  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
                              xmlns:mov="selima:FBI Rendering"
							  xmlns:ext="xalan://com.selima.fbi.webserver.XalanExtension"
							  extension-element-prefixes="ext"
							  >
<ext:annotation
	metadata="P46(base).metadata.xsl"
	rewrite_from_ns="http://www.govtalk.gov.uk/taxation/MOV"
    rewrite_to_ns="selima:FBI Rendering"
/>							  							  							 							  
							  
<xsl:output method="html" encoding="UTF-8"/>	
<!-- These should be supplied by external stylesheet user-->
<xsl:param name="page">1</xsl:param>
<xsl:param name="issueDate.day">30</xsl:param>
<xsl:param name="issueDate.month">03</xsl:param>
<xsl:param name="issueDate.year">2006</xsl:param>


<xsl:template match="/">
<xsl:variable name="p46" select="//mov:IRenvelope/mov:InYearMovements/mov:P46[position() = floor(($page+1) div 2)]"/>
<xsl:variable name="employer" select="//mov:IRenvelope/mov:InYearMovements/mov:Employer"/>
<html>
	<head>
		<title>P46(2006)</title>
		<style type="text/css">
				body {
					margin: 0px;
					padding: 0px;
					color: blue;
					font: normal normal bold 11pt monospace;				
				}
					
				div {
					background: transparent none no-repeat scroll top left;
				}
				
				body * div {
					position: absolute;
					border: 1px dotted transparent;					
				}
				
				div.checkbox {
					font-family:sans-serif;text-align:center
				}
				
				div.large-text {
					font-size: 32pt
				}			
		</style>	
	</head>
	<body>
		<xsl:choose>
		<xsl:when test="$page mod 2 = 1 ">
		<div style="background-image: url(images/p46_2006_p1.png);width:793px;height:1123px">
			<div style="width:793px;height:1123px">
			<xsl:comment> [<xsl:value-of select="$p46"/>] [<xsl:value-of select="name(/IRenvelope)"/>] Your details Please use capitals </xsl:comment>
			<xsl:comment> 
					National Insurance number 
					This is very important in getting your tax and benefits right.
			</xsl:comment>
									
			<xsl:if test="$p46/mov:NINO">																
				<ext:boxText text="{substring($p46/mov:NINO,1,2)}" left="84" top="293" size="20"/>				
				<ext:boxText text="{substring($p46/mov:NINO,3,2)}" left="134" top="293" size="20"/>								
				<ext:boxText text="{substring($p46/mov:NINO,5,2)}" left="184" top="293" size="20"/>				
				<ext:boxText text="{substring($p46/mov:NINO,7,2)}" left="236" top="293" size="20"/>
				
				<div style="left: 288px;top:293px;width:18px;text-align:center">
					<xsl:value-of select="substring($p46/mov:NINO,9,1)"/>
				</div>												
			</xsl:if>
				
			<xsl:comment> Date of birth	</xsl:comment>
			<xsl:if test="$p46/mov:BirthDate">
				<ext:boxText text="{substring($p46/mov:BirthDate,9,2)}" left="442" top="275" size="20"/>
				<ext:boxText text="{substring($p46/mov:BirthDate,6,2)}" left="492" top="275" size="20"/>
				<ext:boxText text="{substring($p46/mov:BirthDate,1,4)}" left="542" top="275" size="20"/>
			</xsl:if>	

			<xsl:comment> Name </xsl:comment>
			<xsl:comment> Title - enter MR, MRS, MISS, MS or other title </xsl:comment>			
			<xsl:if test="$p46/mov:Name/mov:Ttl">
				<ext:boxText text="{$p46/mov:Name/mov:Ttl}" left="84" top="380" size="20"/>			
			</xsl:if>
			
			<xsl:comment> Address </xsl:comment>
			<xsl:comment> Postcode </xsl:comment>
			<xsl:if test="$p46/mov:Address/mov:PostCode">
				<ext:boxText text="{substring($p46/mov:Address/mov:PostCode,1,4)}" left="442" top="362" size="20"/>
				<ext:boxText text="{substring($p46/mov:Address/mov:PostCode,5,4)}" left="535" top="362" size="20"/>							
			</xsl:if>
			
			<xsl:comment> Surname or family name </xsl:comment>
			<xsl:if test="$p46/mov:Name/mov:Sur">			
				<xsl:for-each select="ext:multiLineBoxes($p46/mov:Name/mov:Sur,84,434,33.5,20.5,2,14,7)">							
					<xsl:copy-of select="."/>									
				</xsl:for-each>							
			</xsl:if>
			<div style="left:230px;top:500px">
				<xsl:choose>
					<xsl:when test="$p46/@DirectorIndicator"><xsl:text>*</xsl:text></xsl:when>
					<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>
			
			<xsl:comment> House or flat number </xsl:comment>
			
			<xsl:comment> Rest of address including house name or flat name </xsl:comment>
			<xsl:if test="$p46/mov:Address/mov:Line">			
				<xsl:for-each select="ext:multiLineBoxes($p46/mov:Address/mov:Line,442,470,34,20.5,5,14,2)">							
					<xsl:copy-of select="."/>									
				</xsl:for-each>
			</xsl:if>

			<xsl:comment> First or given name(s) </xsl:comment>
			<xsl:if test="$p46/mov:Name/mov:Fore">			
				<xsl:for-each select="ext:multiLineBoxes($p46/mov:Name/mov:Fore,84,555,34,20.5,5,14,2)">							
					<xsl:copy-of select="."/>									
				</xsl:for-each>
			</xsl:if>			
			
			<xsl:comment> Are you male or female? </xsl:comment>
			<xsl:comment> Male </xsl:comment>
			<div style="left:118px;top:688px;width:20px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p46/mov:Gender='male'">X</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>
			<xsl:comment> Female </xsl:comment>
			<div style="left:210px;top:688px;width:20px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p46/mov:Gender='female'">X</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>	
			
			<xsl:comment> Your present circumstances </xsl:comment>
			
			<xsl:comment> 
					Please read all the following statements carefully
							and tick the one that applies to you. 
			</xsl:comment>
		
			<xsl:comment>		
					A - This is my first job since last 6 April and
						I have not been receiving taxable Jobseeker's
						Allowance or taxable Incapacity Benefit
						or a state or occupational pension.			
			</xsl:comment>
			
			<div style="left:351px;top:840px;width:20px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p46/@Class=1">X</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>
			
			<xsl:comment>
				OR
					B - This is now my only job, but since last 6 April
					I have had another job, or have received
					taxable Jobseeker's Allowance or Incapacity
					Benefit. I do not receive a state or
					occupational pension.
			</xsl:comment>
			
			<div style="left:351px;top:948px;width:20px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p46/@Class=2">X</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>			
			
			<xsl:comment>
			
				OR
					C - I have another job or receive a state or
					occupational pension.			
			</xsl:comment>
			
			<div style="left:351px;top:1007px;width:20px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p46/@Class=3">X</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>
			
			<xsl:comment> Student Loans </xsl:comment>
			<xsl:comment>
					If you left a course of Higher Education before last
					6 April and received your first Student Loan
					instalment on or after 1 September 1998 and
					you have not fully repaid your student loan,
					tick box D. (If you are required to repay your
					Student Loan through your bank or building
					society account do not tick box D.)						
			</xsl:comment>
			<div style="left:710px;top:852px;width:20px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p46/@StudentLoanIndicator">X</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>			
			
			
			<xsl:comment> Signature and date </xsl:comment>			
			<xsl:comment> I can confirm that this information is correct </xsl:comment>
			<xsl:comment> Signature </xsl:comment>
			<div style="left:445px;top: 981px;width: 276px;text-align:center">
				Not Applicable
			</div>				
			<xsl:comment> Date </xsl:comment>
			
			<xsl:if test="$issueDate.day != '&#160;'">			
				<ext:boxText text="{$issueDate.day}" left="442" top="1042" size="20"/>
				<ext:boxText text="{format-number($issueDate.month,'00')}" left="492" top="1042" size="20"/>
				<ext:boxText text="{$issueDate.year}" left="544" top="1042" size="20"/>
			</xsl:if>
			
			</div>
		</div>
		
		</xsl:when>
		<xsl:otherwise>
		<div style="background-image: url(images/p46_2006_p2.png);width:794px;height:1123px">
			<div style="width:794px;height:1123px">

			<xsl:comment> Employee's details Please use capitals </xsl:comment>
			<xsl:comment> Date employment started </xsl:comment>
			
			<xsl:if test="$p46/mov:StartDate">
				<ext:boxText text="{substring($p46/mov:StartDate,9,2)}" left="84" top="227" size="20"/>
				<ext:boxText text="{substring($p46/mov:StartDate,6,2)}" left="134" top="227" size="20"/>
				<ext:boxText text="{substring($p46/mov:StartDate,1,4)}" left="184" top="227" size="20"/>
			</xsl:if>				
			
			<xsl:comment> Works/payroll number and Department or branch (if any) </xsl:comment>
			
			<xsl:if test="$p46/mov:WorksNumber">			
				<xsl:for-each select="ext:multiLineBoxes($p46/mov:WorksNumber,440,227,34,20.5,1,14,6)">							
					<xsl:copy-of select="."/>									
				</xsl:for-each>
			</xsl:if>	

			<xsl:comment> Job title </xsl:comment>
			
			<xsl:if test="$p46/mov:JobTitle">			
				<xsl:for-each select="ext:multiLineBoxes($p46/mov:JobTitle,84,295,34,20.5,1,14,5)">							
					<xsl:copy-of select="."/>									
				</xsl:for-each>
			</xsl:if>				


			<xsl:comment> Employer's details Please use capitals </xsl:comment>
			
			<xsl:comment> Employer's PAYE reference </xsl:comment>			
			<ext:boxText text="{//mov:IRenvelope/mov:IRheader/mov:Keys/mov:Key[@Type='TaxOfficeNumber']}" left="84" top="435" size="20"/>
			<ext:boxText text="{//mov:IRenvelope/mov:IRheader/mov:Keys/mov:Key[@Type='TaxOfficeReference']}" left="168" top="435" size="20"/>

			<xsl:comment> Address </xsl:comment>			

			<xsl:comment> Postcode </xsl:comment>
			<xsl:if test="$employer/mov:Address/mov:PostCode">
				<ext:boxText text="{substring($employer/mov:Address/mov:PostCode,1,4)}" left="441" top="456" size="20"/>
				<ext:boxText text="{substring($employer/mov:Address/mov:PostCode,5,4)}" left="534" top="456" size="20"/>							
			</xsl:if>			
			
			<xsl:comment> Employer's name </xsl:comment>
			<xsl:if test="$employer/mov:Name">
				<xsl:for-each select="ext:multiLineBoxes($employer/mov:Name,84,502,34,20.5,2,14,8)">							
					<xsl:copy-of select="."/>									
				</xsl:for-each>			
			</xsl:if>
			
			<xsl:comment> Rest of Address </xsl:comment>			
			<xsl:if test="$employer/mov:Address/mov:Line">			
				<xsl:for-each select="ext:multiLineBoxes($employer/mov:Address/mov:Line,442,564,34,20.5,4,14,2)">							
					<xsl:copy-of select="."/>									
				</xsl:for-each>
			</xsl:if>			
			<xsl:comment> Tax code used </xsl:comment>
			<xsl:comment>
				If you do not know the tax code to use or the current tax threshold, please go to
				www.hmrc.gov.uk/employers/rates_and_limits.htm 
			</xsl:comment>
			<xsl:comment> Box A ticked </xsl:comment>
			<xsl:comment> Emergency code on a cumulative basis </xsl:comment>
			
			<div style="left:352px;top:830px;width:18px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p46/@Class=1">X</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>			

			<xsl:comment> Box B ticked </xsl:comment>
			<xsl:comment> Emergency code on a non-cumulative Week 1/Month 1 basis </xsl:comment>

			<div style="left:352px;top:895px;width:18px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p46/@Class=2">X</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>		
			
			<xsl:comment> Box C ticked </xsl:comment>
			<xsl:comment> Code BR </xsl:comment>			
			
			<div style="left:352px;top:945px;width:18px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p46/@Class=3">X</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>			
			
			<xsl:comment> Tax code used </xsl:comment>
			<div style="left:292px;top:985px;width:76px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p46/mov:TaxCode"><xsl:value-of select="$p46/mov:TaxCode"/></xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>					
			
			</div>
		</div>		
		</xsl:otherwise>
		</xsl:choose>		
	</body>
</html>	
</xsl:template>			  
</xsl:stylesheet>
