<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
							  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
                              xmlns:mov="selima:FBI Rendering"
							  xmlns:ext="xalan://com.selima.fbi.webserver.XalanExtension"
							  extension-element-prefixes="ext"
							  >
<ext:annotation
	metadata="P45Part3(base).metadata.xsl"
	rewrite_from_ns="http://www.govtalk.gov.uk/taxation/PAYE/MOV/09-10/1"
    rewrite_to_ns="selima:FBI Rendering"
/>	

<xsl:output method="html" encoding="UTF-8"/>

<!-- These should be supplied by external stylesheet user-->
<xsl:param name="page">_list</xsl:param>
<xsl:param name="issueDate.day">30</xsl:param>
<xsl:param name="issueDate.month">3</xsl:param>
<xsl:param name="issueDate.year">2010</xsl:param>


<xsl:template match="/">

<xsl:variable name="p45Part3" select="//mov:IRenvelope/mov:InYearMovements/mov:P45Part3[position() = $page]"/>
<html>
	<head>
		<title>P45Part3(2010)</title>
		<style type="text/css">
				body {
					margin: 0px;
					padding: 0px;
					color: blue;
					font: normal normal bold 11pt monospace;				
				}
					
				div {
					background: transparent none no-repeat scroll top left;
				}
				
				body * div {
					border: 1px dotted transparent;
					position: absolute;				
				}
				
				div.checkbox {
					font-family:sans-serif;text-align:center
				}
				
				div.large-text {
					font-size: 32pt
				}			
		</style>		
	</head>
	<body>
		<div style="background-image: url(images/p45_2009_p4.png);width:794px;height:1152px">
			<div style="width:794px;height:1152px">

			<xsl:comment> 1 Employer PAYE Reference </xsl:comment>
			<xsl:comment> Office number </xsl:comment>
			<ext:boxText text="{$p45Part3/mov:PreviousEmployer/mov:HMRCOfficeDetails/mov:Number}" left="102" top="185" size="20.5"/>				
			<xsl:comment> Reference number </xsl:comment>
			<ext:boxText text="{$p45Part3/mov:PreviousEmployer/mov:HMRCOfficeDetails/mov:Reference}" left="185" top="185" size="20.5"/>				
						
			<xsl:comment> 2 Employee's National Insurance number </xsl:comment>
			<ext:boxText text="{substring($p45Part3/mov:NINO,1,2)}" left="102" top="243" size="19"/>
			<ext:boxText text="{substring($p45Part3/mov:NINO,3,2)}" left="153" top="243" size="19"/>
			<ext:boxText text="{substring($p45Part3/mov:NINO,5,2)}" left="204" top="243" size="19"/>
			<ext:boxText text="{substring($p45Part3/mov:NINO,7,2)}" left="255" top="243" size="19"/>
			<ext:boxText text="{substring($p45Part3/mov:NINO,9,1)}" left="306" top="243" size="19"/>

			<xsl:comment> 3 Title - enter MR, MRS, MISS, MS or other title</xsl:comment>
			<div style="left: 102px;top: 301px;width: 288px;text-transform:uppercase">
				<xsl:choose>
				<xsl:when test="$p45Part3/mov:Name/mov:Ttl">
					<xsl:value-of select="$p45Part3/mov:Name/mov:Ttl"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>	
			
			<xsl:comment> Surname or family name</xsl:comment>
			<div style="left: 102px;top: 352px;width: 288px;text-transform:uppercase">
				<xsl:choose>
				<xsl:when test="$p45Part3/mov:Name/mov:Sur">
					<xsl:value-of select="$p45Part3/mov:Name/mov:Sur"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>			
			
			<xsl:comment> First or given name(s) </xsl:comment>
			<div style="left: 102px;top: 402px;width: 288px;text-transform:uppercase">
				<xsl:choose>
				<xsl:when test="$p45Part3/mov:Name/mov:Fore">
					<xsl:value-of select="$p45Part3/mov:Name/mov:Fore[position()=1]"/>
					<xsl:for-each select="$p45Part3/mov:Name/mov:Fore[position()>1]
					">,&#160;<xsl:value-of select="."/>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>				
			
			<xsl:comment> 4 Leaving date DD MM YYYY</xsl:comment>
			<ext:boxText text="{substring($p45Part3/mov:LeavingDate,9,2)}" left="102" top="460" size="19"/>
			<ext:boxText text="{substring($p45Part3/mov:LeavingDate,6,2)}" left="153" top="460" size="19"/>
			<ext:boxText text="{substring($p45Part3/mov:LeavingDate,1,4)}" left="204" top="460" size="20"/>
						
			
			<xsl:comment> 5 Student Loan Deductions</xsl:comment>
			<div style="left: 459px;top: 168px;width: 20px;text-align:center;">
				<xsl:choose>
					<xsl:when test="$p45Part3/mov:StudentLoanIndicator">Y</xsl:when>
					<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>	
			</div>				
			<xsl:comment> Student Loan deductions to continue</xsl:comment>
			
			<xsl:comment> 6 Tax Code at leaving date</xsl:comment>
			<ext:boxText text="{$p45Part3/mov:TaxCodeAtLeaving}" left="491" top="228" size="20.5"/>
			
			<xsl:comment> If week 1 or month 1 applies, enter 'X' in the box bellow.</xsl:comment>		
			<xsl:comment> Week 1 / Month 1 </xsl:comment>
			<div style="left: 555px;top: 277px;width: 20px;text-align:center">
				<xsl:choose>
					<xsl:when test="$p45Part3/mov:TaxCodeAtLeaving/@Week1Month1Indicator">
						<xsl:value-of select="$p45Part3/mov:TaxCodeAtLeaving/@Week1Month1Indicator"/>
					 </xsl:when>
					 <xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>

			<xsl:comment> 7 Last entries on P11 Deductions Working Sheet.
				Complete only if Tax Code is cumulative. If there is an 'X' at box 6, there will be no entries here.		
			</xsl:comment>

			<xsl:comment> Week number</xsl:comment>
			<xsl:if test="$p45Part3/mov:CumulativeDetails/mov:Period/@Type='week'">
				<ext:boxText text="{$p45Part3/mov:CumulativeDetails/mov:Period}" left="543" top="366" size="19"/>
			</xsl:if>
			<xsl:comment> Month number</xsl:comment>
			<xsl:if test="$p45Part3/mov:CumulativeDetails/mov:Period/@Type='month'">
				<ext:boxText text="{$p45Part3/mov:CumulativeDetails/mov:Period}" left="695" top="366" size="20"/>
			</xsl:if>

			<xsl:comment> Total pay to date </xsl:comment>
			<xsl:if test="$p45Part3/mov:CumulativeDetails/mov:TotalPayToDate">
				<ext:boxText text="{format-number(floor($p45Part3/mov:CumulativeDetails/mov:TotalPayToDate),'#0')}" right="665" top="422" size="20.75"/>
				<ext:boxText text="{substring-after(format-number($p45Part3/mov:CumulativeDetails/mov:TotalPayToDate,'#.00'),'.')}" right="718" top="422" size="20"/>
			</xsl:if>
			
			<xsl:comment> Total tax to date </xsl:comment>
			<xsl:if test="$p45Part3/mov:CumulativeDetails/mov:TotalTaxToDate">
				<ext:boxText text="{format-number(floor($p45Part3/mov:CumulativeDetails/mov:TotalTaxToDate),'#0')}" right="665" top="473" size="20.75"/>
				<ext:boxText text="{substring-after(format-number($p45Part3/mov:CumulativeDetails/mov:TotalTaxToDate,'#.00'),'.')}" right="718" top="473" size="20"/>
			</xsl:if>			

			<xsl:comment> 8 New employer PAYE Reference </xsl:comment>

			<xsl:comment> Office number </xsl:comment>			
			<ext:boxText text="{//mov:IRenvelope/mov:IRheader/mov:Keys/mov:Key[@Type='TaxOfficeNumber']}" left="102" top="569" size="20.75"/>

			<xsl:comment> Reference number </xsl:comment>
			<ext:boxText text="{//mov:IRenvelope/mov:IRheader/mov:Keys/mov:Key[@Type='TaxOfficeReference']}" left="185" top="569" size="20.75"/>

			<xsl:comment> 9 Date new employment started DD MM YYYY </xsl:comment>
			<ext:boxText text="{substring($p45Part3/mov:StartDate,9,2)}" left="102" top="626" size="19"/>
			<ext:boxText text="{substring($p45Part3/mov:StartDate,6,2)}" left="153" top="626" size="19"/>
			<ext:boxText text="{substring($p45Part3/mov:StartDate,1,4)}" left="204" top="626" size="20"/>

			<xsl:comment> 10 Works number/Payroll number and department or branch (if any)</xsl:comment>
			<div style="left: 104px;top: 701px;width: 284px;text-align:left;text-transform:uppercase">
				<xsl:choose>
				<xsl:when test="$p45Part3/mov:WorksNumber">
					<xsl:value-of select="$p45Part3/mov:WorksNumber"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>

			<xsl:comment> 11 Enter 'P' here if employee will not be paid by you
						between date employment began and next 5 April
			</xsl:comment>
			<div style="left: 369px;top: 779px;width: 20px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part3/mov:NoPayUntilApril">
				P
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>	
			
			<xsl:comment> 12 Enter Tax Code in use if different to the Tax Code at box 6</xsl:comment>
			<ext:boxText text="{$p45Part3/mov:TaxCodeInUse}" left="132" top="835" size="20.75"/>
			
			<xsl:comment> If week 1 or month 1 applies, enter 'X' in the box bellow.</xsl:comment>		
			<xsl:comment> Week 1 / Month 1 </xsl:comment>
			<div style="left: 197px;top: 882px;width: 20px;text-align:center">
				<xsl:choose>
					<xsl:when test="$p45Part3/mov:TaxCodeInUse/@Week1Month1Indicator">
						<xsl:value-of select="$p45Part3/mov:TaxCodeInUse/@Week1Month1Indicator"/>
					 </xsl:when>
					 <xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>

			<xsl:comment> 13 If the tax figure you are entering on P11 Deductions Working Sheet
						differs from box 7 (see the E13 Employer Helpbook 
						Day-to-day payroll) please enter 
						the figure here. 
			</xsl:comment>
			<xsl:if test="$p45Part3/mov:P11Figure">
				<ext:boxText text="{format-number(floor($p45Part3/mov:P11Figure),'#0')}" right="308" top="982" size="20.75"/>
				<ext:boxText text="{substring-after(format-number($p45Part3/mov:P11Figure,'#.00'),'.')}" right="360" top="982" size="20"/>
			</xsl:if>			
			
								
			<xsl:comment> 14 New employee's job title or job description</xsl:comment>
			<div style="left: 102px;top: 1038px;width: 288px;text-align:center;text-transform:uppercase">
				<xsl:choose>
					<xsl:when test="$p45Part3/mov:JobTitle">
						<xsl:value-of select="$p45Part3/mov:JobTitle"/>
					</xsl:when>
					<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>	
			</div>	

			<xsl:comment> 15 Employee's private address </xsl:comment>			
			<div style="left: 461px;top: 557px;width: 288px;text-align:left;text-transform:uppercase">
				<xsl:for-each select="$p45Part3/mov:Address/mov:Line">
					<xsl:if test="position() &gt; 1"><br/></xsl:if>
					<xsl:value-of select="."/>
				</xsl:for-each>
				<xsl:choose>
					<xsl:when test="count($p45Part3/mov:Address/mov:Line) &lt; 3"><br/></xsl:when>
					<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
				<xsl:value-of select="$p45Part3/mov:Address/mov:Country"/>
			</div>
			
			<xsl:comment> Postcode </xsl:comment>
			<ext:boxText text="{substring($p45Part3/mov:Address/mov:PostCode,1,4)}" left="459" top="649" size="20.5"/>
			<ext:boxText text="{substring($p45Part3/mov:Address/mov:PostCode,5,4)}" left="551" top="649" size="20.5"/>
			
			<xsl:comment> 16 Gender. Enter 'X' in the appropriate box</xsl:comment>
			<xsl:comment> Male</xsl:comment>
			<div style="left: 502px;top: 703px;width: 20px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part3/mov:Gender = 'male'">
					<xsl:text>X</xsl:text>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>			
			<xsl:comment> Female</xsl:comment>
			<div style="left: 592px;top: 703px;width: 20px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part3/mov:Gender = 'female'">
					<xsl:text>X</xsl:text>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>				

			<xsl:comment> 17 Date of birth DD MM YYYY </xsl:comment>
			<xsl:comment>Day</xsl:comment>
			<ext:boxText text="{substring($p45Part3/mov:BirthDate,9,2)}" left="459" top="760" size="19"/>
			<ext:boxText text="{substring($p45Part3/mov:BirthDate,6,2)}" left="510" top="760" size="19"/>
			<ext:boxText text="{substring($p45Part3/mov:BirthDate,1,4)}" left="561" top="760" size="20"/>			
					
			<xsl:comment> 18 Declaration. I have prepared a p11 Deductions Working Sheet
						 in accordance with the details above. 						
			</xsl:comment>
			
			<xsl:comment> Employer name and address</xsl:comment>
								
			<div style="left: 459px;top: 877px;width: 288px;text-align:left;text-transform:uppercase">
				<xsl:choose>
					<xsl:when test="//mov:IRenvelope/mov:InYearMovements/mov:EmployerName">
						<xsl:value-of select="//mov:IRenvelope/mov:InYearMovements/mov:EmployerName"/>
					</xsl:when>	
					<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>	
			</div>		
			<xsl:comment> Postcode </xsl:comment>
			
			<xsl:comment> Date DD MM YYYY</xsl:comment>
			<xsl:if test="$issueDate.day != '&#160;'">			
				<ext:boxText text="{format-number($issueDate.day,'00')}" left="459" top="1044" size="19"/>
				<ext:boxText text="{format-number($issueDate.month,'00')}" left="510" top="1044" size="19"/>
				<ext:boxText text="{$issueDate.year}" left="561" top="1044" size="20"/>
			</xsl:if>
						
			</div>
		</div>	
	</body>
</html>	
</xsl:template>			  
</xsl:stylesheet>
