<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
							  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
                              xmlns:mov="selima:FBI Rendering"
							  xmlns:ext="xalan://com.selima.fbi.webserver.XalanExtension"							  
							  extension-element-prefixes="ext">	
<ext:annotation
	metadata="P45Part3(base).metadata.xsl"
	rewrite_from_ns="http://www.govtalk.gov.uk/taxation/MOV"
    rewrite_to_ns="selima:FBI Rendering"
/>

<xsl:output method="html" encoding="UTF-8"/>	
<!-- These should be supplied by external stylesheet user-->
<xsl:param name="page">_list</xsl:param>
<xsl:param name="issueDate.day">30</xsl:param>
<xsl:param name="issueDate.month">3</xsl:param>
<xsl:param name="issueDate.year">2006</xsl:param>


<xsl:template match="/">
<xsl:variable name="p45Part3" select="//mov:IRenvelope/mov:InYearMovements/mov:P45Part3[position() = $page]"/>
<xsl:variable name="employer" select="//mov:IRenvelope/mov:InYearMovements/mov:Employer"/>
<html>
	<head>
		<title>P45Part3(2006)</title>
		<style type="text/css">
				body {
					margin: 0px;
					padding: 0px;
					color: blue;
					font: normal normal bold 11pt monospace;				
				}
					
				div {
					background: transparent none no-repeat scroll top left;
				}
				
				body * div {
					border: 1px dotted transparent;
					position: absolute;				
				}
				
				div.checkbox {
					font-family:sans-serif;text-align:center
				}
				
				div.large-text {
					font-size: 32pt
				}			
		</style>		
	</head>
	<body>
		<div style="background-image: url(images/p45_2006_p4.png);width:792px;height:1179px">
			<div style="width:792px;height:1179px">

			<xsl:comment> 1 Previous PAYE Reference </xsl:comment>
			<xsl:comment> Office number </xsl:comment>
			<div style="left: 445px;top: 105px;width: 80px;text-align: right">
				&#160;	
				<xsl:value-of select="$p45Part3/mov:PreviousEmployer/mov:TaxOffice/mov:Number"/>			
			</div>
			
			<xsl:comment> Reference number </xsl:comment>
			<div style="left: 552px;top: 105px;width: 215px;">			
				<xsl:value-of select="$p45Part3/mov:PreviousEmployer/mov:TaxOffice/mov:Reference"/>								
			</div>				
			
			<xsl:comment> 2 Employee's National Insurance number </xsl:comment>
			<div style="left: 450px;top: 155px;width: 50px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part3/mov:NINO">
					<xsl:value-of select="substring($p45Part3/mov:NINO,1,2)"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>				
			<div style="left: 450px;top: 155px;width: 50px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part3/mov:NINO">
					<xsl:value-of select="substring($p45Part3/mov:NINO,1,2)"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>	
			<div style="left: 511px;top: 155px;width: 50px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part3/mov:NINO">
					<xsl:value-of select="substring($p45Part3/mov:NINO,3,2)"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>	
			<div style="left: 570px;top: 155px;width: 50px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part3/mov:NINO">
					<xsl:value-of select="substring($p45Part3/mov:NINO,5,2)"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>	
			<div style="left: 629px;top: 155px;width: 50px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part3/mov:NINO">
					<xsl:value-of select="substring($p45Part3/mov:NINO,7,2)"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>
			<div style="left: 690px;top: 155px;width: 50px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part3/mov:NINO">
					<xsl:value-of select="substring($p45Part3/mov:NINO,9,1)"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>				
			
			<xsl:comment> 3 Surname </xsl:comment>
			<div style="left: 220px;top: 203px;width: 442px;">
				<xsl:choose>
				<xsl:when test="$p45Part3/mov:Name/mov:Sur">
					<xsl:value-of select="$p45Part3/mov:Name/mov:Sur"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>			
			
			<xsl:comment> Mr Mrs Miss Ms Other </xsl:comment>
			<div style="left: 674px;top: 203px;width: 96px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part3/mov:Name/mov:Ttl">
					<xsl:value-of select="$p45Part3/mov:Name/mov:Ttl"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>				
			
			<xsl:comment> First name(s) </xsl:comment>
			<div style="left: 220px;top: 252px;width: 548px;">
				<xsl:choose>
				<xsl:when test="$p45Part3/mov:Name/mov:Fore">
					<xsl:value-of select="$p45Part3/mov:Name/mov:Fore[position()=1]"/>
					<xsl:for-each select="$p45Part3/mov:Name/mov:Fore[position()>1]
					">,&#160;<xsl:value-of select="."/>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>				
			
			<xsl:comment> 4 Date left previous employment </xsl:comment>
			<xsl:comment> Day </xsl:comment>
			<div style="left: 220px;top: 302px;width: 87px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part3/mov:LeavingDate">
					<xsl:value-of select="substring($p45Part3/mov:LeavingDate,9,2)"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>
			<xsl:comment> Month </xsl:comment>
			<div style="left: 318px;top: 302px;width: 76px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part3/mov:LeavingDate">
					<xsl:value-of select="substring($p45Part3/mov:LeavingDate,6,2)"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>				
			<xsl:comment> Year </xsl:comment>
			<div style="left: 405px;top: 302px;width: 136px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part3/mov:LeavingDate">
					<xsl:value-of select="substring($p45Part3/mov:LeavingDate,1,4)"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>				

			<xsl:comment> 5 Continue Student Loan Deductions(Y)</xsl:comment>
			<div style="left: 715px;top: 302px;width: 50px;text-align:center;">
				<xsl:choose>
					<xsl:when test="$p45Part3/mov:StudentLoanIndicator">Y</xsl:when>				
					<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>	
			</div>				
			
			<xsl:comment> 6 Tax Code at leaving date.
				'X' in the box means Week 1 or Month 1 basis applies.
			</xsl:comment>
			<xsl:comment> Code </xsl:comment>
			<div style="left: 446px;top: 350px;width: 180px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part3/mov:TaxCodeAtLeaving">
					<xsl:value-of select="$p45Part3/mov:TaxCodeAtLeaving"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>				
			<xsl:comment> Week 1 or Month1 </xsl:comment>
			<div style="left: 636px;top: 350px;width: 50px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part3/mov:TaxCodeAtLeaving/@Week1Month1Indicator = 'week'">
					X
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>	
			<div style="left: 690px;top: 350px;width: 50px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part3/mov:TaxCodeAtLeaving/@Week1Month1Indicator = 'month'">
					X
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>
			
			<xsl:comment>7 Last entries on Deductions Working Sheet (P11)
				If there is an 'X' at item 6, there will be no entries here.		
			</xsl:comment>
			<xsl:comment> Week or month number </xsl:comment>
			<xsl:comment> Week </xsl:comment>
			<div style="left: 446px;top: 398px;width: 136px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part3/mov:LastEntries/mov:Period/@Type='week'">
					<xsl:value-of select="$p45Part3/mov:LastEntries/mov:Period"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>		
			<xsl:comment> Month </xsl:comment>
			<div style="left: 594px;top: 398px;width: 175px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part3/mov:LastEntries/mov:Period/@Type='month'">
					<xsl:value-of select="$p45Part3/mov:LastEntries/mov:Period"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>	
			
			<xsl:comment> Total pay to date </xsl:comment>
			<div style="left: 462px;top: 448px;width: 120px;text-align:right">
				<xsl:choose>
				<xsl:when test="$p45Part3/mov:LastEntries/mov:TotalPayToDate">
					<xsl:value-of select="format-number(floor($p45Part3/mov:LastEntries/mov:TotalPayToDate),'#0')"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>
			<div style="left: 594px;top: 448px;width: 70px;text-align:left">
				<xsl:choose>
				<xsl:when test="$p45Part3/mov:LastEntries/mov:TotalPayToDate">
					<xsl:value-of select="substring-after(format-number($p45Part3/mov:LastEntries/mov:TotalPayToDate,'#.00'),'.')"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>			
			
			<xsl:comment> Total tax to date </xsl:comment>
			<div style="left: 462px;top: 496px;width: 120px;text-align:right">
				<xsl:choose>
				<xsl:when test="$p45Part3/mov:LastEntries/mov:TotalTaxToDate">
					<xsl:value-of select="format-number(floor($p45Part3/mov:LastEntries/mov:TotalTaxToDate),'#0')"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>
			<div style="left: 594px;top: 496px;width: 70px;text-align:left">
				<xsl:choose>
				<xsl:when test="$p45Part3/mov:LastEntries/mov:TotalTaxToDate">
					<xsl:value-of select="substring-after(format-number($p45Part3/mov:LastEntries/mov:TotalTaxToDate,'#.00'),'.')"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>				
			
			<xsl:comment> 8 New PAYE Reference </xsl:comment>
			<xsl:comment> Office number</xsl:comment>
			<div style="left: 446px;top: 608px;width: 80px;text-align: right">
				&#160;	
				<xsl:value-of select="//mov:IRenvelope/mov:IRheader/mov:Keys/mov:Key[@Type='TaxOfficeNumber']"/>			
			</div>			
			<xsl:comment> Reference number </xsl:comment>
			<div style="left: 550px;top: 608px;width: 218px;">			
				<xsl:value-of select="//mov:IRenvelope/mov:IRheader/mov:Keys/mov:Key[@Type='TaxOfficeReference']"/>								
			</div>				
			
			<xsl:comment> 9 Date employment started (in figures) </xsl:comment>
			<xsl:comment>Day</xsl:comment>		
			<div style="left: 445px;top: 660px;width: 88px;text-align:center">
				<xsl:choose>
					<xsl:when test="$p45Part3/mov:StartDate">
						<xsl:value-of select="substring($p45Part3/mov:StartDate,9,2)"/>
					</xsl:when>
					<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>	
			</div>
			<xsl:comment>Month</xsl:comment>
			<div style="left: 543px;top: 660px;width: 75px;text-align:center">
				<xsl:choose>
					<xsl:when test="$p45Part3/mov:StartDate">
						<xsl:value-of select="substring($p45Part3/mov:StartDate,6,2)"/>
					</xsl:when>
					<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>	
			</div>
			<xsl:comment>Year</xsl:comment>
			<div style="left: 630px;top: 660px;width: 138px;text-align:center">
				<xsl:choose>
					<xsl:when test="$p45Part3/mov:StartDate">
						<xsl:value-of select="substring($p45Part3/mov:StartDate,1,4)"/>
					</xsl:when>
					<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>	
			</div>			
			
			<xsl:comment> 10 Tick here if you want these details to be
						 shown on tax code notifications
			</xsl:comment>
			<div style="left: 267px;top: 706px;width: 38px;text-align:center">
					&#160;
			</div>						
			<xsl:comment> Works/Payroll number </xsl:comment>
			<div style="left: 446px;top: 707px;width: 322px;text-align:left">
				<xsl:choose>
				<xsl:when test="$p45Part3/mov:WorksNumber">
					<xsl:value-of select="$p45Part3/mov:WorksNumber"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>

			<xsl:comment> Department or branch, if any</xsl:comment>
			<div style="left: 446px;top: 740px;width: 322px;text-align:left">
				NOT APPLICABLE
			</div>
			
			<xsl:comment> 11 Enter P if employee will not be paid by you			
						between date employment began and next 5 April
			</xsl:comment>
			<div style="left: 444px;top: 785px;width: 30px;text-align:center">
				&#160;
			</div>	
			
			<xsl:comment> 12 Enter code in use if different to code at item 6</xsl:comment>			
			<div style="left: 635px;top: 785px;width: 130px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part3/mov:TaxCodeInUse">
					<xsl:value-of select="$p45Part3/mov:TaxCodeInUse"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>			
			
			<xsl:comment> 13 If the tax figure you are entering on P11 
						differs from item 7 above (see Employer's Help 
						Book 'Day-to-day payroll, E13') please enter 
						your figure here 
			</xsl:comment>
			<div style="left: 646px;top: 845px;width: 120px;text-align:center">
				&#160;
			</div>							
							
			<xsl:comment> 14 Employee's private address </xsl:comment>			
			<div style="left: 220px;top: 888px;width: 548px;text-align:left;line-height:36px">
				<xsl:choose>
				<xsl:when test="$p45Part3/mov:Address/mov:Line">
					<xsl:value-of select="$p45Part3/mov:Address/mov:Line[position()=1]"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>	
				<xsl:for-each select="$p45Part3/mov:Address/mov:Line[position()>1]">,
				<xsl:value-of select="."/>
				</xsl:for-each>
				
			</div>
			<xsl:comment> Postcode </xsl:comment>
			<div style="left: 670px;top: 930px;width: 100px;text-align:left">
				<xsl:choose>
				<xsl:when test="$p45Part3/mov:Address/mov:PostCode">
					<xsl:value-of select="$p45Part3/mov:Address/mov:PostCode"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>				

			<xsl:comment> 15 Employee's date of birth (if known) </xsl:comment>
			<xsl:comment>Day</xsl:comment>		
			<div style="left: 220px;top: 980px;width: 48px;text-align:center">
				<xsl:choose>
					<xsl:when test="$p45Part3/mov:BirthDate">
						<xsl:value-of select="substring($p45Part3/mov:BirthDate,9,2)"/>
					</xsl:when>
					<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>	
			</div>
			<xsl:comment>Month</xsl:comment>
			<div style="left: 278px;top: 980px;width: 48px;text-align:center">
				<xsl:choose>
					<xsl:when test="$p45Part3/mov:BirthDate">
						<xsl:value-of select="substring($p45Part3/mov:BirthDate,6,2)"/>
					</xsl:when>
					<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>	
			</div>
			<xsl:comment>Year</xsl:comment>
			<div style="left: 335px;top: 980px;width: 50px;text-align:center">
				<xsl:choose>
					<xsl:when test="$p45Part3/mov:BirthDate">
						<xsl:value-of select="substring($p45Part3/mov:BirthDate,1,4)"/>
					</xsl:when>
					<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>	
			</div>			
			
			<xsl:comment> 16 Employee's job title or description </xsl:comment>
			<div style="left: 510px;top: 980px;width: 260px;text-align:center">
				<xsl:choose>
					<xsl:when test="$p45Part3/mov:JobTitle">
						<xsl:value-of select="$p45Part3/mov:JobTitle"/>
					</xsl:when>
					<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>	
			</div>		
			
			<xsl:comment> 17 Declaration. I have prepared a Deductions Working Sheet
						(P11) in accordance with the details above. 						
			</xsl:comment>
			
			<xsl:comment> Employer </xsl:comment>
								
			<div style="left: 220px;top: 1056px;width: 548px;text-align:left">
				<xsl:value-of select="$employer/mov:Name"/><br/>
			</div>	
	
			<xsl:comment> Address </xsl:comment>
			<div style="left: 220px;top: 1090px;width: 548px;text-align:left;line-height:36px">
				<xsl:choose>
				<xsl:when test="$employer/mov:Address/mov:Line">
					<xsl:value-of select="$employer/mov:Address/mov:Line[position()=1]"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
				<xsl:for-each select="$employer/mov:Address/mov:Line[position()>1]">,
				 <xsl:value-of select="."/>
				</xsl:for-each>
			</div>

			<xsl:comment> Postcode </xsl:comment>
			<div style="left: 515px;top: 1140;width: 100px;text-align:left">
				<xsl:choose>
					<xsl:when test="$employer/mov:Address/mov:PostCode">
						<xsl:value-of select="$employer/mov:Address/mov:PostCode"/>
					</xsl:when>
					<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>			
			<xsl:comment> Date </xsl:comment>
			<div style="left:670px;top: 1140;width: 100px;text-align:left">
				<xsl:choose>
				<xsl:when test="$issueDate.day != '&#160;'">			
					<xsl:value-of select="$issueDate.day"/>/<xsl:value-of select="$issueDate.month"/>/<xsl:value-of select="$issueDate.year"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>						
			</div>
						
			</div>
		</div>	
	</body>
</html>	
</xsl:template>			  
</xsl:stylesheet>
