<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
							  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
                              xmlns:mov="selima:FBI Rendering"
							  xmlns:ext="xalan://com.selima.fbi.webserver.XalanExtension"
							  extension-element-prefixes="ext"
                              >
<ext:annotation
	metadata="P45Part1(base).metadata.xsl"
	rewrite_from_ns="http://www.govtalk.gov.uk/taxation/PAYE/MOV/09-10/1"
    rewrite_to_ns="selima:FBI Rendering"	
/>								  
							  
<xsl:output method="html" encoding="UTF-8"/>	
<!-- These should be supplied by external stylesheet user-->
<xsl:param name="page">_list</xsl:param>
<xsl:param name="issueDate.day">30</xsl:param>
<xsl:param name="issueDate.month">3</xsl:param>
<xsl:param name="issueDate.year">2010</xsl:param>


<xsl:template match="/">
<xsl:variable name="p45Part1" select="//mov:IRenvelope/mov:InYearMovements/mov:P45Part1[position() = $page]"/>
<html>
	<head>
		<title>P45Part1(2010)</title>
		<style type="text/css">
				body {
					margin: 0px;
					padding: 0px;
					color: blue;
					font: normal normal bold 11pt monospace;				
				}
					
				div {
					background: transparent none no-repeat scroll top left;
				}
				
				body * div {
					border: 1px dotted transparent;
					position: absolute;				
				}
				
				div.checkbox {
					font-family:sans-serif;text-align:center
				}
				
				div.large-text {
					font-size: 32pt
				}
				
				div.not-required {
					font-style: italic;
					color: #CC2222;
				}	
		</style>		
	</head>
	<body>
		<div style="background-image: url(images/p45_2009_p1.png);width:794px;height:1152px">
			<div style="width:794px;height:1152px">

			<xsl:comment> 1 Employer PAYE Reference </xsl:comment>
			
			<xsl:comment> Office number </xsl:comment>			
			<ext:boxText text="{//mov:IRenvelope/mov:IRheader/mov:Keys/mov:Key[@Type='TaxOfficeNumber']}" left="102" top="185" size="20.5"/>				
			
			<xsl:comment> Reference number </xsl:comment>
			<ext:boxText text="{//mov:IRenvelope/mov:IRheader/mov:Keys/mov:Key[@Type='TaxOfficeReference']}" left="185" top="185" size="20.5"/>								
			
			<xsl:comment> 2 Employee's National Insurance number </xsl:comment>
			
			<ext:boxText text="{substring($p45Part1/mov:NINO,1,2)}" left="102" top="243" size="19"/>
			<ext:boxText text="{substring($p45Part1/mov:NINO,3,2)}" left="153" top="243" size="19"/>
			<ext:boxText text="{substring($p45Part1/mov:NINO,5,2)}" left="204" top="243" size="19"/>
			<ext:boxText text="{substring($p45Part1/mov:NINO,7,2)}" left="254" top="243" size="20"/>
			<ext:boxText text="{substring($p45Part1/mov:NINO,9,1)}" left="305" top="243" size="20"/>
			
			<xsl:comment> 3 Title enter MR, MRS, MISS, MS or other title </xsl:comment>
			<div style="left: 102px;top: 300px;width: 288px;text-align:left;text-transform:uppercase">
				<xsl:choose>
				<xsl:when test="$p45Part1/mov:Name/mov:Ttl">
					<xsl:value-of select="$p45Part1/mov:Name/mov:Ttl"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>				
			
			
			<xsl:comment> Surname or family name </xsl:comment>
			<div style="left: 102px;top: 351px;width: 288px;text-transform:uppercase">
				<xsl:choose>
				<xsl:when test="$p45Part1/mov:Name/mov:Sur">
					<xsl:value-of select="$p45Part1/mov:Name/mov:Sur"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>			
						
			
			<xsl:comment> First or given name(s)</xsl:comment>
			<div style="left: 102px;top: 402px;width: 288px;text-transform:uppercase">
				<xsl:choose>
				<xsl:when test="$p45Part1/mov:Name/mov:Fore">
					<xsl:value-of select="$p45Part1/mov:Name/mov:Fore[position()=1]"/>
					<xsl:for-each select="$p45Part1/mov:Name/mov:Fore[position()>1]
					">,&#160;<xsl:value-of select="."/>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>				
			
			<xsl:comment> 4 Leaving date DD MM YYYY </xsl:comment>
			<ext:boxText text="{substring($p45Part1/mov:LeavingDate,9,2)}" left="102" top="460" size="19"/>
			<ext:boxText text="{substring($p45Part1/mov:LeavingDate,6,2)}" left="153" top="460" size="19"/>
			<ext:boxText text="{substring($p45Part1/mov:LeavingDate,1,4)}" left="204" top="460" size="20"/>
			
			
			<xsl:comment> 5 Student Loan Deductions</xsl:comment>
			<div style="left: 458px;top: 168px;width: 20px;text-align:center;text-transform:uppercase">
				<xsl:choose>
				<xsl:when test="$p45Part1/mov:StudentLoanIndicator = 'yes'">
					<xsl:text>Y</xsl:text>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>
			<xsl:comment>Enter 'Y' if Student Loan deduction is due to be made</xsl:comment>
			
			<xsl:comment> 6 Tax Code at leaving date.</xsl:comment>
			<ext:boxText text="{$p45Part1/mov:TaxCodeAtLeaving}" left="490" top="226" size="20.5"/>
			
			<xsl:comment>
			 If week 1 or month 1 applies
						, enter 'X' in the box bellow. 
			</xsl:comment>						
			<div style="left: 554px;top: 275px;width: 20px;text-align:center">
				<xsl:choose>
					<xsl:when test="$p45Part1/mov:TaxCodeAtLeaving/@Week1Month1Indicator">
						<xsl:value-of select="$p45Part1/mov:TaxCodeAtLeaving/@Week1Month1Indicator"/>
					</xsl:when>
					<xsl:otherwise>&#160;</xsl:otherwise>	
				</xsl:choose>
			</div>	
			
			<xsl:comment> 7 Last entries on P11 Deductions Working Sheet.
						Complete only if Tax Code is cumulative.
						Make no entry here if week 1 or month 1 applies,
						go straight to box 8.
			</xsl:comment>
			<xsl:comment> Week number</xsl:comment>			
			<xsl:if test="$p45Part1/mov:CumulativeDetails/mov:Period/@Type='week'">
				<ext:boxText text="{$p45Part1/mov:CumulativeDetails/mov:Period}" left="542" top="364" size="20"/>
			</xsl:if>
				
			<xsl:comment> Month number</xsl:comment>
			<xsl:if test="$p45Part1/mov:CumulativeDetails/mov:Period/@Type='month'">
				<ext:boxText text="{$p45Part1/mov:CumulativeDetails/mov:Period}" left="695" top="364" size="20"/>
			</xsl:if>
			
			
			<xsl:comment> Total pay to date </xsl:comment>
			<xsl:if test="$p45Part1/mov:CumulativeDetails/mov:TotalPayToDate">
				<ext:boxText text="{format-number(floor($p45Part1/mov:CumulativeDetails/mov:TotalPayToDate),'#0')}" right="665" top="420" size="21"/>
				<ext:boxText text="{substring-after(format-number($p45Part1/mov:CumulativeDetails/mov:TotalPayToDate,'#.00'),'.')}" right="718" top="420" size="20"/>
			</xsl:if>
			
			
			<xsl:comment> Total tax to date </xsl:comment>
			<xsl:if test="$p45Part1/mov:CumulativeDetails/mov:TotalTaxToDate">
				<ext:boxText text="{format-number(floor($p45Part1/mov:CumulativeDetails/mov:TotalTaxToDate),'#0')}" right="665" top="471" size="21"/>
				<ext:boxText text="{substring-after(format-number($p45Part1/mov:CumulativeDetails/mov:TotalTaxToDate,'#.00'),'.')}" right="718" top="471" size="20"/>
			</xsl:if>
							
			
			<xsl:comment> 8 This employment pay and tax. Leave blank if the Tax Code
						is cumulative ant the amounts are the same as box 7. 
			</xsl:comment>
			
			<xsl:comment> Total pay in this employment </xsl:comment>
			<xsl:if test="$p45Part1/mov:ThisEmployment/mov:TotalPay">
				<ext:boxText text="{format-number(floor($p45Part1/mov:ThisEmployment/mov:TotalPay),'#0')}" right="307" top="571" size="20.5"/>
				<ext:boxText text="{substring-after(format-number($p45Part1/mov:ThisEmployment/mov:TotalPay,'#.00'),'.')}" right="360" top="571" size="20"/>
			</xsl:if>
			
			<xsl:comment> Total tax in this employment </xsl:comment>
			<xsl:if test="$p45Part1/mov:ThisEmployment/mov:TotalTax">
				<ext:boxText text="{format-number(floor($p45Part1/mov:ThisEmployment/mov:TotalTax),'#0')}" right="307" top="620" size="20.5"/>
				<ext:boxText text="{substring-after(format-number($p45Part1/mov:ThisEmployment/mov:TotalTax,'#.00'),'.')}" right="360" top="620" size="20"/>
			</xsl:if>
									
			<xsl:comment> 9 Works number/Payroll number and Department or branch (if any) </xsl:comment>
			<div style="left: 102px;top: 697px;width: 288px;text-transform:uppercase">
				<xsl:choose>
				<xsl:when test="$p45Part1/mov:WorksNumber">
					<xsl:value-of select="$p45Part1/mov:WorksNumber"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>

			<xsl:comment> 10 Gender. Enter 'X' in the appropriate box </xsl:comment>
			<xsl:comment> Male</xsl:comment>
			<div style="left: 145px;top: 774px;width: 20px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part1/mov:Gender = 'male'">
					<xsl:text>X</xsl:text>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>			
			<xsl:comment> Female</xsl:comment>
			<div style="left: 234px;top: 774px;width: 20px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part1/mov:Gender = 'female'">
					<xsl:text>X</xsl:text>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>			
			
			<xsl:comment> 11 Date of birth DD MM YYYY</xsl:comment>
			<ext:boxText text="{substring($p45Part1/mov:BirthDate,9,2)}" left="102" top="832" size="19"/>
			<ext:boxText text="{substring($p45Part1/mov:BirthDate,6,2)}" left="153" top="832" size="19"/>
			<ext:boxText text="{substring($p45Part1/mov:BirthDate,1,4)}" left="204" top="832" size="20"/>			
			
			<xsl:comment> 12 Employee's private address</xsl:comment>
			<div style="left: 459px;top: 540px;width: 289px;text-align:left;text-transform:uppercase">
				<xsl:for-each select="$p45Part1/mov:Address/mov:Line">
					<xsl:if test="position() &gt; 1"><br/></xsl:if>
					<xsl:value-of select="."/>
				</xsl:for-each>
				<xsl:choose>
					<xsl:when test="count($p45Part1/mov:Address/mov:Line) &lt; 3"><br/></xsl:when>
					<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
				<xsl:value-of select="$p45Part1/mov:Address/mov:Country"/>
			</div>
			
			<xsl:comment> Postcode</xsl:comment>
			<ext:boxText text="{substring($p45Part1/mov:Address/mov:PostCode,1,4)}" left="459" top="632" size="20.5"/>
			<ext:boxText text="{substring($p45Part1/mov:Address/mov:PostCode,5,4)}" left="551" top="632" size="20.5"/>
			
			<xsl:comment> 13 I certify that the details entered in items 1 to 11 on this form are correct. </xsl:comment>
			<xsl:comment> Employer name and address</xsl:comment>
			<div style="left: 460px;top: 724px;width: 288px;text-align:left;text-transform:uppercase">
				<xsl:choose>
					<xsl:when test="//mov:IRenvelope/mov:InYearMovements/mov:EmployerName">
						<xsl:value-of select="//mov:IRenvelope/mov:InYearMovements/mov:EmployerName"/>
					</xsl:when>
					<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>
			<div class='not-required' style="left: 460px;top: 770px;width: 288px;text-align:center">
				Full address and post code not required for online submissions
			</div>			
			
			<xsl:comment> Postcode</xsl:comment>
			
			<xsl:comment> Date DD MM YYYY</xsl:comment>

			<xsl:if test="$issueDate.day != '&#160;'">			
				<ext:boxText text="{format-number($issueDate.day,'00')}" left="459" top="892" size="19"/>
				<ext:boxText text="{format-number($issueDate.month,'00')}" left="510" top="892" size="19"/>
				<ext:boxText text="{$issueDate.year}" left="561" top="892" size="20"/>
			</xsl:if>
			
			<xsl:comment> 14 If the employee has died,	write 'D' in this box and
						send all four parts of this form (unseparated) to your
						Inland Revenue office immediately.
			</xsl:comment>
			<div style="left:728px;top: 955px;width: 20px;text-align:center;" >
				<xsl:choose>
				<xsl:when test="$p45Part1/@DeceasedIndicator">
					D
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>				
			</div>			
			</div>
		</div>	
	</body>
</html>	
</xsl:template>			  
</xsl:stylesheet>
