<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
							  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
                              xmlns:eoy="selima:FBI Rendering">							  
<xsl:output method="html" encoding="UTF-8"/>
							  
<!-- These should be supplied by external stylesheet user-->
<xsl:param name="page">1</xsl:param>

<!-- These should be overriden by tax year specific stylesheets -->
<xsl:variable name="taxYear">XXXX</xsl:variable>
<xsl:variable name="page1Size">width: 788px; height: 1133px</xsl:variable>
<xsl:variable name="page2-3Size">width: 1152px;height: 1582px</xsl:variable>
<xsl:variable name="page4Size">width: 784px;height: 1115px</xsl:variable>
<xsl:variable name="csPageSize">width: 793px;height: 1124px</xsl:variable>

<xsl:template match="eoy:IRenvelope">
<!-- These are for internal use only and should not be overriden -->
<html>
	<head>
		<title>P35(<xsl:value-of select="$taxYear"/>)</title>
		<style type="text/css">
				body {
					margin: 0px;
					padding: 0px;
					color: blue;
					font: normal normal bold 11pt monospace;				
				}
					
				div {
					background: transparent none no-repeat scroll top left;
				}
				
				body * div {
					border: 1px dotted transparent;
					position: absolute;				
				}
				
				div.checkbox {
					font-family:sans-serif;text-align:center
				}
				
				div.large-text {
					font-size: 16pt
				}			
		</style>		
	</head>
	<body vlink="olive"> 
	<xsl:choose>
	<xsl:when test="$page='1'">
		<div style="background-image: url(images/p35_{$taxYear}_p1.png);{$page1Size}">
			<div style="{$page1Size}">
				<xsl:call-template name="page1"/>
			</div>
		</div>
	</xsl:when>
	<xsl:when test="$page='2-3'">
		<div style="background-image: url(images/p35_{$taxYear}_p2-3.png);{$page2-3Size}">
			<div style="{$page2-3Size}">
				<xsl:comment> Part1 Summary of employees and directors </xsl:comment>				
				<xsl:for-each select="//eoy:IRenvelope/eoy:EndOfYearReturn/eoy:P14[position() &lt;= 10]">
					<xsl:call-template name="page2-3Employee"/>
				</xsl:for-each>
				<xsl:call-template name="page2-3"/>
			</div>
		</div>
	</xsl:when>
	<xsl:when test="$page='4'">
		<div id="page4" style="background-image: url(images/p35_{$taxYear}_p4.png);{$page4Size}">
			<div style="{$page4Size}">
				<xsl:call-template name="page4"/>	
			</div>
		</div>	
	</xsl:when>
	<xsl:otherwise>
	<xsl:for-each select="//eoy:IRenvelope/eoy:EndOfYearReturn/eoy:P14[position()>10]">		
		<xsl:if test="position() mod 25 = 1 and ((position()-1) div 25 + 5) = $page">		  
			<div id="page-cs-{$page}" style="background-image: url(images/p35_{$taxYear}_cs_p{-($page mod 2)+2}.png);{$csPageSize}">
				<div style="{$csPageSize}">
					<xsl:comment>Continuation sheet <xsl:value-of select="$page"/> [<xsl:value-of select="position()"/>] </xsl:comment>
					<xsl:variable name="first" select="position()+9"/>
					<xsl:variable name="pageP14" select="self::* | following-sibling::eoy:P14[position() &lt; 25]"/>
					<xsl:for-each select="$pageP14">
						<xsl:call-template name="csPageEmployee">
							<xsl:with-param name="first" select="$first"/>
						</xsl:call-template>				
					</xsl:for-each>
					<xsl:call-template name="csPage">
						<xsl:with-param name="pageP14" select="$pageP14"/>
					</xsl:call-template>
				</div>
			</div>
		</xsl:if>		
	</xsl:for-each>	
	</xsl:otherwise>
</xsl:choose>
</body>
</html>
</xsl:template>

<xsl:template name="page1">
	Callback placeholder
</xsl:template>

<xsl:template name="page2-3">
	Callback placeholder
</xsl:template>

<xsl:template name="page2-3Employee">
	Callback placeholder
</xsl:template>

<xsl:template name="page4">
	Callback placeholder
</xsl:template>

<xsl:template name="csPageEmployee">
	Callback placeholder
</xsl:template>

<xsl:template name="csPage">
	Callback placeholder
</xsl:template>

<xsl:template match="cutting_rules">
	<cutting_rules>
		<xsl:apply-templates/>
	</cutting_rules>	
</xsl:template>

<xsl:template match="cutting_rules/*" priority="-9999">
	<xsl:comment>No cutting rules for <xsl:value-of select="name()"/></xsl:comment>
</xsl:template>

</xsl:stylesheet>
