<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
							  xmlns:ext="xalan://com.selima.fbi.webserver.XalanExtension"							  
							  extension-element-prefixes="ext"								  
                              xmlns:eoy="selima:FBI Rendering">
<ext:cuttingRules>
	<rules>
		<exclude path="/IRenvelope/IRheader"/>	
		<exclude path="/IRenvelope/EndOfYearReturn/*">
			<exception path="/IRenvelope/EndOfYearReturn/P14"/>
		</exclude>
		<exclude path="/IRenvelope/EndOfYearReturn/P14/*">
			<exception path="/IRenvelope/EndOfYearReturn/P14/Name"/>
			<exception path="/IRenvelope/EndOfYearReturn/P14/NINO"/>
			<exception path="/IRenvelope/EndOfYearReturn/P14/WkNo"/>
		</exclude>
	</rules>
</ext:cuttingRules>

<xsl:output method="xml" encoding="UTF-8"/>
							  
<xsl:template match="eoy:IRenvelope">
<pages>
	<xsl:for-each select="//eoy:IRenvelope/eoy:EndOfYearReturn/eoy:P14">
	<page id="{position()}">
		<keys>
			<key name="Name" default="true"><xsl:value-of select="eoy:Name/eoy:Sur"/> 
				<xsl:for-each select="eoy:Name/eoy:Fore">
						<xsl:if test="position() != 1">,</xsl:if>
						<xsl:value-of select="concat(' ',string(.))"/>
				</xsl:for-each>
			</key>
			<key name="NINO"><xsl:value-of select="eoy:NINO"/></key>
			<key name="WorksNumber"><xsl:value-of select="eoy:WkNo"/></key>
		</keys>
		<rules>
			<exclude path="/IRenvelope/EndOfYearReturn/P35"/>
			<exclude path="/IRenvelope/EndOfYearReturn/P14[position() &gt;= {position() + 1}]"/>
			<exclude path="/IRenvelope/EndOfYearReturn/P14/*">
				<exception path="/IRenvelope/EndOfYearReturn/P14[{position()}]/*"/>
			</exclude>
		</rules>		
	</page>
</xsl:for-each>	
</pages>
</xsl:template>
</xsl:stylesheet>
