<xsl:stylesheet version="1.1" xmlns="http://www.w3.org/1999/xhtml"
			  	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
			  xmlns:ext="xalan://com.selima.fbi.webserver.XalanExtension"							  
		  extension-element-prefixes="ext"							  
	      xmlns:eoy="selima:FBI Rendering">
<ext:annotation
	rewrite_from_ns="http://www.govtalk.gov.uk/taxation/EOY/\d{2}-\d{2}/1"
    rewrite_to_ns="selima:FBI Rendering"	
    metadata="P14(base).metadata.xsl"	
/>
<xsl:import href="P14(base).xsl"/>
<xsl:variable name="taxYear">2013</xsl:variable>
<xsl:variable name="page1Size">width: 1169px; height: 826px</xsl:variable>

<xsl:template name="page1">
	<xsl:variable name="iRenvelope" select="//eoy:IRenvelope"/>
	<xsl:variable name="p35" select="$iRenvelope/eoy:EndOfYearReturn/eoy:P35"/>
	<xsl:variable name="p14" select="$iRenvelope/eoy:EndOfYearReturn/eoy:P14[position()=$page]"/>

	<xsl:comment>Your name and address as employer</xsl:comment>
	<div style="left: 113px;top: 85px;width: 345px;">
		<xsl:choose>
			<xsl:when test="$p35"><xsl:value-of select="$p35/eoy:EmployerDetails/eoy:EmployerName"/></xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	</div>						
	<xsl:comment> HM Revenue &amp; Customs office name</xsl:comment>
	<div style="left: 440px;top: 58px;width: 413px">
	Known by HMRC
	</div>		
	<xsl:comment> Employer's  PAY  reference </xsl:comment>
	<div style="left: 862px;top: 58px;width: 19px;text-align: center">
		&#160;	
		<xsl:value-of select="substring($iRenvelope/eoy:IRheader/eoy:Keys/eoy:Key[@Type='TaxOfficeNumber'],1,1)"/>			
	</div>	
	<div style="left: 882px;top: 58px;width: 19px;text-align: center">
		&#160;	
		<xsl:value-of select="substring($iRenvelope/eoy:IRheader/eoy:Keys/eoy:Key[@Type='TaxOfficeNumber'],2,1)"/>			
	</div>	
	<div style="left: 902px;top: 58px;width: 19px;text-align: center">
		&#160;	
		<xsl:value-of select="substring($iRenvelope/eoy:IRheader/eoy:Keys/eoy:Key[@Type='TaxOfficeNumber'],3,1)"/>			
	</div>		
	<div style="left: 948px;top: 58px;width: 19px;text-align: center">			
		<xsl:value-of select="substring($iRenvelope/eoy:IRheader/eoy:Keys/eoy:Key[@Type='TaxOfficeReference'],1,1)"/>
		&#160;				
	</div>		
	<div style="left: 968px;top: 58px;width: 19px;text-align: center">			
		<xsl:value-of select="substring($iRenvelope/eoy:IRheader/eoy:Keys/eoy:Key[@Type='TaxOfficeReference'],2,1)"/>
		&#160;				
	</div>	
	<div style="left: 988px;top: 58px;width: 19px;text-align: center">			
		<xsl:value-of select="substring($iRenvelope/eoy:IRheader/eoy:Keys/eoy:Key[@Type='TaxOfficeReference'],3,1)"/>
		&#160;				
	</div>
	<div style="left: 1008px;top: 58px;width: 19px;text-align: center">			
		<xsl:value-of select="substring($iRenvelope/eoy:IRheader/eoy:Keys/eoy:Key[@Type='TaxOfficeReference'],4,1)"/>
		&#160;				
	</div>	
	<div style="left: 1028px;top: 58px;width: 19px;text-align: center">			
		<xsl:value-of select="substring($iRenvelope/eoy:IRheader/eoy:Keys/eoy:Key[@Type='TaxOfficeReference'],5,1)"/>
		&#160;				
	</div>		
	<div style="left: 1048px;top: 58px;width: 19px;text-align: center">			
		<xsl:value-of select="substring($iRenvelope/eoy:IRheader/eoy:Keys/eoy:Key[@Type='TaxOfficeReference'],6,1)"/>
		&#160;				
	</div>	
	<div style="left: 1068px;top: 58px;width: 19px;text-align: center">			
		<xsl:value-of select="substring($iRenvelope/eoy:IRheader/eoy:Keys/eoy:Key[@Type='TaxOfficeReference'],7,1)"/>
		&#160;				
	</div>	
	<xsl:comment>National Insurance number</xsl:comment>
	<div style="left: 158px;top: 195px;width: 30px;text-align: center">				
		<xsl:value-of select="substring($p14/eoy:NINO,1,2)"/>			
	</div>		
	<div style="left: 194px;top: 195px;width: 30px;text-align: center">				
		<xsl:value-of select="substring($p14/eoy:NINO,3,2)"/>			
	</div>		
	<div style="left: 232px;top: 195px;width: 30px;text-align: center">				
		<xsl:value-of select="substring($p14/eoy:NINO,5,2)"/>			
	</div>		
	<div style="left: 271px;top: 195px;width: 30px;text-align: center">				
		<xsl:value-of select="substring($p14/eoy:NINO,7,2)"/>			
	</div>		
	<div style="left: 308px;top: 195px;width: 25px;text-align: center">				
		<xsl:value-of select="translate(substring($p14/eoy:NINO,9,1),' ','&#160;')"/>			
	</div>		
	<xsl:comment>Date of birth in figures </xsl:comment>
	<xsl:comment> DD </xsl:comment>
	<div style="left: 376px;top: 195px;width: 30px;text-align: center">
		<xsl:choose>
			<xsl:when test="$p14/eoy:DOB"><xsl:value-of select="substring($p14/eoy:DOB,9,2)"/></xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>	
	</div>
	<xsl:comment> MM </xsl:comment>	
	<div style="left: 420px;top: 195px;width: 23px;text-align: center">
		<xsl:choose>
			<xsl:when test="$p14/eoy:DOB"><xsl:value-of select="substring($p14/eoy:DOB,6,2)"/></xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>				
	</div>			
	<xsl:comment> YYYY </xsl:comment>	
	<div style="left: 450px;top: 195px;width: 49px;text-align: center">
		<xsl:choose>
			<xsl:when test="$p14/eoy:DOB"><xsl:value-of select="substring($p14/eoy:DOB,1,4)"/></xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>							
	</div>		
	<xsl:comment>Gender</xsl:comment>
	<div style="left: 540px;top: 195px;width: 25px;text-align: center;text-transform:uppercase">
		<xsl:choose>
			<xsl:when test="$p14/eoy:Sex"><xsl:value-of select="substring($p14/eoy:Sex,1,1)"/></xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>										
	</div>		
	<xsl:comment>Surname</xsl:comment>
	<div style="left: 158px;top: 223px;width: 242px">				
		<xsl:value-of select="$p14/eoy:Name/eoy:Sur"/>			
	</div>		
	<xsl:comment>First two forenames</xsl:comment>
	<div style="left: 160px;top: 253px;width: 242px">				
		<xsl:value-of select="$p14/eoy:Name/eoy:Fore[1]"/>
	</div>
	<div style="left: 400px;top: 253px;width: 242px">			
		<xsl:value-of select="$p14/eoy:Name/eoy:Fore[2]"/>&#160;
	</div>		
	<xsl:comment>Works/ payroll number</xsl:comment>
	<div style="left: 160px;top: 283px;width: 242px">			
		<xsl:value-of select="$p14/eoy:WkNo"/>&#160;
	</div>		
	<xsl:comment>Employee's private address including postcode (if known)</xsl:comment>
	<div style="left: 685px;top: 188px;width: 292px">
		<xsl:choose>
			<xsl:when test="$p14/eoy:Address">
				<xsl:for-each select="$p14/eoy:Address/*">
					<xsl:value-of select="."/><br/>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	</div>		
	<xsl:comment>National Insurance contributions in this employement</xsl:comment>
	<xsl:for-each select="$p14/eoy:NICs">
	<xsl:variable name="y-offset" select="409+(position()-1)*34"/>
	<xsl:comment>NIC table letter</xsl:comment> 		
	<div style="left: 42px;top: {$y-offset}px;width: 20px;text-align:center">				
		<xsl:value-of select="@Tab"/>			
	</div>		
	<xsl:comment>Earnings at the LEL (where earnings are equal to or exceed the LEL)</xsl:comment>
	<div style="left: 90px;top: {$y-offset}px;width: 54px;text-align:right">				
		<xsl:value-of select="format-number(floor(eoy:Earn/eoy:AtLEL),'#0')"/>		
	</div>		
	<xsl:comment>Earnings above the LEL, up to and including the PT</xsl:comment>
	<div style="left: 198px;top: {$y-offset}px;width: 54px;text-align:right">				
		<xsl:value-of select="format-number(floor(eoy:Earn/eoy:LELtoPT),'#0')"/>			
	</div>
	<xsl:comment>Earnings above the ET up to and including the UAP</xsl:comment>
	<div style="left: 314px;top: {$y-offset}px;width: 53px;text-align:right">				
		<xsl:value-of select="format-number(floor(eoy:Earn/eoy:PTtoUAP),'#0')"/>			
	</div>
	<xsl:comment>Earnings above the UAP up to and including the UEL</xsl:comment>
	<div style="left: 419px;top: {$y-offset}px;width: 55px;text-align:right">				
		<xsl:value-of select="format-number(floor(eoy:Earn/eoy:UAPtoUEL),'#0')"/>			
	</div>				
	<xsl:comment>Total of employee's and employer's contributions</xsl:comment>	
	<div style="left: 495px;top: {$y-offset}px;width: 155px;text-align:right">			
			<xsl:value-of select="substring-before(format-number(eoy:Both,'0.00'),'.')"/>					
	</div>
	<div style="left: 670px;top: {$y-offset}px;width: 38px;text-align:right">			
			<xsl:value-of select="substring-after(format-number(eoy:Both, '0.00'),'.')"/>						
	</div>	
	<xsl:comment>If amount in col. 1d is a minus amount, enter 'R' here</xsl:comment>
	<div style="left: 728px;top: {$y-offset}px;width: 16px">
		<xsl:choose>
		<xsl:when test="eoy:Both &lt; 0">R</xsl:when>
		<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>		
	</div>
	<xsl:comment>Employee's contributions due on all earnings above the ET</xsl:comment>
	<div style="left: 723px;top: {$y-offset}px;width: 155px;text-align:right">			
			<xsl:value-of select="substring-before(format-number(eoy:Emp,'0.00'),'.')"/>					
	</div>
	<div style="left: 897px;top: {$y-offset}px;width: 38px;text-align:right">			
			<xsl:value-of select="substring-after(format-number(eoy:Emp, '0.00'),'.')"/>						
	</div>			
	<xsl:comment>Scheme Contracted-out Number</xsl:comment>
	<div style="left: 1000px;top: {$y-offset}px;width: 155px">				
		<xsl:value-of select="substring(eoy:SCON,2,8)"/>&#160;		
	</div>				
	</xsl:for-each>
	<xsl:comment>Statutory payments Included in the pay 'in this employement' figure below</xsl:comment>		
	<xsl:comment>Statutory Sick Pay (SSP)</xsl:comment>
	<div style="left: 28px;top: 594px;width: 76px;text-align:right">			
			<xsl:value-of select="substring-before(format-number($p14/eoy:SSP,'0.00'),'.')"/>					
	</div>
	<div style="left: 127px;top: 594px;width: 36px;text-align:right">			
			<xsl:value-of select="substring-after(format-number($p14/eoy:SSP, '0.00'),'.')"/>						
	</div>	
    <xsl:comment>Statutory Maternity Pay (SMP)</xsl:comment>
	<div style="left: 166px;top: 594px;width: 116px;text-align:right">			
			<xsl:value-of select="substring-before(format-number($p14/eoy:SMP,'0.00'),'.')"/>					
	</div>
	<div style="left: 304px;top: 594px;width: 36px;text-align:right">			
			<xsl:value-of select="substring-after(format-number($p14/eoy:SMP, '0.00'),'.')"/>						
	</div>	
		
    <xsl:comment>Ordinary Statutory Paternity Pay (OSPP)</xsl:comment>
	<div style="left: 348px;top: 594px;width: 76px;text-align:right">			
			<xsl:value-of select="substring-before(format-number($p14/eoy:OSPP,'0.00'),'.')"/>					
	</div>
	<div style="left: 442px;top: 594px;width: 36px;text-align:right">			
			<xsl:value-of select="substring-after(format-number($p14/eoy:OSPP, '0.00'),'.')"/>						
	</div>		
	
    <xsl:comment>Additional Statutory Paternity Pay (ASPP)</xsl:comment>
	<div style="left: 546px;top: 594px;width: 76px;text-align:right">			
			<xsl:value-of select="substring-before(format-number($p14/eoy:ASPP,'0.00'),'.')"/>					
	</div>
	<div style="left: 642px;top: 594px;width: 36px;text-align:right">			
			<xsl:value-of select="substring-after(format-number($p14/eoy:ASPP, '0.00'),'.')"/>						
	</div>	
	
	<xsl:comment>Statutory Adoption Pay (SAP)</xsl:comment>
	<div style="left: 756px;top: 594px;width: 76px;text-align:right">			
			<xsl:value-of select="substring-before(format-number($p14/eoy:SAP,'0.00'),'.')"/>					
	</div>
	<div style="left: 852px;top: 594px;width: 36px;text-align:right">			
			<xsl:value-of select="substring-after(format-number($p14/eoy:SAP, '0.00'),'.')"/>						
	</div>	

	<xsl:comment>Student Loan Deductions in this employment (whole $ only)</xsl:comment>
	<div style="left: 910px;top: 594px;width: 95px;text-align:right">			
		<xsl:value-of select="$p14/eoy:PayAndTax/eoy:ThisEmp/eoy:StLoan"/>
	</div>		
		
	<xsl:comment>Pay and Income Tax details</xsl:comment>
	<xsl:comment>In previous employments</xsl:comment>
    <div style="left: 401px;top: 656px;width: 155px;text-align:right">			
			<xsl:value-of select="substring-before(format-number($p14/eoy:PayAndTax/eoy:PrevEmp/eoy:TaxablePay,'0.00'),'.')"/>			
	</div>
	<div style="left: 576px;top: 656px;width: 36px;text-align:right">			
			<xsl:value-of select="substring-after(format-number($p14/eoy:PayAndTax/eoy:PrevEmp/eoy:TaxablePay, '0.00'),'.')"/>						
	</div>	
    <div style="left: 671px;top: 656px;width: 155px;text-align:right">			
			<xsl:value-of select="substring-after(format-number($p14/eoy:PayAndTax/eoy:PrevEmp/eoy:Tax,'0.00'),'.')"/>			
	</div>	
	<div style="left: 746px;top: 656px;width: 36px;text-align:right">			
			<xsl:value-of select="substring-before(format-number($p14/eoy:PayAndTax/eoy:PrevEmp/eoy:Tax, '0.00'),'.')"/>						
	</div>	
	<xsl:comment>In this employment</xsl:comment>
	<div style="left: 401px;top: 690px;width: 155px;text-align:right">			
			<xsl:value-of select="substring-before(format-number($p14/eoy:PayAndTax/eoy:ThisEmp/eoy:TaxablePay,'0.00'),'.')"/>			
	</div>
	<div style="left: 576px;top: 690px;width: 36px;text-align:right">			
			<xsl:value-of select="substring-after(format-number($p14/eoy:PayAndTax/eoy:ThisEmp/eoy:TaxablePay, '0.00'),'.')"/>						
	</div>	
    <div style="left: 671px;top: 690px;width: 155px;text-align:right">			
			<xsl:value-of select="substring-after(format-number($p14/eoy:PayAndTax/eoy:ThisEmp/eoy:Tax,'0.00'),'.')"/>			
	</div>
	<div style="left: 746px;top: 690px;width: 36px;text-align:right">			
			<xsl:value-of select="substring-before(format-number($p14/eoy:PayAndTax/eoy:ThisEmp/eoy:Tax, '0.00'),'.')"/>						
	</div>	
	<xsl:comment>Enter 'R' in this box if net refund</xsl:comment>
	<div style="left: 850px;top: 690px;width: 16px">
		<xsl:choose>
		<xsl:when test="$p14/eoy:PayAndTax/eoy:ThisEmp/eoy:Tax &lt; 0">R</xsl:when>
		<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>		
	</div>		
	<xsl:comment>Total for year</xsl:comment>
	<div style="left: 401px;top: 720px;width: 155px;text-align:right">
		<xsl:value-of select="substring-before(format-number(sum($p14/eoy:PayAndTax//eoy:TaxablePay),'0.00'),'.')"/>	
	</div>	
	<div style="left: 576px;top: 720px;width:36px;text-align:right">
		<xsl:value-of select="substring-after(format-number(sum($p14/eoy:PayAndTax//eoy:TaxablePay),'0.00'),'.')"/>	
	</div>	
	<div style="left: 671px;top: 720px;width: 155px;text-align:right">
		<xsl:value-of select="substring-after(format-number(sum($p14/eoy:PayAndTax//eoy:Tax),'0.00'),'.')"/>	
	</div>	
	<div style="left: 746px;top: 720px;width:36px;text-align:right">
		<xsl:value-of select="substring-before(format-number(sum($p14/eoy:PayAndTax//eoy:Tax),'0.00'),'.')"/>	
	</div>		
	<xsl:comment>Employee's Widows &amp; Orphans / Life Assurance contributions in this employment</xsl:comment>
	<div style="left: 496px;top: 756px;width: 155px;text-align:right">
		<xsl:value-of select="substring-before(format-number(sum($p14/eoy:PayAndTax/eoy:ThisEmp/eoy:WidOrph),'0.00'),'.')"/>	
	</div>	
	<div style="left: 670px;top: 756px;width:36px;text-align:right">
		<xsl:value-of select="substring-after(format-number(sum($p14/eoy:PayAndTax/eoy:ThisEmp/eoy:WidOrph),'0.00'),'.')"/>	
	</div>	
	<xsl:comment>Final tax code</xsl:comment>
	<div style="left: 866px;top: 756px;width: 78px">			
		<xsl:value-of select="$p14/eoy:PayAndTax/eoy:ThisEmp/eoy:Code"/>
	</div>
	<xsl:comment>Payment in week 53: if included in Pay and Tax totals enter '53', '54' or '56' here</xsl:comment>
	<div style="left: 938px;top: 756px;width: 34px">			
		<xsl:value-of select="$p14/eoy:PayAndTax/eoy:ThisEmp/eoy:Week53Indicator"/>&#160;
	</div>							
	<xsl:comment>Date of starting if during tax year to 5 April 2011</xsl:comment>
	<xsl:comment>DD</xsl:comment>
	<div style="left: 990px;top: 656px;width: 29px;text-align:center">
		<xsl:choose>
			<xsl:when test="$p14/eoy:PayAndTax/eoy:ThisEmp/eoy:Start">
				<xsl:value-of select="substring($p14/eoy:PayAndTax/eoy:ThisEmp/eoy:Start,9,2)"/>
			</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>	
	</div>
	<xsl:comment>MM</xsl:comment>
	<div style="left: 1035px;top: 656px;width: 22px;text-align:center">
		<xsl:choose>
			<xsl:when test="$p14/eoy:PayAndTax/eoy:ThisEmp/eoy:Start">
				<xsl:value-of select="substring($p14/eoy:PayAndTax/eoy:ThisEmp/eoy:Start,6,2)"/>
			</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>	
	</div>
	<xsl:comment>YYYY</xsl:comment>
	<div style="left: 1080px;top: 656px;width: 47px;text-align:center">
		<xsl:choose>
			<xsl:when test="$p14/eoy:PayAndTax/eoy:ThisEmp/eoy:Start">
				<xsl:value-of select="substring($p14/eoy:PayAndTax/eoy:ThisEmp/eoy:Start,1,4)"/>
			</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>	
	</div>	
	<xsl:comment>Date of leaving if during tax year to 5 April 2011</xsl:comment>
	<xsl:comment>DD</xsl:comment>		
	<div style="left: 990px;top: 690px;width: 29px;text-align:center">
		<xsl:choose>
			<xsl:when test="$p14/eoy:PayAndTax/eoy:ThisEmp/eoy:EndDate">
				<xsl:value-of select="substring($p14/eoy:PayAndTax/eoy:ThisEmp/eoy:EndDate,9,2)"/>
			</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>	
	</div>
	<xsl:comment>MM</xsl:comment>
	<div style="left: 1035px;top: 690px;width: 22px;text-align:center">
		<xsl:choose>
			<xsl:when test="$p14/eoy:PayAndTax/eoy:ThisEmp/eoy:EndDate">
				<xsl:value-of select="substring($p14/eoy:PayAndTax/eoy:ThisEmp/eoy:EndDate,6,2)"/>
			</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>	
	</div>
	<xsl:comment>YYYY</xsl:comment>
	<div style="left: 1080px;top: 690px;width: 47px;text-align:center">
		<xsl:choose>
			<xsl:when test="$p14/eoy:PayAndTax/eoy:ThisEmp/eoy:EndDate">
				<xsl:value-of select="substring($p14/eoy:PayAndTax/eoy:ThisEmp/eoy:EndDate,1,4)"/>
			</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>	
	</div>		
</xsl:template>

</xsl:stylesheet>
