<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
 xmlns:rti="selima:FBI Rendering"
 xmlns:ext="xalan://com.selima.fbi.webserver.XalanExtension"
 extension-element-prefixes="ext"
 xmlns:xalan="http://xml.apache.org/xalan"
 exclude-result-prefixes="xalan"
>
    <ext:annotation
     metadata="FPSEmployee(202X).metadata.xsl"
     rewrite_from_ns="http://www.govtalk.gov.uk/taxation/PAYE/RTI/FullPaymentSubmission/21-22/1"
     rewrite_to_ns="selima:FBI Rendering"
    />
    <xsl:output method="html" encoding="UTF-8"/>

    <xsl:param name="page">title-page</xsl:param>
    <xsl:param name="url"/>
	<xsl:variable name="pageSize">width: 826px; height: 1123px;</xsl:variable>
    <xsl:template match="/">
        <html>
            <head>
                <title>FPS(<xsl:value-of select="rti:IRenvelope/rti:FullPaymentSubmission/rti:RelatedTaxYear"/>)</title>
                <style type="text/css">
					body {
						margin: 0px;
						padding: 0px;
						font: normal normal normal 11pt monospace;
					}
                    
                    div {
                    background: transparent none no-repeat scroll top left;
                    }
                    
                    body * div {
                    position: absolute;
                    border: 1px dotted transparent;
                    }
                    
                    div.checkbox {
                    	font-family:sans-serif;text-align:center;
                    	border-left: 1px solid #606060;
                    	border-bottom: 1px solid #606060;
                    	border-right: 1px solid #D0D0D0;
                    	border-top: 1px solid #D0D0D0;
                        background-color: #FFD;
                        width: 19px;
	                    padding-left: 0px;
                    }
                    
                    div.large-text {
                    	font-size: 18pt
                    }
                    
                    div.number {
                    	text-align: right;
                    }
                    
                    div.date {
                    	text-align: center;
                    }
                    
                    div.label {
                    	color: black;
                    }
                    
                    div.section-header {
                    	font-size: 16pt;
                    }
                    
                    div.field {
                        border-bottom: 1px solid #008080;
                        padding-left: 5px;
                    	color: blue;
                    	font-weight: bold;
                    }
                    div.remark {
                        padding-left: 5px;
                    	color: gray;
                    }
                </style>
            </head>
            <body>
				<div style="background-image: url(images/fps.png);{$pageSize}">
					<div style="{$pageSize};padding:0px;padding-top:100px">
						<div style="left:20px;top:100px">
							<div style="position:relative">
								<div class="label">
									NINO
								</div>
								<div class="field" style="left:100px;width:125px">
									<xsl:value-of select="//rti:EmployeeDetails/rti:NINO"/>&#160;
								</div>					
								<div class="label" style="left:250px">
									Name
								</div>
								<div class="field" style="left:380px;width:400px">					
									<xsl:for-each select="//rti:EmployeeDetails/rti:Name/*">
										<xsl:value-of select="."/><xsl:text> </xsl:text>
									</xsl:for-each>
								</div>
							</div>
							<div style="position: relative">
								<div class="label">
									Birth Date	
								</div>
								<div class="field" style="left:100px;width:100px">
									<xsl:value-of select="ext:dateFormat(//rti:EmployeeDetails/rti:BirthDate)"/>&#160;
								</div>					
								<div class="label" style="left:250px">
									Passport Number
								</div>
								<div class="field" style="left:380px;width:225px">					
									<xsl:value-of select="//rti:EmployeeDetails/rti:PassportNumber"/>&#160;
								</div>
								<div class="label" style="left:690px">
									Gender
								</div>
								<div class="field" style="left:750px;width:25px">
									<xsl:value-of select="//rti:EmployeeDetails/rti:Gender"/>&#160;
								</div>	
							</div>
							<div style="position: relative">
								<div class="label">
									Partner NINO
								</div>
								<div class="field" style="left:100px;width:125px">
									<xsl:value-of select="//rti:EmployeeDetails/rti:PartnerDetails/rti:NINO"/>&#160;
								</div>
								<div class="label" style="left:250px">
									Partner Name
								</div>
								<div class="field" style="left:380px;width:400px">					
									<xsl:for-each select="//rti:EmployeeDetails/rti:PartnerDetails/rti:Name/*">
										<xsl:value-of select="."/><xsl:text> </xsl:text>
									</xsl:for-each>&#160;
								</div>
							</div>
							<xsl:for-each select="//rti:Employment">
							<div class="large-text" style="position:relative; margin: 25px 0px 0px 0px">
								Employment
							</div>
							<div style="position: relative">
								<div class="label">
									Off-Payroll Worker
								</div>
								<div class="field" style="left:150px;width:100px">
									<xsl:value-of select="rti:OffPayrollWorker"/>&#160;
								</div>
								<div class="label" style="left:275px">
									Director's NIC
								</div>
								<div class="field" style="left:380px;width:100px">					
									<xsl:value-of select="rti:DirectorsNIC"/>&#160;
								</div>
								<div class="label" style="left:520px">
									Tax Week No. of Appointment
								</div>
								<div class="field" style="left:750px;width:30px">
									<xsl:value-of select="rti:TaxWkOfApptOfDirector"/>&#160;
								</div>									
							</div>
							<div style="position: relative">
								<div class="label">
									Payroll ID
								</div>
								<div class="field" style="left:150px;width:100px">
									<xsl:value-of select="rti:PayId"/>&#160;
								</div>
								<div class="label" style="left:275px">
									Old Payroll ID
								</div>
								<div class="field" style="left:380px;width:100px">					
									<xsl:value-of select="rti:PayIdChgd/rti:OldPayrollId"/>&#160;
								</div>
								<div class="label" style="left:520px">
									Payroll id changed
								</div>
								<div class="field" style="left:750px;width:30px">
									<xsl:value-of select="rti:PayIdChgd/rti:PayrollIdChangedIndicator"/>&#160;
								</div>
							</div>							
							<div style="position: relative">
								<div class="label">
									OccPen Indicator
								</div>
								<div class="field" style="left:150px;width:100px">
									<xsl:value-of select="rti:OccPenInd"/>&#160;
								</div>
								<div class="label" style="left:275px">
									Student Loan
								</div>
								<div class="field" style="left:380px;width:100px">					
									<xsl:value-of select="rti:Starter/rti:StudentLoan"/>&#160;
								</div>
								<div class="label" style="left:520px">
									Postgraduate Loan
								</div>
								<div class="field" style="left:750px;width:30px">
									<xsl:value-of select="rti:Starter/rti:PostgradLoan"/>&#160;
								</div>													
							</div>			
							<div style="position: relative">
								<div class="label">
									Starting declaration
								</div>
								<div class="field" style="left:150px;width:100px">
									<xsl:value-of select="rti:Starter/rti:StartDec"/>&#160;
								</div>
								<div class="label" style="left:275px">
									Starting Date
								</div>
								<div class="field" style="left:380px;width:100px">
									<xsl:value-of select="ext:dateFormat(rti:Starter/rti:StartDate)"/>&#160;
								</div>
								<div class="label" style="left:520px">
									Leaving Date
								</div>
								<div class="field" style="left:685px;width:100px">
									<xsl:value-of select="ext:dateFormat(rti:LeavingDate)"/>&#160;
								</div>												
							</div>
							<div style="position: relative">
								<div class="label">
									In / out of the UK
								</div>
								<div class="field" style="left:150px;width:100px">
									<xsl:value-of select="rti:Starter/rti:Seconded/rti:InOutUK"/>&#160;
								</div>
								<div class="label" style="left:275px">
									EEA citizen
								</div>
								<div class="field" style="left:380px;width:100px">					
									<xsl:value-of select="rti:Starter/rti:Seconded/rti:EEACitizen"/>&#160;
								</div>
								<div class="label" style="left:520px">
									In UK for 183 days or more
								</div>
								<div class="field" style="left:750px;width:30px">
									<xsl:value-of select="rti:Starter/rti:Seconded/rti:Stay183DaysOrMore"/>&#160;
								</div>
							</div>							
							<div style="position: relative">						
								<div class="label">
									EPM6
								</div>
								<div class="field" style="left:150px;width:100px">					
									<xsl:value-of select="rti:Starter/rti:Seconded/rti:EPM6"/>&#160;
								</div>
								<div class="label" style="left:520px">
									In UK for less than 183 days
								</div>
								<div class="field" style="left:750px;width:30px">
									<xsl:value-of select="rti:Starter/rti:Seconded/rti:StayLessThan183Days"/>&#160;
								</div>
							</div>
							<div style="position: relative">
								<div class="label">
									Occ Pension
								</div>
								<div class="field" style="left:150px;width:130px">
									<xsl:value-of select="rti:Starter/rti:OccPension/rti:Amount"/>&#160;
								</div>
								<div class="label" style="left:300px">
									Bereaved
								</div>
								<div class="field" style="left:380px;width:100px">					
									<xsl:value-of select="rti:Starter/rti:OccPension/rti:Bereaved"/>&#160;
								</div>
								<div class="label" style="left:520px">
									Payment to a non individual
								</div>
								<div class="field" style="left:750px;width:30px">
									<xsl:value-of select="rti:PaymentToANonIndividual"/>&#160;
								</div>											
							</div>
							<div style="position: relative">
								<div class="label">
									State Pension
								</div>
								<div class="field" style="left:150px;width:130px">
									<xsl:value-of select="rti:Starter/rti:StatePension/rti:Amount"/>&#160;
								</div>
								<div class="label" style="left:300px">
									Bereaved
								</div>
								<div class="field" style="left:380px;width:100px">					
									<xsl:value-of select="rti:Starter/rti:StatePension/rti:Bereaved"/>&#160;
								</div>
								<div class="label" style="left:520px">
									Irregular Payment
								</div>
								<div class="field" style="left:750px;width:30px">
									<xsl:value-of select="rti:IrrEmp"/>&#160;
								</div>									
							</div>
							<div class="large-text" style="position:relative; margin: 25px 0px 0px 0px">
								Figures to date
							</div>
							<div style="position: relative">
								<div class="label">
									Taxable Pay
								</div>
								<div class="field" style="left:100px;width:25px">
									<xsl:value-of select="rti:FiguresToDate/rti:TaxablePay"/>&#160;
								</div>
								<div class="label" style="left:210px">
									Total Tax
								</div>
								<div class="field" style="left:290px;width:100px">
									<xsl:value-of select="rti:FiguresToDate/rti:TotalTax"/>&#160;
								</div>
								<div class="label" style="left:430px">
									Employee pen. contrib. not paid
								</div>
								<div class="field" style="left:675px;width:100px">
									<xsl:value-of select="rti:FiguresToDate/rti:EmpeePenContribnsNotPaidYTD"/>&#160;
								</div>
							</div>
							<div style="position: relative">
								<div class="label">
									Employee pension contributions paid
								</div>
								<div class="field" style="left:290px;width:100px">
									<xsl:value-of select="rti:FiguresToDate/rti:EmpeePenContribnsPaidYTD"/>&#160;
								</div>
								<div class="label" style="left:430px">
									Student Loan to date
								</div>
								<div class="field" style="left:675px;width:100px">
									<xsl:value-of select="rti:FiguresToDate/rti:StudentLoansTD"/>&#160;
								</div>
								
							</div>
							<div style="position: relative">
								<div class="label">
									Benefits taxed via payroll YTD
								</div>
								<div class="field" style="left:290px;width:100px">
									<xsl:value-of select="rti:FiguresToDate/rti:BenefitsTaxedViaPayrollYTD"/>&#160;
								</div>
								<div class="label" style="left:430px">
									Postgraduate Loan to date
								</div>
								<div class="field" style="left:675px;width:100px">
									<xsl:value-of select="rti:FiguresToDate/rti:PostgradLoansTD"/>&#160;
								</div>
							</div>
							<div class="large-text" style="position:relative; margin: 25px 0px 0px 0px">
								Payment
							</div>
							<div style="position: relative">
								<div class="label">
									Basc Hash Code
								</div>
								<div class="field" style="left:130px;width:650px">
									<xsl:value-of select="rti:Payment/rti:BacsHashCode"/>&#160;
								</div>
							</div>
							<div style="position: relative">
								<div class="label" style="left:0px">
									Pay frequency				
								</div>
								<div class="field" style="left:250px;width:100px">
									<xsl:value-of select="rti:Payment/rti:PayFreq"/>&#160;
								</div>						
								<div class="label" style="left:440px">
									Payment date
								</div>
								<div class="field" style="left:680px;width:100px">
									<xsl:value-of select="ext:dateFormat(rti:Payment/rti:PmtDate)"/>&#160;
								</div>
							</div>
							<div  style="position: relative">
								<div class="label" style="left:0px">
									Late reason
								</div>
								<div class="field" style="left:250px;width:100px">
									<xsl:value-of select="rti:Payment/rti:LateReason"/>&#160;
								</div>
								<div class="label" style="left: 440px">
									Weekly period
								</div>
								<div class="field" style="left:680px;width:100px">
									<xsl:value-of select="rti:Payment/rti:WeekNo"/>&#160;
								</div>				
							</div>
							<div style="position: relative">
								<div class="label" style="left:0px">
									Monthly period				
								</div>
								<div class="field" style="left:250px;width:100px">
									<xsl:value-of select="rti:Payment/rti:MonthNo"/>&#160;
								</div>
								<div class="label" style="left:440px">
									Periods covered
								</div>
								<div class="field" style="left:680px;width:100px">
									<xsl:value-of select="rti:Payment/rti:PeriodsCovered"/>&#160;
								</div>				
							</div>
							<div style="position: relative">			
								<div class="label" style="left:0px">
									Aggregated earnings
								</div>
								<div class="field" style="left:250px;width:100px">
									<xsl:value-of select="rti:Payment/rti:AggregatedEarnings"/>&#160;
								</div>
								<div class="label" style="left:440px">
									Payment after leaving				
								</div>
								<div class="field" style="left:680px;width:100px">
									<xsl:value-of select="rti:Payment/rti:PmtAfterLeaving"/>&#160;
								</div>				
							</div>			
							<div style="position: relative">
								<div class="label" style="left:0px">
									Hours worked
								</div>
								<div class="field" style="left:250px;width:100px">
									<xsl:value-of select="rti:Payment/rti:HoursWorked"/>&#160;
								</div>			
							</div>
							<div style="position: relative">			
								<div class="label"  style="left:0px">
									Tax code
								</div>
								<div class="field" style="left:250px;width:100px">
									<xsl:value-of select="rti:Payment/rti:TaxCode"/>&#160;
								</div>
								<div class="label" style="left:440px">
									Tax regime
								</div>
								<div class="field" style="left:680px;width:100px">
									<xsl:value-of select="rti:Payment/rti:TaxCode/@TaxRegime"/>&#160;
								</div>
							</div>
							<div style="position: relative">			
								<div class="label" style="left:440px">
									Taxable pay
								</div>
								<div class="field" style="left:680px;width:100px">
									<xsl:value-of select="rti:Payment/rti:TaxablePay"/>&#160;
								</div>								
								<div class="label" style="left:0px">
									Tax code basis is non-cumulative
								</div>
								<div class="field" style="left:250px;width:100px">
									<xsl:value-of select="rti:Payment/rti:TaxCode/@BasisNonCumulative"/>&#160;
								</div>								
							</div>
							<div style="position: relative">
								<div class="label" style="left:0px">
									Non TAX or NIC payments
								</div>
								<div class="field" style="left:250px;width:100px">
									<xsl:value-of select="rti:Payment/rti:NonTaxOrNICPmt"/>&#160;
								</div>						
								<div class="label" style="left:440px">
									Deductions from net
								</div>
								<div class="field" style="left:680px;width:100px">
									<xsl:value-of select="rti:Payment/rti:DednsFromNetPay"/>&#160;
								</div>
							</div>
							<div style="position: relative">
								<div class="label" style="left:0px">
									Pay after Statutory deductions
								</div>
								<div class="field" style="left:250  px;width:100px">
									<xsl:value-of select="rti:Payment/rti:PayAfterStatDedns"/>&#160;
								</div>						
								<div class="label" style="left:440px">
									Benefits taxed via the payroll
								</div>
								<div class="field" style="left:680px;width:100px">
									<xsl:value-of select="rti:Payment/rti:BenefitsTaxedViaPayroll"/>&#160;
								</div>				
							</div>
							<div style="position: relative">			
								<div class="label" style="left:0px">
									Employee pension contributions
								</div>
								<div class="field" style="left:250px;width:100px">
									<xsl:value-of select="rti:Payment/rti:EmpeePenContribnsPaid"/>&#160;
								</div>
								<div class="label" style="left:440px">
									Items subject to Class 1 NIC
								</div>
								<div class="field" style="left:680px;width:100px">
									<xsl:value-of select="rti:Payment/rti:ItemsSubjectToClass1NIC"/>&#160;
								</div>				
							</div>
							<div style="position: relative">			
								<div class="label" style="left:0px">
									Pension contributions not paid<br/>under 'net pay arrangements'
								</div>
								<div class="field" style="left:250px;width:100px">
									<xsl:value-of select="rti:Payment/rti:EmpeePenContribnsNotPaid"/>&#160;
								</div>
								<div class="label" style="left:440px">
									Total real-time Class 1A NICs<br/>
									year to date
								</div>
								<div class="field" style="left:680px;width:100px">
									<xsl:value-of select="rti:Payment/rti:Class1ANICsYTD"/>&#160;
								</div>							
							</div>					
							<div style="position: relative">
								<div class="label" style="left:0px">
									Tax deducted or refunded
								</div>
								<div class="field" style="left:250px;width:100px">
									<xsl:value-of select="rti:Payment/rti:TaxDeductedOrRefunded"/>&#160;
								</div>								
								<div class="label" style="left:440px">
									Student Loan Plan type
								</div>
								<div class="field" style="left:680px;width:100px">
									<xsl:value-of select="rti:Payment/rti:StudentLoanRecovered/@PlanType"/>&#160;
								</div>
							</div>			
							<div style="position: relative">
								<div class="label" style="left:0px">
									Student Loan recovered
								</div>
								<div class="field" style="left:250px;width:100px">
									<xsl:value-of select="rti:Payment/rti:StudentLoanRecovered"/>&#160;
								</div>								
								<div class="label" style="left:440px">
									Postgraduate Loan recovered
								</div>
								<div class="field" style="left:680px;width:100px">
									<xsl:value-of select="rti:Payment/rti:PostgradLoanRecovered"/>&#160;
								</div>								
							</div>
							<div style="position: relative">			
								<div class="label" style="left:0px">
									On strike
								</div>
								<div class="field" style="left:250px;width:100px">
									<xsl:value-of select="rti:Payment/rti:OnStrike"/>&#160;
								</div>										
								<div class="label" style="left:440px">
									Unpaid absence
								</div>
								<div class="field" style="left:680px;width:100px">
									<xsl:value-of select="rti:Payment/rti:UnpaidAbsence"/>&#160;
								</div>								
							</div>
							<div style="position: relative">			
								<div class="label">
									Statutory Maternity pay (SMP)
								</div>
								<div class="field" style="left:250px;width:100px">
									<xsl:value-of select="rti:Payment/rti:SMPYTD"/>&#160;
								</div>
								<div class="label" style="left:440px">
									Statutory Paternity pay (SPP)
								</div>
								<div class="field" style="left:680px;width:100px">
									<xsl:value-of select="rti:Payment/rti:SPPYTD"/>&#160;
								</div>
							</div>
							<div style="position: relative">			
								<div class="label">
									Statutory Adoption pay (SAP)
								</div>
								<div class="field" style="left:250px;width:100px">
									<xsl:value-of select="rti:Payment/rti:SAPYTD"/>&#160;
								</div>
								<div class="label" style="left:440px">
									Shared Parental pay (ShPP)
								</div>
								<div class="field" style="left:680px;width:100px">
									<xsl:value-of select="rti:Payment/rti:ShPPYTD"/>&#160;
								</div>
							</div>
							<div style="position: relative">			
								<div class="label">
									Parental Bereavement pay (SPBP)
								</div>
								<div class="field" style="left:250px;width:100px">
									<xsl:value-of select="rti:Payment/rti:SPBPYTD"/>&#160;
								</div>
							</div>							
							<div style="position: relative">			
								<div class="label" style="left:0px">
									Flexibly accessing pen. rights
								</div>
								<div class="field" style="left:250px;width:100px">
									<xsl:value-of select="rti:Payment/rti:FlexibleDrawdown/rti:FlexiblyAccessingPensionRights"/>&#160;
								</div>
								<div class="label" style="left:440px">
									Pension Death Benefit
								</div>
								<div class="field" style="left:680px;width:100px">
									<xsl:value-of select="rti:Payment/rti:FlexibleDrawdown/rti:PensionDeathBenefit"/>&#160;
								</div>
							</div>
							<div style="position:relative">
								<div class="label" style="left:0px">
									Flexible drawdown taxable<BR/>payment
								</div>
								<div class="field" style="left:250px;width:100px">
									<xsl:value-of select="rti:Payment/rti:FlexibleDrawdown/rti:TaxablePayment"/>&#160;
								</div>
								<div class="label" style="left:440px">
									Flexible drawdown non-taxable<BR/>payment
								</div>
								<div class="field" style="left:680px;width:100px">
									<xsl:value-of select="rti:Payment/rti:FlexibleDrawdown/rti:NontaxablePayment"/>&#160;
								</div>				
							</div>														
							<div class="large-text" style="position:relative; margin: 25px 0px 0px 0px">
								NI Letters and Values
							</div>
							<xsl:for-each select="rti:NIlettersAndValues">
							<div style="position: relative">			
								<div class="label" style="left:30px">
									(Category)
								</div>
								<div class="field" style="left:0px;width:20px">
									<xsl:value-of select="rti:NIletter"/>&#160;
								</div>
							</div>
							<div style="position: relative;left:20px; margin-top:10px">
								<div class="label">
									Gross earnings for NICs
								</div>
								<div class="label" style="left:340px">
									Year to date
								</div>
								<div class="field" style="left:440px;width:100px">
									<xsl:value-of select="rti:GrossEarningsForNICsYTD"/>&#160;
								</div>			
								<div class="label" style="left:560px">
									In this period
								</div>
								<div class="field" style="left:660px;width:100px">
									<xsl:value-of select="rti:GrossEarningsForNICsInPd"/>&#160;
								</div>
							</div>
							<div style="position: relative;left:20px">
								<div class="label">
									Total of employer NI contributions
								</div>
								<div class="label" style="left:340px">
									Year to date
								</div>				
								<div class="field" style="left:440px;width:100px">
									<xsl:value-of select="rti:TotalEmpNICYTD"/>&#160;				
								</div>			
								<div class="label" style="left:560px">
									In this period
								</div>
								<div class="field" style="left:660px;width:100px">
									<xsl:value-of select="rti:TotalEmpNICInPd"/>&#160;
								</div>
							</div>
							<div style="position: relative;left:20px">
								<div class="label">
									Employees contributions due on all earnings
								</div>
								<div class="label" style="left:340px">
									Year to date
								</div>				
								<div class="field" style="left:440px;width:100px">
									<xsl:value-of select="rti:EmpeeContribnsYTD"/>&#160;				
								</div>			
								<div class="label" style="left:560px">
									In this period
								</div>
								<div class="field" style="left:660px;width:100px">
									<xsl:value-of select="rti:EmpeeContribnsInPd"/>&#160;
								</div>
							</div>
							<div style="position: relative;left:20px;margin-top:10px">
								<div class="label">
									Earnings at Lower Earnings Limit
								</div>				
								<div class="field" style="left:610px;width:100px">
									<xsl:value-of select="rti:AtLELYTD"/>&#160;				
								</div>
							</div>
							<div  style="position: relative;left:20px">			
								<div class="label" style="left:0px">
									Earnings above Lower Earnings Limit to Primary Threshold
								</div>
								<div class="field" style="left:610px;width:100px">
									<xsl:value-of select="rti:LELtoPTYTD"/>&#160;
								</div>
							</div>
							<div  style="position: relative;left:20px">			
								<div class="label" style="left:0px">
									Earnings from the Primary Threshold up to and including the Upper Earnings Limit
								</div>
								<div class="field" style="left:610px;width:100px">
									<xsl:value-of select="rti:PTtoUELYTD"/>&#160;
								</div>
							</div>
							</xsl:for-each>						
							<xsl:if test="rti:Payment/rti:Benefits/rti:Car">
							<div class="large-text" style="position:relative; margin: 25px 0px 0px 0px">
								Cars
							</div>
							<xsl:for-each select="rti:Payment/rti:Benefits/rti:Car">
							<div style="position: relative; margin-top:10px">
								<div class="label" style="left:120px">
									(Car ID)
								</div>				
								<div class="field" style="left:0;width:100px">
									<xsl:value-of select="rti:ID"/>&#160;				
								</div>			
							</div>
							<div style="position: relative;left:20px">
								<div class="label" style="left:0px">
									Make and model of car
								</div>				
								<div class="field" style="left:210px;width:150px">
									<xsl:value-of select="rti:Make"/>&#160;				
								</div>
								<div class="label" style="left:420px">
									Date first registered
								</div>
								<div class="field" style="left:620px;width:100px">
									<xsl:value-of select="rti:FirstRegd"/>&#160;
								</div>
							</div>
							<div style="position: relative;left:20px">
								<div class="label" style="left:0px">
									CO2 emissions
								</div>				
								<div class="field" style="left:210px;width:150px">
									<xsl:value-of select="rti:CO2"/>&#160;		
								</div>
								<div class="label" style="left:420px">
									Zero emissions mileage
								</div>
								<div class="field" style="left:620px;width:100px">
									<xsl:value-of select="rti:ZeroEmissionsMileage"/>&#160;
								</div>
							</div>							
							<div style="position: relative;left:20px">
								<div class="label" style="left:0px">
									Fuel type
								</div>				
								<div class="field" style="left:210px;width:150px">
									<xsl:value-of select="rti:Fuel"/>&#160;				
								</div>
								<div class="label" style="left:420px">
									Amendment indicator
								</div>
								<div class="field" style="left:620px;width:100px">
									<xsl:value-of select="rti:Amendment"/>&#160;
								</div>
							</div>
							<div style="position: relative;left:20px">
								<div class="label" style="left:0px">
									Calculated price
								</div>				
								<div class="field" style="left:210px;width:150px">
									<xsl:value-of select="rti:Price"/>&#160;				
								</div>
								<div class="label" style="left:420px">
									Cash equivalent of car
								</div>
								<div class="field" style="left:620px;width:100px">
									<xsl:value-of select="rti:CashEquiv"/>&#160;
								</div>
							</div>
							<div style="position: relative;left:20px">
								<div class="label" style="left:0px">
									Available from
								</div>				
								<div class="field" style="left:210px;width:150px">
									<xsl:value-of select="ext:dateFormat(rti:AvailFrom)"/>&#160;				
								</div>
								<div class="label" style="left:420px">
									Available to
								</div>
								<div class="field" style="left:620px;width:100px">
									<xsl:value-of select="ext:dateFormat(rti:AvailTo)"/>&#160;
								</div>
							</div>
							<div style="position: relative;left:20px">
								<div class="label" style="left:0px">
									Date free fuel provided
								</div>
								<div class="field" style="left:210px;width:150px">
									<xsl:value-of select="ext:dateFormat(rti:FreeFuel/rti:Provided)"/>&#160;				
								</div>
								<div class="label" style="left:420px">
									Cash equivalent of fuel
								</div>
								<div class="field" style="left:620px;width:100px">
									<xsl:value-of select="rti:CashEquiv"/>&#160;
								</div>
							</div>
							<div style="position: relative;left:20px">
								<div class="label" style="left:0px">
									Date free fuel withdrawn
								</div>
								<div class="field" style="left:210px;width:150px">
									<xsl:value-of select="ext:dateFormat(rti:FreeFuel/rti:Withdrawn)"/>&#160;				
								</div>
							</div>
							</xsl:for-each>
							</xsl:if>					
							</xsl:for-each>
							<div style="position:relative;margin:20px">
							</div>
						</div>   
			        </div>
		        </div>
			</body>
		</html>    
	</xsl:template>

</xsl:stylesheet>
