<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
 xmlns:eps="selima:FBI Rendering"
 xmlns:ext="xalan://com.selima.fbi.webserver.XalanExtension"
 extension-element-prefixes="ext"
 xmlns:xalan="http://xml.apache.org/xalan"
 exclude-result-prefixes="xalan"
>
    <ext:annotation
     	metadata="EPS(base).metadata.xsl"
		rewrite_from_ns="http://www.govtalk.gov.uk/taxation/PAYE/RTI/EmployerPaymentSummary/17-18/1"
    	rewrite_to_ns="selima:FBI Rendering"
    />	
    <xsl:import href="EPS(base).xsl"/>  
    

	<xsl:variable name="leftAccount_column1" select="$leftEdge"/>
	<xsl:variable name="topAccount_line1" select="$topAccountsOfficeReference + 2 * $rowHeight"/>
	<xsl:variable name="topAccount_line2" select="$topAccount_line1 + $rowHeight"/>
	<xsl:variable name="topAccount_line3" select="$topAccount_line2 + $rowHeight"/>
	<xsl:variable name="topAccount_line4" select="$topAccount_line3 + $rowHeight"/>	
	<xsl:variable name="leftAccount_column2" select="$leftFieldPayeReference"/>
	<xsl:variable name="widthAccount_column1" select="$leftAccount_column2 - $leftAccount_column1 - $labelGap"/>
	<xsl:variable name="widthAccount_column2" select="$widthFieldPayeReference"/>
	<xsl:variable name="widthAccount_column2_to_5" select="$leftTaxYearField + $widthTaxYearField - $leftAccount_column2 + $labelGap"/>
	
	<xsl:variable name="topNoPaymentPeriod" select="$topAccount_line4 + 2 * $rowHeight"/>
	<xsl:variable name="topPeriodOfInactivity" select="$topNoPaymentPeriod + $rowHeight + 10"/>	
	<xsl:variable name="topFinalSubmission" select="$topPeriodOfInactivity + 2* $rowHeight"/>
	<xsl:variable name="topFinalSubmissionForYear" select="$topFinalSubmission + $rowHeight + 10"/>
	
    <xsl:variable name="topEmpAllowanceIndicator" select="$topFinalSubmissionForYear + 2 * $rowHeight"/>
    <xsl:variable name="widthLabelEmpAllowanceIndicator" select="250"/>
	<xsl:variable name="leftEmpAllowanceIndicator_label" select="$leftEdge"/>    
    <xsl:variable name="leftEmpAllowanceIndicator_column1" select="$leftFieldBecauseSchemeCeased - $labelGap - 30"/>
    <xsl:variable name="leftEmpAllowanceIndicator_column2" select="$leftFieldBecauseSchemeCeased"/>
    <xsl:variable name="leftEmpAllowanceIndicator_column3" select="$leftLabelDateSchemeCeased"/>
    <xsl:variable name="leftEmpAllowanceIndicator_column4" select="$leftLabelDateSchemeCeased + 30 + $labelGap"/>
	<xsl:variable name="topRecoverableAmountsYTD" select="$topEmpAllowanceIndicator + 3 * $rowHeight"/>
	<xsl:variable name="widthLabelApprenticeshipLevy" select="375"/>
	<xsl:variable name="leftLabelApprenticeshipLevy" select="$leftEdge"/>
	<xsl:variable name="topLabelApprenticeshipLevy" select="$topQuestionsAndDeclarations - 30"/>
	<xsl:variable name="apprenticeshipLevy_line1" select="$topLabelApprenticeshipLevy + $rowHeight + 10"/>	
	<xsl:variable name="apprenticeshipLevy_line2" select="$apprenticeshipLevy_line1 + $rowHeight"/>
	<xsl:variable name="apprenticeshipLevy_line3" select="$apprenticeshipLevy_line2 + $rowHeight"/>
	<xsl:variable name="apprenticeshipLevy_column1" select="$leftEdge"/>
	<xsl:variable name="apprenticeshipLevy_column2" select="$leftRecoverableAmountsYTD_column3"/>
	<xsl:variable name="apprenticeshipLevy_width1" select="$apprenticeshipLevy_column2 - $apprenticeshipLevy_column1 - $labelGap"/>
	<xsl:variable name="apprenticeshipLevy_width2" select="$widthFieldtopRecoverableAmountsYTD"/>

	<xsl:template name="bellow-header">
		<div class="label" style="left: {$leftAccount_column1}px;top: {$topAccount_line1}px;width: {widthAccount_column1}px;">
		 Account Holder	
		</div>
		<div class="field" style="left: {$leftAccount_column2}px;top: {$topAccount_line1}px;width: {$widthAccount_column2_to_5}px;">
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:Account/eps:AccountHoldersName"/>&#160;
		</div>
		<div class="label" style="left: {$leftAccount_column1}px;top: {$topAccount_line2}px;width: {$widthAccount_column1}px;">
		 Building Soc. Ref.
		</div>
		<div class="field" style="left: {$leftAccount_column2}px;top: {$topAccount_line2}px;width: {$widthAccount_column2}px;">
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:Account/eps:BuildingSocRef"/>&#160;
		</div>
		<div class="label" style="left: {$leftAccount_column1}px;top: {$topAccount_line3}px;width: {widthAccount_column1}px;">
		 Account Number
		</div>
		<div class="field" style="left: {$leftAccount_column2}px;top: {$topAccount_line3}px;width: {$widthAccount_column2}px;">
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:Account/eps:AccountNo"/>&#160;
		</div>
		<div class="label" style="left: {$leftAccount_column1}px;top: {$topAccount_line4}px;width: {$widthAccount_column1}px;">
		 Branch Sort Code
		</div>
		<div class="field" style="left: {$leftAccount_column2}px;top: {$topAccount_line4}px;width: {$widthAccount_column2}px;">
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:Account/eps:SortCode"/>&#160;
		</div>
	</xsl:template>
        
	<xsl:template name="recovered-amounts-ytd">	
	
		<div class="label" style="left: {$leftEmpAllowanceIndicator_label}px;top: {$topEmpAllowanceIndicator}px;width: {$widthLabelEmpAllowanceIndicator}px;">
			Employment Allowance Indicator
		 </div>
		<div class="label" style="left: {$leftEmpAllowanceIndicator_column1}px;top: {$topEmpAllowanceIndicator}px;width: {$widthYesNoLabel}px;">
			Yes
		 </div>		 
		<div class="checkbox field" style="left: {$leftEmpAllowanceIndicator_column2}px;top: {$topEmpAllowanceIndicator}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=empAllceInd editor=YesNoBox
		    	params="yes;no"
		    	tooltip="If you are eligible to claim new annual £2,000 allowance
		    			 for all businesses, charities and Community Amateur
		    			 Sports Clubs to be offset against your employer Class 1
		    			 Secondary NICs from April 2014 you should indicate 'Yes'
		    			 the claim will be retained until such time as you cease
		    			 to qualify, which you would do by selecting No."</xsl:text>
		  	</xsl:processing-instruction>
			<xsl:choose>
		 	<xsl:when test="eps:IRenvelope/eps:EmployerPaymentSummary/eps:EmpAllceInd = 'yes'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		 </div>
		<div class="label" style="left: {$leftEmpAllowanceIndicator_column3}px;top: {$topEmpAllowanceIndicator}px;width: {$widthYesNoLabel}px;">
			No
		 </div>		 
		<div class="checkbox field" style="left: {$leftEmpAllowanceIndicator_column4}px;top: {$topEmpAllowanceIndicator}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=empAllceInd editor=YesNoBox
		    	params="no;yes"
		    	tooltip="If you are eligible to claim new annual £2,000 allowance
		    			 for all businesses, charities and Community Amateur
		    			 Sports Clubs to be offset against your employer Class 1
		    			 Secondary NICs from April 2014 you should indicate 'Yes'
		    			 the claim will be retained until such time as you cease
		    			 to qualify, which you would do by selecting No."</xsl:text>
		  	</xsl:processing-instruction>
			<xsl:choose>
		 	<xsl:when test="eps:IRenvelope/eps:EmployerPaymentSummary/eps:EmpAllceInd = 'no'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		 </div>	
		<!-- Recovered Amounts YTD -->
		<div class="section-header" style="left: {$leftRecoverableAmountsYTD}px;top: {$topRecoverableAmountsYTD}px;width: {$widthRecoverableAmountsYTD}px;">
		 Recoverable Amounts Year To Date
		</div>
		
		<!--  line 1  -->
		<div class="label" style="left: {$leftRecoverableAmountsYTD_column1}px;top: {$topRecoverableAmountsYTD_line1}px;width: {$widthLabeltopRecoverableAmountsYTD}px;">
			Tax Month
		 </div>
		<div class="field number" style="left: {$leftRecoverableAmountsYTD_column2}px;top: {$topRecoverableAmountsYTD_line1}px;width: {$widthFieldtopRecoverableAmountsYTD}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=taxMonth editor=IntegerField
		    	tooltip="Applies from October 2014: Can be used to indicate which tax month the EPS	credit should be allocated against.
		    	
		    	If included, the EPS must be submitted between the dates defined in the relevant technical specifications for electronic submissions. If this optional field is not supplied, credits will be allocated based on the submission date."</xsl:text>
		  	</xsl:processing-instruction>
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:RecoverableAmountsYTD/eps:TaxMonth"/>&#160;
		 </div>	
		
		<div class="label" style="left: {$leftRecoverableAmountsYTD_column3}px;top: {$topRecoverableAmountsYTD_line1}px;width: {$widthLabeltopRecoverableAmountsYTD}px;">
			CIS Deductions Suffered
		 </div>
		<div class="field number" style="left: {$leftRecoverableAmountsYTD_column4}px;top: {$topRecoverableAmountsYTD_line1}px;width: {$widthFieldtopRecoverableAmountsYTD}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=cisDeductionsSuffered editor=MoneyField
		    	tooltip="You will only need to make an entry if you are a limited
		    	         company that has had CIS deductions made from 
		    	         payments you received for work in the construction
		    	         industry.
		    	          
		    	         Enter the total amount of CIS deductions you suffered in
		    	         the year to date."</xsl:text>
		  	</xsl:processing-instruction>
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:RecoverableAmountsYTD/eps:CISDeductionsSuffered"/>&#160;
		 </div>
		 	
		<!--  line2 -->
		<div class="label" style="left: {$leftRecoverableAmountsYTD_column1}px;top: {$topRecoverableAmountsYTD_line2}px;width: {$widthLabeltopRecoverableAmountsYTD}px;">
			SMP Recovered
		 </div>
		<div class="field number" style="left: {$leftRecoverableAmountsYTD_column2}px;top: {$topRecoverableAmountsYTD_line2}px;width: {$widthFieldtopRecoverableAmountsYTD}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=smpRecovered editor=MoneyField
		    	tooltip="Enter the total amount of SMP you recovered year to date.
		    	
		    			 https://www.gov.uk/browse/employing-people/time-off"</xsl:text>
		  	</xsl:processing-instruction>
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:RecoverableAmountsYTD/eps:SMPRecovered"/>&#160;
		 </div>		
		<div class="label" style="left: {$leftRecoverableAmountsYTD_column3}px;top: {$topRecoverableAmountsYTD_line2}px;width: {$widthLabeltopRecoverableAmountsYTD}px;">
			NIC Compensation On SMP
		 </div>
		<div class="field number" style="left: {$leftRecoverableAmountsYTD_column4}px;top: {$topRecoverableAmountsYTD_line2}px;width: {$widthFieldtopRecoverableAmountsYTD}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=nicCompensationOnSMP editor=MoneyField
		    	tooltip="Enter any compensation you are entitled to claim in
		    	         addition to the SMP you recovered year to date.
		    	         
		    			 https://www.gov.uk/browse/employing-people/time-off"</xsl:text>
		  	</xsl:processing-instruction>
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:RecoverableAmountsYTD/eps:NICCompensationOnSMP"/>&#160;
		 </div>
		  
		 <!--  line3 -->
		<div class="label" style="left: {$leftRecoverableAmountsYTD_column1}px;top: {$topRecoverableAmountsYTD_line3}px;width: {$widthLabeltopRecoverableAmountsYTD}px;">
			SPP Recovered
		 </div>
		<div class="field number" style="left: {$leftRecoverableAmountsYTD_column2}px;top: {$topRecoverableAmountsYTD_line3}px;width: {$widthFieldtopRecoverableAmountsYTD}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=sppRecovered editor=MoneyField
		    	tooltip="Enter the total amount of SPP you recovered year to date.
		    	
		    			 https://www.gov.uk/browse/employing-people/time-off"</xsl:text>
		  	</xsl:processing-instruction>
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:RecoverableAmountsYTD/eps:SPPRecovered"/>&#160;
		 </div>
		<div class="label" style="left: {$leftRecoverableAmountsYTD_column3}px;top: {$topRecoverableAmountsYTD_line3}px;width: {$widthLabeltopRecoverableAmountsYTD}px;">
			NIC Compensation On SPP
		 </div>
		<div class="field number" style="left: {$leftRecoverableAmountsYTD_column4}px;top: {$topRecoverableAmountsYTD_line3}px;width: {$widthFieldtopRecoverableAmountsYTD}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=nicCompensationOnSPP editor=MoneyField
		    	tooltip="Enter any compensation you are entitled to claim in
		    	         addition to the SPP you recovered year to date.
		    	         
		    			 https://www.gov.uk/browse/employing-people/time-off"</xsl:text>
		  	</xsl:processing-instruction>
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:RecoverableAmountsYTD/eps:NICCompensationOnSPP"/>&#160;
		 </div>
		 
		 <!--  line4 -->
		<div class="label" style="left: {$leftRecoverableAmountsYTD_column1}px;top: {$topRecoverableAmountsYTD_line4}px;width: {$widthLabeltopRecoverableAmountsYTD}px;">
			SAP Recovered
		 </div>
		<div class="field number" style="left: {$leftRecoverableAmountsYTD_column2}px;top: {$topRecoverableAmountsYTD_line4}px;width: {$widthFieldtopRecoverableAmountsYTD}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=sapRecovered editor=MoneyField
		    	tooltip="Enter the total amount of SAP you recovered year to date.
		    	
		    			 https://www.gov.uk/browse/employing-people/time-off"</xsl:text>
		  	</xsl:processing-instruction>		
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:RecoverableAmountsYTD/eps:SAPRecovered"/>&#160;
		 </div>	
		<div class="label" style="left: {$leftRecoverableAmountsYTD_column3}px;top: {$topRecoverableAmountsYTD_line4}px;width: {$widthLabeltopRecoverableAmountsYTD}px;">
			NIC Compensation On SAP
		 </div>
		<div class="field number" style="left: {$leftRecoverableAmountsYTD_column4}px;top: {$topRecoverableAmountsYTD_line4}px;width: {$widthFieldtopRecoverableAmountsYTD}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=nicCompensationOnSAP editor=MoneyField
		    	tooltip="Enter any compensation you are entitled to claim in
		    	         addition to the SAP you recovered year to date.
		    	         
		    			 https://www.gov.uk/browse/employing-people/time-off"</xsl:text>
		  	</xsl:processing-instruction>		
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:RecoverableAmountsYTD/eps:NICCompensationOnSAP"/>&#160;
		 </div>	
		 
  		 <!--  line5 -->
		<div class="label" style="left: {$leftRecoverableAmountsYTD_column1}px;top: {$topRecoverableAmountsYTD_line5}px;width: {$widthLabeltopRecoverableAmountsYTD}px;">
			ShPP Recovered
		 </div>
		<div class="field number" style="left: {$leftRecoverableAmountsYTD_column2}px;top: {$topRecoverableAmountsYTD_line5}px;width: {$widthFieldtopRecoverableAmountsYTD}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=shppRecovered editor=MoneyField
		    	tooltip="Enter the total amount of ASPP/ShPP you recovered year to date.
		    	
		    			 https://www.gov.uk/browse/employing-people/time-off"</xsl:text>
		  	</xsl:processing-instruction>	
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:RecoverableAmountsYTD/eps:ShPPRecovered"/>&#160;
		 </div>
		<div class="label" style="left: {$leftRecoverableAmountsYTD_column3}px;top: {$topRecoverableAmountsYTD_line5}px;width: {$widthLabeltopRecoverableAmountsYTD}px;">
			NIC Compensation On ShPP
		 </div>
		<div class="field number" style="left: {$leftRecoverableAmountsYTD_column4}px;top: {$topRecoverableAmountsYTD_line5}px;width: {$widthFieldtopRecoverableAmountsYTD}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=nicCompensationOnShPP editor=MoneyField
		    	tooltip="Enter any compensation you are entitled to claim in
		    	         addition to the ASPP/ShPP you recovered year to date.
		    	         
		    			 https://www.gov.uk/browse/employing-people/time-off"</xsl:text>
		  	</xsl:processing-instruction>
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:RecoverableAmountsYTD/eps:NICCompensationOnShPP"/>&#160;
		 </div>
  		 <!--  line6 -->
	</xsl:template>

	<xsl:template name="questions-and-declarations">
		<div class="section-header" style="left: {$leftLabelApprenticeshipLevy}px;top: {$topLabelApprenticeshipLevy}px;width: {$widthLabelApprenticeshipLevy}px;">
		 Apprenticeship Levy
		</div>
		<div class="label" style="left: {$apprenticeshipLevy_column1}px;top: {$apprenticeshipLevy_line1}px;width: {$apprenticeshipLevy_width1}px;">
			Apprenticeship Levy due year to date
		</div>
		<div class="field number" style="left: {$apprenticeshipLevy_column2}px;top: {$apprenticeshipLevy_line1}px;width: {$apprenticeshipLevy_width2}px;">
			<xsl:processing-instruction name="editor">
				<xsl:text>property=levyDueYTD editor=MoneyField
				tooltip="Enter the total Apprenticeship Levy due year to date.

						 If applicable for Apprenticeship Levy, an EPS submission is 
						 required. You will need to continue making submissions 
						 for the remainder of the year, even if levy due YTD amount 
						 for any subsequent months is zero."</xsl:text>
		  	</xsl:processing-instruction>	
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:ApprenticeshipLevy/eps:LevyDueYTD"/>&#160;
		</div>
		<div class="label" style="left: {$apprenticeshipLevy_column1}px;top: {$apprenticeshipLevy_line2}px;width: {$apprenticeshipLevy_width1}px;">
			Tax month
		</div>
		<div class="field number" style="left: {$apprenticeshipLevy_column2}px;top: {$apprenticeshipLevy_line2}px;width: {$apprenticeshipLevy_width2}px;">
			<xsl:processing-instruction name="editor">
				<xsl:text>property=apprenticeshipLevyTaxMonth editor=IntegerField
				tooltip="Enter the tax month for the levy due to date amount.

						 If applicable for Apprenticeship Levy, an EPS submission is
						 required. You will need to continue making submissions
						 for the remainder of the year, even if levy due YTD amount
						 for any subsequent months is zero."</xsl:text>
		  	</xsl:processing-instruction>
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:ApprenticeshipLevy/eps:TaxMonth"/>&#160;
		</div>
		<div class="label" style="left: {$apprenticeshipLevy_column1}px;top: {$apprenticeshipLevy_line3}px;width: {$apprenticeshipLevy_width1}px;">
			Annual Apprenticeship Levy allowance amount
		</div>
		<div class="field number" style="left: {$apprenticeshipLevy_column2}px;top: {$apprenticeshipLevy_line3}px;width: {$apprenticeshipLevy_width2}px;">
			<xsl:processing-instruction name="editor">
				<xsl:text>property=annualAllce editor=MoneyField
				tooltip="Enter the annual Levy Allowance amount allocated.

						 If applicable for Apprenticeship Levy, an EPS submission is 
						 required. You will need to continue making submissions 
						 for the remainder of the year, even if levy due YTD amount
						 for any subsequent months is zero."</xsl:text>
		  	</xsl:processing-instruction>	
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:ApprenticeshipLevy/eps:AnnualAllce"/>&#160;
		</div>
	</xsl:template>
 
</xsl:stylesheet>
