<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
 xmlns:eps="selima:FBI Rendering"
 xmlns:ext="xalan://com.selima.fbi.webserver.XalanExtension"
 extension-element-prefixes="ext"
 xmlns:xalan="http://xml.apache.org/xalan"
 exclude-result-prefixes="xalan"
>
    <ext:annotation
     	metadata="EPS(base).metadata.xsl"
		rewrite_from_ns="http://www.govtalk.gov.uk/taxation/PAYE/RTI/EmployerPaymentSummary/15-16/1"
    	rewrite_to_ns="selima:FBI Rendering"
    />	
    <xsl:import href="EPS(base).xsl"/>
    <xsl:variable name="topEmpAllowanceIndicator" select="$topRecoverableAmountsYTD_line6 + $rowHeight"/>
    <xsl:variable name="widthLabelEmpAllowanceIndicator" select="250"/>
    <xsl:variable name="topEmpAllowanceIndicator_line1" select="$topEmpAllowanceIndicator + $rowHeight"/>
    <xsl:variable name="leftEmpAllowanceIndicator_column1" select="$leftQuestionsAndDeclarations_column1"/>
    <xsl:variable name="leftEmpAllowanceIndicator_column2" select="$leftQuestionsAndDeclarations_column2 "/>
    <xsl:variable name="leftEmpAllowanceIndicator_column3" select="$leftQuestionsAndDeclarations_column3"/>
    <xsl:variable name="leftEmpAllowanceIndicator_column4" select="$leftQuestionsAndDeclarations_column4"/>
	<xsl:variable name="topQuestionsAndDeclarations" select="$topEmpAllowanceIndicator_line1 + 2 * $rowHeight"/>

	<xsl:variable name="leftAccount_column1" select="$leftEdge"/>
	<xsl:variable name="topAccount_line1" select="$topAccountsOfficeReference + $rowHeight"/>
	<xsl:variable name="topAccount_line2" select="$topAccount_line1 + $rowHeight"/>
	<xsl:variable name="topAccount_line3" select="$topAccount_line2 + $rowHeight"/>
	<xsl:variable name="leftAccount_column2" select="$leftFieldPayeReference"/>
	<xsl:variable name="widthAccount_column1" select="$leftAccount_column2 - $leftAccount_column1 - $labelGap"/>
	<xsl:variable name="leftAccount_column3" select="$leftLabelDateSchemeCeased"/>
	<xsl:variable name="widthAccount_column2" select="$leftAccount_column3 - $leftAccount_column2 - 30"/>
	<xsl:variable name="leftAccount_column4" select="$leftAccount_column3 + 150"/>
	<xsl:variable name="widthAccount_column3" select="$leftAccount_column4 - $leftAccount_column3 - $labelGap"/>
	<xsl:variable name="leftAccount_column5" select="$leftTaxYearField + $widthTaxYearField + 20"/>
	<xsl:variable name="widthAccount_column4" select="$leftAccount_column5 - $leftAccount_column4 - $labelGap"/>
	
	<xsl:variable name="topNoPaymentPeriod" select="$topAccount_line3 + $rowHeight + 20"/>
	<xsl:variable name="topRecoverableAmountsYTD" select="$topFinalSubmissionForYear + $rowHeight + 25"/>

	<xsl:template name="bellow-header">
		<div class="label" style="left: {$leftAccount_column1}px;top: {$topAccount_line1}px;width: {widthAccount_column1}px;">
		 Account Holder	
		</div>
		<div class="field" style="left: {$leftAccount_column2}px;top: {$topAccount_line1}px;width: {$widthAccount_column2}px;">
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:Account/eps:AccountHoldersName"/>&#160;
		</div>
		<div class="label" style="left: {$leftAccount_column3}px;top: {$topAccount_line1}px;width: {$widthAccount_column3}px;">
		 Building Soc. Ref.
		</div>
		<div class="field" style="left: {$leftAccount_column4}px;top: {$topAccount_line1}px;width: {$widthAccount_column4}px;">
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:Account/eps:BuildingSocRef"/>&#160;
		</div>
		<div class="label" style="left: {$leftAccount_column3}px;top: {$topAccount_line2}px;width: {widthAccount_column3}px;">
		 Account Number
		</div>
		<div class="field" style="left: {$leftAccount_column4}px;top: {$topAccount_line2}px;width: {$widthAccount_column4}px;">
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:Account/eps:AccountNo"/>&#160;
		</div>
		<div class="label" style="left: {$leftAccount_column3}px;top: {$topAccount_line3}px;width: {$widthAccount_column3}px;">
		 Branch Sort Code
		</div>
		<div class="field" style="left: {$leftAccount_column4}px;top: {$topAccount_line3}px;width: {$widthAccount_column4}px;">
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:Account/eps:SortCode"/>&#160;
		</div>
	</xsl:template>
    
    <xsl:template name="above-questions-and-declarations">
		<div class="label" style="left: {$leftEmpAllowanceIndicator_column1}px;top: {$topEmpAllowanceIndicator}px;width: {$widthLabelEmpAllowanceIndicator}px;">
			Employment Allowance Indicator
		 </div>
		<div class="label" style="left: {$leftEmpAllowanceIndicator_column1}px;top: {$topEmpAllowanceIndicator_line1}px;width: {$widthYesNoLabel}px;">
			Yes
		 </div>		 
		<div class="checkbox field" style="left: {$leftEmpAllowanceIndicator_column2}px;top: {$topEmpAllowanceIndicator_line1}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=empAllceInd editor=YesNoBox
		    	params="yes;no"
		    	tooltip="If you are eligible to claim new annual £2,000 allowance
		    			 for all businesses, charities and Community Amateur
		    			 Sports Clubs to be offset against your employer Class 1
		    			 Secondary NICs from April 2014 you should indicate 'Yes'
		    			 the claim will be retained until such time as you cease
		    			 to qualify, which you would do by selecting No."</xsl:text>
		  	</xsl:processing-instruction>
			<xsl:choose>
		 	<xsl:when test="eps:IRenvelope/eps:EmployerPaymentSummary/eps:EmpAllceInd = 'yes'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		 </div>
		<div class="label" style="left: {$leftEmpAllowanceIndicator_column3}px;top: {$topEmpAllowanceIndicator_line1}px;width: {$widthYesNoLabel}px;">
			No
		 </div>		 
		<div class="checkbox field" style="left: {$leftEmpAllowanceIndicator_column4}px;top: {$topEmpAllowanceIndicator_line1}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=empAllceInd editor=YesNoBox
		    	params="no;yes"
		    	tooltip="If you are eligible to claim new annual £2,000 allowance
		    			 for all businesses, charities and Community Amateur
		    			 Sports Clubs to be offset against your employer Class 1
		    			 Secondary NICs from April 2014 you should indicate 'Yes'
		    			 the claim will be retained until such time as you cease
		    			 to qualify, which you would do by selecting No."</xsl:text>
		  	</xsl:processing-instruction>
			<xsl:choose>
		 	<xsl:when test="eps:IRenvelope/eps:EmployerPaymentSummary/eps:EmpAllceInd = 'no'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		 </div>
    </xsl:template>
    
	<xsl:template name="recovered-amounts-ytd">	
		<!-- Recovered Amounts YTD -->
		<div class="section-header" style="left: {$leftRecoverableAmountsYTD}px;top: {$topRecoverableAmountsYTD}px;width: {$widthRecoverableAmountsYTD}px;">
		 Recoverable Amounts Year To Date
		</div>
		
		<!--  line 1  -->
		<div class="label" style="left: {$leftRecoverableAmountsYTD_column1}px;top: {$topRecoverableAmountsYTD_line1}px;width: {$widthLabeltopRecoverableAmountsYTD}px;">
			Tax Month
		 </div>
		<div class="field number" style="left: {$leftRecoverableAmountsYTD_column2}px;top: {$topRecoverableAmountsYTD_line1}px;width: {$widthFieldtopRecoverableAmountsYTD}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=taxMonth editor=IntegerField
		    	tooltip="Applies from October 2014: Can be used to indicate which tax month the EPS	credit should be allocated against.
		    	
		    	If included, the EPS must be submitted between the dates defined in the relevant technical specifications for electronic submissions. If this optional field is not supplied, credits will be allocated based on the submission date."</xsl:text>
		  	</xsl:processing-instruction>
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:RecoverableAmountsYTD/eps:TaxMonth"/>&#160;
		 </div>	
		
		<div class="label" style="left: {$leftRecoverableAmountsYTD_column3}px;top: {$topRecoverableAmountsYTD_line1}px;width: {$widthLabeltopRecoverableAmountsYTD}px;">
			CIS Deductions Suffered
		 </div>
		<div class="field number" style="left: {$leftRecoverableAmountsYTD_column4}px;top: {$topRecoverableAmountsYTD_line1}px;width: {$widthFieldtopRecoverableAmountsYTD}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=cisDeductionsSuffered editor=MoneyField
		    	tooltip="You will only need to make an entry if you are a limited
		    	         company that has had CIS deductions made from 
		    	         payments you received for work in the construction
		    	         industry.
		    	          
		    	         Enter the total amount of CIS deductions you suffered in
		    	         the year to date."</xsl:text>
		  	</xsl:processing-instruction>
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:RecoverableAmountsYTD/eps:CISDeductionsSuffered"/>&#160;
		 </div>
		 	
		<!--  line2 -->
		<div class="label" style="left: {$leftRecoverableAmountsYTD_column1}px;top: {$topRecoverableAmountsYTD_line2}px;width: {$widthLabeltopRecoverableAmountsYTD}px;">
			SMP Recovered
		 </div>
		<div class="field number" style="left: {$leftRecoverableAmountsYTD_column2}px;top: {$topRecoverableAmountsYTD_line2}px;width: {$widthFieldtopRecoverableAmountsYTD}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=smpRecovered editor=MoneyField
		    	tooltip="Enter the total amount of SMP you recovered year to date.
		    	
		    			 https://www.gov.uk/browse/employing-people/time-off"</xsl:text>
		  	</xsl:processing-instruction>
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:RecoverableAmountsYTD/eps:SMPRecovered"/>&#160;
		 </div>		
		<div class="label" style="left: {$leftRecoverableAmountsYTD_column3}px;top: {$topRecoverableAmountsYTD_line2}px;width: {$widthLabeltopRecoverableAmountsYTD}px;">
			NIC Compensation On SMP
		 </div>
		<div class="field number" style="left: {$leftRecoverableAmountsYTD_column4}px;top: {$topRecoverableAmountsYTD_line2}px;width: {$widthFieldtopRecoverableAmountsYTD}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=nicCompensationOnSMP editor=MoneyField
		    	tooltip="Enter any compensation you are entitled to claim in
		    	         addition to the SMP you recovered year to date.
		    	         
		    			 https://www.gov.uk/browse/employing-people/time-off"</xsl:text>
		  	</xsl:processing-instruction>
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:RecoverableAmountsYTD/eps:NICCompensationOnSMP"/>&#160;
		 </div>
		  
		 <!--  line3 -->
		<div class="label" style="left: {$leftRecoverableAmountsYTD_column1}px;top: {$topRecoverableAmountsYTD_line3}px;width: {$widthLabeltopRecoverableAmountsYTD}px;">
			SPP Recovered
		 </div>
		<div class="field number" style="left: {$leftRecoverableAmountsYTD_column2}px;top: {$topRecoverableAmountsYTD_line3}px;width: {$widthFieldtopRecoverableAmountsYTD}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=sppRecovered editor=MoneyField
		    	tooltip="Enter the total amount of SPP you recovered year to date.
		    	
		    			 https://www.gov.uk/browse/employing-people/time-off"</xsl:text>
		  	</xsl:processing-instruction>
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:RecoverableAmountsYTD/eps:SPPRecovered"/>&#160;
		 </div>
		<div class="label" style="left: {$leftRecoverableAmountsYTD_column3}px;top: {$topRecoverableAmountsYTD_line3}px;width: {$widthLabeltopRecoverableAmountsYTD}px;">
			NIC Compensation On SPP
		 </div>
		<div class="field number" style="left: {$leftRecoverableAmountsYTD_column4}px;top: {$topRecoverableAmountsYTD_line3}px;width: {$widthFieldtopRecoverableAmountsYTD}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=nicCompensationOnSPP editor=MoneyField
		    	tooltip="Enter any compensation you are entitled to claim in
		    	         addition to the SPP you recovered year to date.
		    	         
		    			 https://www.gov.uk/browse/employing-people/time-off"</xsl:text>
		  	</xsl:processing-instruction>
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:RecoverableAmountsYTD/eps:NICCompensationOnSPP"/>&#160;
		 </div>
		 
		 <!--  line4 -->
		<div class="label" style="left: {$leftRecoverableAmountsYTD_column1}px;top: {$topRecoverableAmountsYTD_line4}px;width: {$widthLabeltopRecoverableAmountsYTD}px;">
			SAP Recovered
		 </div>
		<div class="field number" style="left: {$leftRecoverableAmountsYTD_column2}px;top: {$topRecoverableAmountsYTD_line4}px;width: {$widthFieldtopRecoverableAmountsYTD}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=sapRecovered editor=MoneyField
		    	tooltip="Enter the total amount of SAP you recovered year to date.
		    	
		    			 https://www.gov.uk/browse/employing-people/time-off"</xsl:text>
		  	</xsl:processing-instruction>		
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:RecoverableAmountsYTD/eps:SAPRecovered"/>&#160;
		 </div>	
		<div class="label" style="left: {$leftRecoverableAmountsYTD_column3}px;top: {$topRecoverableAmountsYTD_line4}px;width: {$widthLabeltopRecoverableAmountsYTD}px;">
			NIC Compensation On SAP
		 </div>
		<div class="field number" style="left: {$leftRecoverableAmountsYTD_column4}px;top: {$topRecoverableAmountsYTD_line4}px;width: {$widthFieldtopRecoverableAmountsYTD}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=nicCompensationOnSAP editor=MoneyField
		    	tooltip="Enter any compensation you are entitled to claim in
		    	         addition to the SAP you recovered year to date.
		    	         
		    			 https://www.gov.uk/browse/employing-people/time-off"</xsl:text>
		  	</xsl:processing-instruction>		
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:RecoverableAmountsYTD/eps:NICCompensationOnSAP"/>&#160;
		 </div>	
		 
  		 <!--  line5 -->
		<div class="label" style="left: {$leftRecoverableAmountsYTD_column1}px;top: {$topRecoverableAmountsYTD_line5}px;width: {$widthLabeltopRecoverableAmountsYTD}px;">
			ShPP Recovered
		 </div>
		<div class="field number" style="left: {$leftRecoverableAmountsYTD_column2}px;top: {$topRecoverableAmountsYTD_line5}px;width: {$widthFieldtopRecoverableAmountsYTD}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=shppRecovered editor=MoneyField
		    	tooltip="Enter the total amount of ASPP/ShPP you recovered year to date.
		    	
		    			 https://www.gov.uk/browse/employing-people/time-off"</xsl:text>
		  	</xsl:processing-instruction>	
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:RecoverableAmountsYTD/eps:ShPPRecovered"/>&#160;
		 </div>
		<div class="label" style="left: {$leftRecoverableAmountsYTD_column3}px;top: {$topRecoverableAmountsYTD_line5}px;width: {$widthLabeltopRecoverableAmountsYTD}px;">
			NIC Compensation On ShPP
		 </div>
		<div class="field number" style="left: {$leftRecoverableAmountsYTD_column4}px;top: {$topRecoverableAmountsYTD_line5}px;width: {$widthFieldtopRecoverableAmountsYTD}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=nicCompensationOnShPP editor=MoneyField
		    	tooltip="Enter any compensation you are entitled to claim in
		    	         addition to the ASPP/ShPP you recovered year to date.
		    	         
		    			 https://www.gov.uk/browse/employing-people/time-off"</xsl:text>
		  	</xsl:processing-instruction>
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:RecoverableAmountsYTD/eps:NICCompensationOnShPP"/>&#160;
		 </div>
  		 <!--  line6 -->
	</xsl:template>
	
	<xsl:template name="bellow-questions-and-declarations">
		<div class="label" style="left: {$leftQuestionsAndDeclarations_column5}px;top: {$topQuestionsAndDeclarations}px;width: {$widthLabelQuestionsAndDeclarations}px;">
			This optional section is omitted from submission.
		 </div>			 
		 <div class="label" style="left: {$leftQuestionsAndDeclarations_column5}px;top: {$topQuestionsAndDeclarations + $rowHeight}px;width: {$widthLabelQuestionsAndDeclarations}px;">
			Yes
		 </div>
		<div class="checkbox field" style="left: {$leftQuestionsAndDeclarations_column6}px;top: {$topQuestionsAndDeclarations + $rowHeight}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=questionsAndDeclarationsNotFilled editor=YesBox
		    	params="no;yes"
		    	tooltip="Idicate 'Yes' to omit this optional section from submission to HRMC."
		  		</xsl:text>
		  	</xsl:processing-instruction>	
			<xsl:choose>
		 	<xsl:when test="not(eps:IRenvelope/eps:EmployerPaymentSummary/eps:QuestionsAndDeclarations)">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		 </div>
		 
	</xsl:template>
    
</xsl:stylesheet>
