<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
 xmlns:eps="selima:FBI Rendering"
 xmlns:ext="xalan://com.selima.fbi.webserver.XalanExtension"
 extension-element-prefixes="ext"
 xmlns:xalan="http://xml.apache.org/xalan"
 exclude-result-prefixes="xalan"
>
    <ext:annotation
     	metadata="EPS(base).metadata.xsl"
		rewrite_from_ns="http://www.govtalk.gov.uk/taxation/PAYE/RTI/EmployerPaymentSummary/13-14/2"
    	rewrite_to_ns="selima:FBI Rendering"
    />	
    <xsl:import href="EPS(base).xsl"/>
    
	<xsl:template name="recovered-amounts-ytd">	
		<!-- Recovered Amounts YTD -->
		<div class="section-header" style="left: {$leftRecoverableAmountsYTD}px;top: {$topRecoverableAmountsYTD}px;width: {$widthRecoverableAmountsYTD}px;">
		 Recoverable Amounts Year To Date
		</div>
		<!--  line1 -->
		<div class="label" style="left: {$leftRecoverableAmountsYTD_column1}px;top: {$topRecoverableAmountsYTD_line1}px;width: {$widthLabeltopRecoverableAmountsYTD}px;">
			SSP Recovered
		 </div>
		<div class="field number" style="left: {$leftRecoverableAmountsYTD_column2}px;top: {$topRecoverableAmountsYTD_line1}px;width: {$widthFieldtopRecoverableAmountsYTD}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=sspRecovered editor=MoneyField
		    	tooltip="Enter the total amount of SSP you recovered year to date.
		    	
		    			 http://www.hmrc.gov.uk/paye/employees/statutory-pay/ssp-calc.htm"</xsl:text>
		  	</xsl:processing-instruction>
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:RecoverableAmountsYTD/eps:SSPRecovered"/>&#160;
		 </div>
		<div class="label" style="left: {$leftRecoverableAmountsYTD_column3}px;top: {$topRecoverableAmountsYTD_line1}px;width: {$widthLabeltopRecoverableAmountsYTD}px;">
			SMP Recovered
		 </div>
		<div class="field number" style="left: {$leftRecoverableAmountsYTD_column4}px;top: {$topRecoverableAmountsYTD_line1}px;width: {$widthFieldtopRecoverableAmountsYTD}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=smpRecovered editor=MoneyField
		    	tooltip="Enter the total amount of SMP you recovered year to date.
		    	
		    			 http://www.hmrc.gov.uk/paye/employees/statutory-pay/smp-calc.htm"</xsl:text>
		  	</xsl:processing-instruction>
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:RecoverableAmountsYTD/eps:SMPRecovered"/>&#160;
		 </div>		
		 
		 <!--  line2 -->
		<div class="label" style="left: {$leftRecoverableAmountsYTD_column1}px;top: {$topRecoverableAmountsYTD_line2}px;width: {$widthLabeltopRecoverableAmountsYTD}px;">
			OSPP Recovered
		 </div>
		<div class="field number" style="left: {$leftRecoverableAmountsYTD_column2}px;top: {$topRecoverableAmountsYTD_line2}px;width: {$widthFieldtopRecoverableAmountsYTD}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=osppRecovered editor=MoneyField
		    	tooltip="Enter the total amount of OSPP you recovered year to date.
		    	
		    			 http://www.hmrc.gov.uk/paye/employees/statutory-pay/spp-calc.htm"</xsl:text>
		  	</xsl:processing-instruction>
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:RecoverableAmountsYTD/eps:OSPPRecovered"/>&#160;
		 </div>
		<div class="label" style="left: {$leftRecoverableAmountsYTD_column3}px;top: {$topRecoverableAmountsYTD_line2}px;width: {$widthLabeltopRecoverableAmountsYTD}px;">
			SAP Recovered
		 </div>
		<div class="field number" style="left: {$leftRecoverableAmountsYTD_column4}px;top: {$topRecoverableAmountsYTD_line2}px;width: {$widthFieldtopRecoverableAmountsYTD}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=sapRecovered editor=MoneyField
		    	tooltip="Enter the total amount of SAP you recovered year to date.
		    	
		    			 http://www.hmrc.gov.uk/paye/employees/statutory-pay/sap-calc.htm"</xsl:text>
		  	</xsl:processing-instruction>		
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:RecoverableAmountsYTD/eps:SAPRecovered"/>&#160;
		 </div>	
		 
		 <!--  line3 -->
		<div class="label" style="left: {$leftRecoverableAmountsYTD_column1}px;top: {$topRecoverableAmountsYTD_line3}px;width: {$widthLabeltopRecoverableAmountsYTD}px;">
			ASPP Recovered
		 </div>
		<div class="field number" style="left: {$leftRecoverableAmountsYTD_column2}px;top: {$topRecoverableAmountsYTD_line3}px;width: {$widthFieldtopRecoverableAmountsYTD}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=asppRecovered editor=MoneyField
		    	tooltip="Enter the total amount of ASPP you recovered year to date.
		    	
		    			 http://www.hmrc.gov.uk/paye/employees/statutory-pay/aspp-calc.htm"</xsl:text>
		  	</xsl:processing-instruction>	
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:RecoverableAmountsYTD/eps:ASPPRecovered"/>&#160;
		 </div>
		<div class="label" style="left: {$leftRecoverableAmountsYTD_column3}px;top: {$topRecoverableAmountsYTD_line3}px;width: {$widthLabeltopRecoverableAmountsYTD}px;">
			NIC Compensation On SMP
		 </div>
		<div class="field number" style="left: {$leftRecoverableAmountsYTD_column4}px;top: {$topRecoverableAmountsYTD_line3}px;width: {$widthFieldtopRecoverableAmountsYTD}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=nicCompensationOnSMP editor=MoneyField
		    	tooltip="Enter any compensation you are entitled to claim in
		    	         addition to the SMP you recovered year to date.
		    	         
		    			 http://www.hmrc.gov.uk/paye/employees/statutory-pay/smp-calc.htm"</xsl:text>
		  	</xsl:processing-instruction>
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:RecoverableAmountsYTD/eps:NICCompensationOnSMP"/>&#160;
		 </div>
		 
  		 <!--  line4 -->
		<div class="label" style="left: {$leftRecoverableAmountsYTD_column1}px;top: {$topRecoverableAmountsYTD_line4}px;width: {$widthLabeltopRecoverableAmountsYTD}px;">
			NIC Compensation On OSPP
		 </div>
		<div class="field number" style="left: {$leftRecoverableAmountsYTD_column2}px;top: {$topRecoverableAmountsYTD_line4}px;width: {$widthFieldtopRecoverableAmountsYTD}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=nicCompensationOnOSPP editor=MoneyField
		    	tooltip="Enter any compensation you are entitled to claim in
		    	         addition to the OSPP you recovered year to date.
		    	         
		    			 http://www.hmrc.gov.uk/paye/employees/statutory-pay/spp-calc.htm"</xsl:text>
		  	</xsl:processing-instruction>
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:RecoverableAmountsYTD/eps:NICCompensationOnOSPP"/>&#160;
		 </div>
		<div class="label" style="left: {$leftRecoverableAmountsYTD_column3}px;top: {$topRecoverableAmountsYTD_line4}px;width: {$widthLabeltopRecoverableAmountsYTD}px;">
			NIC Compensation On SAP
		 </div>
		<div class="field number" style="left: {$leftRecoverableAmountsYTD_column4}px;top: {$topRecoverableAmountsYTD_line4}px;width: {$widthFieldtopRecoverableAmountsYTD}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=nicCompensationOnSAP editor=MoneyField
		    	tooltip="Enter any compensation you are entitled to claim in
		    	         addition to the SAP you recovered year to date.
		    	         
		    			 http://www.hmrc.gov.uk/paye/employees/statutory-pay/sap-calc.htm"</xsl:text>
		  	</xsl:processing-instruction>		
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:RecoverableAmountsYTD/eps:NICCompensationOnSAP"/>&#160;
		 </div>	
		 
  		 <!--  line5 -->
		<div class="label" style="left: {$leftRecoverableAmountsYTD_column1}px;top: {$topRecoverableAmountsYTD_line5}px;width: {$widthLabeltopRecoverableAmountsYTD}px;">
			NIC Compensation On ASPP
		 </div>
		<div class="field number" style="left: {$leftRecoverableAmountsYTD_column2}px;top: {$topRecoverableAmountsYTD_line5}px;width: {$widthFieldtopRecoverableAmountsYTD}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=nicCompensationOnASPP editor=MoneyField
		    	tooltip="Enter any compensation you are entitled to claim in
		    	         addition to the ASPP you recovered year to date.
		    	         
		    			 http://www.hmrc.gov.uk/paye/employees/statutory-pay/aspp-calc.htm"</xsl:text>
		  	</xsl:processing-instruction>
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:RecoverableAmountsYTD/eps:NICCompensationOnASPP"/>&#160;
		 </div>
		<div class="label" style="left: {$leftRecoverableAmountsYTD_column3}px;top: {$topRecoverableAmountsYTD_line5}px;width: {$widthLabeltopRecoverableAmountsYTD}px;">
			CIS Deductions Suffered
		 </div>
		<div class="field number" style="left: {$leftRecoverableAmountsYTD_column4}px;top: {$topRecoverableAmountsYTD_line5}px;width: {$widthFieldtopRecoverableAmountsYTD}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=cisDeductionsSuffered editor=MoneyField
		    	tooltip="You will only need to make an entry if you are a limited
		    	         company that has had CIS deductions made from 
		    	         payments you received for work in the construction
		    	         industry.
		    	          
		    	         Enter the total amount of CIS deductions you suffered in
		    	         the year to date."</xsl:text>
		  	</xsl:processing-instruction>
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:RecoverableAmountsYTD/eps:CISDeductionsSuffered"/>&#160;
		 </div>		
		 
  		 <!--  line6 -->
		<div class="label" style="left: {$leftRecoverableAmountsYTD_column1}px;top: {$topRecoverableAmountsYTD_line6}px;width: {$widthLabeltopRecoverableAmountsYTD}px;">
			NICs Holiday
		 </div>
		<div class="field number" style="left: {$leftRecoverableAmountsYTD_column2}px;top: {$topRecoverableAmountsYTD_line6}px;width: {$widthFieldtopRecoverableAmountsYTD}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=nicsHoliday editor=MoneyField
		    	tooltip="This only applies to employers who are registered for the
		    	         Regional Employer NICs Holiday for New Businesses scheme.
		    	         Enter the total amount of employer Class 1 NICs you are
		    	         entitled to withhold in the tax year to date.
		    	          
		    	         You can find guidance on the NICs Holiday scheme at     
		    	         http://www.hmrc.gov.uk/paye/intro/nics-holiday/index.htm"</xsl:text>
		  	</xsl:processing-instruction>
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:RecoverableAmountsYTD/eps:NICsHoliday"/>&#160;
		 </div>
	</xsl:template>
    
</xsl:stylesheet>
