<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
 xmlns:rti="selima:FBI Rendering"
 xmlns:ext="xalan://com.selima.fbi.webserver.XalanExtension"
 extension-element-prefixes="ext"
 xmlns:xalan="http://xml.apache.org/xalan"
 exclude-result-prefixes="xalan"
>
        <xsl:variable name="pageType">
            <xsl:choose>
                <xsl:when test="$page = 1">title page</xsl:when>
                <xsl:when test="$page mod 2 = 0">cont. sheet 1</xsl:when>
                <xsl:otherwise>cont. sheet 2</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
		<xsl:variable name="firstPosition">
			<xsl:choose>
			<xsl:when test="$pageType='title page'">
				<xsl:value-of select="0"/>
			</xsl:when>
			<xsl:when test="$pageType='cont. sheet 1'">
				<xsl:value-of select="floor(($page - 2) div 2) * 66 + 25"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="floor(($page - 2) div 2) * 66 + 57"/>
			</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="lastPosition">
			<xsl:choose>
			<xsl:when test="$pageType='title page'">
				<xsl:value-of select="24"/>
			</xsl:when>
			<xsl:when test="$pageType='cont. sheet 1'">
				<xsl:value-of select="$firstPosition + 31"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$firstPosition + 33"/>
			</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
	
    <xsl:output method="html" encoding="UTF-8"/>
    
    <!-- These should be supplied by external stylesheet user-->
    <xsl:param name="page">1</xsl:param>
	
    <xsl:template match="/">
		<xsl:variable name="employees" select="//rti:IRenvelope/rti:EmployerAlignmentSubmission/rti:Employee[ $firstPosition &lt;= position() and position() &lt;= $lastPosition]"/>	
        <html>
            <head>
                <title>EAS</title>
                <style type="text/css">
                    body {
                    margin: 0px;
                    padding: 0px;
                    color: blue;
                    font: normal normal bold 11pt monospace;
                    }
                    
                    div {
                    background: transparent none no-repeat scroll top left;
                    }
                    
                    body * div {
                    position: absolute;
                    border: 1px dotted transparent;
                    }
                    
                    div.checkbox {
                    font-family:sans-serif;text-align:center
                    }
                    
                    div.large-text {
                    font-size: 32pt
                    }
                    
                    div.label {
                    	color: black;
                    }
                </style>
            </head>
            
            <body>
                <xsl:choose>
                    <xsl:when test="$pageType = 'title page'">
                        <div style="background-image: url(images/eas.png);width:825px;height:1123px">
                            <div style="width:794px;height:1130px">
                            	<div class="label" style="left:75px;top:100px;width:250px">
                            		HRMC Office Number
                            	</div>
                            	<div style="left:325px;top:100px;width:200px">
                            		<xsl:value-of select="//rti:IRenvelope/rti:EmployerAlignmentSubmission/rti:EmpRefs/rti:OfficeNo"/>
                            	</div>
                            	<div class="label" style="left:75px;top:125px;width:250px">
                            		Employer PAYE Reference
                            	</div>
                            	<div style="left:325px;top:125px;width:200px">
                            		<xsl:value-of select="//rti:IRenvelope/rti:EmployerAlignmentSubmission/rti:EmpRefs/rti:PayeRef"/>
                            	</div>
                            	<div class="label" style="left:75px;top:150px;width:250px">
                            		Accounts Office Reference
                            	</div>
                            	<div style="left:325px;top:150px;width:200px">
                            		<xsl:value-of select="//rti:IRenvelope/rti:EmployerAlignmentSubmission/rti:EmpRefs/rti:AORef"/>
                            	</div>
                            	
								<div class="label" style="left:75px;top:260px;with:305px">
								<u>
								Name
								</u>
								</div>
								<div class="label" style="left:380px;top:260px;with:155px">
								<u>
								NINO
								</u>
								</div>
								<div class="label" style="left:535px;top:260px;with:300px">
								<u>
								Date of Birth / Gender
								</u>
								</div>
								<xsl:for-each select="$employees">
									<xsl:call-template name="row">
										<xsl:with-param name="top" select="280 + position()*26.25"/>
										<xsl:with-param name="left" select="75"/>
									</xsl:call-template>
								</xsl:for-each>
                            </div>
                        </div>
                    </xsl:when>
		<xsl:when test="$pageType = 'cont. sheet 1'">
		<div style="background-image: url(images/eas.png);width:825px;height:1123px">
			<div style="width:794px;height:1123px">
				<div class="label" style="left:59px;top:130px;with:305px">
				<u>
				Name
				</u>
				</div>
				<div class="label" style="left:364px;top:130px;with:155px">
				<u>
				NINO
				</u>
				</div>
				<div class="label" style="left:519px;top:130px;with:300px">
				<u>
				Date of Birth / Gender
				</u>
				</div>
				<xsl:for-each select="$employees">
					<xsl:call-template name="row">
						<xsl:with-param name="top" select="154 + position()*26.6"/>
						<xsl:with-param name="left" select="59"/>
					</xsl:call-template>
				</xsl:for-each>
			</div>
		</div>
		</xsl:when>
        <xsl:otherwise>
		<div style="background-image: url(images/eas.png);width:825px;height:1123px">
			<div style="width:794px;height:1123px">
			<div class="label" style="left:59px;top:120px;with:305px">
			<u>
			Name
			</u>
			</div>
			<div class="label" style="left:364px;top:120px;with:155px">
			<u>
			NINO
			</u>
			</div>
			<div class="label" style="left:519px;top:120px;with:300px">
			<u>
			Date of Birth / Gender
			</u>
			</div>
			<xsl:for-each select="$employees">
				<xsl:call-template name="row">
					<xsl:with-param name="top" select="140 + position()*26.6"/>
					<xsl:with-param name="left" select="59"/>
				</xsl:call-template>
			</xsl:for-each>				
			</div>
		</div>		
        </xsl:otherwise>
    </xsl:choose>
</body>
</html>
</xsl:template>

<xsl:template name="row">
	<xsl:param name="top"/>
	<xsl:param name="left"/>
	<div style="left: {$left}px;top: {$top}px;width: 292px;text-align: left">
		<xsl:choose>
			<xsl:when test="rti:EmployeeDetails/rti:Name">
				<xsl:for-each select="rti:EmployeeDetails/rti:Name/*"><xsl:value-of select="."/>&#160;</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	</div>	
	<div style="left: {$left + 308}px;top: {$top}px;width: 90px;text-align: left">
		<xsl:choose>
			<xsl:when test="rti:EmployeeDetails/rti:NINO">
				<xsl:value-of select="rti:EmployeeDetails/rti:NINO"/>
			</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	</div>			
	<div style="left: {$left + 460}px;top: {$top}px;width: 150px;text-align: left">
		<xsl:choose>
			<xsl:when test="rti:EmployeeDetails/rti:BirthDate">
				<xsl:value-of select="rti:EmployeeDetails/rti:BirthDate"/>
			</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
		<xsl:when test="rti:EmployeeDetails/rti:BirthDate">
		<xsl:choose>												
			<xsl:when test="rti:EmployeeDetails/rti:Gender">
				/ <xsl:value-of select="rti:EmployeeDetails/rti:Gender"/>
			</xsl:when>	
		</xsl:choose>	
		</xsl:when>
		</xsl:choose>
	</div>
</xsl:template>
</xsl:stylesheet>
