<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
 xmlns:rti="selima:FBI Rendering"
 xmlns:xalan="http://xml.apache.org/xalan"
 xmlns:ext="xalan://com.selima.fbi.webserver.XalanExtension"
 extension-element-prefixes="ext">
    
    <ext:cuttingRules>
        <rules>
            <exclude path="/IRenvelope/IRheader"/>
            <exclude path="/IRenvelope/*">
                <exception path="/IRenvelope/EmployerAlignmentSubmission"/>
            </exclude>
            <exclude path="/IRenvelope/EmployerAlignmentSubmission/*">
                <exception path="/IRenvelope/EmployerAlignmentSubmission/Employee"/>
            </exclude>
            <exclude path="/IRenvelope/EmployerAlignmentSubmission/Employee/*">
                <exception path="/IRenvelope/EmployerAlignmentSubmission/Employee/EmployeeDetails"/>
            </exclude>
        </rules>
    </ext:cuttingRules>
    
    <xsl:output method="xml" encoding="UTF-8"/>
    
    <xsl:template match="/">
        <pages>
            <xsl:for-each select="//rti:IRenvelope/rti:EmployerAlignmentSubmission/rti:Employee">
                <xsl:choose>
                    <xsl:when test="position()=1">
                        <page id="1">
                            <keys>
                                <key name="Name" default="true">
                                    Page 1 (title page)
                                </key>
                            </keys>
                            <rules>
                                <exclude path='/IRenvelope/EmployerAlignmentSubmission/Employee[position() >= 25]'/>
                            </rules>
                        </page>
                    </xsl:when>
					<xsl:when test="(position() - 24) mod 66 = 1">
						<xsl:comment><xsl:value-of select="position()"/></xsl:comment>			
						<xsl:variable name="pageNum" select="2*floor((position()-24) div 66)+2"/>
						<page id="{$pageNum}">
							<keys>
								<key name="Name" default="true">Page <xsl:value-of select="$pageNum"/> (cs)</key>
							</keys>
							<rules>
								<exclude path='/IRenvelope/EmployerAlignmentSubmission/Employee[position() &gt;= {position() + 32}]'/>						
								<exclude path='/IRenvelope/EmployerAlignmentSubmission/Employee[position() &lt;= {position() - 1}]/*'/>
							</rules>
						</page>
					</xsl:when>
					<xsl:when test="(position() - 24) mod 66 = 33">
						<xsl:variable name="pageNum" select="2*floor((position()-24) div 66)+3"/>
						<page id="{$pageNum}">
							<keys>				
								<key name="Name" default="true">Page <xsl:value-of select="$pageNum"/> (cs)</key>
							</keys>
							<rules>
								<exclude path='/IRenvelope/EmployerAlignmentSubmission/Employee[position() &gt;= {position() + 34}]'/>						
								<exclude path='/IRenvelope/EmployerAlignmentSubmission/Employee[position() &lt;= {position() - 1}]/*'/>
							</rules>
						</page>
					</xsl:when>	
                </xsl:choose>
            </xsl:for-each>
        </pages>
    </xsl:template>
    
    
</xsl:stylesheet>
