<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance" xmlns:dps="http://www.govtalk.gov.uk/taxation/DPSwrapper/1" xmlns:sl2="http://www.govtalk.gov.uk/taxation/StudentLoanEnd/2">
    <xsl:import href='dps_variables.xsl'/>
    <xsl:output method="html" encoding="UTF-8"/>
    <xsl:variable name="FBIGGISVersion">
 /**
 *
 *  Program Name:      sl2_dps_stylesheet_2007.xsl    
 *
 *  Description:       Outgoing Forms - rendering stylesheet for student loan end forms.
 *
 *  Author:            Jon Head
 *
 *  Amendment History:
 *
 * Date       Author        Release   Description
 * 18/01/2006 J Head        56RJ      Modified for 56RJ project (re-writing secure mail)
 * 02/02/2006 J Head        All DPS form stylesheets now import another stylesheet, dps_variables.xsl. Variables that may change between
 *                          environments, such as image and help page URIs and URLs, are set in dps_variables.xsl and referenced
 *                          in the DPS form stylesheets. This facilitates making the stylesheets environment specific without the need to
 *                          change hard coded variables in each and every DPS stylesheet as only dps_variables.xsl needs to be changed.
 * 23/02/2006 J Head        Changes made in response to email received by SDSTeam on 21/02/2006: -
 *                              1. Borders are used on all tabular stylesheets now for both single and multiple employers for clarity and consistency.
 *                              2. Date of Issue is now included in the table rows for single employers and not at the top of the page.
 * 13/11/2007 D Patel	    CR 07/08-116 Changes to DPS Proxy stylesheets re forms SL2, ILEA, ILEB, ILEC, ILED, AR2MN
 *				1. Removed the reference to the 42 day lead time.
 *				2. StopDate field added.
 * 08/06/200 R Kunnaiah	    CR0910-30 Changes to DPS Proxy stylesheets forms SL1, SL2
 *				1. Student Loan deductions text changed.
 *04/08/2009 R Videla	Changes made as per the instructions in 8530481
 * 07/12/2010 C Weston  Changes to wording and links for Enhancement E145 CR054 v2
 * 17/01/2017 D Fox T Davies Changed guidance wording and new special rules url
 * 04/12/2018 C Plant   Changes to wording and links for 25FP. Bring guidance into line with new PGL notices
*/
    </xsl:variable>
	<xsl:template match="/">
		<html>
			<head>
				<title>Student Loan Notice - SL2</title>
				<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>
			</head>
			<body bgcolor="#FFFFFF">
				<table width="99%" border="0">
					<tr>
						<td width="15%">
							<xsl:element name="img">
								<xsl:attribute name="alt">HMRC Logo</xsl:attribute>
								<xsl:attribute name="src"><xsl:value-of select="$hmrc_logo_image_URI"/></xsl:attribute>
							</xsl:element>
						</td>
						<td colspan="5" valign="top">
							<div align="right">
								<b>
									<i>
										<font size="5"/>
										<font size="5">Student 
        Loan </font>
									</i>
								</b>
							</div>
						</td>
					</tr>
					<xsl:if test="/dps:DPSdata/dps:DPSheader/dps:Entity!=''">
						<tr>
							<td width="15%" height="22">&#160;</td>
							<td width="10%" height="22">&#160;</td>
							<td width="20%" height="22">&#160;</td>
							<td width="26%" height="22">&#160;</td>
							<td colspan="2" height="22" width="29%">&#160;</td>
						</tr>
						<tr>
							<td colspan="4">
								<div align="right">
									<font face="Tahoma" size="2">
										<b>Employer Reference</b>
									</font>
								</div>
							</td>
							<td colspan="2" width="29%">
								<xsl:value-of select="/dps:DPSdata/sl2:StudentLoanEnd/sl2:EmployerRef"/>
							</td>
						</tr>
					</xsl:if>
					<tr> </tr>
				</table>
				<table width="100%" border="0">
					<tr>
						<td colspan="2">&#160;</td>
					</tr>
					<tr>
						<td bgcolor="#FF0000" colspan="2">
							<xsl:element name="img">
								<xsl:attribute name="alt">Student Loan Stop</xsl:attribute>
								<xsl:attribute name="src"><xsl:value-of select="$student_loan_stop_image_URI"/></xsl:attribute>
							</xsl:element>
						</td>
					</tr>
					<tr>
						<td colspan="2">&#160;</td>
					</tr>
					<tr>
						<td colspan="2">
							<b>Student Loan deductions must stop on the first available pay day after the Student Loan deduction stop date shown below.<br/>
For more information go to 
<xsl:element name="a">
	<xsl:attribute name="href"><xsl:value-of select="$gov_uk_URL"/></xsl:attribute>
		www.gov.uk
</xsl:element>
 and search for 'Student Loan Repayments'.
							</b>
						</td>
					</tr>
					<tr>
						<td colspan="2">&#160;</td>
					</tr>
				</table>
				<xsl:if test="/dps:DPSdata/dps:DPSheader/dps:Entity!=''">
					<table width="100%" border="1">
						<tr align="center">
							<td>
								<font face="Tahoma" size="2">
									<b>Employee Name</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>National Insurance Number</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Date of Issue</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Works/ Payroll no.</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Stop Date</b>
								</font>
							</td>							
						</tr>
						<xsl:for-each select="/dps:DPSdata/sl2:StudentLoanEnd/sl2:NINO">
							<xsl:sort select="." order="ascending" data-type="text"/>
							<tr align="center">
								<td>
									<xsl:value-of select="../sl2:Name/sl2:Title"/>&#160;<xsl:value-of select="../sl2:Name/sl2:Forename"/>&#160;<xsl:value-of select="../sl2:Name/sl2:Surname"/>
								</td>
								<td>
									<xsl:value-of select="../sl2:NINO"/>
								</td>
								<td>
									<xsl:value-of select="substring(../@IssueDate, 9, 2)"/>-<xsl:value-of select="substring(../@IssueDate, 6, 2)"/>-<xsl:value-of select="substring(../@IssueDate, 1, 4)"/>
								</td>
								<xsl:choose>
									<xsl:when test="../sl2:WorksNumber!=''">
										<td>
											<xsl:value-of select="../sl2:WorksNumber"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td>
											&#160;
										</td>
									</xsl:otherwise>
								</xsl:choose>
								<td>
									<xsl:value-of select="substring(../sl2:StopDate, 9, 2)"/>-<xsl:value-of select="substring(../sl2:StopDate, 6, 2)"/>-<xsl:value-of select="substring(../sl2:StopDate, 1, 4)"/>
								</td>								
							</tr>
						</xsl:for-each>
					</table>
				</xsl:if>
				<xsl:if test="/dps:DPSdata/dps:DPSheader/dps:Entity=''">
					<table width="100%" border="1">
						<tr align="center">
							<td>
								<font face="Tahoma" size="2">
									<b>Employee Name</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Employer Reference</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>National Insurance Number</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Date of Issue</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Works/ Payroll no.</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Stop Date</b>
								</font>
							</td>					
						</tr>
						<xsl:for-each select="/dps:DPSdata/sl2:StudentLoanEnd/sl2:NINO">
							<xsl:sort select="." order="ascending" data-type="text"/>
							<tr align="center">
								<td>
									<xsl:value-of select="../sl2:Name/sl2:Title"/>&#160;<xsl:value-of select="../sl2:Name/sl2:Forename"/>&#160;<xsl:value-of select="../sl2:Name/sl2:Surname"/>
								</td>
								<td>
									<xsl:value-of select="../sl2:EmployerRef"/>
								</td>
								<td>
									<xsl:value-of select="../sl2:NINO"/>
								</td>
								<td>
									<xsl:value-of select="substring(../@IssueDate, 9, 2)"/>-<xsl:value-of select="substring(../@IssueDate, 6, 2)"/>-<xsl:value-of select="substring(../@IssueDate, 1, 4)"/>
								</td>
								<xsl:choose>
									<xsl:when test="../sl2:WorksNumber!=''">
										<td width="16%">
											<xsl:value-of select="../sl2:WorksNumber"/>	
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td width="16%">
												&#160;
											</td>
									</xsl:otherwise>
								</xsl:choose>
								<td>
									<xsl:value-of select="substring(../sl2:StopDate, 9, 2)"/>-<xsl:value-of select="substring(../sl2:StopDate, 6, 2)"/>-<xsl:value-of select="substring(../sl2:StopDate, 1, 4)"/>
								</td>								
							</tr>
						</xsl:for-each>
					</table>
				</xsl:if>
				<br/>
				<table width="100%" border="0">
					<tr>
						<td align="left">
							<font face="Tahoma">
								<b>
									<font size="2">END OF LIST</font>
								</b>
							</font>
						</td>
						<td>
							<div align="right">
								<a style="text-decoration: none" href="javascript:window.close()">
									<b>
										<font size="2" face="Tahoma">Close Window</font>
									</b>
								</a>
							</div>
						</td>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
