<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance" xmlns:dps="http://www.govtalk.gov.uk/taxation/DPSwrapper/1" xmlns:rtin="http://www.govtalk.gov.uk/taxation/RTInotification/1">
    <xsl:import href='dps_variables.xsl'/>
    <xsl:output method="html" encoding="UTF-8"/>
    <xsl:variable name="FBIGGISVersion">
 /**
 *
 *  Description:       Outgoing Forms - rendering stylesheet for NINO verification request
 *
 *  Author:            Mike Shires
 *
 *  Amendment History:
 *
 * Date       Author        Release   Description
 */
    </xsl:variable>
	<xsl:template match="/">
		<html>
			<head>
				<title>RTI Notification</title>
				<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>
			</head>
			<body bgcolor="#FFFFFF">
				<table width="92%" border="0">
					<tr>
						<td width="20%">
							<xsl:element name="img">
								<xsl:attribute name="alt">HMRC Logo</xsl:attribute>
								<xsl:attribute name="src"><xsl:value-of select="$hmrc_logo_image_URI"/></xsl:attribute>
							</xsl:element>
						</td>
						<td colspan="3">&#160;</td>
						<td width="25" valign="top">
							<b>
								<i>
									<font size="5">NINO Verification Notice</font>
								</i>
							</b>
						</td>
					</tr>
					<xsl:if test="/dps:DPSdata/dps:DPSheader/dps:Entity!=''">
						<tr>
							<td width="20%" height="22">&#160;</td>
							<td width="20%" height="22">&#160;</td>
							<td width="10%" height="22">&#160;</td>
							<td width="25%" height="22">&#160;</td>
							<td width="25%" height="22">&#160;</td>
						</tr>
						<tr>
							<td colspan="3" rowspan="3" valign="top" style="padding-right:10px">
							&#160;
							</td>
							<td>
									<font face="Tahoma" size="2">
										<b>Employer Reference</b>
									</font>
							</td>
							<td  width="29%">
								<xsl:value-of select="/dps:DPSdata/rtin:RTINot/rtin:EmployerRef"/>
							</td>
						</tr>
						<tr>
							<td valign="middle">
								<font face="Tahoma" size="2"><b>Generated from</b></font>
							</td>
							<td>
							<xsl:choose>
								<xsl:when test="/dps:DPSdata/rtin:RTINot/@FormType = 'NVR'">
								<xsl:text>NINO Verification Request</xsl:text>
								</xsl:when>
								<xsl:otherwise>
								<xsl:text>Full Payment Submission or</xsl:text><br/><xsl:text>Employer Alignment Submission</xsl:text>
								</xsl:otherwise>
							</xsl:choose>
							</td>
						</tr>
						<tr>
							<td>
								<font face="Tahoma" size="2">
									<b>Correlation ID</b>
								</font>
							</td>
							<td width="29%">
								<xsl:value-of select="/dps:DPSdata/rtin:RTINot/rtin:CorrelationID"/>
							</td>
						</tr>
						<tr height="22">
							<td coslpan="5">&#160;</td>
						</tr>
						<tr>
							<td colspan="5">
							<xsl:choose>
							<xsl:when test="/dps:DPSdata/rtin:RTINot/rtin:MessageID = '1'">
							<xsl:text>This notification shows the correct NINO. Please use
								this NINO for any future submissions instead of the one you
								originally provided</xsl:text>
								<xsl:if test="/dps:DPSdata/rtin:RTINot/rtin:NINOProvided">
									<xsl:text> (</xsl:text>
									<xsl:value-of select="/dps:DPSdata/rtin:RTINot/rtin:NINOProvided"></xsl:value-of>
									<xsl:text>)</xsl:text>
								</xsl:if>
								<xsl:text>.</xsl:text>
							</xsl:when>
							<xsl:when test="/dps:DPSdata/rtin:RTINot/rtin:MessageID = '2'">
							<xsl:text>There was no NINO provided or the one given is incorrect.
							Please do not use the incorrect one for any future submissions
							</xsl:text>
							<xsl:if test="/dps:DPSdata/rtin:RTINot/rtin:NINOProvided">
								<xsl:text>(</xsl:text>
								<xsl:value-of select="/dps:DPSdata/rtin:RTINot/rtin:NINOProvided"></xsl:value-of>
								<xsl:text>)</xsl:text>
							</xsl:if>
							<xsl:text>.</xsl:text>
							</xsl:when>
							<xsl:when test="/dps:DPSdata/rtin:RTINot/rtin:MessageID = '3'">
							<xsl:text>For future submissions please use the NINO provided in this
							notification.
							</xsl:text>
							</xsl:when>
							<xsl:when test="/dps:DPSdata/rtin:RTINot/rtin:MessageID = '4'">
							<xsl:text>The NINO provided is correct. For future submissions please
							continue to use this NINO.
							</xsl:text>
							</xsl:when>
							<xsl:when test="/dps:DPSdata/rtin:RTINot/rtin:MessageID = '5'">
							<xsl:text>Service currently unavailable.</xsl:text>
							</xsl:when>
							</xsl:choose>
							</td>
						</tr>
					</xsl:if>
					<tr> </tr>
				</table>
				<table  border="0">
					<tr>
						<td>&#160;</td>
					</tr>
					<tr>
						<td bgcolor="#33CC33">
							<xsl:element name="img">
								<xsl:attribute name="alt">NINO Verification</xsl:attribute>
								<!--xsl:attribute name="src"><xsl:value-of select="$student_loan_start_image_URI"/></xsl:attribute-->
							</xsl:element>
						</td>
					</tr>
					<tr>
						<td>&#160;</td>
					</tr>


				</table>
				<xsl:if test="/dps:DPSdata/dps:DPSheader/dps:Entity!=''">
					<center>
					<table width="95%" border="1">
						<tr align="center">
							<td>
								<font face="Tahoma" size="2">
									<b>Employee Name</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>NINO to use</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Works/ Payroll Number</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Date of Issue</b>
								</font>
							</td>
						</tr>			
						
						<xsl:for-each select="/dps:DPSdata/rtin:RTINot/rtin:Name">
						<xsl:sort select="." order="ascending" data-type="text"/>
						<tr align="center">
							<td width="16%">
								<xsl:value-of select="../rtin:Name/rtin:Ttl"/>&#160;<xsl:value-of select="../rtin:Name/rtin:Fore"/>&#160;<xsl:value-of select="../rtin:Name/rtin:Sur"/>
							</td>
							<td width="16%">
								<xsl:value-of select="../rtin:NINOToUse"/>
							</td>
							<td width="16%">
								<xsl:value-of select="../rtin:PayId"/>
							</td>
							<td width="16%">
								<xsl:value-of select="substring(../@IssueDate, 9, 2)"/>-<xsl:value-of select="substring(../@IssueDate, 6, 2)"/>-<xsl:value-of select="substring(../@IssueDate, 1, 4)"/>
							</td>
						</tr>
						</xsl:for-each>
					</table>
					</center>
				</xsl:if>
				<xsl:if test="/dps:DPSdata/dps:DPSheader/dps:Entity=''">
					<table width="100%" border="1">
						<tr align="center">
							<td>
								<font face="Tahoma" size="2">
									<b>Employee Name</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Employer Reference</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>National Insurance Number</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Works/ Payroll Number</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Date of Issue</b>
								</font>
							</td>
						</tr>
						<xsl:for-each select="/dps:DPSdata/rtin:RTINot/rtin:Name">						
							<xsl:sort select="." order="ascending" data-type="text"/>
							<tr align="center">
								<td width="16%">
									<xsl:value-of select="../rtin:Name/rtin:Ttl"/>&#160;<xsl:value-of select="../rtin:Name/rtin:Fore"/>&#160;<xsl:value-of select="../rtin:Name/rtin:Sur"/>
								</td>
								<td width="16%">
									<xsl:value-of select="../rtin:EmployerRef"/>
								</td>
								<td width="16%">
									<xsl:value-of select="../rtin:NINOToUse"/>
								</td>
								<td width="16%">
									<xsl:value-of select="../rtin:PayId"/>
								</td>
								<td width="16%">
									<xsl:value-of select="substring(../@IssueDate, 9, 2)"/>-<xsl:value-of select="substring(../@IssueDate, 6, 2)"/>-<xsl:value-of select="substring(../@IssueDate, 1, 4)"/>
								</td>
							</tr>
						</xsl:for-each>
					</table>
				</xsl:if>
				<br/>
				<table width="100%" border="0">
					<tr>
						<td align="left">
							<font face="Tahoma">
								<b>
									<font size="2">END OF LIST</font>
								</b>
							</font>
						</td>
						<td>
							<div align="right">
								<a style="text-decoration: none" href="javascript:window.close()">
									<b>
										<font size="2" face="Tahoma">Close Window</font>
									</b>
								</a>
							</div>
						</td>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
