<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance" xmlns:dps="http://www.govtalk.gov.uk/taxation/DPSwrapper/1" xmlns:pgl1="http://www.govtalk.gov.uk/taxation/PostgraduateLoanStart/1">
	<xsl:import href="dps_variables.xsl"/>
	<xsl:output method="html" encoding="UTF-8"/>
	<xsl:variable name="FBIGGISVersion">
 /**
 *
 *  Program Name:      sl1_dps_stylesheet_2007.xsl    
 *
 *  Description:       Outgoing Forms - rendering stylesheet for student loan start forms.
 *
 *  Author:            Jon Head
 *
 *  Amendment History:
 *
 * Date       Author        Release   Description
 * 18/01/2006 J Head        56RJ      Modified for 56RJ project (re-writing secure mail)
 * 02/02/2006 J Head:       All DPS form stylesheets now import another stylesheet, dps_variables.xsl. Variables that may change between
 *                          environments, such as image and help page URIs and URLs, are set in dps_variables.xsl and referenced
 *                          in the DPS form stylesheets. This facilitates making the stylesheets environment specific without the need to
 *                          change hard coded variables in each and every DPS stylesheet as only dps_variables.xsl needs to be changed.
 * 23/02/2006 J Head        Changes made in response to email received by SDSTeam on 21/02/2006: -
 *                              1. Borders are used on all tabular stylesheets now for both single and multiple employers for clarity and consistency.
 *                              2. Date of Issue is now included in the table rows for single employers and not at the top of the page.
 * 08/06/2009 R Kunnaiah	    CR0910-30 Changes to DPS Proxy stylesheets forms SL1, SL2
 *				1. Postgraduate Loan deductions text changed.
 * 04/08/2009 R Videla	Changes made as per the instructions in 8523215 
 * 07/12/2010 C Weston  Changes to wording and links for Enhancement E145 CR054 v2
 * 25/09/2014	F Ahmad	Changes for 84CO added PlanType as per requirements to the Change.
 * 04/12/2014	D Joss	Changed wording and link for payroll publications.
 * 17/01/2017   D Fox T Davies Changed wording for guidance notes
 * 16/11/2018   C Plant	 Cloned SL1/2 stylesheets into PGL1/2 for 25FP Postrgraduate loans Ph2.
*/
    </xsl:variable>
	<xsl:template match="/">
		<html>
			<head>
				<title>Postgraduate Loan Notice - PGL1</title>
				<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>
			</head>
			<body bgcolor="#FFFFFF">
				<table width="95%" border="0">
					<tr>
						<td width="15%">
							<xsl:element name="img">
								<xsl:attribute name="alt">HMRC Logo</xsl:attribute>
								<xsl:attribute name="src"><xsl:value-of select="$hmrc_logo_image_URI"/></xsl:attribute>
							</xsl:element>
						</td>
						<td colspan="6" valign="top">
							<div align="right">
								<b>
									<i>
										<font size="5"/>
										<font size="5">Postgraduate Loan </font>
									</i>
								</b>
							</div>
						</td>
					</tr>
					<xsl:if test="/dps:DPSdata/dps:DPSheader/dps:Entity!=''">
						<tr>
							<td width="15%" height="22">&#160;</td>
							<td width="10%" height="22">&#160;</td>
							<td width="20%" height="22">&#160;</td>
							<td width="26%" height="22">&#160;</td>
							<td colspan="3" height="22" width="29%">&#160;</td>
						</tr>
						<tr>
							<td colspan="4">
								<div align="right">
									<font face="Tahoma" size="2">
										<b>Employer Reference</b>
									</font>
								</div>
							</td>
							<td colspan="3" width="29%">
								<xsl:value-of select="/dps:DPSdata/pgl1:PostgraduateLoanStart/pgl1:EmployerRef"/>
							</td>
						</tr>
						<tr>
							<td rowspan="3">&#160;</td>
						</tr>
					</xsl:if>
					<tr> </tr>
				</table>
				<table width="100%" border="0">
					<tr>
						<td>&#160;</td>
					</tr>
					<tr>
						<td bgcolor="#33CC33">
							<xsl:element name="img">
								<xsl:attribute name="alt">Postgraduate Loan Start</xsl:attribute>
								<xsl:attribute name="src"><xsl:value-of select="$postgraduate_loan_start_image_URI"/></xsl:attribute>
							</xsl:element>
						</td>
					</tr>
					<tr>
						<td>&#160;</td>
					</tr>
					<tr>
						<td colspan="2">
							<b>Postgraduate Loan deductions must start on the first available pay day after the Postgraduate Loan deduction start date shown below, whenever total pay exceeds the Postgraduate Loan Threshold.<br/><br/>
It is important that you act on this notice or we may charge you a penalty.<br/><br/>
For more information go to 
<xsl:element name="a">
	<xsl:attribute name="href"><xsl:value-of select="$gov_uk_URL"/></xsl:attribute>
		www.gov.uk
</xsl:element>
 and search for 'Postgraduate Loan Repayments'.<br/></b>
						</td>
					</tr>
					<tr>
						<td>&#160;</td>
					</tr>
					<tr>
						<td colspan="2">&#160;</td>
					</tr>
				</table>
				<xsl:if test="/dps:DPSdata/dps:DPSheader/dps:Entity!=''">
					<table width="95%" border="1">
						<tr align="center">
							<td>
								<font face="Tahoma" size="2">
									<b>Employee Name</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>National Insurance Number</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Works/ Payroll Number</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Date of Issue</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Postgraduate Loan Deduction Start Date</b>
								</font>
							</td>
						</tr>
						<xsl:for-each select="/dps:DPSdata/pgl1:PostgraduateLoanStart/pgl1:NINO">
							<xsl:sort select="." order="ascending" data-type="text"/>
							<tr align="center">
								<td width="16%">
									<xsl:value-of select="../pgl1:Name/pgl1:Title"/>&#160;<xsl:value-of select="../pgl1:Name/pgl1:Forename"/>&#160;<xsl:value-of select="../pgl1:Name/pgl1:Surname"/>
								</td>
								<td width="16%">
									<xsl:value-of select="../pgl1:NINO"/>
								</td>
								<xsl:choose>
									<xsl:when test="../pgl1:WorksNumber!=''">
										<td width="16%">
											<xsl:value-of select="../pgl1:WorksNumber"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td width="16%">
													&#160;
												</td>
									</xsl:otherwise>
								</xsl:choose>
								<td width="16%">
									<xsl:value-of select="substring(../@IssueDate, 9, 2)"/>-<xsl:value-of select="substring(../@IssueDate, 6, 2)"/>-<xsl:value-of select="substring(../@IssueDate, 1, 4)"/>
								</td>
								<td width="16%">
									<xsl:value-of select="substring(../pgl1:LoanStartDate, 9, 2)"/>-<xsl:value-of select="substring(../pgl1:LoanStartDate, 6, 2)"/>-<xsl:value-of select="substring(../pgl1:LoanStartDate, 1, 4)"/>
								</td>
							</tr>
						</xsl:for-each>
					</table>
				</xsl:if>
				<xsl:if test="/dps:DPSdata/dps:DPSheader/dps:Entity=''">
					<table width="100%" border="1">
						<tr align="center">
							<td>
								<font face="Tahoma" size="2">
									<b>Employee Name</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Employer Reference</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>National Insurance Number</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Works/ Payroll Number</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Date of Issue</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Postgraduate Loan Deduction Start Date</b>
								</font>
							</td>
						</tr>
						<xsl:for-each select="/dps:DPSdata/pgl1:PostgraduateLoanStart/pgl1:NINO">
							<xsl:sort select="." order="ascending" data-type="text"/>
							<tr align="center">
								<td width="16%">
									<xsl:value-of select="../pgl1:Name/pgl1:Title"/>&#160;<xsl:value-of select="../pgl1:Name/pgl1:Forename"/>&#160;<xsl:value-of select="../pgl1:Name/pgl1:Surname"/>
								</td>
								<td width="16%">
									<xsl:value-of select="../pgl1:EmployerRef"/>
								</td>
								<td width="16%">
									<xsl:value-of select="../pgl1:NINO"/>
								</td>
								<xsl:choose>
									<xsl:when test="../pgl1:WorksNumber!=''">
										<td width="16%">
											<xsl:value-of select="../pgl1:WorksNumber"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td width="16%">
													&#160;
												</td>
									</xsl:otherwise>
								</xsl:choose>
								<td width="16%">
									<xsl:value-of select="substring(../@IssueDate, 9, 2)"/>-<xsl:value-of select="substring(../@IssueDate, 6, 2)"/>-<xsl:value-of select="substring(../@IssueDate, 1, 4)"/>
								</td>
								<td width="16%">
									<xsl:value-of select="substring(../pgl1:LoanStartDate, 9, 2)"/>-<xsl:value-of select="substring(../pgl1:LoanStartDate, 6, 2)"/>-<xsl:value-of select="substring(../pgl1:LoanStartDate, 1, 4)"/>
								</td>
							</tr>
						</xsl:for-each>
					</table>
				</xsl:if>
				<br/>
				<table width="100%" border="0">
					<tr>
						<td align="left">
							<font face="Tahoma">
								<b>
									<font size="2">END OF LIST</font>
								</b>
							</font>
						</td>
						<td>
							<div align="right">
								<a style="text-decoration: none" href="javascript:window.close()">
									<b>
										<font size="2" face="Tahoma">Close Window</font>
									</b>
								</a>
							</div>
						</td>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
