<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
xmlns:xsd="http://www.w3.org/2001/XMLSchema" 
xmlns:dps="http://www.govtalk.gov.uk/taxation/DPSwrapper/1" 
xmlns:gen="http://www.govtalk.gov.uk/taxation/RTI/GenericNotification/1"
xmlns:info="http://www.govtalk.gov.uk/taxation/RTI/Notifications/Information/1"
xmlns:chg="http://www.govtalk.gov.uk/taxation/RTI/Notifications/Change/1"
xmlns:ext="xalan://com.selima.fbi.webserver.XalanExtension"
extension-element-prefixes="ext"
xmlns:xalan="http://xml.apache.org/xalan"
exclude-result-prefixes="xalan"
>
    <xsl:import href='dps_variables.xsl'/>
    <xsl:output method="html" encoding="UTF-8"/>
    <xsl:variable name="FBIGGISVersion">
 /**
 *
 *  Description:       Outgoing Forms - rendering stylesheet for Generic Notification
 *
 *  Author:            Vit Cvachoucek
 *
 *  Amendment History:
 *
 * Date       Author        Release   Description
 */
    </xsl:variable>
	<xsl:template match="/">
		<html>
			<head>
				<title>Generic Notification</title>
				<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>
			</head>
			<body bgcolor="#FFFFFF">
				<table width="92%" border="0">
					<tr>
						<td width="20%">
							<xsl:element name="img">
								<xsl:attribute name="alt">HMRC Logo</xsl:attribute>
								<xsl:attribute name="src"><xsl:value-of select="$hmrc_logo_image_URI"/></xsl:attribute>
							</xsl:element>
						</td>
						<td colspan="3">&#160;</td>
						<td width="25" valign="top">
							<b>
								<i>
									<font size="5">
									<xsl:value-of select="//gen:GenericNotification/gen:MessageTypeTitle"/>
									</font>
								</i>
							</b>
						</td>
					</tr>
						<tr>
							<td width="20%" height="22">&#160;</td>
							<td width="20%" height="22">&#160;</td>
							<td width="10%" height="22">&#160;</td>
							<td width="25%" height="22">&#160;</td>
							<td width="25%" height="22">&#160;</td>
						</tr>
						<tr>
							<td colspan="3" rowspan="3" valign="top" style="padding-right:10px">
							&#160;
							</td>
							<td>
									<font face="Tahoma" size="2">
										<b>Employer Reference</b>
									</font>
							</td>
							<td  width="29%">
								<xsl:value-of select="//gen:GenericNotification/gen:EmployerRef"/>
							</td>
						</tr>
						<tr>
							<td>
									<font face="Tahoma" size="2">
										<b>Employer Name</b>
									</font>
							</td>
							<td  width="29%">
								<xsl:value-of select="//gen:GenericNotification/gen:EmployerName"/>
							</td>
						</tr>
						<tr>
							<td>
								<font face="Tahoma" size="2">
									<b>Issue Date</b>
								</font>
							</td>
							<td width="29%">
								<xsl:value-of select="substring(//gen:GenericNotification/@IssueDate, 9, 2)"/>
								<xsl:text>-</xsl:text>
								<xsl:value-of select="substring(//gen:GenericNotification/@IssueDate, 6, 2)"/>
								<xsl:text>-</xsl:text>
								<xsl:value-of select="substring(//gen:GenericNotification/@IssueDate, 1, 4)"/>
							</td>
						</tr>
						<tr height="22">
							<td coslpan="5">&#160;</td>
						</tr>
						<tr>
							<td colspan="5">
							<p>
							<xsl:for-each select="ext:splitLines(//gen:GenericNotification/gen:MessageText)">
								<p><xsl:value-of select="."/></p>
							</xsl:for-each>
							</p>
							</td>
						</tr>
					<tr><td colspan="5" height="22">&#160;</td></tr>
				</table>
				<xsl:for-each select="//info:Information">
					<table width="90%" border="1">
						<tr align="center">
							<td>
								<font face="Tahoma" size="2">
									<b>Display Name</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Value</b>
								</font>
							</td>
						</tr>			
						<xsl:for-each select="info:InformationItem">
						<xsl:sort select="info:DisplayName" order="ascending" data-type="text"/>
						<tr align="center">
							<td>
								<xsl:value-of select="info:DisplayName"/>
							</td>
							<td>
								<xsl:choose>
									<xsl:when test="info:Value/@Type = 'xs:date'">
										<xsl:value-of select="substring(info:Value, 9, 2)"/>
										<xsl:text>-</xsl:text>
										<xsl:value-of select="substring(info:Value, 6, 2)"/>
										<xsl:text>-</xsl:text>
										<xsl:value-of select="substring(info:Value, 1, 4)"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="info:Value"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						</xsl:for-each>
					</table>
				</xsl:for-each>
				<xsl:for-each select="//chg:Change">
					<p>
						<font face="Tahoma" size="4">
							<b>Change <xsl:value-of select="@Seq"/></b>
						</font>
					</p>
					<xsl:if test="chg:ActionItem">
					<table width="90%" border="1">
						<tr align="center">
							<td width="33%">
								<font face="Tahoma" size="2">
									<b>Display Name</b>
								</font>
							</td>
							<td width="33%">
								<font face="Tahoma" size="2">
									<b>Previous Value</b>
								</font>
							</td>
							<td width="33%">
								<font face="Tahoma" size="2">
									<b>Value</b>
								</font>
							</td>
						</tr>
						<xsl:for-each select="chg:ActionItem">
						<xsl:sort select="chg:DisplayName" order="ascending" data-type="text"/>
						<tr align="center">
							<td>
								<xsl:value-of select="chg:DisplayName"/>
							</td>
							<td>
								<xsl:choose>
									<xsl:when test="chg:PreviousValue/@Type = 'xs:date'">
										<xsl:value-of select="substring(chg:PreviousValue, 9, 2)"/>
										<xsl:text>-</xsl:text>
										<xsl:value-of select="substring(chg:PreviousValue, 6, 2)"/>
										<xsl:text>-</xsl:text>
										<xsl:value-of select="substring(chg:PreviousValue, 1, 4)"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="chg:PreviousValue"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td>
								<xsl:choose>
									<xsl:when test="chg:Value/@Type = 'xs:date'">
										<xsl:value-of select="substring(chg:Value, 9, 2)"/>
										<xsl:text>-</xsl:text>
										<xsl:value-of select="substring(chg:Value, 6, 2)"/>
										<xsl:text>-</xsl:text>
										<xsl:value-of select="substring(chg:Value, 1, 4)"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="chg:Value"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						</xsl:for-each>
					</table>
					</xsl:if>
					<xsl:if test="chg:InformationItem">
					<p>
						<font face="Tahoma" size="3">
							<b>Related Information</b>
						</font>
					</p>					
					<table width="66%" border="1">
						<tr align="center">
							<td width="50%">
								<font face="Tahoma" size="2">
									<b>Display Name</b>
								</font>
							</td>
							<td width="50%">
								<font face="Tahoma" size="2">
									<b>Value</b>
								</font>
							</td>
						</tr>
						<xsl:for-each select="chg:InformationItem">
						<xsl:sort select="chg:DisplayName" order="ascending" data-type="text"/>
						<tr align="center">
							<td>
								<xsl:value-of select="chg:DisplayName"/>
							</td>
							<td>
								<xsl:choose>
									<xsl:when test="chg:Value/@Type = 'xs:date'">
										<xsl:value-of select="substring(chg:Value, 9, 2)"/>
										<xsl:text>-</xsl:text>
										<xsl:value-of select="substring(chg:Value, 6, 2)"/>
										<xsl:text>-</xsl:text>
										<xsl:value-of select="substring(chg:Value, 1, 4)"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="chg:Value"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						</xsl:for-each>
					</table>
					</xsl:if>
				</xsl:for-each>
				<br/>
				<table width="100%" border="0">
					<tr>
						<td align="left">
							<font face="Tahoma">
								<b>
									<font size="2">END OF LIST</font>
								</b>
							</font>
						</td>
						<td>
							<div align="right">
								<a style="text-decoration: none" href="javascript:window.close()">
									<b>
										<font size="2" face="Tahoma">Close Window</font>
									</b>
								</a>
							</div>
						</td>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
