<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance">
	<xsl:output method="html" encoding="UTF-8"/>
	<xsl:variable name="FBIGGISVersion">
 /**
 *
 *  Program Name:      dps_variables.xsl    
 *
 *  Description:       DPS Outgoing Forms - stylesheet to contain variable definitions for the individual form stylesheets.
 *                     This stylesheet is imported into each individual form stylesheet, where the variable names are referenced.
 *                     This facilitates the changing of variable names for specific environments, rather than hard coding image and help page URIs, URLs, etc.
 *
 *  Author:            Jon Head
 *
 *  Amendment History:
 *
 * Date       Author        Release   Description
 * 04/02/2006 J Head        56RJ  Stylsheet created.
 * 09/03/2007 K.Hutchinson         Change the amount in the incentive_amount_next_year from 150 to 100 
 * 13/11/2007 D Patel	    CR 07/08-116 Changes to DPS Proxy stylesheets re forms SL2, ILEA, ILEB, ILEC, ILED, AR2MN
 *				1. Change the amount in incentive_amount_next_year from 100 to 75. 
 * 29/11/2007 D Patel 	    Value of variable employers_annual_pack_URL changed.
 * 08/08/2008 D Patel		CR 08/09-025 - Text rewriting, AR1N, AR2N, AR1MN, AR2MN, AR6.
 * 08/06/2009 R Kunnaiah    CR0910-30 Added employers_annual_pack URL for forms SL1, SL2
 * 07/12/2010 C Weston  Changes to wording and links for Enhancement E145 CR054 v2
 * 04/12/2014 D Joss	New link for payroll-publications 	
 * 17/01/2017 D Fox T Davies New Links for payroll software and special rules for student-loans 
 * 03/12/2018 C Plant	Add definitions for postrgaduate loan gif files
*/
<!--Images-->
</xsl:variable>
<xsl:variable name="hmrc_logo_image_URI">./images/hmrc_logo.gif</xsl:variable>
<xsl:variable name="student_loan_stop_image_URI">./images/sl2stop.gif</xsl:variable>
<xsl:variable name="student_loan_start_image_URI">./images/sl1start.gif</xsl:variable>
<xsl:variable name="postgraduate_loan_stop_image_URI">./images/pgl2stop.gif</xsl:variable>
<xsl:variable name="postgraduate_loan_start_image_URI">./images/pgl1start.gif</xsl:variable>
<xsl:variable name="reminder_image_URI">./images/remindr.gif</xsl:variable>
<xsl:variable name="reminder_b_image_URI">./images/remindb.gif</xsl:variable>
<xsl:variable name="online_filing_image_URI">./images/online_filing.gif</xsl:variable>

<!--URLs-->
<xsl:variable name="employers_annual_pack_URL"><![CDATA[http://www.businesslink.gov.uk/bdotg/action/layer?topicId=1083050418&furlname=studentloandeductions&furlparam=studentloandeductions&ref=&domain=www.businesslink.gov.uk]]></xsl:variable>
<xsl:variable name="student_loan_threshold_URL"><![CDATA[http://www.businesslink.gov.uk/bdotg/action/layer?topicId=1083050418&furlname=studentloandeductions&furlparam=studentloandeductions&ref=&domain=www.businesslink.gov.uk]]></xsl:variable>
<xsl:variable name="paye_online_URL">http://www.hmrc.gov.uk/payeonline</xsl:variable>
<xsl:variable name="sending_paye_online_URL">http://www.hmrc.gov.uk/payeonline</xsl:variable>
<xsl:variable name="hmrc_online_URL">http://www.hmrc.gov.uk</xsl:variable>
<xsl:variable name="gov_uk_URL">http://www.gov.uk</xsl:variable>
<xsl:variable name="hmrc_paye_nil_URL">http://www.hmrc.gov.uk/howtopay/paye_nil.htm</xsl:variable>
<xsl:variable name="hmrc_paye_howtopay_URL">http://www.hmrc.gov.uk/howtopay/paye.htm</xsl:variable>
<xsl:variable name="basic_paye_tools_URL">http://www.businesslink.gov.uk/basicpayetools</xsl:variable>
<xsl:variable name="paye_forms_and_publications_URL">http://www.businesslink.gov.uk/payeformsandpublications</xsl:variable>
<xsl:variable name="payroll_pub_for_employers_URL">https://www.gov.uk/government/collections/payroll-publications-for-employers</xsl:variable>
<xsl:variable name="payroll_software">https://www.gov.uk/payroll-software</xsl:variable>
<xsl:variable name="special_rules_for_student_loans">https://www.gov.uk/guidance/special-rules-for-student-loans</xsl:variable>


<!--Help Pages-->
<xsl:variable name="outgoing_helpline_numbers_htm_URI">./help/outgoingHelp.htm</xsl:variable>
<xsl:variable name="p11d_notes_htm_URI">./help/p11dnotes.htm</xsl:variable>
<xsl:variable name="p35_notes_htm_URI">./help/p35notes.htm</xsl:variable>
<xsl:variable name="p6_instructions_htm_URI">./help/p6instructions.htm</xsl:variable>
<xsl:variable name="p9_instructions_htm_URI">./help/p9instructions.htm</xsl:variable>
<xsl:variable name="student_loan_threshold_htm_URI">./help/threshold.htm</xsl:variable>

<!--Miscellaneous values within individual forms-->
<!--Notifications-->
<xsl:variable name="incentive_amount_next_year">75</xsl:variable>
<xsl:variable name="minimum_no_of_employees_for_incentive">50</xsl:variable>
<!--Reminders-->
<xsl:variable name="annual_returns_late_penalty">100</xsl:variable>
<xsl:variable name="annual_returns_max_late_penalty">3000</xsl:variable>
</xsl:stylesheet>
