/*
 * Decompiled with CFR 0.152.
 */
package asjava.unirpc;

import asjava.uniclientlibs.UniString;
import asjava.unirpc.UniRPC;
import asjava.unirpc.UniRPCConnection;
import asjava.unirpc.UniRPCPMessage;
import asjava.unirpc.UniRPCPProxyHeader;
import asjava.unirpc.UniRPCPacketException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Writer;

public class UniRPCPacket
extends UniRPC {
    public static final int UNIRPC_INT = 0;
    public static final int UNIRPC_DOUBLE = 1;
    public static final int UNIRPC_CHAR = 2;
    public static final int UNIRPC_STRING = 3;
    public static final int UNIRPC_INT_PTR = 4;
    public static final int UNIRPC_DOUBLE_PTR = 5;
    public static final int UNIRPC_FUNCNAME = 6;
    private boolean isProxyPacket;
    private int currentVersionProxy = 1;
    private UniRPCConnection currentConnection;
    private UniRPCPProxyHeader proxyHeaderObject;
    private UniRPCPMessage messageObject;

    public UniRPCPacket() {
        this.isProxyPacket = false;
        this.messageObject = new UniRPCPMessage();
    }

    public UniRPCPacket(UniRPCConnection aConnection) throws UniRPCPacketException {
        if (aConnection == null || !aConnection.isConnected()) {
            throw new UniRPCPacketException("An open connection is required for this constructor.", 81002);
        }
        this.currentConnection = aConnection;
        this.debugLevel = aConnection.getDebugLevel();
        this.debugWriter = aConnection.getDebugWriter();
        this.currentVersion = aConnection.getVersionCurrent();
        this.currentVersionProxy = aConnection.getVersionCurrentProxy();
        if (aConnection.isProxyConnection() && aConnection.getSSLMode() != 1 && aConnection.getSSLMode() != 3) {
            this.proxyHeaderObject = new UniRPCPProxyHeader();
            this.proxyHeaderObject.setDebugLevel(this.debugLevel);
            this.proxyHeaderObject.setDebugWriter(this.debugWriter);
            this.proxyHeaderObject.setVersionCurrentProxy(this.currentVersionProxy);
            this.isProxyPacket = true;
        } else {
            this.isProxyPacket = false;
        }
        this.messageObject = new UniRPCPMessage();
        this.messageObject.setDebugLevel(this.debugLevel);
        this.messageObject.setDebugWriter(this.debugWriter);
        this.messageObject.setVersionCurrent(this.currentVersion);
        this.setCompressionThreshold(aConnection.getCompressionThreshold());
    }

    public void dump() {
        if (this.isProxyPacket) {
            this.proxyHeaderObject.dump();
        }
        this.messageObject.dump();
    }

    public int getArgumentCount() {
        return this.messageObject.getArgumentCount();
    }

    public int getCompressionThreshold() {
        return this.messageObject.getCompressionThreshold();
    }

    public UniRPCConnection getConnection() {
        return this.currentConnection;
    }

    public byte getEncryptionType() {
        return this.messageObject.readEncryptionMask();
    }

    public UniRPCPMessage getMessage() {
        return this.messageObject;
    }

    public int getMessageType() {
        return this.messageObject.readMessageType();
    }

    public UniRPCPProxyHeader getProxyHeader() {
        return this.proxyHeaderObject;
    }

    public int getSize() {
        int size = 0;
        if (this.isProxyPacket) {
            size += this.proxyHeaderObject.getSize();
        }
        return size += this.messageObject.getSize();
    }

    public char[] readCharArray(int anIndex) throws UniRPCPacketException {
        return this.messageObject.readCharArray(anIndex);
    }

    public double readDouble(int anIndex) throws UniRPCPacketException {
        return this.messageObject.readDouble(anIndex);
    }

    public double[] readDoubleArray(int anIndex) throws UniRPCPacketException {
        return this.messageObject.readDoubleArray(anIndex);
    }

    public int readInteger(int anIndex) throws UniRPCPacketException {
        return this.messageObject.readInteger(anIndex);
    }

    public int[] readIntegerArray(int anIndex) throws UniRPCPacketException {
        return this.messageObject.readIntegerArray(anIndex);
    }

    public String readString(int anIndex) throws UniRPCPacketException {
        return this.messageObject.readString(anIndex);
    }

    public byte[] readBytes(int anIndex) throws UniRPCPacketException {
        return this.messageObject.readBytes(anIndex);
    }

    public int readType(int anIndex) throws UniRPCPacketException {
        return this.messageObject.readType(anIndex);
    }

    public void receive(DataInputStream aDataIn) throws UniRPCPacketException {
        if (this.debugLevel > 3) {
            this.debugWriter.println("INCOMING PACKET:");
        }
        if (this.isProxyPacket) {
            this.proxyHeaderObject.receive(aDataIn);
        }
        this.messageObject.receive(aDataIn);
    }

    public void send(DataOutputStream aDataOut, byte anEncryptionMask, int aConnectionID) throws UniRPCPacketException {
        if (this.debugLevel > 3) {
            this.debugWriter.println("OUTGOING PACKET:");
        }
        if (this.isProxyPacket) {
            this.proxyHeaderObject.setLength(this.messageObject.getLength(anEncryptionMask));
            this.proxyHeaderObject.writeConnection(aConnectionID);
            this.proxyHeaderObject.send(aDataOut);
        }
        this.messageObject.send(aDataOut, anEncryptionMask);
        try {
            aDataOut.flush();
        }
        catch (IOException e) {
            throw new UniRPCPacketException(e.getMessage(), 81009);
        }
    }

    public void setCompressionThreshold(int aThreshold) throws UniRPCPacketException {
        this.messageObject.setCompressionThreshold(aThreshold);
    }

    @Override
    public void setDebugLevel(int aLevel) {
        super.setDebugLevel(aLevel);
        if (this.isProxyPacket) {
            this.proxyHeaderObject.setDebugLevel(aLevel);
        }
        this.messageObject.setDebugLevel(aLevel);
    }

    @Override
    public void setDebugWriter(Writer aWriter) {
        super.setDebugWriter(aWriter);
        if (this.isProxyPacket) {
            this.proxyHeaderObject.setDebugWriter(aWriter);
        }
        this.messageObject.setDebugWriter(aWriter);
    }

    public void setMessage(UniRPCPMessage aMessage) {
        this.messageObject = aMessage;
        this.messageObject.setDebugLevel(this.debugLevel);
        this.messageObject.setDebugWriter(this.debugWriter);
        this.messageObject.setVersionCurrent(this.currentVersion);
    }

    public void setMessageType(int aType) {
        this.messageObject.writeMessageType(aType);
    }

    public void setProxyHeader(UniRPCPProxyHeader aProxyHeader) {
        this.proxyHeaderObject = aProxyHeader;
        this.proxyHeaderObject.setDebugLevel(this.debugLevel);
        this.proxyHeaderObject.setDebugWriter(this.debugWriter);
        this.proxyHeaderObject.setVersionCurrentProxy(this.currentVersionProxy);
        this.isProxyPacket = true;
    }

    public void unsetProxyHeader() {
        this.isProxyPacket = false;
        this.proxyHeaderObject = null;
    }

    public void write(int anIndex, char[] aCharArray) throws UniRPCPacketException {
        this.messageObject.write(anIndex, aCharArray);
    }

    public void write(int anIndex, double aDouble) throws UniRPCPacketException {
        this.messageObject.write(anIndex, aDouble);
    }

    public void write(int anIndex, double[] aDouble) throws UniRPCPacketException {
        this.messageObject.write(anIndex, aDouble);
    }

    public void write(int anIndex, int anInteger) throws UniRPCPacketException {
        this.messageObject.write(anIndex, anInteger);
    }

    public void write(int anIndex, Integer anInteger) throws UniRPCPacketException {
        this.messageObject.write(anIndex, anInteger);
    }

    public void write(int anIndex, int[] anInteger) throws UniRPCPacketException {
        this.messageObject.write(anIndex, anInteger);
    }

    public void write(int anIndex, String aString) throws UniRPCPacketException {
        this.messageObject.write(anIndex, aString);
    }

    public void write(int anIndex, byte[] bArray) throws UniRPCPacketException {
        this.messageObject.write(anIndex, bArray);
    }

    public void writeChars(int anIndex, byte[] bArray) throws UniRPCPacketException {
        this.messageObject.writeChars(anIndex, bArray);
    }

    protected void write(int anIndex, UniString aString) throws UniRPCPacketException {
        this.messageObject.write(anIndex, aString);
    }
}

