/*
 * Decompiled with CFR 0.152.
 */
package asjava.unirpc;

import asjava.unirpc.UniRPC;
import asjava.unirpc.UniRPCPacketException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;

public class UniRPCPProxyHeader
extends UniRPC {
    private byte[] proxyHeaderBuffer = new byte[24];
    private int hdrSequenceNumber = 0;
    private static final byte UNIRPC_PATT_CHECK = 108;
    private static final int UNIRPC_PROXY_HEADER_SIZE = 24;

    public UniRPCPProxyHeader() {
        int i = 0;
        while (i < 24) {
            this.proxyHeaderBuffer[i] = 0;
            ++i;
        }
        this.proxyHeaderBuffer[0] = 108;
        this.proxyHeaderBuffer[1] = (byte)(this.currentVersion >>> 0 & 0xFF);
        this.proxyHeaderBuffer[4] = 2;
        this.proxyHeaderBuffer[6] = 0;
        this.proxyHeaderBuffer[7] = 24;
        this.writeHeaderType(0);
    }

    public void dump() {
        if (this.debugLevel > 5) {
            String temp;
            int i;
            this.debugWriter.println("Proxy Packet Header Detail:");
            if (this.debugLevel > 7) {
                this.debugWriter.print(" proxyHeaderBuffer=0x");
                i = 0;
                while (i < this.proxyHeaderBuffer.length) {
                    temp = Integer.toHexString(this.proxyHeaderBuffer[i] & 0xFF);
                    if (temp.length() == 1) {
                        this.debugWriter.print("0" + temp);
                    } else if (temp.length() == 2) {
                        this.debugWriter.print(temp);
                    } else {
                        this.debugWriter.print("(" + temp + ")");
                    }
                    if ((i + 1) % 4 == 0) {
                        this.debugWriter.print(" ");
                    }
                    ++i;
                }
                this.debugWriter.println();
            }
            this.debugWriter.print(" VersionInHex=0x");
            i = 0;
            while (i < 2) {
                temp = Integer.toHexString(this.proxyHeaderBuffer[i] & 0xFF);
                if (temp.length() == 1) {
                    this.debugWriter.print("0" + temp);
                } else {
                    this.debugWriter.print(temp);
                }
                if ((i + 1) % 4 == 0) {
                    this.debugWriter.print(" ");
                }
                ++i;
            }
            this.debugWriter.println();
            this.debugWriter.println(" Sequence=" + (((this.proxyHeaderBuffer[2] & 0xFF) << 8) + ((this.proxyHeaderBuffer[3] & 0xFF) << 0)));
            this.debugWriter.println(" Highest Supported Version=" + ((this.proxyHeaderBuffer[4] & 0xFF) << 0));
            this.debugWriter.println(" Future Use=0x" + Integer.toHexString(this.proxyHeaderBuffer[5] & 0xFF));
            this.debugWriter.println(" Proxy Header length=" + (((this.proxyHeaderBuffer[6] & 0xFF) << 8) + ((this.proxyHeaderBuffer[7] & 0xFF) << 0)));
            this.debugWriter.println(" Header Type=" + (((this.proxyHeaderBuffer[8] & 0xFF) << 24) + ((this.proxyHeaderBuffer[9] & 0xFF) << 16) + ((this.proxyHeaderBuffer[10] & 0xFF) << 8) + ((this.proxyHeaderBuffer[11] & 0xFF) << 0)));
            this.debugWriter.println(" ConnectionID=" + (((this.proxyHeaderBuffer[12] & 0xFF) << 24) + ((this.proxyHeaderBuffer[13] & 0xFF) << 16) + ((this.proxyHeaderBuffer[14] & 0xFF) << 8) + ((this.proxyHeaderBuffer[15] & 0xFF) << 0)));
            this.debugWriter.println(" Length=" + (((this.proxyHeaderBuffer[16] & 0xFF) << 24) + ((this.proxyHeaderBuffer[17] & 0xFF) << 16) + ((this.proxyHeaderBuffer[18] & 0xFF) << 8) + ((this.proxyHeaderBuffer[19] & 0xFF) << 0)));
        }
    }

    public int getLength() {
        return ((this.proxyHeaderBuffer[16] & 0xFF) << 24) + ((this.proxyHeaderBuffer[17] & 0xFF) << 16) + ((this.proxyHeaderBuffer[18] & 0xFF) << 8) + ((this.proxyHeaderBuffer[19] & 0xFF) << 0);
    }

    public int getSize() {
        return 24;
    }

    public int readConnection() {
        return ((this.proxyHeaderBuffer[12] & 0xFF) << 24) + ((this.proxyHeaderBuffer[13] & 0xFF) << 16) + ((this.proxyHeaderBuffer[14] & 0xFF) << 8) + ((this.proxyHeaderBuffer[15] & 0xFF) << 0);
    }

    public int readHeaderType() {
        return ((this.proxyHeaderBuffer[8] & 0xFF) << 24) + ((this.proxyHeaderBuffer[9] & 0xFF) << 16) + ((this.proxyHeaderBuffer[10] & 0xFF) << 8) + ((this.proxyHeaderBuffer[11] & 0xFF) << 0);
    }

    public int readHeaderVersion() {
        return (this.proxyHeaderBuffer[1] & 0xFF) << 0;
    }

    public int readHeaderVersionHighest() {
        return (this.proxyHeaderBuffer[4] & 0xFF) << 0;
    }

    public void receive(DataInputStream aDataIn) throws UniRPCPacketException {
        if (aDataIn == null) {
            throw new UniRPCPacketException("The DataInputStream is dead.", 81002);
        }
        try {
            aDataIn.readFully(this.proxyHeaderBuffer);
            if (this.debugLevel > 3) {
                this.dump();
            }
        }
        catch (InterruptedIOException e) {
            throw new UniRPCPacketException(e.getMessage(), 81015);
        }
        catch (IOException e) {
            throw new UniRPCPacketException(e.getMessage(), 81009);
        }
    }

    public void send(DataOutputStream aDataOut) throws UniRPCPacketException {
        if (aDataOut == null) {
            throw new UniRPCPacketException("The DataOutputStream is dead.", 81002);
        }
        if (this.debugLevel > 3) {
            this.dump();
        }
        try {
            aDataOut.write(this.proxyHeaderBuffer);
        }
        catch (IOException e) {
            throw new UniRPCPacketException(e.getMessage(), 81009);
        }
    }

    public void setLength(int aLength) {
        this.proxyHeaderBuffer[16] = (byte)(aLength >>> 24 & 0xFF);
        this.proxyHeaderBuffer[17] = (byte)(aLength >>> 16 & 0xFF);
        this.proxyHeaderBuffer[18] = (byte)(aLength >>> 8 & 0xFF);
        this.proxyHeaderBuffer[19] = (byte)(aLength >>> 0 & 0xFF);
    }

    public void writeConnection(int aHost) {
        this.proxyHeaderBuffer[12] = (byte)(aHost >>> 24 & 0xFF);
        this.proxyHeaderBuffer[13] = (byte)(aHost >>> 16 & 0xFF);
        this.proxyHeaderBuffer[14] = (byte)(aHost >>> 8 & 0xFF);
        this.proxyHeaderBuffer[15] = (byte)(aHost >>> 0 & 0xFF);
    }

    public void writeHeaderType(int aType) {
        this.proxyHeaderBuffer[8] = (byte)(aType >>> 24 & 0xFF);
        this.proxyHeaderBuffer[9] = (byte)(aType >>> 16 & 0xFF);
        this.proxyHeaderBuffer[10] = (byte)(aType >>> 8 & 0xFF);
        this.proxyHeaderBuffer[11] = (byte)(aType >>> 0 & 0xFF);
    }

    private void clear() {
        int i = 0;
        while (i < this.proxyHeaderBuffer.length) {
            this.proxyHeaderBuffer[i] = 0;
            ++i;
        }
        this.proxyHeaderBuffer[0] = 108;
        this.proxyHeaderBuffer[1] = (byte)(this.currentVersion >>> 0 & 0xFF);
        this.proxyHeaderBuffer[4] = 2;
        this.proxyHeaderBuffer[6] = 0;
        this.proxyHeaderBuffer[7] = 24;
        this.writeHeaderType(0);
    }
}

