/*
 * Decompiled with CFR 0.152.
 */
package asjava.unirpc;

import asjava.uniobjects.UniSSLDescriptor;
import asjava.unirpc.UniRPC;
import asjava.unirpc.UniRPCConnectionException;
import asjava.unirpc.UniRPCPProxyHeader;
import asjava.unirpc.UniRPCPacket;
import asjava.unirpc.UniRPCPacketException;
import asjava.unirpc.UniRPCSocket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class UniRPCConnection
extends UniRPC {
    private static final int UNIRPC_DEFAULT_TIMEOUT = 300;
    private boolean versionPromotion = true;
    private String currentHost;
    private String currentProxyHost;
    private String currentProxyToken;
    private InetAddress currentHostAddress;
    private InetAddress currentProxyAddress;
    private int currentPort = -1;
    private int currentProxyPort = -1;
    private int currentTransportType;
    private char[] currentService;
    private int currentTimeoutSeconds = 0;
    private int currentCompressionThreshold = 0;
    private byte currentEncryptionType;
    private byte lastEncryptionType;
    private int currentProxyConnectionID;
    private boolean isActive = false;
    private boolean isConnected = false;
    private boolean isProxyConnection = false;
    private boolean isMultiplexed = false;
    private boolean isClient = true;
    private boolean isEncryptionEnabled = false;
    private UniRPCSocket socket;
    private DataInputStream dataIn;
    private DataOutputStream dataOut;
    private int sslMode = 0;
    private String serverId = "";

    public UniRPCConnection() {
        this.isActive = false;
        this.isConnected = false;
        this.isProxyConnection = false;
        this.isMultiplexed = false;
        this.currentTimeoutSeconds = 300;
        this.currentPort = 31438;
        this.currentTransportType = 1;
        this.currentEncryptionType = 0;
        this.currentProxyToken = "";
        this.currentProxyConnectionID = 0;
    }

    public UniRPCConnection(int sslmode) {
        this.sslMode = sslmode;
        this.isActive = false;
        this.isConnected = false;
        this.isProxyConnection = false;
        this.isMultiplexed = false;
        this.currentTimeoutSeconds = 300;
        this.currentPort = 31438;
        this.currentTransportType = 1;
        this.currentEncryptionType = 0;
        this.currentProxyToken = "";
        this.currentProxyConnectionID = 0;
        this.currentProxyPort = this.sslMode == 2 ? 31452 : 31448;
    }

    public UniRPCConnection(UniRPCConnection aConnection) throws UniRPCConnectionException {
        if (aConnection == null || !aConnection.isConnected()) {
            throw new UniRPCConnectionException(81002);
        }
        if (!aConnection.isProxyConnection()) {
            throw new UniRPCConnectionException(81024);
        }
        if (aConnection.getSSLMode() == 1 || aConnection.getSSLMode() == 3) {
            throw new UniRPCConnectionException(81024);
        }
        this.isActive = false;
        this.isConnected = false;
        this.isProxyConnection = true;
        this.isMultiplexed = true;
        aConnection.isMultiplexed = true;
        this.currentCompressionThreshold = aConnection.currentCompressionThreshold;
        this.currentHost = aConnection.currentHost;
        this.currentHostAddress = aConnection.currentHostAddress;
        this.currentPort = 31438;
        this.currentProxyHost = aConnection.currentProxyHost;
        this.currentProxyAddress = aConnection.currentProxyAddress;
        this.currentProxyPort = aConnection.currentProxyPort;
        this.currentProxyToken = aConnection.currentProxyToken;
        this.currentService = aConnection.currentService;
        this.currentTimeoutSeconds = aConnection.currentTimeoutSeconds;
        this.currentTransportType = aConnection.currentTransportType;
        this.currentEncryptionType = aConnection.currentEncryptionType;
        this.currentProxyConnectionID = 0;
        this.socket = aConnection.socket.multiplex();
        this.dataIn = aConnection.dataIn;
        this.dataOut = aConnection.dataOut;
        this.debugLevel = aConnection.debugLevel;
        this.debugWriter = aConnection.debugWriter;
    }

    public void acceptConnect(UniRPCSocket aSocket) throws UniRPCConnectionException {
        try {
            this.socket = aSocket;
            this.socket.setSoTimeout(this.currentTimeoutSeconds * 1000);
            this.socket.setSoLinger(true, this.currentTimeoutSeconds);
            this.socket.setTcpNoDelay(true);
            this.dataOut = new DataOutputStream(this.socket.getOutputStream());
            this.dataIn = new DataInputStream(this.socket.getInputStream());
            this.currentPort = aSocket.getPort();
            this.currentTransportType = 1;
        }
        catch (SocketException socketException) {
            throw new UniRPCConnectionException(81002);
        }
        catch (IOException iOException) {
            throw new UniRPCConnectionException(81002);
        }
        this.isActive = true;
        this.isConnected = true;
        this.isProxyConnection = false;
        this.isMultiplexed = false;
        this.isClient = false;
        this.lastEncryptionType = 0;
    }

    public void call(UniRPCPacket anOutPacket, UniRPCPacket anInPacket) throws UniRPCConnectionException {
        if (this.isEncryptionEnabled) {
            this.call(anOutPacket, anInPacket, this.currentEncryptionType, this.currentProxyConnectionID);
        } else {
            this.call(anOutPacket, anInPacket, (byte)0, this.currentProxyConnectionID);
        }
    }

    public void call(UniRPCPacket anOutPacket, UniRPCPacket anInPacket, byte anEncryptionType) throws UniRPCConnectionException {
        this.call(anOutPacket, anInPacket, anEncryptionType, this.currentProxyConnectionID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call(UniRPCPacket anOutPacket, UniRPCPacket anInPacket, byte anEncryptionType, int aConnectionID) throws UniRPCConnectionException {
        if (!this.equals(anOutPacket.getConnection()) || !this.equals(anInPacket.getConnection())) {
            throw new UniRPCConnectionException(81023);
        }
        UniRPCSocket uniRPCSocket = this.socket;
        synchronized (uniRPCSocket) {
            this.writePacketInternal(anOutPacket, anEncryptionType, aConnectionID);
            this.readPacketInternal(anInPacket);
        }
    }

    public void close() throws UniRPCConnectionException {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            throw new UniRPCConnectionException(81001);
        }
        this.isConnected = false;
    }

    public void sconnect(UniSSLDescriptor ussld) throws UniRPCConnectionException {
        try {
            int response;
            this.socket = !this.isProxyConnection ? new UniRPCSocket(this.currentHostAddress, this.currentPort) : new UniRPCSocket(this.currentProxyAddress, this.currentProxyPort);
            this.socket.setSoTimeout(this.currentTimeoutSeconds * 1000);
            this.socket.setSoLinger(true, this.currentTimeoutSeconds);
            this.socket.setTcpNoDelay(true);
            this.dataOut = new DataOutputStream(this.socket.getOutputStream());
            this.dataIn = new DataInputStream(this.socket.getInputStream());
            this.isClient = true;
            UniRPCPacket outPacket = new UniRPCPacket();
            UniRPCPacket inPacket = new UniRPCPacket();
            if (this.isProxyConnection) {
                outPacket.setProxyHeader(new UniRPCPProxyHeader());
                inPacket.setProxyHeader(new UniRPCPProxyHeader());
            }
            outPacket.setDebugLevel(this.debugLevel);
            inPacket.setDebugLevel(this.debugLevel);
            outPacket.setDebugWriter(this.debugWriter);
            inPacket.setDebugWriter(this.debugWriter);
            if (this.isProxyConnection) {
                this.setVersionCurrent(2);
                outPacket.write(0, this.currentHost);
                outPacket.write(1, this.currentPort);
                outPacket.write(2, this.currentProxyToken);
                outPacket.write(3, 1);
                this.writePacketInternal(outPacket, (byte)1, 0);
                this.readPacketInternal(inPacket);
                try {
                    response = inPacket.readInteger(0);
                    if (response != 0) {
                        if (response == 83000 || response == 83001 || response == 83002 || response == 83003) {
                            throw new UniRPCConnectionException("The proxy server login failed!", response);
                        }
                        throw new UniRPCConnectionException("The proxy server login failed! The returned error code=" + response + ".", 83000);
                    }
                }
                catch (UniRPCPacketException uniRPCPacketException) {
                    throw new UniRPCConnectionException(81002);
                }
                this.setVersionCurrent(1);
                this.versionPromotion = true;
            }
            if (this.isProxyConnection()) {
                inPacket.unsetProxyHeader();
                outPacket.unsetProxyHeader();
            }
            outPacket.write(0, this.currentService);
            outPacket.write(1, 1);
            this.writePacketInternal(outPacket, (byte)0, this.currentProxyConnectionID);
            this.readPacketInternal(inPacket);
            try {
                if (inPacket.getArgumentCount() == 2) {
                    response = inPacket.readInteger(1);
                    this.serverId = inPacket.readString(0);
                } else {
                    response = inPacket.readInteger(0);
                }
                if (response != 0) {
                    throw new UniRPCConnectionException("UniRPCConnection failed to establish a connection with the remote host. The returned error code=" + response + ".", 81002);
                }
                this.isConnected = true;
                this.isActive = true;
            }
            catch (UniRPCPacketException uniRPCPacketException) {
                throw new UniRPCConnectionException(81002);
            }
            if (!this.isProxyConnection) {
                this.socket.makeSecure(this.currentHost, this.currentPort, ussld);
            } else {
                this.socket.makeSecure(this.currentProxyHost, this.currentProxyPort, ussld);
            }
            this.dataOut = new DataOutputStream(this.socket.getOutputStream());
            this.dataIn = new DataInputStream(this.socket.getInputStream());
        }
        catch (IOException iOException) {
            throw new UniRPCConnectionException(81001);
        }
        catch (UniRPCPacketException uniRPCPacketException) {
            throw new UniRPCConnectionException(81002);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void espconnect(UniSSLDescriptor ussld, boolean intsslflag) throws UniRPCConnectionException {
        try {
            if (!this.isMultiplexed) {
                if (!this.isProxyConnection) {
                    throw new UniRPCConnectionException(83004);
                }
                this.socket = new UniRPCSocket(this.currentProxyAddress, this.currentProxyPort, ussld, true);
                this.socket.setSoTimeout(this.currentTimeoutSeconds * 1000);
                this.socket.setSoLinger(true, this.currentTimeoutSeconds);
                this.socket.setTcpNoDelay(true);
                this.dataOut = new DataOutputStream(this.socket.getOutputStream());
                this.dataIn = new DataInputStream(this.socket.getInputStream());
            }
            this.isClient = true;
            UniRPCPacket outPacket = new UniRPCPacket();
            UniRPCPacket inPacket = new UniRPCPacket();
            outPacket.setProxyHeader(new UniRPCPProxyHeader());
            inPacket.setProxyHeader(new UniRPCPProxyHeader());
            outPacket.setDebugLevel(this.debugLevel);
            inPacket.setDebugLevel(this.debugLevel);
            outPacket.setDebugWriter(this.debugWriter);
            inPacket.setDebugWriter(this.debugWriter);
            UniRPCSocket uniRPCSocket = this.socket;
            synchronized (uniRPCSocket) {
                this.setVersionCurrent(2);
                outPacket.write(0, this.currentHost);
                outPacket.write(1, this.currentPort);
                outPacket.write(2, this.currentProxyToken);
                if (!intsslflag) {
                    outPacket.write(3, 0);
                } else {
                    outPacket.write(3, 1);
                }
                this.writePacketInternal(outPacket, (byte)1, 0);
                this.readPacketInternal(inPacket);
                try {
                    int connectionID;
                    int response = inPacket.readInteger(0);
                    if (response != 0) {
                        if (response == 83000 || response == 83001 || response == 83002 || response == 83003) {
                            throw new UniRPCConnectionException("The proxy server login failed!", response);
                        }
                        throw new UniRPCConnectionException("The proxy server login failed! The returned error code=" + response + ".", 83000);
                    }
                    this.isConnected = true;
                    this.isActive = true;
                    this.currentProxyConnectionID = connectionID = inPacket.readInteger(1);
                }
                catch (UniRPCPacketException uniRPCPacketException) {
                    throw new UniRPCConnectionException(81002);
                }
                this.setVersionCurrent(1);
                this.versionPromotion = true;
                outPacket.write(0, this.currentService);
                this.writePacketInternal(outPacket, (byte)0, this.currentProxyConnectionID);
                this.readPacketInternal(inPacket);
            }
            try {
                int response = inPacket.getArgumentCount() == 2 ? inPacket.readInteger(1) : inPacket.readInteger(0);
                if (response != 0) {
                    throw new UniRPCConnectionException("UniRPCConnection failed to establish a connection with the remote host. The returned error code=" + response + ".", 81002);
                }
                this.isConnected = true;
                this.isActive = true;
            }
            catch (UniRPCPacketException uniRPCPacketException) {
                throw new UniRPCConnectionException(81002);
            }
        }
        catch (IOException iOException) {
            throw new UniRPCConnectionException(81002);
        }
        catch (UniRPCPacketException uniRPCPacketException) {
            throw new UniRPCConnectionException(81002);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectInternal(int responseIndex) throws UniRPCConnectionException {
        try {
            if (!this.isMultiplexed) {
                this.socket = !this.isProxyConnection ? new UniRPCSocket(this.currentHostAddress, this.currentPort) : new UniRPCSocket(this.currentProxyAddress, this.currentProxyPort);
                this.socket.setSoTimeout(this.currentTimeoutSeconds * 1000);
                this.socket.setSoLinger(true, this.currentTimeoutSeconds);
                this.socket.setTcpNoDelay(true);
                this.dataOut = new DataOutputStream(this.socket.getOutputStream());
                this.dataIn = new DataInputStream(this.socket.getInputStream());
            }
            this.isClient = true;
            UniRPCPacket outPacket = new UniRPCPacket();
            UniRPCPacket inPacket = new UniRPCPacket();
            if (this.isProxyConnection) {
                outPacket.setProxyHeader(new UniRPCPProxyHeader());
                inPacket.setProxyHeader(new UniRPCPProxyHeader());
            }
            outPacket.setDebugLevel(this.debugLevel);
            inPacket.setDebugLevel(this.debugLevel);
            outPacket.setDebugWriter(this.debugWriter);
            inPacket.setDebugWriter(this.debugWriter);
            UniRPCSocket uniRPCSocket = this.socket;
            synchronized (uniRPCSocket) {
                if (this.isProxyConnection) {
                    this.setVersionCurrent(2);
                    outPacket.write(0, this.currentHost);
                    outPacket.write(1, this.currentPort);
                    outPacket.write(2, this.currentProxyToken);
                    outPacket.write(3, 0);
                    this.writePacketInternal(outPacket, (byte)1, 0);
                    this.readPacketInternal(inPacket);
                    try {
                        int connectionID;
                        int response = inPacket.readInteger(0);
                        if (response != 0) {
                            if (response == 83000 || response == 83001 || response == 83002 || response == 83003) {
                                throw new UniRPCConnectionException("The proxy server login failed!", response);
                            }
                            throw new UniRPCConnectionException("The proxy server login failed! The returned error code=" + response + ".", 83000);
                        }
                        this.isConnected = true;
                        this.isActive = true;
                        this.currentProxyConnectionID = connectionID = inPacket.readInteger(1);
                    }
                    catch (UniRPCPacketException uniRPCPacketException) {
                        throw new UniRPCConnectionException(81002);
                    }
                    this.setVersionCurrent(1);
                    this.versionPromotion = true;
                }
                outPacket.write(0, this.currentService);
                this.writePacketInternal(outPacket, (byte)0, this.currentProxyConnectionID);
                this.readPacketInternal(inPacket);
            }
            try {
                int response;
                if (inPacket.getArgumentCount() == 2) {
                    response = inPacket.readInteger(1);
                    this.serverId = inPacket.readString(0);
                } else {
                    response = inPacket.readInteger(responseIndex);
                }
                if (response != 0) {
                    throw new UniRPCConnectionException("UniRPCConnection failed to establish a connection with the remote host. The returned error code=" + response + ".", 81002);
                }
                this.isConnected = true;
                this.isActive = true;
            }
            catch (UniRPCPacketException uniRPCPacketException) {
                throw new UniRPCConnectionException(81002);
            }
        }
        catch (IOException iOException) {
            throw new UniRPCConnectionException(81002);
        }
        catch (UniRPCPacketException uniRPCPacketException) {
            throw new UniRPCConnectionException(81002);
        }
    }

    public void connect() throws UniRPCConnectionException {
        this.connectInternal(0);
    }

    public void connect(int responseIndex) throws UniRPCConnectionException {
        this.connectInternal(responseIndex);
    }

    public void disableEncryption() {
        this.isEncryptionEnabled = false;
    }

    public boolean isServerAlive() {
        return this.socket.isServerAlive();
    }

    public void enableEncryption() throws UniRPCConnectionException {
        if (!this.isEncryptionSupported()) {
            throw new UniRPCConnectionException(81025);
        }
        this.isEncryptionEnabled = true;
    }

    public int getCompressionThreshold() {
        return this.currentCompressionThreshold;
    }

    public byte getEncryptionType() {
        return this.currentEncryptionType;
    }

    public String getHost() {
        return this.currentHostAddress.getHostName();
    }

    public InetAddress getHostAddress() {
        return this.currentHostAddress;
    }

    public int getPort() {
        return this.currentPort;
    }

    public String getProxyHost() {
        return this.currentProxyAddress.getHostName();
    }

    public InetAddress getProxyAddress() {
        return this.currentProxyAddress;
    }

    public int getProxyConnectionID() {
        return this.currentProxyConnectionID;
    }

    public int getProxyPort() {
        return this.currentProxyPort;
    }

    public String getProxyToken() {
        return this.currentProxyToken;
    }

    public String getService() {
        return new String(this.currentService);
    }

    public int getTimeoutSeconds() {
        return this.currentTimeoutSeconds;
    }

    public int getTransportType() {
        return this.currentTransportType;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public boolean isProxyConnection() {
        return this.isProxyConnection;
    }

    public int getSSLMode() {
        return this.sslMode;
    }

    public UniRPCPacket packet() throws UniRPCConnectionException {
        try {
            return new UniRPCPacket(this);
        }
        catch (UniRPCPacketException e) {
            throw new UniRPCConnectionException(e.getErrorCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readPacket(UniRPCPacket anInPacket) throws UniRPCConnectionException {
        if (this.isMultiplexed) {
            throw new UniRPCConnectionException("You can't use readPacket() on a multiplexed connection.", 81024);
        }
        if (!this.equals(anInPacket.getConnection())) {
            throw new UniRPCConnectionException("This packet was created with a different connection.", 81023);
        }
        UniRPCSocket uniRPCSocket = this.socket;
        synchronized (uniRPCSocket) {
            this.readPacketInternal(anInPacket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readPacketSpoofProxy(UniRPCPacket anInPacket) throws UniRPCConnectionException {
        block10: {
            if (!this.equals(anInPacket.getConnection())) {
                throw new UniRPCConnectionException("This packets was created with a different connection.", 81023);
            }
            if (this.isProxyConnection && this.sslMode != 1 && this.sslMode != 3) {
                UniRPCPProxyHeader proxyHeader = new UniRPCPProxyHeader();
                proxyHeader.writeHeaderType(10000);
                proxyHeader.writeConnection(this.currentProxyConnectionID);
                proxyHeader.setLength(0);
                try {
                    UniRPCSocket uniRPCSocket = this.socket;
                    synchronized (uniRPCSocket) {
                        proxyHeader.send(this.dataOut);
                        this.readPacketInternal(anInPacket);
                        break block10;
                    }
                }
                catch (UniRPCPacketException e) {
                    throw new UniRPCConnectionException(e.getMessage(), 81023);
                }
            }
            UniRPCSocket uniRPCSocket = this.socket;
            synchronized (uniRPCSocket) {
                this.readPacketInternal(anInPacket);
            }
        }
    }

    public void setCompressionThreshold(int aThreshold) {
        this.currentCompressionThreshold = aThreshold;
    }

    public void setEncryptionType(byte aType) throws UniRPCConnectionException {
        if (aType != 0 && aType != 1) {
            throw new UniRPCConnectionException("This type of encryption is not supported on this connection", 81025);
        }
        this.currentEncryptionType = aType;
    }

    public void setHost(String aHost) throws UniRPCConnectionException {
        if (this.isConnected()) {
            throw new UniRPCConnectionException("This method can't be used on a connected connection", 81023);
        }
        this.currentHost = new String(aHost);
        if (!this.isProxyConnection) {
            try {
                this.currentHostAddress = InetAddress.getByName(this.currentHost);
            }
            catch (UnknownHostException e) {
                throw new UniRPCConnectionException(e.getMessage(), 81011);
            }
        }
    }

    public void setPort(int aPort) throws UniRPCConnectionException {
        if (this.isConnected()) {
            throw new UniRPCConnectionException("This method can't be used on a connected connection", 81023);
        }
        this.currentPort = aPort;
    }

    public void setProxyConnectionID(int aConnectionID) throws UniRPCConnectionException {
        if (!this.isProxyConnection()) {
            throw new UniRPCConnectionException("This method has no effect when used with a non proxy connection.", 81023);
        }
        this.currentProxyConnectionID = aConnectionID;
    }

    public void setProxyHost(String aProxyServer) throws UniRPCConnectionException {
        if (this.isConnected()) {
            throw new UniRPCConnectionException("This method can't be used on a connected connection", 81023);
        }
        this.currentProxyHost = aProxyServer;
        try {
            this.currentProxyAddress = InetAddress.getByName(this.currentProxyHost);
        }
        catch (UnknownHostException e) {
            this.isProxyConnection = false;
            throw new UniRPCConnectionException(e.getMessage(), 81011);
        }
        if (this.currentProxyPort > -1) {
            this.isProxyConnection = true;
        }
    }

    public void setProxyPort(int aProxyPort) throws UniRPCConnectionException {
        if (this.isConnected()) {
            throw new UniRPCConnectionException("This method can't be used on a connected connection", 81023);
        }
        this.currentProxyPort = aProxyPort;
        if (this.currentProxyHost != "" && aProxyPort > -1) {
            this.isProxyConnection = true;
        }
    }

    public void setProxyToken(String aProxyToken) throws UniRPCConnectionException {
        if (this.isConnected()) {
            throw new UniRPCConnectionException("This method can't be used on a connected connection", 81023);
        }
        this.currentProxyToken = aProxyToken;
    }

    public void setService(String aService) throws UniRPCConnectionException {
        if (this.isConnected()) {
            throw new UniRPCConnectionException("This method can't be used on a connected connection", 81023);
        }
        this.currentService = aService.toCharArray();
    }

    public void setTimeoutSeconds(int aTimeout) throws UniRPCConnectionException {
        this.currentTimeoutSeconds = aTimeout;
        try {
            if (this.socket != null) {
                this.socket.setSoTimeout(this.currentTimeoutSeconds * 1000);
            }
        }
        catch (SocketException e) {
            throw new UniRPCConnectionException(e.getMessage(), 81009);
        }
    }

    public void setTransportType(int aTransportType) throws UniRPCConnectionException {
        if (this.isConnected()) {
            throw new UniRPCConnectionException("This method can't be used on a connected connection", 81023);
        }
        this.currentTransportType = aTransportType;
    }

    public void writePacket(UniRPCPacket anOutPacket) throws UniRPCConnectionException {
        if (this.isClient) {
            this.writePacket(anOutPacket, this.currentEncryptionType);
        } else {
            this.writePacket(anOutPacket, this.lastEncryptionType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePacket(UniRPCPacket anOutPacket, byte anEncryptionType) throws UniRPCConnectionException {
        if (this.isMultiplexed) {
            throw new UniRPCConnectionException("You can't use writePacket() on a multiplexed connection.", 81024);
        }
        if (!this.equals(anOutPacket.getConnection())) {
            throw new UniRPCConnectionException("This packets was created with a different connection.", 81023);
        }
        UniRPCSocket uniRPCSocket = this.socket;
        synchronized (uniRPCSocket) {
            this.writePacketInternal(anOutPacket, anEncryptionType, this.currentProxyConnectionID);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readPacketInternal(UniRPCPacket anInPacket) throws UniRPCConnectionException {
        try {
            anInPacket.receive(this.dataIn);
            if (!this.isClient) {
                this.lastEncryptionType = anInPacket.getEncryptionType();
            }
            if (!this.versionPromotion) return;
            int tmpVersion = anInPacket.getMessage().readHeaderVersion();
            int tmpHighVersion = anInPacket.getMessage().readHeaderVersionHighest();
            if (2 <= tmpHighVersion) {
                if (2 < tmpVersion) throw new UniRPCConnectionException("Incompatible RPC transport layers", 81005);
                this.currentVersion = 2;
            } else {
                this.currentVersion = 1 <= tmpHighVersion ? tmpHighVersion : 1;
            }
            if (this.isProxyConnection && this.sslMode != 1 && this.sslMode != 3) {
                tmpVersion = anInPacket.getProxyHeader().readHeaderVersion();
                tmpHighVersion = anInPacket.getProxyHeader().readHeaderVersionHighest();
                if (2 <= tmpHighVersion) {
                    if (2 < tmpVersion) throw new UniRPCConnectionException("Incompatible RPC transport layers", 81005);
                    this.currentVersionProxy = 2;
                } else {
                    if (1 > tmpHighVersion) throw new UniRPCConnectionException("Incompatible RPC transport layers", 81005);
                    this.currentVersionProxy = tmpHighVersion;
                }
            }
            this.versionPromotion = false;
            return;
        }
        catch (UniRPCPacketException e) {
            throw new UniRPCConnectionException(e.getMessage(), e.getErrorCode());
        }
    }

    private void writePacketInternal(UniRPCPacket anOutPacket, byte anEncryptionType, int aConnectionID) throws UniRPCConnectionException {
        if (!(anEncryptionType == 0 || this.isEncryptionSupported() && anEncryptionType == 1)) {
            throw new UniRPCConnectionException("Encryption or this type of encryption is not supported on this connection.", 81025);
        }
        try {
            anOutPacket.send(this.dataOut, anEncryptionType, aConnectionID);
        }
        catch (UniRPCPacketException e) {
            throw new UniRPCConnectionException(e.getMessage(), e.getErrorCode());
        }
    }

    public String getServerId() {
        return this.serverId;
    }
}

