/*
 * Decompiled with CFR 0.152.
 */
package asjava.uniobjects;

import asjava.uniclientlibs.UniConnection;
import asjava.uniclientlibs.UniConnectionException;
import asjava.uniclientlibs.UniDataSet;
import asjava.uniclientlibs.UniDynArray;
import asjava.uniclientlibs.UniException;
import asjava.uniclientlibs.UniString;
import asjava.uniclientlibs.UniStringException;
import asjava.uniclientlibs.UniTokens;
import asjava.uniobjects.UniCommand;
import asjava.uniobjects.UniCommandException;
import asjava.uniobjects.UniDictionary;
import asjava.uniobjects.UniFile;
import asjava.uniobjects.UniFileException;
import asjava.uniobjects.UniJava;
import asjava.uniobjects.UniNLSException;
import asjava.uniobjects.UniNLSlocale;
import asjava.uniobjects.UniNLSmap;
import asjava.uniobjects.UniSSLDescriptor;
import asjava.uniobjects.UniSelectList;
import asjava.uniobjects.UniSelectListException;
import asjava.uniobjects.UniSequentialFile;
import asjava.uniobjects.UniSequentialFileException;
import asjava.uniobjects.UniSessionException;
import asjava.uniobjects.UniSubroutine;
import asjava.uniobjects.UniSubroutineException;
import asjava.uniobjects.UniTransaction;
import asjava.uniobjects.UniTransactionException;
import asjava.uniobjects.UniXML;
import asjava.uniobjects.UniXMLException;
import asjava.unirpc.UniRPCConnection;
import asjava.unirpc.UniRPCException;
import asjava.unirpc.UniRPCPacket;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Locale;

public class UniSession
extends UniConnection
implements Cloneable {
    protected UniTransaction uniTransaction = null;
    protected UniCommand uniCommand = null;
    protected UniNLSlocale uniNLSLocale = null;
    protected UniNLSmap uniNLSMap = null;
    protected String[] atVariableArray;
    private int blockingStrategy = 2;
    private int lockStrategy = 0;
    private int releaseStrategy = 12;
    private int uniReturnCode = 0;
    private int numOpenFiles = 0;
    private int uniStatus = 0;
    private UniSSLDescriptor uSSLD = null;
    private int sslMode = 0;
    private final String MAC_ADDRESS = "JAVA";
    private final String DEVICE_NAME = "unknown host";
    private boolean pooledSession = false;
    private Date creationTime = new Date();
    private Date freedTime = new Date();
    private boolean isIgnoreDeviceLicense = false;
    private String altDeviceName;
    private String lastServerError;

    public UniSession() {
        this.connection = new UniRPCConnection();
        this.isActive = false;
        this.initDefaultValues();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public UniSession(UniSession aSession) throws UniSessionException {
        if (aSession == null) {
            throw new UniSessionException(39120);
        }
        if (aSession.getSSLMode() == 1 || aSession.getSSLMode() == 3) {
            throw new UniSessionException(84444);
        }
        try {
            this.connection = new UniRPCConnection(aSession.connection);
        }
        catch (UniRPCException e) {
            throw new UniSessionException(e.getErrorCode());
        }
        this.isActive = false;
        this.initDefaultValues();
    }

    public UniSession(int sslmode) throws UniSessionException {
        if (sslmode != 0 && sslmode != 3 && sslmode != 1 && sslmode != 2) {
            throw new UniSessionException(84446);
        }
        this.connection = new UniRPCConnection(sslmode);
        this.initDefaultValues();
        this.sslMode = sslmode;
    }

    protected synchronized void finalize() {
        try {
            UniJava.uniLog("UniSession.finalize called");
            UniJava.closeSessionInternal(this);
        }
        catch (UniSessionException e) {
            e.printStackTrace();
        }
    }

    public UniCommand command() throws UniSessionException {
        this.checkEntryConditions();
        if (this.uniCommand == null) {
            try {
                this.uniCommand = new UniCommand(this);
            }
            catch (UniCommandException e) {
                throw new UniSessionException(e.getErrorCode());
            }
        }
        return this.uniCommand;
    }

    private boolean isSessionAlive() {
        return this.connection.isServerAlive();
    }

    public UniCommand command(Object aCommandString) throws UniSessionException {
        this.uniCommand = this.command();
        this.uniCommand.setCommand(aCommandString.toString());
        return this.uniCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void connectInternal() throws UniSessionException {
        UniSession uniSession = this;
        synchronized (uniSession) {
            try {
                if (this.connection == null) {
                    this.connection = new UniRPCConnection();
                    this.isActive = false;
                    this.initDefaultValues();
                }
                if (this.proxyHost != null) {
                    this.connection.setProxyHost(this.proxyHost);
                    this.connection.setProxyPort(this.proxyPort);
                    this.connection.setProxyToken(this.proxySecurityToken);
                }
                this.connection.setHost(this.hostName);
                this.connection.setPort(this.hostPort);
                this.connection.setService(this.uniConnectionString);
                this.connection.setTimeoutSeconds(this.timeout);
                this.connection.setTransportType(this.transport);
                if (this.sslMode == 0) {
                    try {
                        this.connection.connect();
                    }
                    catch (UniException uniException) {
                        this.setRPCError(true);
                        this.connection.setService("uvcs");
                        this.connection.connect();
                    }
                } else if (this.sslMode == 1 || this.sslMode == 3) {
                    this.connection.sconnect(this.uSSLD);
                } else {
                    if (this.sslMode != 2) throw new UniSessionException(84446);
                    if (this.proxyHost == null) throw new UniSessionException(84445);
                    if (this.sslMode == 2) {
                        this.connection.espconnect(this.uSSLD, false);
                    } else {
                        this.connection.espconnect(this.uSSLD, true);
                    }
                }
                this.outPacket = new UniRPCPacket(this.connection);
                this.inPacket = new UniRPCPacket(this.connection);
                if (this.userName == null || this.userName.equals("")) {
                    throw new UniSessionException(80011);
                }
                if (this.accountPath == null || this.accountPath.equals("")) {
                    throw new UniSessionException(39125);
                }
                switch (this.getServerVersion()) {
                    case 1: {
                        this.outPacket.write(0, 3);
                        this.outPacket.write(1, 4);
                        this.outPacket.write(2, this.encode(this.userName));
                        this.outPacket.write(3, this.encode(this.encrypt(this.password)));
                        this.outPacket.write(4, this.encode(this.accountPath));
                        this.outPacket.write(5, this.encode(this.licenseToken));
                        this.outPacket.write(6, 0);
                        break;
                    }
                    default: {
                        this.outPacket.write(0, 4);
                        this.outPacket.write(1, 6);
                        this.outPacket.write(2, this.encode(this.userName));
                        this.outPacket.write(3, this.encode(this.encrypt(this.password)));
                        this.outPacket.write(4, this.encode(this.accountPath));
                        this.outPacket.write(5, this.encode(this.licenseToken));
                        this.outPacket.write(6, 0);
                        if (this.isIgnoreDeviceLicense) {
                            this.outPacket.write(7, "");
                            this.outPacket.write(8, "");
                            this.outPacket.write(9, this.getAltDeviceName());
                            this.outPacket.write(10, "");
                        } else {
                            this.outPacket.write(7, this.getIPaddress());
                            this.outPacket.write(8, this.encode(this.getMacAddress()));
                            this.outPacket.write(9, this.encode(this.getDeviceName()));
                            this.outPacket.write(10, this.encode(this.getDeviceSubkey()));
                        }
                        if (UniJava.getUOPooling()) {
                            if (!this.IsCPSupported(this.connection.getServerId())) throw new UniSessionException(82002);
                            this.outPacket.write(11, 1);
                            break;
                        }
                        this.outPacket.write(11, 0);
                    }
                }
                this.connection.call(this.outPacket, this.inPacket);
                this.uniReturnCode = this.inPacket.readInteger(0);
                if (this.uniReturnCode != 0) {
                    if (this.inPacket.getArgumentCount() > 1) {
                        this.lastServerError = this.inPacket.readString(1);
                    }
                    this.connection.close();
                    throw new UniSessionException(this.uniReturnCode);
                }
                this.getHostInfo();
                this.nlsInit();
                this.isActive = true;
            }
            catch (UniRPCException e) {
                throw new UniSessionException(e.getErrorCode());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws UniSessionException {
        if (!UniJava.getUOPooling() || this.proxyHost != null) {
            this.connectInternal();
        } else {
            if (UniJava.getUOPooling() && this.proxyHost != null) {
                throw new UniSessionException(82005);
            }
            UniSession uniSession = this;
            synchronized (uniSession) {
                UniSession us = UniJava.openPooledSession(this.hostName, this.hostPort, this.userName, this.password, this.accountPath, this.uniConnectionString, this.sslMode);
                this.connection = us.connection;
                this.inPacket = us.inPacket;
                this.outPacket = us.outPacket;
                this.uniMarkCharacters = us.uniMarkCharacters;
                this.uniMarkBytes = us.uniMarkBytes;
                this.encoding = us.encoding;
                this.charset = us.charset;
                this.uniConnectionString = us.uniConnectionString;
                this.uniDataSourceType = us.uniDataSourceType;
                this.proxyHost = us.proxyHost;
                this.proxySecurityToken = us.proxySecurityToken;
                this.licenseToken = us.licenseToken;
                this.uniSubKey = us.uniSubKey;
                this.hostPort = us.hostPort;
                this.proxyPort = us.proxyPort;
                this.transport = us.transport;
                this.compressionThreshold = us.compressionThreshold;
                this.timeout = us.timeout;
                this.encryptionType = us.encryptionType;
                this.hostType = us.hostType;
                this.isNLSEnabled = us.isNLSEnabled;
                this.isNLSLocalesEnabled = us.isNLSLocalesEnabled;
                this.isActive = us.isActive;
                this.isRPCError = us.isRPCError;
                this.isNLSUnidataSession = us.isNLSUnidataSession;
                this.uniNLSMap = us.uniNLSMap;
                this.uniNLSLocale = us.uniNLSLocale;
                this.sslMode = us.sslMode;
                this.uniTransaction = us.uniTransaction;
                this.uniCommand = us.uniCommand;
                this.atVariableArray = us.atVariableArray;
                this.blockingStrategy = us.blockingStrategy;
                this.lockStrategy = us.lockStrategy;
                this.releaseStrategy = us.releaseStrategy;
                this.uniReturnCode = us.uniReturnCode;
                this.numOpenFiles = us.numOpenFiles;
                this.uniStatus = us.uniStatus;
                this.uSSLD = us.uSSLD;
                this.pooledSession = us.pooledSession;
                this.creationTime = us.creationTime;
                this.freedTime = us.freedTime;
                us.connection = null;
                us.initDefaultValues();
                Object var2_2 = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Object aHost, Object aUser, Object aPass, Object aPath) throws UniSessionException {
        UniSession uniSession = this;
        synchronized (uniSession) {
            super.setHostName(aHost);
            super.setUserName(aUser);
            super.setPassword(aPass);
            super.setAccountPath(aPath);
            this.connect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Object aHost, int aPortNumber, Object aUser, Object aPass, Object aPath) throws UniSessionException {
        UniSession uniSession = this;
        synchronized (uniSession) {
            this.setHostPort(aPortNumber);
            this.connect(aHost, aUser, aPass, aPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Object aHost, Object aUser, Object aPass, Object aPath, Object aProxyHost, Object aProxyToken) throws UniSessionException {
        UniSession uniSession = this;
        synchronized (uniSession) {
            this.setProxyHost(aProxyHost);
            this.setProxyToken(aProxyToken);
            this.connect(aHost, aUser, aPass, aPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Object aHost, Object aUser, Object aPass, Object aPath, Object aProxyHost, int aProxyPort, Object aProxyToken) throws UniSessionException {
        UniSession uniSession = this;
        synchronized (uniSession) {
            this.setProxyPort(aProxyPort);
            this.connect(aHost, aUser, aPass, aPath, aProxyHost, aProxyToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Object aHost, int aHostPort, Object aUser, Object aPass, Object aPath, Object aProxyHost, Object aProxyToken) throws UniSessionException {
        UniSession uniSession = this;
        synchronized (uniSession) {
            this.setHostPort(aHostPort);
            this.connect(aHost, aUser, aPass, aPath, aProxyHost, aProxyToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws UniSessionException {
        UniSession uniSession = this;
        synchronized (uniSession) {
            UniJava.closeSessionInternal(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnectServer() throws UniSessionException {
        UniSession uniSession = this;
        synchronized (uniSession) {
            if (!this.isActive) {
                return;
            }
            try {
                try {
                    this.connection.close();
                }
                catch (UniRPCException e) {
                    this.setRPCError(true);
                    throw new UniSessionException(e.getErrorCode());
                }
            }
            finally {
                this.initDefaultValues();
                this.connection = null;
            }
        }
    }

    public UniDataSet dataSet() {
        return new UniDataSet(this);
    }

    public UniDynArray dynArray() {
        return new UniDynArray(this);
    }

    public UniDynArray dynArray(Object aString) {
        return new UniDynArray((UniConnection)this, aString);
    }

    public String getAtVariable(int aTokenVal) throws UniSessionException {
        return this.getValue(aTokenVal);
    }

    public int getDefaultBlockingStrategy() {
        return this.blockingStrategy;
    }

    public int getDefaultLockStrategy() {
        return this.lockStrategy;
    }

    public int getDefaultReleaseStrategy() {
        return this.releaseStrategy;
    }

    public int getMaxOpenFiles() {
        return 32;
    }

    public int getNumOpenFiles() {
        return this.numOpenFiles;
    }

    public UniSSLDescriptor getSSLDescriptor() {
        return this.uSSLD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniString iconv(Object aString, Object aConvCode) throws UniStringException {
        UniSession uniSession = this;
        synchronized (uniSession) {
            UniString tmpString = new UniString((UniConnection)this, aString);
            UniString retVal = tmpString.iconv(this, aConvCode);
            this.uniStatus = tmpString.status();
            return retVal;
        }
    }

    public boolean isnSecure() {
        return this.sslMode == 0;
    }

    public int getSSLMode() {
        return this.sslMode;
    }

    public UniNLSlocale nlsLocale() throws UniSessionException {
        this.checkEntryConditions();
        if (this.isNLSEnabled && !this.isNLSUnidataSession && this.uniNLSLocale == null) {
            this.uniNLSLocale = new UniNLSlocale(this);
        }
        return this.uniNLSLocale;
    }

    public UniNLSmap nlsMap() throws UniSessionException {
        this.checkEntryConditions();
        if (this.isNLSEnabled && !this.isNLSUnidataSession && this.uniNLSMap == null) {
            this.uniNLSMap = new UniNLSmap(this);
        }
        return this.uniNLSMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniString oconv(Object aString, Object aConvCode) throws UniStringException {
        UniSession uniSession = this;
        synchronized (uniSession) {
            UniString tmpString = new UniString((UniConnection)this, aString);
            UniString retVal = tmpString.oconv(this, aConvCode);
            this.uniStatus = tmpString.status();
            return retVal;
        }
    }

    public UniFile openFile(Object aFileName) throws UniSessionException {
        this.checkEntryConditions();
        try {
            return new UniFile(this, aFileName, 0);
        }
        catch (UniFileException e) {
            throw new UniSessionException(e.getErrorCode());
        }
    }

    public UniFile open(Object aFileName) throws UniSessionException {
        return this.openFile(aFileName);
    }

    public UniDictionary openDict(Object aFileName) throws UniSessionException {
        this.checkEntryConditions();
        try {
            return new UniDictionary(this, aFileName, 1);
        }
        catch (UniFileException e) {
            throw new UniSessionException(e.getErrorCode());
        }
    }

    public UniSequentialFile openSeq(Object aFileName, Object aRecordID, boolean aCreateFlag) throws UniSessionException {
        this.checkEntryConditions();
        try {
            return new UniSequentialFile(this, aFileName, aRecordID, aCreateFlag);
        }
        catch (UniSequentialFileException e) {
            throw new UniSessionException(e.getErrorCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseTaskLock(int aLockNum) throws UniSessionException {
        UniSession uniSession = this;
        synchronized (uniSession) {
            this.checkEntryConditions();
            if (aLockNum < 0 || aLockNum > 64) {
                throw new UniSessionException(30098);
            }
            try {
                this.outPacket.write(0, 59);
                this.outPacket.write(1, aLockNum);
                this.connection.call(this.outPacket, this.inPacket);
                this.uniReturnCode = this.inPacket.readInteger(0);
            }
            catch (UniRPCException e) {
                this.setRPCError(true);
                throw new UniSessionException(e.getErrorCode());
            }
        }
    }

    public UniSelectList selectList(int aSelectListNumber) throws UniSessionException {
        this.checkEntryConditions();
        try {
            return new UniSelectList(this, aSelectListNumber);
        }
        catch (UniSelectListException e) {
            throw new UniSessionException(e.getErrorCode());
        }
    }

    public void setAtVariable(int aTokenVal, Object aAtVariable) throws UniSessionException {
        if (aTokenVal == 7 || aTokenVal == 11) {
            this.setValue(aTokenVal, aAtVariable.toString());
        }
    }

    public void setCompressionThreshold(int aCompressionThresholdVal) throws UniSessionException {
        try {
            this.setCompressionThresholdInt(aCompressionThresholdVal);
        }
        catch (UniConnectionException e) {
            throw new UniSessionException(e.getErrorCode());
        }
    }

    public void setDefaultBlockingStrategy(int aBlockingStrategy) throws UniSessionException {
        if (aBlockingStrategy < 1 || aBlockingStrategy > 2) {
            throw new UniSessionException("UniSession.setDefaultBlockingStrategy() failed:  Strategy eitherWAIT_ON_LOCKED (1) or RETURN_ON_LOCKED(2)", 14022);
        }
        this.blockingStrategy = aBlockingStrategy;
    }

    public void setDefaultEncryptionType(int aEncryptionType) throws UniSessionException {
        try {
            this.setDefaultEncryptionTypeInt(aEncryptionType);
        }
        catch (UniConnectionException e) {
            throw new UniSessionException(e.getErrorCode());
        }
    }

    public void setDefaultLockStrategy(int aLockingStrategy) throws UniSessionException {
        if (aLockingStrategy < 0 || aLockingStrategy > 2) {
            throw new UniSessionException("UniSession.setDefaultLockStrategy() failed:  Strategy eitherNO_LOCKS (0), EXCLUSIVE_UPDATE (1) or SHARED_READ(2)", 14022);
        }
        this.lockStrategy = aLockingStrategy;
    }

    public void setDefaultReleaseStrategy(int aReleaseStrategy) throws UniSessionException {
        if (aReleaseStrategy < 0 || aReleaseStrategy > 8) {
            throw new UniSessionException("UniSession.setDefaultReleaseStrategy() failed:  Strategy eitherWRITE_RELEASE (1), READ_RELEASE (2), EXPLICIT_RELEASE (4) or CHANGE_RELEASE (8)", 14022);
        }
        this.releaseStrategy = aReleaseStrategy;
    }

    public void setSSLDescriptor(UniSSLDescriptor ussld) {
        this.uSSLD = ussld;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskLock(int aLockNum) throws UniSessionException {
        UniSession uniSession = this;
        synchronized (uniSession) {
            this.checkEntryConditions();
            if (aLockNum < 0 || aLockNum > 64) {
                throw new UniSessionException(30098);
            }
            try {
                this.outPacket.write(0, 31);
                this.outPacket.write(1, aLockNum);
                this.connection.call(this.outPacket, this.inPacket);
                this.uniReturnCode = this.inPacket.readInteger(0);
                if (this.uniReturnCode != 0) {
                    throw new UniSessionException(30002);
                }
            }
            catch (UniRPCException e) {
                this.setRPCError(true);
                throw new UniSessionException(e.getErrorCode());
            }
        }
    }

    public void setTimeout(int aTimeoutVal) throws UniSessionException {
        try {
            this.setTimeoutInt(aTimeoutVal);
        }
        catch (UniConnectionException e) {
            this.setRPCError(true);
            throw new UniSessionException(e.getErrorCode());
        }
    }

    protected void setMarks(String[] MarksArray) {
        this.uniMarkCharacters = MarksArray;
        UniTokens.AT_IM = this.uniMarkCharacters[0];
        UniTokens.AT_FM = this.uniMarkCharacters[1];
        UniTokens.AT_VM = this.uniMarkCharacters[2];
        UniTokens.AT_SVM = this.uniMarkCharacters[3];
        UniTokens.AT_TM = this.uniMarkCharacters[4];
        UniTokens.AT_SQLNULL = this.uniMarkCharacters[5];
        UniTokens.defaultMarkArray[0] = UniTokens.AT_IM;
        UniTokens.defaultMarkArray[1] = UniTokens.AT_FM;
        UniTokens.defaultMarkArray[2] = UniTokens.AT_VM;
        UniTokens.defaultMarkArray[3] = UniTokens.AT_SVM;
        UniTokens.defaultMarkArray[4] = UniTokens.AT_TM;
        UniTokens.defaultMarkArray[5] = UniTokens.AT_SQLNULL;
    }

    public int status() {
        return this.uniStatus;
    }

    public UniSubroutine subroutine(Object aSubName, int aNumArgs) throws UniSessionException {
        this.checkEntryConditions();
        try {
            return new UniSubroutine(this, aSubName, aNumArgs);
        }
        catch (UniSubroutineException e) {
            throw new UniSessionException(e.getErrorCode());
        }
    }

    public UniXML xml() throws UniSessionException {
        this.checkEntryConditions();
        try {
            return new UniXML(this);
        }
        catch (UniXMLException e) {
            throw new UniSessionException(e.getErrorCode());
        }
    }

    public UniTransaction transaction() throws UniSessionException {
        this.checkEntryConditions();
        if (this.uniTransaction == null) {
            try {
                this.uniTransaction = new UniTransaction(this);
            }
            catch (UniTransactionException e) {
                throw new UniSessionException(e.getErrorCode());
            }
        }
        return this.uniTransaction;
    }

    protected String getValue(int key) throws UniSessionException {
        UniSession uniSession = this;
        synchronized (uniSession) {
            try {
                this.outPacket.write(0, 25);
                this.outPacket.write(1, key);
                this.connection.call(this.outPacket, this.inPacket);
                int uniReturnCode = this.inPacket.readInteger(0);
                if (uniReturnCode == 0) {
                    return this.decode(this.inPacket.readBytes(1));
                }
                throw new UniSessionException(uniReturnCode);
            }
            catch (UniRPCException e) {
                this.setRPCError(true);
                throw new UniSessionException(e.getErrorCode());
            }
        }
    }

    protected boolean isCommandActive() {
        int status;
        return this.uniCommand != null && ((status = this.uniCommand.status()) == 1 || status == 2);
    }

    private void checkEntryConditions() throws UniSessionException {
        if (!this.isActive()) {
            throw new UniSessionException(39120);
        }
        if (this.isCommandActive()) {
            throw new UniSessionException(30114);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getHostInfo() throws UniRPCException {
        UniSession uniSession = this;
        synchronized (uniSession) {
            this.outPacket.write(0, 69);
            this.connection.call(this.outPacket, this.inPacket);
            int response = this.inPacket.readInteger(0);
            if (response == 0) {
                this.userName = this.decode(this.inPacket.readBytes(1));
                this.hostType = this.inPacket.readInteger(2);
            }
        }
    }

    private int getIPaddress() {
        try {
            return InetAddress.getLocalHost().hashCode();
        }
        catch (UnknownHostException unknownHostException) {
            return 0;
        }
    }

    private String getMacAddress() {
        return "JAVA";
    }

    private String getDeviceName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "unknown host";
        }
    }

    private void nlsInit() {
        block15: {
            this.isNLSEnabled = false;
            this.isNLSLocalesEnabled = false;
            this.isNLSUnidataSession = false;
            if (this.getServerVersion() == 1) {
                return;
            }
            try {
                this.outPacket.write(0, 75);
                this.connection.call(this.outPacket, this.inPacket);
                this.uniReturnCode = this.inPacket.readInteger(0);
                int nlsMode = this.inPacket.readInteger(1);
                int nlsLCmode = this.inPacket.readInteger(2);
                if (nlsMode == 1) {
                    this.isNLSEnabled = true;
                    if (nlsLCmode == 1) {
                        this.isNLSLocalesEnabled = true;
                    }
                    this.uniDataSourceType = "UNIVERSE";
                }
                if (nlsMode == 2) {
                    this.isNLSUnidataSession = true;
                    this.uniDataSourceType = "UNIDATA";
                }
                if (!this.isNLSEnabled && !this.isNLSUnidataSession) break block15;
                byte[] byteArray = new byte[1];
                ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArray);
                InputStreamReader reader = new InputStreamReader(inputStream);
                String nlsmapname = reader.getEncoding();
                try {
                    reader.close();
                    ((InputStream)inputStream).close();
                }
                catch (Exception exception) {}
                if (nlsmapname.equals("")) break block15;
                this.uniNLSMap = new UniNLSmap(this);
                try {
                    this.uniNLSMap.setName(nlsmapname);
                }
                catch (UniNLSException uniNLSException) {
                    this.uniNLSMap.setName("DEFAULT");
                }
                if (this.isNLSLocalesEnabled) {
                    this.uniNLSLocale = new UniNLSlocale(this);
                    try {
                        Locale lc = Locale.getDefault();
                        this.uniNLSLocale.setName(lc);
                    }
                    catch (UniNLSException uniNLSException) {
                        this.uniNLSLocale.setName("DEFAULT");
                    }
                }
            }
            catch (UniRPCException uniRPCException) {
                this.isNLSEnabled = false;
                this.isNLSLocalesEnabled = false;
                this.isNLSUnidataSession = false;
                this.setRPCError(true);
            }
            catch (UniNLSException uniNLSException) {
                this.isNLSEnabled = false;
                this.isNLSLocalesEnabled = false;
                this.isNLSUnidataSession = false;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setValue(int key, String aNewVal) throws UniSessionException {
        UniSession uniSession = this;
        synchronized (uniSession) {
            try {
                this.outPacket.write(0, 50);
                this.outPacket.write(1, key);
                this.outPacket.write(2, this.encode(aNewVal));
                this.connection.call(this.outPacket, this.inPacket);
                this.inPacket.readInteger(0);
            }
            catch (UniRPCException e) {
                this.setRPCError(true);
                throw new UniSessionException(e.getErrorCode());
            }
        }
    }

    protected Object clonePooled() throws UniSessionException {
        UniSession us = null;
        us = (UniSession)this.clone();
        us.uniCommand = null;
        us.uniTransaction = null;
        us.uniStatus = 0;
        return us;
    }

    protected boolean IsCPSupported(String ServerId) {
        return ServerId.startsWith("udapi") || ServerId.startsWith("uvapi");
    }

    protected synchronized Date getCreationTime() {
        return this.creationTime;
    }

    protected synchronized void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    protected synchronized boolean getPooledSession() {
        return this.pooledSession;
    }

    protected synchronized void setPooledSession(boolean pooledSession) {
        this.pooledSession = pooledSession;
    }

    protected synchronized Date getFreedTime() {
        return this.freedTime;
    }

    protected synchronized void setFreedTime(Date freedTime) {
        this.freedTime = freedTime;
    }

    protected void initDefaultValues() {
        this.setRPCError(false);
        this.isNLSUnidataSession = false;
        this.uniMarkCharacters = UniTokens.defaultMarkArray;
        this.isActive = false;
        this.isRPCError = false;
        this.isNLSEnabled = false;
        this.uniCommand = null;
        this.uniTransaction = null;
        this.uniNLSLocale = null;
        this.uniNLSMap = null;
        this.uSSLD = null;
        this.blockingStrategy = 2;
        this.lockStrategy = 0;
        this.releaseStrategy = 12;
        this.uniReturnCode = 0;
        this.numOpenFiles = 0;
        this.uniStatus = 0;
        this.sslMode = 0;
        this.pooledSession = false;
    }

    public String getSessionEncoding() {
        return super.getEncoding();
    }

    public void setSessionEncoding(String encoding) throws UniSessionException {
        try {
            super.setEncoding(encoding);
        }
        catch (UniConnectionException uniConnectionException) {
            throw new UniSessionException(82006);
        }
    }

    public boolean isIgnoreDeviceLicense() {
        return this.isIgnoreDeviceLicense;
    }

    public void setIgnoreDeviceLicense(boolean isIgnoreDeviceLicense) {
        this.isIgnoreDeviceLicense = isIgnoreDeviceLicense;
    }

    public String getAltDeviceName() {
        if (this.altDeviceName == null) {
            this.altDeviceName = this.getDeviceName();
        }
        return this.altDeviceName;
    }

    public void setAltDeviceName(String altDeviceName) {
        this.altDeviceName = altDeviceName;
    }

    public String getLastServerError() throws UniSessionException {
        if (!this.isActive) {
            return this.lastServerError;
        }
        UniSession uniSession = this;
        synchronized (uniSession) {
            try {
                this.outPacket.write(0, 85);
                this.connection.call(this.outPacket, this.inPacket);
                int uniReturnCode = this.inPacket.readInteger(0);
                if (uniReturnCode == 0) {
                    return new UniString((UniConnection)this, this.inPacket.readBytes(1)).toString();
                }
                throw new UniSessionException(uniReturnCode);
            }
            catch (UniRPCException e) {
                this.setRPCError(true);
                throw new UniSessionException(e.getErrorCode());
            }
        }
    }
}

