/*
 * Decompiled with CFR 0.152.
 */
package asjava.uniobjects;

import asjava.uniclientlibs.UniConnection;
import asjava.uniclientlibs.UniString;
import asjava.uniobjects.UniBase;
import asjava.uniobjects.UniSequentialFileException;
import asjava.uniobjects.UniSession;
import asjava.unirpc.UniRPCException;
import asjava.unirpc.UniRPCPacket;

public class UniSequentialFile
extends UniBase {
    protected int uniFileHandle;
    private String uniSeqFileName;
    private String uniRecordName;
    private UniString uniReturnString;
    private int uniReturnCode;
    private int uniCreateFlag;
    private int uniBlockSize;
    private int uniTimeout;
    private boolean isFileOpen;

    UniSequentialFile() throws UniSequentialFileException {
        throw new UniSequentialFileException(88889);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UniSequentialFile(UniSession aSession, Object aFileName, Object aRecordID, boolean aCreateFlag) throws UniSequentialFileException {
        UniSequentialFile uniSequentialFile = this;
        synchronized (uniSequentialFile) {
            if (aSession == null) {
                throw new UniSequentialFileException(39120);
            }
            this.uniParentSession = aSession;
            this.uniConnection = aSession.connection;
            this.uniSeqFileName = aFileName.toString();
            this.uniRecordName = aRecordID.toString();
            this.uniEncryptionType = this.uniParentSession.getDefaultEncryptionType();
            this.isFileOpen = false;
            this.uniTimeout = 0;
            this.uniBlockSize = 0;
            this.uniFileHandle = 0;
            this.uniCreateFlag = aCreateFlag ? 1 : 0;
            this.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws UniSequentialFileException {
        UniSequentialFile uniSequentialFile = this;
        synchronized (uniSequentialFile) {
            this.checkEntryConditions(true);
            try {
                this.outPacket.write(0, 6);
                this.outPacket.write(1, this.uniFileHandle);
                this.uniConnection.call(this.outPacket, this.inPacket);
                this.uniReturnCode = this.inPacket.readInteger(0);
                if (this.uniReturnCode != 0) {
                    throw new UniSequentialFileException(this.uniReturnCode);
                }
                this.isFileOpen = false;
                this.uniParentSession = null;
                this.uniConnection = null;
                this.inPacket = null;
                this.outPacket = null;
                this.uniFileHandle = 0;
            }
            catch (UniRPCException e) {
                this.uniParentSession.setRPCError(true);
                throw new UniSequentialFileException(e.getErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileSeek(int aRelPos, int aOffset) throws UniSequentialFileException {
        UniSequentialFile uniSequentialFile = this;
        synchronized (uniSequentialFile) {
            if (aRelPos < 0 || aRelPos > 2) {
                throw new UniSequentialFileException(14022);
            }
            this.checkEntryConditions(false);
            try {
                this.outPacket.write(0, 47);
                this.outPacket.write(1, this.uniFileHandle);
                this.outPacket.write(2, aOffset);
                this.outPacket.write(3, aRelPos);
                this.uniConnection.call(this.outPacket, this.inPacket);
                this.uniReturnCode = this.inPacket.readInteger(0);
                this.uniStatus = 0;
                if (this.uniReturnCode != 0) {
                    throw new UniSequentialFileException(this.uniReturnCode);
                }
            }
            catch (UniRPCException e) {
                this.uniParentSession.setRPCError(true);
                throw new UniSequentialFileException(e.getErrorCode());
            }
        }
    }

    public int getReadSize() {
        return this.uniBlockSize;
    }

    public int getTimeout() {
        return this.uniTimeout;
    }

    public boolean isOpen() {
        return this.isFileOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws UniSequentialFileException {
        UniSequentialFile uniSequentialFile = this;
        synchronized (uniSequentialFile) {
            this.checkEntryConditions(false);
            try {
                this.inPacket = new UniRPCPacket(this.uniConnection);
                this.outPacket = new UniRPCPacket(this.uniConnection);
                this.outPacket.write(0, 35);
                this.outPacket.write(1, this.encode(this.uniSeqFileName));
                this.outPacket.write(2, this.encode(this.uniRecordName));
                this.outPacket.write(3, this.uniCreateFlag);
                this.uniConnection.call(this.outPacket, this.inPacket, (byte)this.uniEncryptionType);
                this.uniReturnCode = this.inPacket.readInteger(0);
                if (this.uniReturnCode != 0) {
                    throw new UniSequentialFileException(this.uniReturnCode);
                }
                this.uniStatus = this.inPacket.readInteger(1);
                this.uniFileHandle = this.inPacket.readInteger(2);
                this.isFileOpen = true;
            }
            catch (UniRPCException e) {
                this.uniParentSession.setRPCError(true);
                throw new UniSequentialFileException(e.getErrorCode());
            }
        }
    }

    public UniString readBlk() throws UniSequentialFileException {
        UniSequentialFile uniSequentialFile = this;
        synchronized (uniSequentialFile) {
            this.checkEntryConditions(true);
            try {
                this.outPacket.write(0, 38);
                this.outPacket.write(1, this.uniFileHandle);
                this.outPacket.write(2, this.uniBlockSize != 0 ? this.uniBlockSize : 8192);
                UniString tmpString = new UniString(this.uniParentSession);
                this.uniReturnString = null;
                while (this.uniStatus == 0) {
                    this.uniConnection.call(this.outPacket, this.inPacket, (byte)this.uniEncryptionType);
                    this.uniReturnCode = this.inPacket.readInteger(0);
                    if (this.uniReturnCode == 0) {
                        this.uniStatus = this.inPacket.readInteger(1);
                        if (this.uniBlockSize != 0) {
                            this.uniReturnString = new UniString((UniConnection)this.uniParentSession, this.inPacket.readBytes(2));
                            this.setReadSize(this.uniReturnString.length());
                            return this.uniReturnString;
                        }
                        tmpString.append(this.inPacket.readBytes(2));
                        continue;
                    }
                    this.setReadSize(0);
                    throw new UniSequentialFileException(this.uniReturnCode);
                }
                this.uniReturnString = tmpString;
                this.setReadSize(this.uniReturnString.length());
                return this.uniReturnString;
            }
            catch (UniRPCException e) {
                this.uniParentSession.setRPCError(true);
                throw new UniSequentialFileException(e.getErrorCode());
            }
        }
    }

    public UniString readLine() throws UniSequentialFileException {
        UniSequentialFile uniSequentialFile = this;
        synchronized (uniSequentialFile) {
            this.checkEntryConditions(true);
            try {
                this.outPacket.write(0, 41);
                this.outPacket.write(1, this.uniFileHandle);
                this.uniConnection.call(this.outPacket, this.inPacket, (byte)this.uniEncryptionType);
                this.uniReturnCode = this.inPacket.readInteger(0);
                if (this.uniReturnCode == 0) {
                    this.uniStatus = this.inPacket.readInteger(1);
                    this.uniReturnString = new UniString((UniConnection)this.uniParentSession, this.inPacket.readBytes(2));
                    return this.uniReturnString;
                }
                this.uniStatus = 0;
                throw new UniSequentialFileException(this.uniReturnCode);
            }
            catch (UniRPCException e) {
                this.uniParentSession.setRPCError(true);
                throw new UniSequentialFileException(e.getErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadSize(int aBlockSize) {
        UniSequentialFile uniSequentialFile = this;
        synchronized (uniSequentialFile) {
            if (aBlockSize < 0) {
                aBlockSize = 0;
            }
            this.uniBlockSize = aBlockSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeout(int aTimeOut) throws UniSequentialFileException {
        UniSequentialFile uniSequentialFile = this;
        synchronized (uniSequentialFile) {
            this.checkEntryConditions(true);
            if (aTimeOut < 0) {
                aTimeOut = 0;
            }
            this.uniTimeout = aTimeOut;
            try {
                this.outPacket.write(0, 55);
                this.outPacket.write(1, this.uniFileHandle);
                this.outPacket.write(2, this.uniTimeout);
                this.uniConnection.call(this.outPacket, this.inPacket);
                this.uniReturnCode = this.inPacket.readInteger(0);
                if (this.uniReturnCode != 0) {
                    throw new UniSequentialFileException(this.uniReturnCode);
                }
            }
            catch (UniRPCException e) {
                this.uniParentSession.setRPCError(true);
                throw new UniSequentialFileException(e.getErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBlk(Object aString) throws UniSequentialFileException {
        UniSequentialFile uniSequentialFile = this;
        synchronized (uniSequentialFile) {
            this.checkEntryConditions(true);
            try {
                this.outPacket.write(0, 62);
                this.outPacket.write(1, this.uniFileHandle);
                if (UniString.class.isInstance(aString)) {
                    this.outPacket.write(2, ((UniString)aString).getBytes());
                } else {
                    this.outPacket.write(2, this.encode(aString.toString()));
                }
                this.uniConnection.call(this.outPacket, this.inPacket, (byte)this.uniEncryptionType);
                this.uniReturnCode = this.inPacket.readInteger(0);
                if (this.uniReturnCode != 0) {
                    this.uniStatus = 0;
                    throw new UniSequentialFileException(this.uniReturnCode);
                }
                this.uniStatus = this.inPacket.readInteger(1);
            }
            catch (UniRPCException e) {
                this.uniParentSession.setRPCError(true);
                throw new UniSequentialFileException(e.getErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeEOF() throws UniSequentialFileException {
        UniSequentialFile uniSequentialFile = this;
        synchronized (uniSequentialFile) {
            this.checkEntryConditions(true);
            try {
                this.outPacket.write(0, 60);
                this.outPacket.write(1, this.uniFileHandle);
                this.uniConnection.call(this.outPacket, this.inPacket, (byte)this.uniEncryptionType);
                this.uniReturnCode = this.inPacket.readInteger(0);
                if (this.uniReturnCode != 0) {
                    throw new UniSequentialFileException(this.uniReturnCode);
                }
            }
            catch (UniRPCException e) {
                this.uniParentSession.setRPCError(true);
                throw new UniSequentialFileException(e.getErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLine(Object aString) throws UniSequentialFileException {
        UniSequentialFile uniSequentialFile = this;
        synchronized (uniSequentialFile) {
            this.checkEntryConditions(true);
            try {
                this.outPacket.write(0, 64);
                this.outPacket.write(1, this.uniFileHandle);
                if (UniString.class.isInstance(aString)) {
                    this.outPacket.write(2, ((UniString)aString).getBytes());
                } else {
                    this.outPacket.write(2, this.encode(aString.toString()));
                }
                this.uniConnection.call(this.outPacket, this.inPacket, (byte)this.uniEncryptionType);
                this.uniReturnCode = this.inPacket.readInteger(0);
                if (this.uniReturnCode != 0) {
                    this.uniStatus = 0;
                    throw new UniSequentialFileException(this.uniReturnCode);
                }
                this.uniStatus = this.inPacket.readInteger(1);
            }
            catch (UniRPCException e) {
                this.uniParentSession.setRPCError(true);
                throw new UniSequentialFileException(e.getErrorCode());
            }
        }
    }

    private void checkEntryConditions(boolean shouldThrow) throws UniSequentialFileException {
        if (!this.isOpen() && shouldThrow) {
            String tmpFileName = String.valueOf(this.uniSeqFileName) + ":" + this.uniRecordName;
            this.uniStatus = -1;
            throw new UniSequentialFileException(45000, tmpFileName);
        }
        if (this.isCommandActive()) {
            throw new UniSequentialFileException(30114);
        }
        this.uniStatus = 0;
    }
}

