/*
 * Decompiled with CFR 0.152.
 */
package asjava.uniobjects;

import asjava.uniobjects.UniBase;
import asjava.uniobjects.UniJava;
import asjava.uniobjects.UniSession;
import asjava.uniobjects.UniSessionException;
import asjava.uniobjects.UniTransactionException;
import asjava.unirpc.UniRPCConnection;
import asjava.unirpc.UniRPCConnectionException;
import java.util.Date;
import java.util.Vector;

public final class UniPool
extends UniBase {
    private String service = "";
    private String userid = "";
    private String password = "";
    private String server = "";
    private String account = "";
    private int sslmode = 0;
    private int hostport = 31438;
    private int minPoolSize = 0;
    private int maxPoolSize = 0;
    private Vector availableConnections = null;
    private Vector busyConnections = null;
    private int retryNewInTimes = 0;
    private final int defaultRetryNewInTimes = 10;
    private int nextRetryNewInTimes = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected UniPool(String phostname, int phostport, String puserid, String ppassword, String paccount, String pservice, int psslmode, int pmin_poolsize, int pmax_poolsize) throws UniSessionException {
        super();
        var10_10 = this;
        synchronized (var10_10) {
            block10: {
                this.userid = puserid;
                this.password = ppassword;
                this.server = phostname;
                this.account = paccount;
                this.service = pservice;
                this.sslmode = psslmode;
                this.hostport = phostport;
                this.minPoolSize = pmin_poolsize;
                this.maxPoolSize = pmax_poolsize;
                UniJava.uniLog("calling UniPool::UniPool() with  hostname : " + this.server + " hostport : " + this.hostport + " userid : " + this.userid + " password : " + "********" + " account : " + this.account + " service : " + this.service + " sslmode : " + this.sslmode + " min_poolsize : " + this.minPoolSize + " max_poolsize : " + this.maxPoolSize + " IdleRemoveThreshold:" + UniJava.getIdleRemoveThreshold() + " IdleRemoveExecInterval:" + UniJava.getIdleRemoveExecInterval());
                if (this.availableConnections == null && this.busyConnections == null) {
                    if (this.minPoolSize > this.maxPoolSize) {
                        this.minPoolSize = this.maxPoolSize;
                    }
                    this.availableConnections = new Vector<E>(this.minPoolSize);
                    this.busyConnections = new Vector<E>();
                    lIndex = 0;
                    try {
                        lIndex = 0;
                        while (lIndex < this.minPoolSize) {
                            this.availableConnections.add(this.makeNewConnection(this.sslmode));
                            ++lIndex;
                        }
                        break block10;
                    }
                    catch (UniSessionException e) {
                        i = 0;
                        ** while (i < this.availableConnections.size())
                    }
lbl-1000:
                    // 1 sources

                    {
                        us = (UniSession)this.availableConnections.elementAt(i);
                        us.disconnectServer();
                        UniJava.uniLog("In UniPool()::UniPool()us.disconnectServer is called due to exception");
                        ++i;
                        continue;
                    }
lbl51:
                    // 1 sources

                    if (lIndex > 0 && lIndex < this.minPoolSize) {
                        UniJava.uniLog("In UniPool()::UniPool()may be m_MinPoolSize > license limit");
                        throw new UniSessionException(82004);
                    }
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UniSession findSession(long sessionTimeout, int sslmode) throws UniSessionException {
        UniPool uniPool = this;
        synchronized (uniPool) {
            UniJava.uniLog("Enter UniPool::findSession()");
            int sizeAvailableConnections = this.availableConnections.size();
            int sizeBusyConnections = this.busyConnections.size();
            UniJava.uniLog("In UniPool::findSession() sizeAvailableConnections:" + sizeAvailableConnections + " sizeBusyConnections:" + sizeBusyConnections);
            if (sizeAvailableConnections != 0) {
                int LastIndex = sizeAvailableConnections - 1;
                UniSession us = (UniSession)this.availableConnections.elementAt(LastIndex);
                this.availableConnections.removeElementAt(LastIndex);
                if (us.connection.isServerAlive()) {
                    this.busyConnections.add(us.connection);
                    UniJava.uniLog("In UniPool::findSession() Found Session as sizeAvailableConnections != 0 and session is alive");
                    return us;
                }
                UniJava.uniLog("In UniPool::findSession() Could not found Session. May be  Session is NOT alive");
                this.closeServerConnection(us);
                this.notifyAll();
                return this.findSession(sessionTimeout, sslmode);
            }
            if (this.totalConnections() < this.maxPoolSize) {
                if (this.retryNewInTimes == 0) {
                    try {
                        UniSession us = this.makeNewConnection(sslmode);
                        this.busyConnections.add(us.connection);
                        this.nextRetryNewInTimes = 10;
                        UniJava.uniLog("In UniPool::findSession() Created new Session as totalConnections() < maxPoolSize");
                        return us;
                    }
                    catch (UniSessionException uniSessionException) {
                        this.retryNewInTimes = this.nextRetryNewInTimes;
                        this.nextRetryNewInTimes *= 2;
                    }
                } else {
                    --this.retryNewInTimes;
                }
            }
            long lDiffTime = 0L;
            try {
                long lStartTime = new Date().getTime();
                UniJava.uniLog("In UniPool::findSession() - we are in wait");
                this.wait(sessionTimeout);
                long lEndTime = new Date().getTime();
                lDiffTime = lEndTime - lStartTime;
                UniJava.uniLog("In UniPool::findSession() sessionTimeout:" + sessionTimeout + " lStartTime:" + lStartTime + " lEndTime:" + lEndTime);
                if (lDiffTime >= sessionTimeout) {
                    throw new UniSessionException(82001);
                }
            }
            catch (InterruptedException interruptedException) {
                throw new UniSessionException(82001);
            }
            UniJava.uniLog("In UniPool::findSession() - we got notify");
            return this.findSession(sessionTimeout - lDiffTime, sslmode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void free(UniSession us) throws UniSessionException {
        UniPool uniPool = this;
        synchronized (uniPool) {
            int status;
            UniJava.uniLog("Enter UniPool::free()");
            if (this.availableConnections.contains(us)) {
                return;
            }
            if (!us.isActive()) {
                return;
            }
            if (us.isActive() && us.getRPCError()) {
                this.closeServerConnection(us);
                return;
            }
            if (us.uniCommand != null && ((status = us.uniCommand.status()) == 1 || status == 2)) {
                throw new UniSessionException(30114);
            }
            if (us.uniTransaction != null) {
                status = 0;
                try {
                    status = us.uniTransaction.isActive() ? 1 : 0;
                }
                catch (UniTransactionException uniTransactionException) {
                    throw new UniSessionException(30114);
                }
                if (status != 0) {
                    throw new UniSessionException(30114);
                }
            }
            this.busyConnections.remove(us.connection);
            us.setFreedTime(new Date());
            UniSession lNewus = (UniSession)us.clonePooled();
            us.initDefaultValues();
            us.connection = null;
            this.availableConnections.add(lNewus);
            this.notifyAll();
            UniJava.uniLog("Exit UniPool::free()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeIdleConnections() throws UniSessionException {
        UniPool uniPool = this;
        synchronized (uniPool) {
            UniJava.uniLog("Enter UniPool::closeIdleConnections()");
            int i = 0;
            while (i < this.availableConnections.size()) {
                UniSession us = (UniSession)this.availableConnections.elementAt(i);
                if (us == null) {
                    UniJava.uniLog("In UniPool::closeIdleConnections():Session (us) is null");
                    return;
                }
                UniJava.uniLog("in UniPool::closeIdleConnections()size is:" + this.availableConnections.size() + "this index is:" + i);
                int p1 = UniJava.getIdleRemoveThreshold();
                UniJava.uniLog("in UniPool::closeIdleConnections()UniJava.getIdleRemoveThreshold() is:" + p1);
                long p2 = us.getFreedTime().getTime();
                UniJava.uniLog("in UniPool::closeIdleConnections()us.getFreedTime().getTime() is:" + p2);
                long freedtime = p2 + (long)p1;
                long curtime = new Date().getTime();
                UniJava.uniLog("in UniPool::closeIdleConnections()curdtime is:" + curtime);
                long diff = curtime - freedtime;
                if (diff >= 0L && this.availableConnections.size() > this.minPoolSize) {
                    UniJava.uniLog("in UniPool::closeIdleConnections() diff is:" + diff);
                    UniJava.uniLog("in UniPool::closeIdleConnections() availableConnections.size() is:" + this.availableConnections.size() + " and minPoolSize is: " + this.minPoolSize);
                    us.disconnectServer();
                    this.availableConnections.remove(us);
                    UniJava.uniLog("in UniPool::closeIdleConnections() closing session physically");
                    --i;
                } else {
                    UniJava.uniLog("in UniPool::closeIdleConnections() diff is:" + diff);
                    UniJava.uniLog("in UniPool::closeIdleConnections() availableConnections.size() is:" + this.availableConnections.size());
                    UniJava.uniLog("in UniPool::closeIdleConnections() minPoolSize is: " + this.minPoolSize);
                    if (diff < 0L) {
                        UniJava.uniLog("in UniPool::closeIdleConnections() can not close session physically as diff < 0");
                    }
                    if (this.availableConnections.size() <= this.minPoolSize) {
                        UniJava.uniLog("in UniPool::closeIdleConnections() can not close session physically as availableConnections.size() <=minPoolSize");
                    }
                }
                ++i;
            }
            UniJava.uniLog("Exit UniPool::closeIdleConnections()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeServerConnection(UniSession us) throws UniSessionException {
        UniPool uniPool = this;
        synchronized (uniPool) {
            int sslmode = us.getSSLMode();
            this.busyConnections.remove(us.connection);
            try {
                us.disconnectServer();
            }
            catch (Exception e) {
                UniJava.uniLog("In UniPool::closeServerConnection:" + e.getMessage());
            }
            UniJava.uniLog("In UniPool::closeServerConnection");
            this.adjustMinPoolSizeConnections(sslmode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAllConnections() throws UniSessionException, UniRPCConnectionException {
        UniPool uniPool = this;
        synchronized (uniPool) {
            UniJava.uniLog("Enter UniPool::closeAllConnections");
            this.closeConnections(this.availableConnections);
            this.availableConnections.clear();
            this.closeBusyConnections(this.busyConnections);
            this.busyConnections.clear();
            UniJava.uniLog("Exit UniPool::closeAllConnections");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void adjustMinPoolSizeConnections(int sslmode) throws UniSessionException {
        UniPool uniPool = this;
        synchronized (uniPool) {
            UniJava.uniLog("Enter UniPool::adjustMinPoolSizeConnections");
            if (this.totalConnections() < this.minPoolSize) {
                UniSession us = null;
                us = this.makeNewConnection(sslmode);
                this.availableConnections.add(us);
            }
            UniJava.uniLog("Exit UniPool::adjustMinPoolSizeConnections");
        }
    }

    private void closeConnections(Vector pUniSessions) throws UniSessionException {
        UniJava.uniLog("Enter UniPool::closeConnections");
        if (pUniSessions == null) {
            UniJava.uniLog("Exit UniPool::closeConnections because pUniSessions is null");
            return;
        }
        int i = 0;
        while (i < pUniSessions.size()) {
            UniSession us = (UniSession)pUniSessions.elementAt(i);
            if (us.isActive()) {
                us.disconnectServer();
                UniJava.uniLog("In UniPool::closeConnections() and us.disconnectServer");
            }
            ++i;
        }
        UniJava.uniLog("Exit UniPool::closeConnections");
    }

    private void closeBusyConnections(Vector pRPCConnections) throws UniRPCConnectionException {
        UniJava.uniLog("Enter UniPool::closeBusyConnections");
        if (pRPCConnections == null) {
            UniJava.uniLog("Exit UniPool::closeBusyConnections because pRPCConnections is null");
            return;
        }
        int i = 0;
        while (i < pRPCConnections.size()) {
            UniRPCConnection uc = (UniRPCConnection)pRPCConnections.elementAt(i);
            uc.close();
            UniJava.uniLog("In UniPool::closeBusyConnections()");
            ++i;
        }
        UniJava.uniLog("Exit UniPool::closeBusyConnections");
    }

    private UniSession makeNewConnection(int sslmode) throws UniSessionException {
        UniPool uniPool = this;
        synchronized (uniPool) {
            try {
                UniSession us = null;
                us = sslmode == 0 ? new UniSession() : new UniSession(sslmode);
                us.setHostPort(this.hostport);
                us.setConnectionString(this.service);
                us.setHostName(this.server);
                us.setUserName(this.userid);
                us.setPassword(this.password);
                us.setAccountPath(this.account);
                us.connectInternal();
                us.setPooledSession(true);
                us.setCreationTime(new Date());
                UniJava.uniLog("In UniPool::makeNewConnection");
                return us;
            }
            catch (UniSessionException e) {
                throw new UniSessionException(e.getErrorCode(), e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int totalConnections() {
        UniPool uniPool = this;
        synchronized (uniPool) {
            int val = this.availableConnections.size() + this.busyConnections.size();
            UniJava.uniLog("In UniPool::totalConnections and total connection is " + val);
            return val;
        }
    }

    protected String getAccount() {
        return this.account;
    }

    protected int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    protected int getMinPoolSize() {
        return this.minPoolSize;
    }

    protected String getPassword() {
        return this.password;
    }

    protected String getServer() {
        return this.server;
    }

    protected String getUserid() {
        return this.userid;
    }
}

