/*
 * Decompiled with CFR 0.152.
 */
package asjava.uniobjects;

import asjava.uniobjects.UniPool;
import asjava.uniobjects.UniProperties;
import asjava.uniobjects.UniSession;
import asjava.uniobjects.UniSessionException;
import asjava.unirpc.UniRPCConnectionException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class UniJava {
    private static final int MAX_OPEN_SESSIONS = 0;
    private static final String UVJAVA_VERSION_NUM = "4.110.1";
    private final int uniMaxSessions = 0;
    private final String uniJavaVersionNumber = "4.110.1";
    private static int uniJavaIsActive = 0;
    private static int uniNumSessions = 0;
    private static Vector uniSessionsVector = new Vector();
    private static boolean uoPooling = false;
    private static int socketTimeout = 300;
    private static Hashtable poolList = null;
    private static Hashtable poolListMinSize = null;
    private static Hashtable poolListMaxSize = null;
    private static Hashtable poolListThreshold = null;
    private static Hashtable poolListInterval = null;
    private static int minPoolSize = 0;
    private static int maxPoolSize = 10;
    private static Thread pollingThread = null;
    private static int poolingOpenSessionTimeout = 30000;
    private static int idleRemoveThreshold = 300000;
    private static int idleRemoveExecInterval = 300000;
    private static Timer timer = null;
    private static PrintWriter uniPW;
    private static boolean uniPoolingDebug;
    private static UniProperties uojProperties;

    static {
        uniPoolingDebug = false;
        uojProperties = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniJava() {
        Class<UniJava> clazz = UniJava.class;
        synchronized (UniJava.class) {
            if (uniJavaIsActive > 0) {
                ++uniJavaIsActive;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            uniJavaIsActive = 1;
            uniSessionsVector = new Vector();
            uniNumSessions = 0;
            uojProperties = new UniProperties();
            UniJava.readUOJProperties();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static synchronized void setPoolingDebug(boolean debug) {
        if (!UniJava.getUOPooling()) {
            return;
        }
        uniPoolingDebug = debug;
        if (!debug) {
            if (uniPW != null) {
                uniPW.close();
            }
            uniPW = null;
            return;
        }
        if (debug && uniPW == null) {
            try {
                uniPW = new PrintWriter(new FileWriter("uoj_trace.log"));
            }
            catch (IOException iOException) {}
        }
    }

    public static void uniLog(String message) {
        if (uniPoolingDebug && uniPW != null) {
            uniPW.println(new Date() + ":" + Thread.currentThread().toString() + " " + message);
            uniPW.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllSessions() throws UniRPCConnectionException, UniSessionException {
        Class<UniJava> clazz = UniJava.class;
        synchronized (UniJava.class) {
            if (uoPooling) {
                Enumeration lEnumerator = poolList.elements();
                while (lEnumerator.hasMoreElements()) {
                    UniPool lPool = (UniPool)lEnumerator.nextElement();
                    lPool.closeAllConnections();
                }
                poolList.clear();
                poolListMinSize.clear();
                poolListMaxSize.clear();
                poolListThreshold.clear();
                poolListInterval.clear();
                UniJava.uniLog("In UniJava::closeAllSessions()");
                if (timer != null) {
                    timer.cancel();
                }
                uniPW = null;
            }
            Enumeration e = uniSessionsVector.elements();
            while (e.hasMoreElements()) {
                UniSession unis = (UniSession)e.nextElement();
                unis.disconnectServer();
                UniJava.uniLog("calling UniJava::closeAllSessions() and us.disconnectServer and pooling is off");
            }
            uniSessionsVector.removeAllElements();
            uniNumSessions = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static synchronized void closeAllCPSessions() throws UniRPCConnectionException, UniSessionException {
        if (uoPooling) {
            Enumeration lEnumerator = poolList.elements();
            while (lEnumerator.hasMoreElements()) {
                UniPool lPool = (UniPool)lEnumerator.nextElement();
                lPool.closeAllConnections();
            }
            poolList.clear();
            poolListMinSize.clear();
            poolListMaxSize.clear();
            poolListThreshold.clear();
            poolListInterval.clear();
            UniJava.uniLog("In UniJava::closeAllCPSessions()");
            if (timer != null) {
                timer.cancel();
            }
            uniPW = null;
        }
    }

    public void closeSession(UniSession aSession) throws UniSessionException {
        UniJava.closeSessionInternal(aSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void closeSessionInternal(UniSession aSession) throws UniSessionException {
        UniPool lPool = null;
        if (aSession == null) {
            return;
        }
        if (!aSession.isActive()) {
            return;
        }
        if (!aSession.getPooledSession()) {
            aSession.disconnectServer();
            UniJava.uniLog("In  UniJava::closeSessionInternal UniJava::closeSession() and us.disconnectServer and getpooledSession is false");
            Class<UniJava> clazz = UniJava.class;
            synchronized (UniJava.class) {
                uniSessionsVector.removeElement(aSession);
                if (--uniNumSessions < 0) {
                    uniNumSessions = 0;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
        Class<UniJava> clazz = UniJava.class;
        synchronized (UniJava.class) {
            UniJava.uniLog("In  UniJava::closeSessionInternal UniJava::closeSession() and UniPool.free()");
            String lKey = String.valueOf(aSession.getHostName()) + aSession.getUserName() + aSession.getPassword() + aSession.getAccountPath();
            lPool = (UniPool)poolList.get(lKey);
            if (lPool == null) {
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var2_3] (shouldn't be in output)
            lPool.free(aSession);
            return;
        }
    }

    public int getMaxSessions() {
        return 0;
    }

    public int getNumSessions() {
        return uniNumSessions;
    }

    public String getVersionNumber() {
        return UVJAVA_VERSION_NUM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniSession openSession() throws UniSessionException {
        Class<UniJava> clazz = UniJava.class;
        synchronized (UniJava.class) {
            ++uniNumSessions;
            UniSession unis = new UniSession();
            if (!uoPooling) {
                uniSessionsVector.addElement(unis);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return unis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniSession openSession(int sslmode) throws UniSessionException {
        Class<UniJava> clazz = UniJava.class;
        synchronized (UniJava.class) {
            ++uniNumSessions;
            UniSession unis = new UniSession(sslmode);
            if (!uoPooling) {
                uniSessionsVector.addElement(unis);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return unis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeServerConnection(UniSession us) throws UniSessionException {
        UniJava.uniLog("Enter UniJava::closeServerConnection()");
        if (!us.isActive()) {
            return;
        }
        if (!us.getPooledSession()) {
            us.disconnectServer();
            UniJava.uniLog("calling closeServerConnection() and us.disconnectServer and pooling is false");
            return;
        }
        Class<UniJava> clazz = UniJava.class;
        synchronized (UniJava.class) {
            String lKey = String.valueOf(us.getHostName()) + us.getUserName() + us.getPassword() + us.getAccountPath();
            UniPool lPool = (UniPool)poolList.get(lKey);
            if (lPool == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            lPool.closeServerConnection(us);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            UniJava.uniLog("Exir UniJava::closeServerConnection()");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static UniSession openPooledSession(String hostname, int hostport, String userid, String password, String account, String service, int sslmode) throws UniSessionException {
        UniSession us = null;
        UniPool lPool = null;
        UniJava.uniLog("Enter UniJava::openPooledSession()");
        Class<UniJava> clazz = UniJava.class;
        synchronized (UniJava.class) {
            if (!uoPooling) {
                throw new UniSessionException(86);
            }
            String lKey = String.valueOf(hostname) + userid + password + account;
            lPool = (UniPool)poolList.get(lKey);
            if (lPool == null) {
                Integer p = (Integer)poolListMinSize.get(Thread.currentThread());
                Integer q = (Integer)poolListMaxSize.get(Thread.currentThread());
                if (p != null) {
                    minPoolSize = p;
                }
                if (q != null) {
                    maxPoolSize = q;
                }
                lPool = new UniPool(hostname, hostport, userid, password, account, service, sslmode, minPoolSize, maxPoolSize);
                poolList.put(lKey, lPool);
            }
            // ** MonitorExit[var9_9] (shouldn't be in output)
            us = lPool.findSession(poolingOpenSessionTimeout, sslmode);
            UniJava.uniLog("Exit UniJava::openPooledSession()");
            return us;
        }
    }

    private static void closeIdleSessions(Object o) throws UniSessionException {
        UniJava.uniLog("Enter UniJava::closeIdleSessions()");
        if (poolList != null) {
            Enumeration lEnumerator = poolList.elements();
            while (lEnumerator.hasMoreElements()) {
                UniPool lPool = (UniPool)lEnumerator.nextElement();
                String s = String.valueOf(lPool.getServer()) + lPool.getUserid() + lPool.getPassword() + lPool.getAccount();
                UniJava.uniLog("Int UniJava::closeIdleSessions() Application details is:" + s);
                lPool.closeIdleConnections();
            }
        }
        UniJava.uniLog("Exit UniJava::closeIdleSessions()");
    }

    private static void readUOJProperties() {
        String luniDebugLevel = "";
        String luoPooling = "";
        try {
            int lminPoolSize = -1;
            int lmaxPoolSize = -1;
            int lpoolingOpenSessionTimeout = -1;
            int lidleRemoveThreshold = -1;
            int lidleRemoveExecInterval = -1;
            luoPooling = uojProperties.getPropertyString("ConnectionPoolingOn");
            lminPoolSize = uojProperties.getPropertyInt("MinimumPoolSize");
            lmaxPoolSize = uojProperties.getPropertyInt("MaximumPoolSize");
            lpoolingOpenSessionTimeout = uojProperties.getPropertyInt("OpenSessionTimeOut");
            lidleRemoveThreshold = uojProperties.getPropertyInt("IdleRemoveThreshold");
            lidleRemoveExecInterval = uojProperties.getPropertyInt("IdleRemoveExecInterval");
            luniDebugLevel = uojProperties.getPropertyString("PoolingDebug");
            luoPooling = uojProperties.getPropertyString("ConnectionPoolingOn");
            if (luoPooling.equals("1")) {
                if (lminPoolSize > -1) {
                    minPoolSize = lminPoolSize;
                }
                if (lmaxPoolSize > 0) {
                    maxPoolSize = lmaxPoolSize;
                }
                if (lpoolingOpenSessionTimeout != -1) {
                    poolingOpenSessionTimeout = lpoolingOpenSessionTimeout;
                }
                if (lidleRemoveThreshold != -1) {
                    idleRemoveThreshold = lidleRemoveThreshold;
                }
                if (lidleRemoveExecInterval != -1) {
                    idleRemoveExecInterval = lidleRemoveExecInterval;
                }
                if (luniDebugLevel.equals("1")) {
                    uniPoolingDebug = true;
                }
                UniJava.setUOPooling(true);
            }
            UniJava.uniLog("In UniJava::readUOJProperties()");
        }
        catch (UniSessionException uniSessionException) {
            UniJava.uniLog("In UniJava::readUOJProperties() got exception");
        }
    }

    public static synchronized int getIdleRemoveExecInterval() {
        return idleRemoveExecInterval;
    }

    public static synchronized void setIdleRemoveExecInterval(int pidleRemoveExecInterval) {
        idleRemoveExecInterval = pidleRemoveExecInterval;
        if (poolListInterval != null) {
            poolListInterval.put(Thread.currentThread(), new Integer(idleRemoveExecInterval));
        }
        UniJava.uniLog("in UniJava::setidleRemoveExecInterval " + idleRemoveExecInterval + "Thread:" + Thread.currentThread());
    }

    public static synchronized int getIdleRemoveThreshold() {
        return idleRemoveThreshold;
    }

    public static synchronized void setIdleRemoveThreshold(int pidleRemoveThreshold) {
        idleRemoveThreshold = pidleRemoveThreshold;
        if (poolListThreshold != null) {
            poolListThreshold.put(Thread.currentThread(), new Integer(idleRemoveThreshold));
        }
        UniJava.uniLog("in UniJava::setidleRemoveThreshold " + idleRemoveThreshold + "Thread:" + Thread.currentThread());
    }

    public static synchronized int getSocketTimeout() {
        return socketTimeout;
    }

    public static synchronized void setSocketTimeout(int ptimeout) {
        socketTimeout = ptimeout;
    }

    public static synchronized int getOpenSessionTimeOut() {
        return poolingOpenSessionTimeout;
    }

    public static synchronized void setOpenSessionTimeOut(int ptimeout) {
        poolingOpenSessionTimeout = ptimeout;
    }

    public static synchronized boolean getUOPooling() {
        return uoPooling;
    }

    public static synchronized void setUOPooling(boolean puoPooling) {
        if (uoPooling == puoPooling) {
            return;
        }
        if (uoPooling && !puoPooling) {
            try {
                UniJava.closeAllCPSessions();
            }
            catch (UniRPCConnectionException uniRPCConnectionException) {
            }
            catch (UniSessionException uniSessionException) {}
            if (timer != null) {
                timer.cancel();
            }
            uniPW = null;
        }
        if ((uoPooling = puoPooling) && poolList == null && timer == null) {
            poolList = new Hashtable();
            poolListMinSize = new Hashtable();
            poolListMaxSize = new Hashtable();
            poolListThreshold = new Hashtable();
            poolListInterval = new Hashtable();
            timer = new Timer(true);
            timer.schedule((TimerTask)new UniTimerTask(), 0L, (long)idleRemoveExecInterval);
            if (uniPoolingDebug) {
                try {
                    if (uniPW == null) {
                        uniPW = new PrintWriter(new FileWriter("uoj_trace.log"));
                        UniJava.uniLog("in UniJava::setUOPooling() Program Started at:" + new Date());
                        UniJava.uniLog("===========================================================");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static synchronized int getMaxPoolSize() {
        return maxPoolSize;
    }

    public static synchronized void setMaxPoolSize(int pmaxPoolSize) {
        maxPoolSize = pmaxPoolSize >= minPoolSize ? pmaxPoolSize : minPoolSize;
        if (poolListMaxSize != null) {
            poolListMaxSize.put(Thread.currentThread(), new Integer(maxPoolSize));
        }
        UniJava.uniLog("in UniJava::setMaxPoolSize " + maxPoolSize + "Thread:" + Thread.currentThread());
    }

    public static synchronized int getMinPoolSize() {
        return minPoolSize;
    }

    public static synchronized void setMinPoolSize(int pminPoolSize) {
        if (pminPoolSize <= maxPoolSize) {
            minPoolSize = pminPoolSize;
        }
        if (pminPoolSize < 0) {
            minPoolSize = 0;
        }
        if (poolListMinSize != null) {
            poolListMinSize.put(Thread.currentThread(), new Integer(minPoolSize));
        }
        UniJava.uniLog("in UniJava::setMinPoolSize " + minPoolSize + "Thread:" + Thread.currentThread());
    }

    static class UniTimerTask
    extends TimerTask {
        UniTimerTask() {
        }

        @Override
        public void run() {
            try {
                UniJava.uniLog("in UniTimerTask::run() Timer Started at:" + new Date());
                UniJava.closeIdleSessions(null);
            }
            catch (UniSessionException e) {
                e.printStackTrace();
            }
        }
    }
}

