/*
 * Decompiled with CFR 0.152.
 */
package asjava.uniobjects;

import asjava.uniclientlibs.UniByteArrayTokenizer;
import asjava.uniclientlibs.UniConnection;
import asjava.uniclientlibs.UniDataSet;
import asjava.uniclientlibs.UniDynArray;
import asjava.uniclientlibs.UniException;
import asjava.uniclientlibs.UniRecord;
import asjava.uniclientlibs.UniString;
import asjava.uniclientlibs.UniStringException;
import asjava.uniobjects.UniBase;
import asjava.uniobjects.UniDictionary;
import asjava.uniobjects.UniFileException;
import asjava.uniobjects.UniSession;
import asjava.unirpc.UniRPCException;
import asjava.unirpc.UniRPCPacket;

public class UniFile
extends UniBase {
    protected int uniFileHandle = 0;
    private static final boolean THROW_EXCEPTION = true;
    private static final boolean NO_EXCEPTION = false;
    private static final boolean CHECK_RECORD = true;
    private static final boolean NO_RECORD = false;
    private UniString uniFileName;
    private UniString uniRecordID;
    private UniString uniRecord;
    private int uniFieldNumber = 0;
    private int uniLockFlag = 0;
    private int uniDictFlag = 0;
    private int uniFileType = 0;
    private int uniReturnCode = 0;
    private int uniLockCount = 0;
    private int uniReleaseStrategy = 0;
    private int uniLockStrategy = 0;
    private int uniBlockingStrategy = 0;
    private boolean isFileOpen = false;

    public UniFile() throws UniFileException {
        throw new UniFileException(88889);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniFile(UniSession aSession, Object aFileName, int aDictFlag) throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            if (aSession == null) {
                throw new UniFileException(39120);
            }
            if (aFileName == null || aFileName.toString().equals("")) {
                throw new UniFileException(30112);
            }
            this.uniParentSession = aSession;
            this.uniConnection = this.uniParentSession.connection;
            this.inPacket = null;
            this.outPacket = null;
            this.uniFileName = new UniString((UniConnection)this.uniParentSession, aFileName.toString());
            this.uniDictFlag = aDictFlag;
            this.uniLockCount = 0;
            this.isFileOpen = false;
            this.setBlockingStrategy(this.uniParentSession.getDefaultBlockingStrategy());
            this.setLockStrategy(this.uniParentSession.getDefaultLockStrategy());
            this.setReleaseStrategy(this.uniParentSession.getDefaultReleaseStrategy());
            this.setEncryptionType(this.uniParentSession.getDefaultEncryptionType());
            this.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearFile() throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.checkEntryConditions(true, false);
            try {
                this.outPacket.write(0, 3);
                this.outPacket.write(1, this.uniFileHandle);
                this.uniConnection.call(this.outPacket, this.inPacket, (byte)this.uniEncryptionType);
                this.uniReturnCode = this.inPacket.readInteger(0);
                if (this.uniReturnCode != 0) {
                    throw new UniFileException(this.uniReturnCode);
                }
            }
            catch (UniException e) {
                this.uniParentSession.setRPCError(true);
                throw new UniFileException(e.getErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.checkEntryConditions(false, false);
            try {
                this.outPacket.write(0, 5);
                this.outPacket.write(1, this.uniFileHandle);
                this.uniConnection.call(this.outPacket, this.inPacket, (byte)this.uniEncryptionType);
                this.uniReturnCode = this.inPacket.readInteger(0);
                this.uniLockCount = 0;
                this.isFileOpen = false;
                if (this.uniReturnCode != 0) {
                    throw new UniFileException(this.uniReturnCode);
                }
            }
            catch (UniRPCException e) {
                this.uniParentSession.setRPCError(true);
                throw new UniFileException(e.getErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRecord() throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.checkEntryConditions(true, true);
            try {
                this.outPacket.write(0, 14);
                this.outPacket.write(1, this.uniFileHandle);
                this.outPacket.write(2, this.getDeleteLock());
                this.outPacket.write(3, this.uniRecordID.getBytes());
                this.uniConnection.call(this.outPacket, this.inPacket, (byte)this.uniEncryptionType);
                this.uniReturnCode = this.inPacket.readInteger(0);
                if (this.uniReturnCode != 0) {
                    this.uniStatus = this.inPacket.readInteger(1);
                    throw new UniFileException(this.uniReturnCode);
                }
                this.uniStatus = 0;
            }
            catch (UniException e) {
                this.uniParentSession.setRPCError(true);
                throw new UniFileException(e.getErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniDataSet deleteRecord(UniDataSet aDataSet) throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.checkEntryConditions(true, false);
            return this.fileAction(79, aDataSet, null, this.getReadLock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRecord(Object aRecordIDObj) throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.setRecordID(aRecordIDObj);
            this.deleteRecord();
        }
    }

    public UniDynArray getAkInfo(Object akNameObj) throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.checkEntryConditions(true, false);
            String akName = akNameObj.toString();
            try {
                this.outPacket.write(0, 27);
                this.outPacket.write(1, this.uniFileHandle);
                this.outPacket.write(2, akName.length());
                this.outPacket.write(3, this.encode(akName.toString()));
                this.uniConnection.call(this.outPacket, this.inPacket, (byte)this.uniEncryptionType);
                this.uniReturnCode = this.inPacket.readInteger(0);
                if (this.uniReturnCode != 0) {
                    throw new UniFileException(this.uniReturnCode);
                }
                this.uniStatus = 0;
                this.uniRecord = new UniString((UniConnection)this.uniParentSession, this.inPacket.readBytes(1));
                return new UniDynArray(this.uniRecord);
            }
            catch (UniException e) {
                this.uniParentSession.setRPCError(true);
                throw new UniFileException(e.getErrorCode());
            }
        }
    }

    public int getBlockingStrategy() {
        return this.uniBlockingStrategy;
    }

    public String getFileName() {
        return this.uniFileName.toString();
    }

    public int getFileType() {
        return this.uniFileType;
    }

    public int getLockStrategy() {
        return this.uniLockStrategy;
    }

    public UniString getRecord() {
        return this.uniRecord;
    }

    public String getRecordID() {
        return this.uniRecordID.toString();
    }

    public int getReleaseStrategy() {
        return this.uniReleaseStrategy;
    }

    public boolean isOpen() {
        return this.isFileOpen;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isRecordLocked() throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            int lockStatus = 0;
            this.checkEntryConditions(true, true);
            try {
                this.outPacket.write(0, 44);
                this.outPacket.write(1, this.uniFileHandle);
                this.outPacket.write(2, this.uniRecordID.getBytes());
                this.uniConnection.call(this.outPacket, this.inPacket, (byte)this.uniEncryptionType);
                this.uniReturnCode = this.inPacket.readInteger(0);
                if (this.uniReturnCode != 0) {
                    throw new UniFileException(this.uniReturnCode);
                }
                lockStatus = this.inPacket.readInteger(1);
                this.uniStatus = this.inPacket.readInteger(2);
                if (lockStatus == 0) {
                    return false;
                }
            }
            catch (UniException e) {
                this.uniParentSession.setRPCError(true);
                throw new UniFileException(e.getErrorCode());
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRecordLocked(Object aRecordIDObj) throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.setRecordID(aRecordIDObj);
            return this.isRecordLocked();
        }
    }

    public UniString iType(Object aRecordIDObj, Object aITypeIDObj) throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            aRecordIDObj.toString();
            UniString aITypeID = new UniString((UniConnection)this.uniParentSession, aITypeIDObj.toString());
            this.setRecordID(aRecordIDObj);
            this.checkEntryConditions(true, true);
            try {
                this.outPacket.write(0, 29);
                this.outPacket.write(1, this.uniFileName.getBytes());
                this.outPacket.write(2, this.uniRecordID.getBytes());
                this.outPacket.write(3, aITypeID.getBytes());
                this.uniConnection.call(this.outPacket, this.inPacket, (byte)this.uniEncryptionType);
                this.uniReturnCode = this.inPacket.readInteger(0);
                if (this.uniReturnCode != 0) {
                    throw new UniFileException(this.uniReturnCode);
                }
                return new UniString((UniConnection)this.uniParentSession, this.inPacket.readBytes(1));
            }
            catch (UniException e) {
                this.uniParentSession.setRPCError(true);
                throw new UniFileException(e.getErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockFile() throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.checkEntryConditions(true, false);
            try {
                this.outPacket.write(0, 20);
                this.outPacket.write(1, this.uniFileHandle);
                this.uniConnection.call(this.outPacket, this.inPacket, (byte)this.uniEncryptionType);
                this.uniReturnCode = this.inPacket.readInteger(0);
                if (this.uniReturnCode != 0) {
                    this.uniStatus = this.inPacket.readInteger(1);
                    throw new UniFileException(this.uniReturnCode);
                }
            }
            catch (UniException e) {
                this.uniParentSession.setRPCError(true);
                throw new UniFileException(e.getErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockRecord(int aLockFlag) throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            if (aLockFlag == 0) {
                return;
            }
            this.checkEntryConditions(true, true);
            this.uniLockFlag = 2;
            if (aLockFlag == 2) {
                this.uniLockFlag = 4;
            }
            if (this.uniBlockingStrategy == 1) {
                ++this.uniLockFlag;
            }
            try {
                this.outPacket.write(0, 43);
                this.outPacket.write(1, this.uniFileHandle);
                this.outPacket.write(2, this.uniLockFlag);
                this.outPacket.write(3, this.uniRecordID.getBytes());
                this.uniConnection.call(this.outPacket, this.inPacket, (byte)this.uniEncryptionType);
                this.uniReturnCode = this.inPacket.readInteger(0);
                if (this.uniReturnCode != 0) {
                    this.uniStatus = this.inPacket.readInteger(1);
                    throw new UniFileException(this.uniReturnCode);
                }
            }
            catch (UniException e) {
                this.uniParentSession.setRPCError(true);
                throw new UniFileException(e.getErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockRecord(Object aRecordIDObj, int aLockFlag) throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.setRecordID(aRecordIDObj);
            this.lockRecord(aLockFlag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniDataSet lockRecord(UniDataSet aDataSet, int aLockFlag) throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.checkEntryConditions(true, false);
            this.uniLockFlag = 2;
            if (aLockFlag == 2) {
                this.uniLockFlag = 4;
            }
            if (this.uniBlockingStrategy == 1) {
                ++this.uniLockFlag;
            }
            return this.fileAction(83, aDataSet, null, this.uniLockFlag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.checkEntryConditions(false, false);
            try {
                if (this.outPacket == null) {
                    this.outPacket = new UniRPCPacket(this.uniConnection);
                    this.inPacket = new UniRPCPacket(this.uniConnection);
                }
                this.outPacket.write(0, 34);
                this.outPacket.write(1, this.uniDictFlag);
                this.outPacket.write(2, this.uniFileName.getBytes());
                this.uniConnection.call(this.outPacket, this.inPacket, (byte)this.uniEncryptionType);
                this.uniStatus = 0;
                this.uniReturnCode = this.inPacket.readInteger(0);
                if (this.uniReturnCode != 0) {
                    throw new UniFileException(this.uniReturnCode);
                }
                this.uniStatus = this.inPacket.readInteger(1);
                this.uniFileHandle = this.inPacket.readInteger(2);
                this.uniFileType = this.uniStatus;
                this.isFileOpen = true;
            }
            catch (UniException e) {
                this.uniParentSession.setRPCError(true);
                throw new UniFileException(e.getErrorCode(), this.uniFileName.toString());
            }
        }
    }

    public UniString read() throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.checkEntryConditions(true, true);
            this.uniRecord = null;
            try {
                this.outPacket.write(0, 37);
                this.outPacket.write(1, this.uniFileHandle);
                this.outPacket.write(2, this.getReadLock());
                this.outPacket.write(3, this.uniRecordID.getBytes());
                this.uniConnection.call(this.outPacket, this.inPacket, (byte)this.uniEncryptionType);
                this.uniReturnCode = this.inPacket.readInteger(0);
                this.uniStatus = this.inPacket.readInteger(1);
                if (this.uniReturnCode != 0) {
                    switch (this.uniReturnCode) {
                        case 14005: {
                            String msg;
                            switch (this.uniStatus) {
                                case 1: {
                                    msg = new String("A bad partitioning algorithm exists for this file");
                                    break;
                                }
                                case 2: {
                                    msg = new String("No such part file");
                                    break;
                                }
                                case 3: {
                                    msg = new String("Record ID contains unmappable NLS characters");
                                    break;
                                }
                                case 4: {
                                    msg = new String("Record data contains unmappable NLS characters");
                                    break;
                                }
                                default: {
                                    msg = new String("An IO Error has occured");
                                }
                            }
                            throw new UniFileException(msg, 14005);
                        }
                    }
                    throw new UniFileException(this.uniReturnCode);
                }
                this.uniRecord = new UniString((UniConnection)this.uniParentSession, this.inPacket.readBytes(2));
                this.Lock();
                this.doReadRelease();
                return this.uniRecord;
            }
            catch (UniException e) {
                this.uniParentSession.setRPCError(true);
                throw new UniFileException(e.getErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniDataSet read(UniDataSet aRowSet) throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.checkEntryConditions(true, false);
            return this.fileAction(76, aRowSet, null, this.getReadLock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniString read(Object aRecordIDObj) throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.setRecordID(aRecordIDObj);
            return this.read();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniString read(Object aRecordIDObj, int aLockFlag) throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.uniLockFlag = aLockFlag;
            return this.read(aRecordIDObj);
        }
    }

    public UniString readField(Object aRecordIDObj, int aFieldNumber) throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.setRecordID(aRecordIDObj);
            this.checkEntryConditions(true, false);
            this.uniRecord = null;
            try {
                this.outPacket.write(0, 42);
                this.outPacket.write(1, this.uniFileHandle);
                this.outPacket.write(2, this.getReadLock());
                this.outPacket.write(3, aFieldNumber);
                this.outPacket.write(4, this.uniRecordID.getBytes());
                this.uniConnection.call(this.outPacket, this.inPacket, (byte)this.uniEncryptionType);
                this.uniReturnCode = this.inPacket.readInteger(0);
                this.uniStatus = this.inPacket.readInteger(1);
                if (this.uniReturnCode != 0) {
                    switch (this.uniReturnCode) {
                        case 14005: {
                            String msg;
                            switch (this.uniStatus) {
                                case 1: {
                                    msg = new String("A bad partitioning algorithm exists for this file");
                                    break;
                                }
                                case 2: {
                                    msg = new String("No such part file");
                                    break;
                                }
                                case 3: {
                                    msg = new String("Record ID contains unmappable NLS characters");
                                    break;
                                }
                                case 4: {
                                    msg = new String("Record data contains unmappable NLS characters");
                                    break;
                                }
                                default: {
                                    msg = new String("An IO Error has occured");
                                }
                            }
                            throw new UniFileException(msg, 14005);
                        }
                    }
                    throw new UniFileException(this.uniReturnCode);
                }
                this.Lock();
                this.doReadRelease();
                this.uniRecord = new UniString((UniConnection)this.uniParentSession, this.inPacket.readBytes(2));
                return this.uniRecord;
            }
            catch (UniException e) {
                this.uniParentSession.setRPCError(true);
                throw new UniFileException(e.getErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniString readField(Object aRecordIDObj, int aFieldNumber, int aLockFlag) throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.uniLockFlag = aLockFlag;
            return this.readField(aRecordIDObj, aFieldNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniDataSet readField(UniDataSet aRowSet, int aFieldNumber) throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.checkEntryConditions(true, false);
            Integer x = new Integer(aFieldNumber);
            String fieldStr = x.toString();
            return this.fileAction(77, aRowSet, fieldStr, this.getReadLock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniDataSet readField(UniDataSet aRowSet, Object aFieldNumber) throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.checkEntryConditions(true, false);
            String fieldStr = aFieldNumber.toString();
            return this.fileAction(77, aRowSet, fieldStr, this.getReadLock());
        }
    }

    public UniString readNamedField(Object aFieldNameObj) throws UniFileException {
        return this.readNamedField(this.uniRecordID, aFieldNameObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniString readNamedField(Object aRecordIDObj, Object aFieldNameObj) throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.checkEntryConditions(true, true);
            UniDataSet x = new UniDataSet(this.uniParentSession);
            x.insert(aRecordIDObj);
            UniDataSet y = this.readNamedField(x, aFieldNameObj);
            return y.getUniRecord(0).getRecord();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniDataSet readNamedField(UniDataSet aRowSet, Object aFieldNameObj) throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.checkEntryConditions(true, false);
            return this.fileAction(78, aRowSet, aFieldNameObj, this.getReadLock());
        }
    }

    public void setBlockingStrategy(int aBlock) throws UniFileException {
        if (aBlock < 1 || aBlock > 2) {
            throw new UniFileException("Blocking strategy must be either UniObjectsTokens.UVT_WAIT_LOCKED(1) or UniObjectsTokens.UVT_RETURN_LOCKED(2)", 14022);
        }
        this.uniBlockingStrategy = aBlock;
    }

    public void setFileName(Object aFileNameObj) {
        this.uniFileName = new UniString((UniConnection)this.uniParentSession, aFileNameObj.toString());
    }

    public void setLockStrategy(int aLock) throws UniFileException {
        if (aLock < 0 || aLock > 2) {
            throw new UniFileException("Locking strategy must be either UniObjectsTokens.UVT_NO_LOCKS(0), UniObjectsTokens.UVT_EXCLUSIVE_UPDATE(1) or UniObjectsTokens.UVT_SHARED_READ(2)", 14022);
        }
        this.uniLockStrategy = aLock;
    }

    public void setRecord(Object aStringObj) {
        this.uniRecord = UniString.class.isInstance(aStringObj) ? new UniString((UniString)aStringObj) : new UniString((UniConnection)this.uniParentSession, aStringObj);
    }

    public void setRecordID(Object aStringObj) throws UniFileException {
        this.uniRecordID = new UniString((UniConnection)this.uniParentSession, aStringObj.toString());
    }

    public void setReleaseStrategy(int aRelease) throws UniFileException {
        if (aRelease < 0 || aRelease > 15) {
            throw new UniFileException("UniFile.setReleaseStrategy() failed:  Strategy eitherWRITE_RELEASE (1), READ_RELEASE (2), EXPLICIT_RELEASE (4) or CHANGE_RELEASE (8)", 14022);
        }
        this.uniReleaseStrategy = aRelease;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockFile() throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.checkEntryConditions(true, false);
            try {
                this.outPacket.write(0, 21);
                this.outPacket.write(1, this.uniFileHandle);
                this.uniConnection.call(this.outPacket, this.inPacket, (byte)this.uniEncryptionType);
                this.uniReturnCode = this.inPacket.readInteger(0);
                if (this.uniReturnCode != 0) {
                    this.uniStatus = this.inPacket.readInteger(1);
                    throw new UniFileException(this.uniReturnCode);
                }
            }
            catch (UniException e) {
                this.uniParentSession.setRPCError(true);
                throw new UniFileException(e.getErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockRecord() throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.checkEntryConditions(true, true);
            this.releaseLock(this.uniRecordID, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockRecord(UniDataSet aDataSet) throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.checkEntryConditions(true, false);
            this.fileAction(84, aDataSet, null, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockRecord(Object aRecordIDObj) throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.setRecordID(aRecordIDObj);
            this.unlockRecord();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.checkEntryConditions(true, true);
            try {
                this.outPacket.write(0, 61);
                this.outPacket.write(1, this.uniFileHandle);
                this.outPacket.write(2, this.getWriteLock());
                this.outPacket.write(3, this.uniRecordID.getBytes());
                this.outPacket.write(4, this.uniRecord.getBytes());
                this.uniConnection.call(this.outPacket, this.inPacket, (byte)this.uniEncryptionType);
                this.uniReturnCode = this.inPacket.readInteger(0);
                if (this.uniReturnCode != 0) {
                    this.uniStatus = this.inPacket.readInteger(1);
                    throw new UniFileException(this.uniReturnCode);
                }
                this.unLock();
            }
            catch (UniException e) {
                this.uniParentSession.setRPCError(true);
                throw new UniFileException(e.getErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Object aRecordIDObj, Object aRecordDataObj) throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.uniRecordID = new UniString((UniConnection)this.uniParentSession, aRecordIDObj.toString());
            this.uniRecord = UniString.class.isInstance(aRecordDataObj) ? new UniString((UniString)aRecordDataObj) : new UniString((UniConnection)this.uniParentSession, aRecordDataObj.toString());
            this.write();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Object aRecordIDObj, Object aRecordDataObj, int aLockFlag) throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.uniLockFlag = aLockFlag;
            this.write(aRecordIDObj, aRecordDataObj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniDataSet write(UniDataSet aDataSet) throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.checkEntryConditions(true, false);
            return this.fileAction(80, aDataSet, null, this.getWriteLock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeField(int uniFieldNumber) throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.checkEntryConditions(true, true);
            try {
                this.outPacket.write(0, 65);
                this.outPacket.write(1, this.uniFileHandle);
                this.outPacket.write(2, this.getWriteLock());
                this.outPacket.write(3, uniFieldNumber);
                this.outPacket.write(4, this.uniRecordID.getBytes());
                this.outPacket.write(5, this.uniRecord.getBytes());
                this.uniConnection.call(this.outPacket, this.inPacket, (byte)this.uniEncryptionType);
                this.uniReturnCode = this.inPacket.readInteger(0);
                if (this.uniReturnCode != 0) {
                    this.uniStatus = this.inPacket.readInteger(1);
                    throw new UniFileException(this.uniReturnCode);
                }
                this.unLock();
            }
            catch (UniException e) {
                this.uniParentSession.setRPCError(true);
                throw new UniFileException(e.getErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniDataSet writeField(UniDataSet aDataSet, int uniFieldNumber) throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.checkEntryConditions(true, false);
            Integer x = new Integer(uniFieldNumber);
            String fieldStr = x.toString();
            return this.fileAction(81, aDataSet, fieldStr, this.getWriteLock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniDataSet writeField(UniDataSet aDataSet, Object uniFieldName) throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.checkEntryConditions(true, false);
            String fieldNum = uniFieldName.toString();
            return this.fileAction(81, aDataSet, fieldNum, this.getWriteLock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeField(Object aRecordIDObj, Object aRecordDataObj, int aFieldNumber) throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.setRecordID(aRecordIDObj);
            this.uniRecord = UniString.class.isInstance(aRecordDataObj) ? new UniString((UniString)aRecordDataObj) : new UniString((UniConnection)this.uniParentSession, aRecordDataObj.toString());
            this.writeField(aFieldNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeField(Object aRecordIDObj, Object aRecordDataObj, int aFieldNumber, int aLockFlag) throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.uniLockFlag = aLockFlag;
            this.writeField(aRecordIDObj, aRecordDataObj, aFieldNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeNamedField(Object aFieldName, Object aString) throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.checkEntryConditions(true, true);
            this.writeNamedField(this.uniRecordID, aFieldName, aString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeNamedField(Object aRecordID, Object aFieldName, Object aString) throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.checkEntryConditions(true, false);
            UniDataSet x = new UniDataSet(this.uniParentSession);
            x.insert(aRecordID, aString);
            this.writeNamedField(x, aFieldName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniDataSet writeNamedField(UniDataSet aDataSet, Object aFieldName) throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.checkEntryConditions(true, false);
            return this.fileAction(82, aDataSet, aFieldName, this.getWriteLock());
        }
    }

    private int convertField(Object aFieldNameObj, Object aFieldDataObj) throws UniFileException {
        UniString convRecord = null;
        UniDictionary unid = null;
        int fieldNumber = 0;
        if (this.uniDictFlag == 1) {
            unid = new UniDictionary(this.uniParentSession, "DICT.DICT", 0);
        } else {
            this.uniFileName.toString();
            unid = new UniDictionary(this.uniParentSession, this.uniFileName, 1);
        }
        UniString uniDictRecord = unid.read(aFieldNameObj, 0);
        unid.close();
        UniDynArray uniDictEntry = new UniDynArray(uniDictRecord);
        UniDynArray uniDictType = uniDictEntry.extract(1);
        switch (uniDictType.toString().charAt(0)) {
            case 'D': 
            case 'd': {
                break;
            }
            default: {
                throw new UniFileException(40007);
            }
        }
        UniDynArray uniDictConv = uniDictEntry.extract(3);
        try {
            convRecord = this.uniParentSession.iconv(aFieldDataObj, uniDictConv);
        }
        catch (UniStringException uniStringException) {
            throw new UniFileException(40009);
        }
        UniDynArray uniDictLoc = uniDictEntry.extract(2);
        try {
            Integer tmpField = new Integer(uniDictLoc.toString());
            fieldNumber = tmpField;
        }
        catch (NumberFormatException numberFormatException) {
            throw new UniFileException(40008);
        }
        this.uniRecord = convRecord;
        return fieldNumber;
    }

    private void doOnChangeRelease() throws UniFileException {
        if ((this.uniReleaseStrategy & 8) != 0) {
            this.singleRelease();
        }
    }

    private void doReadRelease() throws UniFileException {
        if ((this.uniReleaseStrategy & 2) != 0) {
            this.singleRelease();
        }
    }

    private int getDeleteLock() {
        int lockType = 0;
        if ((this.uniReleaseStrategy & 1) == 0) {
            lockType = 3;
        }
        if (this.uniBlockingStrategy == 1) {
            ++lockType;
        }
        return lockType;
    }

    private int getReadLock() {
        int lockType = 0;
        switch (this.uniLockStrategy) {
            case 2: {
                lockType = 4;
                break;
            }
            case 1: {
                lockType = 2;
                break;
            }
        }
        if (this.uniBlockingStrategy == 1) {
            ++lockType;
        }
        return lockType;
    }

    private int getWriteLock() {
        int lockType = 0;
        lockType = (this.uniReleaseStrategy & 1) != 0 ? 0 : 5;
        if (this.uniBlockingStrategy == 1) {
            ++lockType;
        }
        return lockType;
    }

    private void Lock() {
        if (this.uniLockStrategy != 0) {
            ++this.uniLockCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLock(Object aRecordIDObj, int aClearFlag) throws UniFileException {
        UniFile uniFile = this;
        synchronized (uniFile) {
            this.checkEntryConditions(true, false);
            try {
                this.outPacket.write(0, 45);
                this.outPacket.write(1, this.uniFileHandle);
                this.outPacket.write(2, aClearFlag);
                this.outPacket.write(3, this.encode(aRecordIDObj.toString()));
                this.uniConnection.call(this.outPacket, this.inPacket, (byte)this.uniEncryptionType);
                this.uniReturnCode = this.inPacket.readInteger(0);
                if (this.uniReturnCode != 0) {
                    throw new UniFileException(this.uniReturnCode);
                }
            }
            catch (UniException e) {
                this.uniParentSession.setRPCError(true);
                throw new UniFileException(e.getErrorCode());
            }
        }
    }

    private void singleRelease() throws UniFileException {
        this.releaseLock(this.uniRecordID, 0);
    }

    private void unLock() {
        if (this.uniLockStrategy != 0) {
            --this.uniLockCount;
            if (this.uniLockCount < 0) {
                this.uniLockCount = 0;
            }
        }
    }

    protected UniDataSet fileAction(int actionRequested, UniDataSet dataSet, Object fieldList, int lockType) throws UniFileException {
        int serverVersion = this.uniParentSession.getServerVersion();
        try {
            switch (serverVersion) {
                case 1: {
                    int numItems = dataSet.getRowCount();
                    byte delimiter = this.uniParentSession.getMarkByte(0);
                    UniByteArrayTokenizer idSet = new UniByteArrayTokenizer(dataSet.getIDSetUniDynArray().getBytes(), delimiter);
                    UniByteArrayTokenizer recSet = new UniByteArrayTokenizer(dataSet.getDataSetUniDynArray().getBytes(), delimiter);
                    UniDataSet returnSet = new UniDataSet(this.uniParentSession);
                    int i = 0;
                    while (i < numItems) {
                        UniString recID = new UniString((UniConnection)this.uniParentSession, idSet.nextToken());
                        UniString recVal = new UniString((UniConnection)this.uniParentSession, recSet.nextToken());
                        switch (actionRequested) {
                            case 76: {
                                UniRecord resultRec;
                                UniRecord resultRec2;
                                UniString dataVal;
                                try {
                                    dataVal = this.read(recID);
                                    resultRec2 = new UniRecord(recID, dataVal, this.uniStatus);
                                    resultRec2.setReturnCode(this.uniReturnCode);
                                    returnSet.append(resultRec2);
                                }
                                catch (UniException uniException) {
                                    resultRec = new UniRecord(recID, new UniString(this.uniParentSession), this.uniStatus);
                                    resultRec.setReturnCode(this.uniReturnCode);
                                    returnSet.append(resultRec);
                                }
                                break;
                            }
                            case 77: {
                                int fieldNum;
                                UniDynArray fieldOne;
                                UniDynArray fieldArray;
                                UniRecord resultRec;
                                try {
                                    fieldArray = new UniDynArray((UniConnection)this.uniParentSession, fieldList);
                                    fieldOne = fieldArray.extract(1);
                                    fieldNum = Integer.parseInt(fieldOne.toString());
                                    UniString dataVal = this.readField(recID, fieldNum);
                                    UniRecord resultRec3 = new UniRecord(recID, dataVal, this.uniStatus);
                                    resultRec3.setReturnCode(this.uniReturnCode);
                                    returnSet.append(resultRec3);
                                }
                                catch (UniException uniException) {
                                    resultRec = new UniRecord(recID, new UniString(this.uniParentSession), this.uniStatus);
                                    resultRec.setReturnCode(this.uniReturnCode);
                                    returnSet.append(resultRec);
                                }
                                break;
                            }
                            case 78: {
                                UniRecord resultRec;
                                UniRecord resultRec2;
                                UniString dataVal;
                                try {
                                    dataVal = this.readNamedField(recID, fieldList);
                                    resultRec2 = new UniRecord(recID, dataVal, this.uniStatus);
                                    resultRec2.setReturnCode(this.uniReturnCode);
                                    returnSet.append(resultRec2);
                                }
                                catch (UniException uniException) {
                                    resultRec = new UniRecord(recID, new UniString(this.uniParentSession), this.uniStatus);
                                    resultRec.setReturnCode(this.uniReturnCode);
                                    returnSet.append(resultRec);
                                }
                                break;
                            }
                            case 80: {
                                UniRecord resultRec;
                                try {
                                    this.write(recID, recVal);
                                    resultRec = new UniRecord(recID, new UniString(this.uniParentSession), this.uniStatus);
                                    resultRec.setReturnCode(this.uniReturnCode);
                                    returnSet.append(resultRec);
                                }
                                catch (UniException uniException) {
                                    resultRec = new UniRecord(recID, new UniString(this.uniParentSession), this.uniStatus);
                                    resultRec.setReturnCode(this.uniReturnCode);
                                    returnSet.append(resultRec);
                                }
                                break;
                            }
                            case 81: {
                                int fieldNum;
                                UniDynArray fieldOne;
                                UniDynArray fieldArray;
                                UniRecord resultRec;
                                try {
                                    fieldArray = new UniDynArray((UniConnection)this.uniParentSession, fieldList);
                                    fieldOne = fieldArray.extract(1);
                                    fieldNum = Integer.parseInt(fieldOne.toString());
                                    this.writeField(recID, recVal, fieldNum);
                                    UniRecord resultRec4 = new UniRecord(recID, new UniString(this.uniParentSession), this.uniStatus);
                                    resultRec4.setReturnCode(this.uniReturnCode);
                                    returnSet.append(resultRec4);
                                }
                                catch (UniException uniException) {
                                    resultRec = new UniRecord(recID, new UniString(this.uniParentSession), this.uniStatus);
                                    resultRec.setReturnCode(this.uniReturnCode);
                                    returnSet.append(resultRec);
                                }
                                break;
                            }
                            case 82: {
                                UniRecord resultRec;
                                try {
                                    this.writeNamedField(recID, recVal, fieldList);
                                    resultRec = new UniRecord(recID, new UniString(this.uniParentSession), this.uniStatus);
                                    resultRec.setReturnCode(this.uniReturnCode);
                                    returnSet.append(resultRec);
                                }
                                catch (UniException uniException) {
                                    resultRec = new UniRecord(recID, new UniString(this.uniParentSession), this.uniStatus);
                                    resultRec.setReturnCode(this.uniReturnCode);
                                    returnSet.append(resultRec);
                                }
                                break;
                            }
                            case 83: {
                                UniRecord resultRec;
                                try {
                                    this.lockRecord(recID, lockType);
                                    resultRec = new UniRecord(recID, new UniString(this.uniParentSession), this.uniStatus);
                                    resultRec.setReturnCode(this.uniReturnCode);
                                    returnSet.append(resultRec);
                                }
                                catch (UniException uniException) {
                                    resultRec = new UniRecord(recID, new UniString(this.uniParentSession), this.uniStatus);
                                    resultRec.setReturnCode(this.uniReturnCode);
                                    returnSet.append(resultRec);
                                }
                                break;
                            }
                            case 84: {
                                UniRecord resultRec;
                                try {
                                    this.unlockRecord(recID);
                                    resultRec = new UniRecord(recID, new UniString(this.uniParentSession), this.uniStatus);
                                    resultRec.setReturnCode(this.uniReturnCode);
                                    returnSet.append(resultRec);
                                }
                                catch (UniException uniException) {
                                    resultRec = new UniRecord(recID, new UniString(this.uniParentSession), this.uniStatus);
                                    resultRec.setReturnCode(this.uniReturnCode);
                                    returnSet.append(resultRec);
                                }
                                break;
                            }
                            default: {
                                throw new UniFileException(30096);
                            }
                        }
                        ++i;
                    }
                    return returnSet;
                }
            }
            return this.serverRequest(actionRequested, dataSet, fieldList, lockType);
        }
        catch (UniException e) {
            this.uniParentSession.setRPCError(true);
            throw new UniFileException(e.getErrorCode());
        }
    }

    private UniDataSet serverRequest(int serverRequestVal, UniDataSet dataSet, Object fieldStr, int lockType) throws UniException {
        this.outPacket.write(0, serverRequestVal);
        this.outPacket.write(1, this.uniFileHandle);
        this.outPacket.write(2, lockType);
        this.outPacket.write(3, dataSet.getIDSetUniDynArray().getBytes());
        this.outPacket.write(4, dataSet.getDataSetUniDynArray().getBytes());
        if (fieldStr != null) {
            this.outPacket.write(5, this.getByteValue(fieldStr));
        }
        this.uniConnection.call(this.outPacket, this.inPacket, (byte)this.getEncryptionType());
        int uniReturnCode = this.inPacket.readInteger(0);
        UniDynArray uniReturnSet = new UniDynArray((UniConnection)this.uniParentSession, this.inPacket.readBytes(1));
        UniDynArray uniStatus = new UniDynArray((UniConnection)this.uniParentSession, this.inPacket.readBytes(2));
        UniDynArray returnDataSet = serverRequestVal == 76 || serverRequestVal == 77 || serverRequestVal == 78 ? new UniDynArray((UniConnection)this.uniParentSession, this.inPacket.readBytes(3)) : new UniDynArray(this.uniParentSession);
        return new UniDataSet(dataSet, returnDataSet, uniReturnSet, uniStatus, uniReturnCode);
    }

    private byte[] getByteValue(Object aString) {
        if (aString instanceof byte[]) {
            return (byte[])aString;
        }
        if (aString instanceof UniString) {
            return ((UniString)aString).getBytes();
        }
        String insertString = aString.toString();
        if (insertString.equals("")) {
            return null;
        }
        return this.encode(insertString);
    }

    private void checkEntryConditions(boolean shouldThrow, boolean checkForRecord) throws UniFileException {
        if (!this.isOpen() && shouldThrow) {
            this.uniStatus = -1;
            throw new UniFileException(45000, this.uniFileName.toString());
        }
        if (this.isCommandActive()) {
            throw new UniFileException(30114);
        }
        if (checkForRecord && (this.uniRecordID == null || this.uniRecordID.equals(""))) {
            throw new UniFileException(45002);
        }
        this.uniStatus = 0;
    }
}

