/*
 * Decompiled with CFR 0.152.
 */
package asjava.uniclientlibs;

public class UniStringTokenizer {
    String uniString = "";
    String delimiter = "";
    int curPos = 0;
    int maxPos = 0;

    public UniStringTokenizer(Object stringVal) {
        this(stringVal, " ");
    }

    public UniStringTokenizer(Object stringVal, Object delimiterVal) {
        this.resetTokenizer();
        this.uniString = stringVal != null ? stringVal.toString() : new String();
        this.delimiter = delimiterVal == null ? new String(" ") : delimiterVal.toString();
        this.maxPos = this.uniString.length();
    }

    public int countTokens() {
        int currpos = 0;
        int count = 1;
        while (currpos < this.maxPos) {
            if (this.delimiter.indexOf(this.uniString.charAt(currpos)) >= 0) {
                ++count;
            }
            ++currpos;
        }
        return count;
    }

    public boolean hasMoreTokens() {
        if (this.curPos == -1) {
            return false;
        }
        return this.curPos <= this.maxPos;
    }

    public String nextToken() {
        if (!this.hasMoreTokens()) {
            return null;
        }
        int startPos = this.curPos;
        while (this.curPos < this.maxPos && this.delimiter.indexOf(this.uniString.charAt(this.curPos)) < 0) {
            ++this.curPos;
        }
        String subvalue = this.uniString.substring(startPos, this.curPos);
        ++this.curPos;
        return subvalue;
    }

    public void resetTokenizer() {
        this.curPos = 0;
    }
}

