/*
 * Decompiled with CFR 0.152.
 */
package asjava.uniclientlibs;

import asjava.uniclientlibs.UniConnection;
import asjava.uniclientlibs.UniConnectionException;
import asjava.uniclientlibs.UniDynArray;
import asjava.uniclientlibs.UniException;
import asjava.uniclientlibs.UniStringException;
import asjava.uniclientlibs.UniTokens;
import asjava.unirpc.UniRPCException;
import asjava.unirpc.UniRPCPacket;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Vector;

public class UniString
implements Serializable {
    protected byte[] byteValue;
    protected int count;
    protected char[] charValue;
    protected boolean valueChanged = true;
    protected boolean dynArrayChanged = false;
    protected int uniStatus = 0;
    protected int uniReturnCode = 0;
    protected UniConnection uniConnection = null;
    protected UniRPCPacket inPacket = null;
    protected UniRPCPacket outPacket = null;
    protected Vector dynArray = null;
    private byte[] marks = UniTokens.b_marks;
    protected Charset charset = Charset.forName(System.getProperty("file.encoding"));
    protected String encoding = System.getProperty("file.encoding");

    public UniString() {
        this(16);
    }

    public UniString(int length) {
        if (length < 0) {
            length = 0;
        }
        this.byteValue = new byte[length];
    }

    public UniString(String aString) {
        ByteBuffer bb = this.charset.encode(aString);
        this.count = bb.limit();
        this.byteValue = new byte[this.count];
        bb.get(this.byteValue);
    }

    public UniString(UniString aString) {
        if (aString != null) {
            this.uniConnection = aString.uniConnection;
            if (this.uniConnection != null) {
                this.setMarks(this.uniConnection.getByteMarks());
                this.setEncoding(this.uniConnection.getEncoding());
            }
            this.byteValue = aString.getBytes();
            this.count = this.byteValue.length;
        }
    }

    public UniString(Object aString) {
        if (aString instanceof byte[]) {
            byte[] bytes = (byte[])aString;
            if (bytes == null) {
                this.byteValue = new byte[16];
                this.count = 0;
            } else {
                this.byteValue = new byte[bytes.length];
                System.arraycopy(bytes, 0, this.byteValue, 0, bytes.length);
                this.count = this.byteValue.length;
            }
        } else if (aString instanceof UniString) {
            UniString uString = (UniString)aString;
            this.uniConnection = uString.uniConnection;
            if (this.uniConnection != null) {
                this.setMarks(this.uniConnection.getByteMarks());
                this.setEncoding(this.uniConnection.getEncoding());
            }
            this.byteValue = uString.getBytes();
            this.count = this.byteValue.length;
        } else {
            ByteBuffer bb = this.charset.encode(aString.toString());
            this.count = bb.limit();
            this.byteValue = new byte[this.count];
            bb.get(this.byteValue);
        }
    }

    public UniString(UniConnection aNewSession) {
        this.byteValue = new byte[16];
        if (aNewSession != null) {
            this.uniConnection = aNewSession;
            this.setMarks(aNewSession.getByteMarks());
            this.setEncoding(aNewSession.getEncoding());
        }
    }

    public UniString(UniConnection aNewSession, Object aString) {
        if (aString instanceof byte[]) {
            byte[] bytes = (byte[])aString;
            if (aNewSession != null) {
                this.uniConnection = aNewSession;
                this.setMarks(aNewSession.getByteMarks());
                this.setEncoding(aNewSession.getEncoding());
            }
            if (bytes == null) {
                this.byteValue = new byte[16];
                this.count = 0;
            } else {
                this.byteValue = new byte[bytes.length];
                System.arraycopy(bytes, 0, this.byteValue, 0, bytes.length);
                this.count = this.byteValue.length;
            }
        } else if (aString instanceof UniString) {
            UniString uString = (UniString)aString;
            this.uniConnection = uString.uniConnection;
            if (this.uniConnection != null) {
                this.setMarks(this.uniConnection.getByteMarks());
                this.setEncoding(this.uniConnection.getEncoding());
            }
            this.byteValue = uString.getBytes();
            this.count = this.byteValue.length;
        } else {
            if (aNewSession != null) {
                this.uniConnection = aNewSession;
                this.setMarks(aNewSession.getByteMarks());
                this.setEncoding(aNewSession.getEncoding());
            }
            ByteBuffer bb = this.charset.encode(aString.toString());
            this.count = bb.limit();
            this.byteValue = new byte[this.count];
            bb.get(this.byteValue);
        }
    }

    public UniString(UniConnection aNewSession, byte[] aString) {
        byte[] bytes = aString;
        if (aNewSession != null) {
            this.uniConnection = aNewSession;
            this.setMarks(aNewSession.getByteMarks());
            this.setEncoding(aNewSession.getEncoding());
        }
        if (bytes == null) {
            this.byteValue = new byte[16];
            this.count = 0;
        } else {
            this.byteValue = bytes;
            this.count = this.byteValue.length;
        }
    }

    public boolean alpha() throws UniStringException {
        if (this.uniConnection != null && this.uniConnection.isNLSEnabled()) {
            return this.alpha(this.uniConnection);
        }
        this.checkChanged();
        int i = 0;
        while (i < this.charValue.length) {
            if (!Character.isLetter(this.charValue[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean alpha(UniConnection aConnection) throws UniStringException {
        if (!aConnection.isNLSEnabled()) {
            return this.alpha();
        }
        UniString uniString = this;
        synchronized (uniString) {
            try {
                this.uniConnection = aConnection;
                if (this.inPacket == null || this.outPacket == null) {
                    this.inPacket = new UniRPCPacket(this.uniConnection.connection);
                    this.outPacket = new UniRPCPacket(this.uniConnection.connection);
                }
                this.outPacket.write(0, 1);
                this.outPacket.write(1, this.getBytes());
                this.uniConnection.connection.call(this.outPacket, this.inPacket, (byte)this.uniConnection.getDefaultEncryptionType());
                if (this.inPacket.readInteger(0) == 0) {
                    return false;
                }
            }
            catch (UniRPCException e) {
                throw new UniStringException(e.getErrorCode());
            }
            return true;
        }
    }

    public synchronized void append(String aString) {
        byte[] ba = this.encode(aString);
        this.append(ba);
    }

    public synchronized void append(Object aString) {
        byte[] appendBytes = this.getByteValue(aString);
        this.append(appendBytes);
    }

    protected synchronized void append(UniString aString) {
        if (aString != null) {
            this.append(aString.getBytes());
        }
    }

    public synchronized void append(char[] str) {
        this.append(str, 0, str.length);
    }

    public synchronized void append(char[] str, int offset, int len) {
        byte[] ba = this.encode(str, offset, len);
        this.append(ba);
    }

    public synchronized void append(boolean b) {
        this.append(String.valueOf(b));
    }

    public synchronized void append(char c) {
        char[] ca = new char[]{c};
        this.append(ca);
    }

    public synchronized void append(byte ba) {
        this.checkDynChanged();
        byte[] bytes = new byte[]{ba};
        this.append(bytes);
    }

    public synchronized void append(byte[] ba) {
        this.checkDynChanged();
        this.ensureCapacity(this.count + ba.length);
        System.arraycopy(ba, 0, this.byteValue, this.count, ba.length);
        this.count += ba.length;
        this.valueChanged = true;
    }

    public synchronized void append(int i) {
        this.append(String.valueOf(i));
    }

    public synchronized void append(long l) {
        this.append(String.valueOf(l));
    }

    public synchronized void append(float f) {
        this.append(String.valueOf(f));
    }

    public synchronized void append(double d) {
        this.append(String.valueOf(d));
    }

    protected static int indexOf(byte[] src, byte[] target, int start) {
        int subCount;
        if (start < 0) {
            start = 0;
        }
        if ((subCount = target.length) > 0) {
            if (subCount + start > src.length) {
                return -1;
            }
            byte firstByte = target[0];
            int end = subCount;
            while (true) {
                int i;
                if ((i = UniString.indexOf(src, firstByte, start)) == -1 || subCount + i > src.length) {
                    return -1;
                }
                int o1 = i;
                int o2 = 0;
                while (++o2 < end && src[++o1] == target[o2]) {
                }
                if (o2 == end) {
                    return i;
                }
                start = i + 1;
            }
        }
        return start < src.length ? start : src.length;
    }

    protected static int indexOf(byte[] src, byte b, int start) {
        int count = src.length;
        if (start < count) {
            if (start < 0) {
                start = 0;
            }
            int i = start;
            while (i < count) {
                if (src[i] == b) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public void change(Object aSubString, Object aReplacementString) {
        this.change(aSubString, aReplacementString, 0, 0);
    }

    public void change(Object aSubString, Object aReplacementString, int aOccurance) {
        this.change(aSubString, aReplacementString, aOccurance, 0);
    }

    public synchronized void change(Object aSubString, Object aReplacementString, int aOccurance, int aStart) {
        char[] ca = this.decode(this.byteValue, 0, this.count);
        if (aStart < 0) {
            aStart = 0;
        }
        byte[] ba = this.encode(ca, 0, aStart);
        byte[] subBa = aSubString instanceof byte[] ? (byte[])aSubString : this.encode(aSubString.toString());
        byte[] repBa = aReplacementString instanceof byte[] ? (byte[])aReplacementString : this.encode(aReplacementString.toString());
        this.change(subBa, repBa, aOccurance, ba.length);
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void change(byte[] subBytes, byte[] replaceBytes, int aOccurance, int aStart) {
        continueFlag = true;
        currentOccurance = 0;
        curLoc = 0;
        oldCurLoc = 0;
        this.checkDynChanged();
        if (subBytes.length == 0) {
            return;
        }
        if (aOccurance < 0) {
            aOccurance = 0;
        }
        if (aStart < 0) {
            aStart = 0;
        }
        while (currentOccurance != aStart && oldCurLoc != -1) {
            if ((oldCurLoc = UniString.indexOf(this.byteValue, subBytes, oldCurLoc)) == -1) continue;
            ++currentOccurance;
            curLoc = oldCurLoc;
            oldCurLoc += subBytes.length;
        }
        if (aStart == currentOccurance || oldCurLoc != -1) ** GOTO lbl36
        return;
lbl-1000:
        // 1 sources

        {
            if ((curLoc = UniString.indexOf(this.byteValue, subBytes, curLoc)) == -1) {
                continueFlag = false;
                continue;
            }
            newSize = this.count - subBytes.length + replaceBytes.length;
            this.ensureCapacity(newSize);
            newValue = new byte[newSize];
            if (curLoc > 0) {
                System.arraycopy(this.byteValue, 0, newValue, 0, curLoc);
            }
            System.arraycopy(replaceBytes, 0, newValue, curLoc, replaceBytes.length);
            System.arraycopy(this.byteValue, curLoc + subBytes.length, newValue, curLoc + replaceBytes.length, this.count - subBytes.length - curLoc);
            this.count = this.count - subBytes.length + replaceBytes.length;
            this.byteValue = newValue;
            curLoc += replaceBytes.length;
            if (++currentOccurance == aOccurance && aOccurance != 0) {
                continueFlag = false;
            }
            this.valueChanged = true;
lbl36:
            // 3 sources

            ** while (continueFlag)
        }
lbl37:
        // 1 sources

    }

    protected void checkChanged() {
        if (this.valueChanged) {
            this.constructDynArray();
        } else if (this.dynArrayChanged) {
            this.collapseDynArray();
        }
        this.charValue = this.decode(this.byteValue, 0, this.count);
    }

    protected void checkDynChanged() {
        if (this.dynArrayChanged) {
            this.collapseDynArray();
        }
    }

    protected void checkBytesChanged() {
        if (this.valueChanged) {
            this.constructDynArray();
        }
    }

    public synchronized char charAt(int index) throws UniStringException {
        if (index < 0 || index >= this.count) {
            throw new UniStringException(14022);
        }
        this.checkChanged();
        return this.charValue[index];
    }

    public int compareTo(Object aCompareString) {
        return this.toString().compareTo(aCompareString.toString());
    }

    protected static byte[] subByteArray(byte[] bytes, int start, int end) {
        int length = end - start;
        if (length < 0) {
            length = 0;
        }
        byte[] subBytes = new byte[length];
        System.arraycopy(bytes, start, subBytes, 0, length);
        return subBytes;
    }

    /*
     * Unable to fully structure code
     */
    protected void constructDynArray() {
        item = new byte[this.count];
        System.arraycopy(this.byteValue, 0, item, 0, this.count);
        indexVal = 0;
        tmpIndexVal = 0;
        fieldVal = 0;
        tmpFieldVal = 0;
        valueVal = 0;
        tmpValueVal = 0;
        this.valueChanged = false;
        this.dynArrayChanged = false;
        this.dynArray = new Vector<E>();
        if (item != null && this.count != 0) ** GOTO lbl40
        return;
lbl-1000:
        // 1 sources

        {
            aFieldVector = new Vector<Vector<E>>();
            this.dynArray.addElement(aFieldVector);
            tmpIndexVal = UniString.indexOf(item, this.getMarkByte(1), indexVal);
            field = tmpIndexVal != -1 ? UniString.subByteArray(item, indexVal, tmpIndexVal) : UniString.subByteArray(item, indexVal, this.count);
            fieldVal = 0;
            while (fieldVal != -1) {
                aValueVector = new Vector<byte[]>();
                aFieldVector.addElement(aValueVector);
                tmpFieldVal = UniString.indexOf(field, this.getMarkByte(2), fieldVal);
                value = tmpFieldVal != -1 ? UniString.subByteArray(field, fieldVal, tmpFieldVal) : UniString.subByteArray(field, fieldVal, field.length);
                valueVal = 0;
                while (valueVal != -1) {
                    tmpValueVal = UniString.indexOf(value, this.getMarkByte(3), valueVal);
                    subvalue = tmpValueVal != -1 ? UniString.subByteArray(value, valueVal, tmpValueVal) : UniString.subByteArray(value, valueVal, value.length);
                    aValueVector.addElement(subvalue);
                    if (tmpValueVal != -1) {
                        // empty if block
                    }
                    valueVal = ++tmpValueVal;
                }
                if (tmpFieldVal != -1) {
                    // empty if block
                }
                fieldVal = ++tmpFieldVal;
            }
            if (tmpIndexVal != -1) {
                // empty if block
            }
            indexVal = ++tmpIndexVal;
lbl40:
            // 2 sources

            ** while (indexVal != -1)
        }
lbl41:
        // 1 sources

    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert(UniConnection aConnection, Object aReplaceChars, Object aReplaceWithChars) throws UniStringException {
        UniString uniString = this;
        synchronized (uniString) {
            if (!aConnection.isNLSEnabled()) {
                this.convert(aReplaceChars, aReplaceWithChars);
            }
            String replaceChars = aReplaceChars.toString();
            String replaceWithChars = aReplaceWithChars.toString();
            try {
                this.uniConnection = aConnection;
                if (this.inPacket == null || this.outPacket == null) {
                    this.inPacket = new UniRPCPacket(this.uniConnection.connection);
                    this.outPacket = new UniRPCPacket(this.uniConnection.connection);
                }
                this.outPacket.write(0, 9);
                this.outPacket.write(1, this.encode(replaceChars));
                this.outPacket.write(2, this.encode(replaceWithChars));
                this.outPacket.write(3, this.getBytes());
                this.uniConnection.connection.call(this.outPacket, this.inPacket, (byte)this.uniConnection.getDefaultEncryptionType());
                int returnCode = this.inPacket.readInteger(0);
                if (returnCode != 0) {
                    throw new UniStringException(returnCode);
                }
                byte[] tmpValue = this.inPacket.readBytes(1);
                this.checkChanged();
                this.count = 0;
                this.append(tmpValue);
            }
            catch (UniRPCException e) {
                throw new UniStringException(e.getErrorCode());
            }
        }
    }

    public synchronized void convert(Object aReplaceChars, Object aReplaceWithChars) throws UniStringException {
        char[] replaceChars = aReplaceChars.toString().toCharArray();
        char[] replaceWithChars = aReplaceWithChars.toString().toCharArray();
        int replaceLen = aReplaceChars.toString().length();
        int replaceWithLen = aReplaceWithChars.toString().length();
        boolean replaced = false;
        this.checkBytesChanged();
        int numFields = this.dynArray.size();
        int i = 0;
        while (i < numFields) {
            Vector anAttribute = (Vector)this.dynArray.elementAt(i);
            int numValues = anAttribute.size();
            int j = 0;
            while (j < numValues) {
                Vector aValue = (Vector)anAttribute.elementAt(j);
                int numSubValues = aValue.size();
                int k = 0;
                while (k < numSubValues) {
                    byte[] bytes = (byte[])aValue.elementAt(k);
                    char[] chars = this.decode(bytes);
                    char[] newchars = new char[chars.length];
                    int newsize = 0;
                    boolean changedFlag = false;
                    replaced = false;
                    int j1 = 0;
                    while (j1 < chars.length) {
                        int i1 = 0;
                        while (i1 < replaceLen) {
                            if (chars[j1] == replaceChars[i1]) {
                                if (i1 < replaceWithLen) {
                                    newchars[newsize++] = replaceWithChars[i1];
                                    replaced = true;
                                }
                                changedFlag = true;
                                break;
                            }
                            ++i1;
                        }
                        if (!changedFlag) {
                            newchars[newsize++] = chars[j1];
                        }
                        changedFlag = false;
                        ++j1;
                    }
                    if (replaced) {
                        bytes = this.encode(newchars, 0, newsize);
                        aValue.set(k, bytes);
                        this.dynArrayChanged = true;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    protected void collapseDynArray() {
        int numFields = this.dynArray.size();
        UniString newstring = new UniString(this.byteValue.length);
        int i = 0;
        while (i < numFields) {
            Vector anAttribute = (Vector)this.dynArray.elementAt(i);
            int numValues = anAttribute.size();
            int j = 0;
            while (j < numValues) {
                Vector aValue = (Vector)anAttribute.elementAt(j);
                int numSubValues = aValue.size();
                int k = 0;
                while (k < numSubValues) {
                    byte[] bytes = (byte[])aValue.elementAt(k);
                    newstring.append(bytes);
                    if (k != numSubValues - 1) {
                        newstring.append(this.getMarkByte(3));
                    }
                    ++k;
                }
                if (j != numValues - 1) {
                    newstring.append(this.getMarkByte(2));
                }
                ++j;
            }
            if (i < numFields - 1) {
                newstring.append(this.getMarkByte(1));
            }
            ++i;
        }
        this.byteValue = newstring.getBytes();
        this.count = this.byteValue.length;
        this.valueChanged = false;
        this.dynArrayChanged = false;
    }

    public int count() {
        return this.count(this.getMarkByte(1));
    }

    private int count(byte mark) {
        this.checkDynChanged();
        int counter = 0;
        int i = 0;
        while (i < this.count) {
            if (this.byteValue[i] == mark) {
                ++counter;
            }
            ++i;
        }
        return counter;
    }

    public int count(Object aSubString) {
        String subString = aSubString.toString();
        String stringVal = this.toString();
        int subStringLen = subString.length();
        int curIndex = stringVal.indexOf(subString);
        int curCount = 0;
        if (stringVal.equals("")) {
            return 0;
        }
        if (subStringLen == 0) {
            return stringVal.length();
        }
        if (curIndex != -1) {
            ++curCount;
            while (curIndex != -1) {
                curIndex = stringVal.indexOf(subString, curIndex + subStringLen);
                ++curCount;
            }
            --curCount;
        }
        return curCount;
    }

    public int dcount() {
        return this.count() + 1;
    }

    public int dcount(Object aSubString) {
        String stringVal = this.toString();
        if (stringVal.equals("")) {
            return 0;
        }
        return this.count(aSubString) + 1;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject != null) {
            if (anObject instanceof String) {
                return anObject.toString().equals(this.toString());
            }
            if (anObject instanceof UniString || anObject instanceof UniDynArray) {
                byte[] ba2;
                byte[] ba1 = this.getBytes();
                if (ba1.length != (ba2 = ((UniString)anObject).getBytes()).length) {
                    return false;
                }
                int i = 0;
                while (i < ba1.length) {
                    if (ba1[i] != ba2[i]) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public boolean equalsIgnoreCase(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject != null && (anObject instanceof String || anObject instanceof UniString || anObject instanceof UniDynArray)) {
            return anObject.toString().equalsIgnoreCase(this.toString());
        }
        return false;
    }

    public byte[] getBytes() {
        this.checkDynChanged();
        byte[] ba = new byte[this.count];
        System.arraycopy(this.byteValue, 0, ba, 0, this.count);
        return ba;
    }

    public synchronized void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) throws UniStringException {
        if (srcBegin < 0 || srcBegin >= this.count) {
            throw new UniStringException(14022);
        }
        if (srcEnd < 0 || srcEnd > this.count) {
            throw new UniStringException(14022);
        }
        this.checkChanged();
        if (srcBegin < srcEnd) {
            System.arraycopy(this.charValue, srcBegin, dst, dstBegin, srcEnd - srcBegin);
        }
    }

    public String getMarkCharacter(int aTokenVal) throws UniStringException {
        if (aTokenVal < 0 || aTokenVal > 4) {
            throw new UniStringException(14022);
        }
        if (this.uniConnection != null) {
            try {
                return this.uniConnection.getMarkCharacter(aTokenVal);
            }
            catch (UniConnectionException e) {
                throw new UniStringException(e.getErrorCode());
            }
        }
        return UniTokens.defaultMarkArray[aTokenVal];
    }

    public byte getMarkByte(int aTokenVal) {
        return this.marks[aTokenVal];
    }

    public synchronized UniString iconv(UniConnection aConnection, Object aConvCode) throws UniStringException {
        this.uniStatus = 0;
        try {
            this.uniConnection = aConnection;
            if (this.inPacket == null || this.outPacket == null) {
                this.inPacket = new UniRPCPacket(this.uniConnection.connection);
                this.outPacket = new UniRPCPacket(this.uniConnection.connection);
            }
            this.outPacket.write(0, 26);
            this.outPacket.write(1, this.getBytes());
            this.outPacket.write(2, this.encode(aConvCode.toString()));
            this.uniConnection.connection.call(this.outPacket, this.inPacket, (byte)this.uniConnection.getDefaultEncryptionType());
            if (this.inPacket.readInteger(0) == 0) {
                this.uniStatus = this.inPacket.readInteger(1);
                if (this.uniStatus == 0) {
                    UniString tmpString = new UniString(aConnection, this.inPacket.readBytes(2));
                    tmpString.uniStatus = this.uniStatus;
                    return tmpString;
                }
            }
            return this;
        }
        catch (UniException e) {
            throw new UniStringException(e.getErrorCode());
        }
    }

    public synchronized void insert(int offset, Object obj) {
        byte[] insertBytes = this.getByteValue(obj);
        if (insertBytes == null) {
            return;
        }
        this.insert(offset, insertBytes);
    }

    private void insert(int byteOffset, byte[] bytes) {
        this.checkDynChanged();
        if (byteOffset > this.count) {
            byteOffset = this.count;
        }
        if (byteOffset < 0) {
            byteOffset = 0;
        }
        this.ensureCapacity(this.count + bytes.length);
        System.arraycopy(this.byteValue, byteOffset, this.byteValue, byteOffset + bytes.length, this.count - byteOffset);
        System.arraycopy(bytes, 0, this.byteValue, byteOffset, bytes.length);
        this.count += bytes.length;
        this.valueChanged = true;
    }

    public synchronized void insert(int offset, char[] str) {
        byte[] ba;
        if (offset < 0) {
            offset = 0;
        } else {
            char[] ca = this.decode(this.byteValue, 0, this.count);
            if (offset >= ca.length) {
                offset = this.count;
            } else {
                ba = this.encode(ca, 0, offset);
                offset = ba.length;
            }
        }
        ba = this.encode(str);
        this.insert(offset, ba);
    }

    public void insert(int offset, boolean b) {
        this.insert(offset, String.valueOf(b));
    }

    public synchronized void insert(int offset, char c) {
        char[] chars = new char[]{c};
        this.insert(offset, chars);
    }

    public synchronized void insert(int offset, int i) {
        this.insert(offset, String.valueOf(i));
    }

    public synchronized void insert(int offset, long l) {
        this.insert(offset, String.valueOf(l));
    }

    public synchronized void insert(int offset, float f) {
        this.insert(offset, String.valueOf(f));
    }

    public synchronized void insert(int offset, double d) {
        this.insert(offset, String.valueOf(d));
    }

    public UniString left(int aNumChars) {
        this.checkChanged();
        if (aNumChars < 0) {
            return new UniString("");
        }
        if (aNumChars > this.charValue.length) {
            return new UniString(this);
        }
        char[] tmpValue = new char[aNumChars];
        System.arraycopy(this.charValue, 0, tmpValue, 0, aNumChars);
        return new UniString(this.uniConnection, this.encode(tmpValue));
    }

    public int length() {
        if (this.count <= 0) {
            return 0;
        }
        this.checkChanged();
        return this.charValue.length;
    }

    public synchronized UniString oconv(UniConnection aConnection, Object aConvCode) throws UniStringException {
        this.uniStatus = 0;
        try {
            this.uniConnection = aConnection;
            if (this.inPacket == null || this.outPacket == null) {
                this.inPacket = new UniRPCPacket(this.uniConnection.connection);
                this.outPacket = new UniRPCPacket(this.uniConnection.connection);
            }
            this.outPacket.write(0, 33);
            this.outPacket.write(1, this.getBytes());
            this.outPacket.write(2, this.encode(aConvCode.toString()));
            this.uniConnection.connection.call(this.outPacket, this.inPacket, (byte)this.uniConnection.getDefaultEncryptionType());
            this.uniReturnCode = this.inPacket.readInteger(0);
            if (this.uniReturnCode == 0) {
                this.uniStatus = this.inPacket.readInteger(1);
                UniString tmpString = new UniString(aConnection, this.inPacket.readBytes(2));
                tmpString.uniStatus = this.uniStatus;
                return tmpString;
            }
            return this;
        }
        catch (UniRPCException e) {
            throw new UniStringException(e.getErrorCode());
        }
    }

    public void quote() {
        this.quote("'");
    }

    public synchronized void quote(Object aChar) {
        String quoteString = aChar.toString();
        this.insert(0, quoteString);
        this.append(quoteString);
    }

    public UniString right(int aNumChars) {
        this.checkChanged();
        if (aNumChars < 0) {
            return new UniString("");
        }
        if (aNumChars > this.charValue.length) {
            return new UniString(this);
        }
        char[] tmpValue = new char[aNumChars];
        System.arraycopy(this.charValue, this.charValue.length - aNumChars, tmpValue, 0, aNumChars);
        return new UniString(this.uniConnection, this.encode(tmpValue));
    }

    public synchronized void setCharAt(int index, char ch) throws UniStringException {
        if (index < 0 || index >= this.charValue.length) {
            throw new UniStringException(14022);
        }
        this.checkChanged();
        this.charValue[index] = ch;
        this.count = 0;
        this.append(this.encode(this.charValue));
    }

    public synchronized void setValue(String newValue) {
        this.checkChanged();
        this.count = 0;
        this.append(this.encode(newValue));
    }

    public void setValue(Object newValue) {
        if (newValue instanceof UniString) {
            this.setValue((UniString)newValue);
        } else if (newValue instanceof byte[]) {
            this.setValue((byte[])newValue);
        } else {
            this.setValue(newValue.toString());
        }
    }

    private void setValue(UniString aString) {
        this.uniConnection = aString.uniConnection;
        if (this.uniConnection != null) {
            this.setMarks(this.uniConnection.getByteMarks());
            this.setEncoding(this.uniConnection.getEncoding());
        }
        this.byteValue = aString.getBytes();
        this.count = this.byteValue.length;
    }

    private void setValue(byte[] bytes) {
        this.checkChanged();
        this.count = 0;
        this.append(bytes);
    }

    public int status() {
        return this.uniStatus;
    }

    public UniString substring(int aBeginIndex) throws UniStringException {
        this.checkChanged();
        return this.substring(aBeginIndex, this.charValue.length);
    }

    public UniString substring(int aBeginPoint, int aEndPoint) throws UniStringException {
        this.checkChanged();
        if (aBeginPoint > this.charValue.length || aEndPoint < 0 || aBeginPoint > aEndPoint) {
            throw new UniStringException(14022);
        }
        if (aBeginPoint < 0) {
            aBeginPoint = 0;
        }
        if (aEndPoint > this.charValue.length) {
            aEndPoint = this.charValue.length;
        }
        return new UniString(this.uniConnection, new String(this.charValue, aBeginPoint, aEndPoint - aBeginPoint));
    }

    public char[] toCharArray() {
        this.checkChanged();
        return this.charValue;
    }

    public UniString toLowerCase() {
        return new UniString(this.uniConnection, this.toString().toLowerCase());
    }

    public UniString toUpperCase() {
        return new UniString(this.uniConnection, this.toString().toUpperCase());
    }

    public String toString() {
        this.checkChanged();
        return new String(this.charValue);
    }

    private synchronized void ensureCapacity(int minimumCapacity) {
        int maxCapacity = this.byteValue.length;
        if (minimumCapacity > maxCapacity) {
            int newCapacity = (maxCapacity + 1) * 2;
            if (minimumCapacity > newCapacity) {
                newCapacity = minimumCapacity;
            }
            byte[] newValue = new byte[newCapacity];
            System.arraycopy(this.byteValue, 0, newValue, 0, maxCapacity);
            this.byteValue = newValue;
        }
    }

    protected void setEncoding(String encoding) {
        if (encoding.compareToIgnoreCase(this.encoding) != 0 && Charset.isSupported(encoding)) {
            this.charset = Charset.forName(encoding);
            this.encoding = encoding;
        }
    }

    protected void setMarks(byte[] marks) {
        this.marks = marks;
    }

    protected void regenerateDynArray() {
        this.collapseDynArray();
        this.constructDynArray();
    }

    protected char[] decode(byte[] bytes) {
        return this.decode(bytes, 0, bytes.length);
    }

    protected char[] decode(byte[] bytes, int offset, int len) {
        CharBuffer cb = this.charset.decode(ByteBuffer.wrap(bytes, offset, len));
        char[] ca = new char[cb.limit()];
        cb.get(ca);
        return ca;
    }

    protected byte[] encode(String string) {
        return this.encode(string.toCharArray());
    }

    protected byte[] encode(char[] str) {
        return this.encode(str, 0, str.length);
    }

    protected byte[] encode(char[] str, int offset, int len) {
        ByteBuffer bb = this.charset.encode(CharBuffer.wrap(str, offset, len));
        byte[] ba = new byte[bb.limit()];
        bb.get(ba);
        return ba;
    }

    byte[] getByteValue(Object aString) {
        if (aString instanceof byte[]) {
            return (byte[])aString;
        }
        if (aString instanceof UniString) {
            return ((UniString)aString).getBytes();
        }
        String insertString = aString.toString();
        if (insertString.equals("")) {
            return new byte[0];
        }
        return this.encode(insertString);
    }
}

