/*
 * Decompiled with CFR 0.152.
 */
package asjava.uniclientlibs;

import asjava.uniclientlibs.UniByteArrayTokenizer;
import asjava.uniclientlibs.UniConnection;
import asjava.uniclientlibs.UniDynArray;
import asjava.uniclientlibs.UniRecord;
import asjava.uniclientlibs.UniString;
import asjava.uniclientlibs.UniStringTokenizer;
import asjava.uniclientlibs.UniTokens;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Vector;

public class UniDataSet
implements Serializable {
    private static final int DEFAULT_FORMAT = 0;
    private static final int NOT_FOUND = -1;
    private int currentRow = 0;
    private int LAST_ROW = 0;
    protected int formatType = 0;
    protected Vector rowSet = new Vector();
    protected UniConnection uniConnection = null;

    public UniDataSet() {
        this.formatType = 0;
    }

    public UniDataSet(Object initVal) {
        this(initVal, UniTokens.AT_FM);
    }

    public UniDataSet(Object initVal, String delimiter) {
        this();
        String setString = initVal == null ? new String() : initVal.toString();
        UniStringTokenizer setTok = new UniStringTokenizer(setString, delimiter);
        int numTokens = setTok.countTokens();
        int i = 0;
        while (i < numTokens) {
            UniRecord newRec = new UniRecord((Object)setTok.nextToken());
            this.append(newRec);
            ++i;
        }
    }

    public UniDataSet(UniConnection aConn) {
        this.formatType = 0;
        this.uniConnection = aConn;
    }

    public UniDataSet(UniDynArray dyn) {
        int nFields = dyn.dcount();
        this.uniConnection = dyn.uniConnection;
        int i = 0;
        while (i < nFields) {
            UniRecord newRec = new UniRecord((UniString)dyn.extract(i + 1));
            this.append(newRec);
            ++i;
        }
    }

    public UniDataSet(UniDataSet origSet, UniDynArray newSet, UniDynArray retSet, UniDynArray statSet, int returnCode) {
        this.formatType = origSet.formatType;
        this.uniConnection = origSet.uniConnection;
        if (newSet == null) {
            newSet = new UniDynArray(origSet.uniConnection);
        }
        if (retSet == null) {
            retSet = new UniDynArray(origSet.uniConnection);
        }
        if (statSet == null) {
            statSet = new UniDynArray(origSet.uniConnection);
        }
        UniDynArray origIdSet = origSet.getIDSetUniDynArray();
        byte delimiter = newSet.getMarkByte(0);
        UniByteArrayTokenizer origSetok = new UniByteArrayTokenizer(origIdSet.getBytes(), delimiter);
        UniByteArrayTokenizer newSettok = new UniByteArrayTokenizer(newSet.getBytes(), delimiter);
        UniByteArrayTokenizer retSettok = new UniByteArrayTokenizer(retSet.getBytes(), delimiter);
        UniByteArrayTokenizer statSettok = new UniByteArrayTokenizer(statSet.getBytes(), delimiter);
        int numTokens = origSet.getRowCount();
        int i = 0;
        while (i < numTokens) {
            try {
                UniString recVal = new UniString(this.uniConnection, retSettok.nextToken());
                int retCode = recVal == null ? returnCode : Integer.parseInt(recVal.toString());
                recVal = new UniString(this.uniConnection, statSettok.nextToken());
                int status = recVal == null ? 0 : Integer.parseInt(recVal.toString());
                recVal = new UniString(this.uniConnection, newSettok.nextToken());
                UniRecord newRec = recVal == null ? new UniRecord(new UniString(this.uniConnection, origSetok.nextToken()), new UniString(this.uniConnection), status) : new UniRecord(new UniString(this.uniConnection, origSetok.nextToken()), recVal, status);
                newRec.setReturnCode(retCode);
                this.append(newRec);
            }
            catch (NoSuchElementException noSuchElementException) {
                UniRecord newRec = new UniRecord("", "", -1);
                this.append(newRec);
            }
            ++i;
        }
    }

    public boolean absolute(int rowNum) {
        this.currentRow = rowNum < 0 ? this.getRowCount() + rowNum : rowNum;
        if (this.currentRow < 0) {
            this.first();
            return false;
        }
        if (this.currentRow >= this.getRowCount()) {
            this.afterLast();
            return false;
        }
        return true;
    }

    public void afterLast() {
        this.currentRow = this.getRowCount();
    }

    public boolean append(Object rowID) {
        return this.append(rowID, "");
    }

    public boolean append(Object rowID, Object rowData) {
        UniRecord recordSet = new UniRecord(rowID, rowData);
        return this.append(recordSet);
    }

    public boolean append(UniRecord recordSet) {
        return this.insert(this.getRowCount() + 1, recordSet);
    }

    public void close() {
        this.first();
        this.formatType = 0;
        this.LAST_ROW = 0;
        this.rowSet.removeAllElements();
    }

    public boolean deleteRow() {
        return this.deleteRow(this.currentRow);
    }

    public boolean deleteRow(int indexLoc) {
        if (this.getRowCount() == 0) {
            return false;
        }
        if (indexLoc < 0) {
            indexLoc = 0;
        }
        if (indexLoc >= this.getRowCount()) {
            indexLoc = this.getRowCount() - 1;
        }
        this.rowSet.removeElementAt(indexLoc);
        --this.LAST_ROW;
        return true;
    }

    public boolean deleteRow(String recordID) {
        int rowID = this.findRow(recordID);
        if (rowID < 0) {
            return false;
        }
        return this.deleteRow(rowID);
    }

    public int findRow(String aRowVal) {
        int rowPos = 0;
        while (rowPos < this.getRowCount()) {
            UniRecord recordSet = (UniRecord)this.rowSet.elementAt(rowPos);
            UniDynArray recID = recordSet.getRecordID();
            if (recID.equals(aRowVal)) break;
            ++rowPos;
        }
        if (rowPos >= this.getRowCount()) {
            return -1;
        }
        return rowPos;
    }

    public void first() {
        this.currentRow = 0;
    }

    public int getCurrentRow() {
        return this.currentRow;
    }

    public String getDataSet() {
        StringBuffer x = new StringBuffer();
        int rowCount = this.getRowCount();
        int i = 0;
        while (i < rowCount) {
            UniRecord y = (UniRecord)this.rowSet.elementAt(i);
            x.append(y.getRecord());
            if (i != rowCount - 1) {
                x.append(UniTokens.AT_IM);
            }
            ++i;
        }
        return x.toString();
    }

    public UniDynArray getDataSetUniDynArray() {
        UniDynArray x = new UniDynArray(this.uniConnection);
        int rowCount = this.getRowCount();
        int i = 0;
        while (i < rowCount) {
            UniRecord y = (UniRecord)this.rowSet.elementAt(i);
            x.append(y.getRecord());
            if (i != rowCount - 1) {
                x.append(x.getMarkByte(0));
            }
            ++i;
        }
        return x;
    }

    public String getIDSet() {
        StringBuffer x = new StringBuffer();
        int rowCount = this.getRowCount();
        int i = 0;
        while (i < rowCount) {
            UniRecord y = (UniRecord)this.rowSet.elementAt(i);
            x.append(y.getRecordID());
            if (i != rowCount - 1) {
                x.append(UniTokens.AT_IM);
            }
            ++i;
        }
        return x.toString();
    }

    public UniDynArray getIDSetUniDynArray() {
        UniDynArray x = new UniDynArray(this.uniConnection);
        int rowCount = this.getRowCount();
        int i = 0;
        while (i < rowCount) {
            UniRecord y = (UniRecord)this.rowSet.elementAt(i);
            x.append(y.getRecordID());
            if (i != rowCount - 1) {
                x.append(x.getMarkByte(0));
            }
            ++i;
        }
        return x;
    }

    String getString() {
        return this.getString(this.currentRow);
    }

    public String getString(int columnIndex) {
        if (columnIndex < 0) {
            columnIndex = 0;
        }
        if (columnIndex >= this.getRowCount()) {
            columnIndex = this.getRowCount() - 1;
        }
        UniRecord recordSet = (UniRecord)this.rowSet.elementAt(this.currentRow);
        return recordSet.toString();
    }

    public String getString(String columnName) {
        int columnIndex = this.findRow(columnName);
        return this.getString(columnIndex);
    }

    public UniDynArray getUniDynArray() {
        return this.getUniDynArray(this.currentRow);
    }

    public UniDynArray getUniDynArray(int indexLoc) {
        if (indexLoc < 0) {
            indexLoc = 0;
        }
        if (indexLoc >= this.getRowCount()) {
            indexLoc = this.getRowCount() - 1;
        }
        UniRecord recordSet = (UniRecord)this.rowSet.elementAt(indexLoc);
        return recordSet.toUniDynArray();
    }

    public UniDynArray getUniDynArray(String columnName) {
        int columnIndex = this.findRow(columnName);
        return this.getUniDynArray(columnIndex);
    }

    public UniRecord getUniRecord() {
        return this.getUniRecord(this.currentRow);
    }

    public UniRecord getUniRecord(int indexLoc) {
        if (indexLoc < 0) {
            indexLoc = 0;
        }
        if (indexLoc >= this.getRowCount()) {
            indexLoc = this.getRowCount() - 1;
        }
        UniRecord recordSet = (UniRecord)this.rowSet.elementAt(indexLoc);
        return recordSet;
    }

    public UniRecord getUniRecord(String columnName) {
        int columnIndex = this.findRow(columnName);
        return this.getUniRecord(columnIndex);
    }

    public UniString getUniString() {
        return this.getUniString(this.currentRow);
    }

    public UniString getUniString(int indexLoc) {
        if (indexLoc < 0) {
            indexLoc = 0;
        }
        if (indexLoc >= this.getRowCount()) {
            indexLoc = this.getRowCount() - 1;
        }
        UniRecord recordSet = (UniRecord)this.rowSet.elementAt(indexLoc);
        return recordSet.toUniString();
    }

    public UniString getUniString(String columnName) {
        int columnIndex = this.findRow(columnName);
        return this.getUniString(columnIndex);
    }

    public int getRowCount() {
        return this.LAST_ROW;
    }

    public boolean insert(Object rowVal) {
        return this.insert(this.currentRow, rowVal);
    }

    public boolean insert(int indexLoc, Object rowID) {
        return this.insert(indexLoc, rowID, "");
    }

    public boolean insert(Object rowID, Object rowVal) {
        return this.insert(this.currentRow, rowID, rowVal);
    }

    public boolean insert(int indexLoc, Object rowID, Object rowVal) {
        UniRecord recordSet = new UniRecord(rowID, rowVal);
        return this.insert(indexLoc, recordSet);
    }

    public boolean insert(UniRecord recordSet) {
        return this.insert(this.currentRow, recordSet);
    }

    public boolean insert(int indexLoc, UniRecord recordSet) {
        if (indexLoc < 0) {
            indexLoc = 0;
        }
        if (indexLoc > this.getRowCount()) {
            this.rowSet.addElement(recordSet);
        } else {
            this.rowSet.insertElementAt(recordSet, indexLoc);
        }
        ++this.LAST_ROW;
        return true;
    }

    public boolean isAfterLast() {
        return this.currentRow >= this.getRowCount();
    }

    public boolean isBeforeFirst() {
        return this.currentRow < 0;
    }

    public boolean isFirst() {
        return this.currentRow == 0;
    }

    public boolean isLast() {
        return this.currentRow == this.getRowCount() - 1;
    }

    public void last() {
        this.currentRow = this.getRowCount() - 1;
    }

    public boolean next() {
        ++this.currentRow;
        if (this.currentRow >= this.getRowCount()) {
            this.afterLast();
            return false;
        }
        return true;
    }

    public boolean previous() {
        --this.currentRow;
        if (this.currentRow < 0) {
            this.first();
            return false;
        }
        return true;
    }

    public boolean relative(int numRows) {
        this.currentRow += numRows;
        if (this.currentRow < 0) {
            this.first();
            return false;
        }
        if (this.currentRow >= this.getRowCount()) {
            this.afterLast();
            return false;
        }
        return true;
    }

    public boolean setIndex(int indexLoc) {
        if (indexLoc < 0 || indexLoc >= this.getRowCount()) {
            return false;
        }
        this.currentRow = indexLoc;
        return true;
    }

    public String toString() {
        StringBuffer x = new StringBuffer();
        int rowCount = this.getRowCount();
        int i = 0;
        while (i < rowCount) {
            UniRecord recordSet = (UniRecord)this.rowSet.elementAt(i);
            x.append(recordSet.toString());
            ++i;
        }
        return x.toString();
    }
}

