/*
 * Decompiled with CFR 0.152.
 */
package asjava.uniclientlibs;

import asjava.uniclientlibs.UniConnectionException;
import asjava.uniclientlibs.UniTokens;
import asjava.uniobjects.UniJava;
import asjava.unirpc.UniRPCConnection;
import asjava.unirpc.UniRPCConnectionException;
import asjava.unirpc.UniRPCPacket;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public abstract class UniConnection {
    public static final String clientEncoding = System.getProperty("clientencoding");
    public UniRPCConnection connection;
    protected UniRPCPacket inPacket;
    protected UniRPCPacket outPacket;
    protected String accountPath = null;
    protected String hostName = null;
    protected String password = null;
    protected String userName = null;
    protected String[] uniMarkCharacters;
    protected byte[] uniMarkBytes = UniTokens.b_marks;
    protected String uniConnectionString = "defcs";
    protected String uniDataSourceType = "UNIVERSE";
    protected String proxyHost = null;
    protected String proxySecurityToken = "";
    protected String licenseToken = "";
    protected String uniSubKey = "";
    protected int hostPort = 31438;
    protected int proxyPort = 31448;
    protected int transport = 1;
    protected int compressionThreshold = 0;
    protected int timeout = UniJava.getSocketTimeout();
    protected int encryptionType = 0;
    protected int hostType = 0;
    protected boolean isNLSEnabled = false;
    protected boolean isNLSLocalesEnabled = false;
    protected boolean isActive = false;
    protected boolean isRPCError = false;
    protected boolean isNLSUnidataSession = false;
    protected Charset charset = Charset.forName(System.getProperty("file.encoding"));
    protected String encoding = System.getProperty("file.encoding");

    public UniConnection() {
        if (clientEncoding != null) {
            try {
                this.setEncoding(clientEncoding);
            }
            catch (UniConnectionException uniConnectionException) {}
        }
    }

    public String getAccountPath() {
        return this.accountPath;
    }

    public int getCompressionThreshold() {
        return this.compressionThreshold;
    }

    public String getConnectionString() {
        return this.uniConnectionString;
    }

    public String getDataSourceType() {
        return this.uniDataSourceType;
    }

    public int getDefaultEncryptionType() {
        return this.encryptionType;
    }

    public String getDeviceSubkey() {
        return this.uniSubKey;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getHostPort() {
        return this.hostPort;
    }

    public int getHostType() {
        return this.hostType;
    }

    public int getServerVersion() {
        if (this.connection != null) {
            return this.connection.getVersionCurrent();
        }
        return -1;
    }

    public String getMarkCharacter(int aMarkChar) throws UniConnectionException {
        if (aMarkChar < 0 || aMarkChar > 5) {
            throw new UniConnectionException("Mark Character  must be between IM-SQLNULL", 14022);
        }
        return this.uniMarkCharacters[aMarkChar];
    }

    public String getPassword() {
        return this.password;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyToken() {
        return this.proxySecurityToken;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getTransport() {
        return this.transport;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isCompressionEnabled() {
        if (this.connection != null) {
            return this.connection.isCompressionSupported();
        }
        return false;
    }

    public boolean isEncryptionEnabled() {
        if (this.connection != null) {
            return this.connection.isEncryptionSupported();
        }
        return false;
    }

    public boolean isNLSEnabled() {
        return this.isNLSEnabled;
    }

    public boolean isNLSLocalesEnabled() {
        return this.isNLSLocalesEnabled;
    }

    public void setAccountPath(Object aAccountPath) {
        if (aAccountPath != null && !this.isActive) {
            this.accountPath = aAccountPath.toString();
        }
    }

    public void setAccountPath(String aAccountPath) {
        if (aAccountPath != null && !this.isActive) {
            this.accountPath = aAccountPath;
        }
    }

    public void setCompressionThresholdInt(int aCompressionThresholdVal) throws UniConnectionException {
        if (!this.isCompressionEnabled()) {
            throw new UniConnectionException(81026);
        }
        if (aCompressionThresholdVal < 0) {
            throw new UniConnectionException("Compression threshold must be a positive value", 14022);
        }
        this.compressionThreshold = aCompressionThresholdVal;
    }

    public void setConnectionString(Object connString) {
        if (connString != null && !this.isActive) {
            this.setConnectionString(connString.toString());
        }
    }

    public void setConnectionString(String connString) {
        if (connString != null && !this.isActive) {
            this.uniConnectionString = connString;
        }
    }

    public void setDataSourceType(Object dataSourceType) throws UniConnectionException {
        if (dataSourceType == null) {
            return;
        }
        this.setDataSourceType(dataSourceType.toString());
    }

    public void setDataSourceType(String dataSourceType) throws UniConnectionException {
        if (dataSourceType == null) {
            return;
        }
        if (dataSourceType.equalsIgnoreCase("UNIVERSE")) {
            this.setConnectionString("uvcs");
            this.uniDataSourceType = dataSourceType.toUpperCase();
        } else if (dataSourceType.equalsIgnoreCase("UNIDATA")) {
            this.setConnectionString("udcs");
            this.uniDataSourceType = dataSourceType.toUpperCase();
        } else {
            throw new UniConnectionException(String.valueOf(dataSourceType) + " is an invalid DataSourceType.", 14022);
        }
    }

    public void setDefaultEncryptionTypeInt(int aType) throws UniConnectionException {
        if (!this.isEncryptionEnabled()) {
            throw new UniConnectionException(81025);
        }
        switch (aType) {
            case 0: 
            case 1: {
                this.encryptionType = aType;
                break;
            }
            default: {
                throw new UniConnectionException("Invalid Encryption Type", 14022);
            }
        }
    }

    public void setDeviceSubkey(Object subKey) {
        if (subKey != null) {
            this.uniSubKey = subKey.toString();
        }
    }

    public void setHostName(String aHostName) {
        if (aHostName != null && !this.isActive) {
            this.hostName = aHostName;
        }
    }

    public void setHostName(Object aHostName) {
        if (aHostName != null && !this.isActive) {
            this.hostName = aHostName.toString();
        }
    }

    public void setHostPort(int aHostPort) {
        if (!this.isActive) {
            this.hostPort = aHostPort;
        }
    }

    public void setPassword(Object aPassword) {
        if (aPassword != null && !this.isActive) {
            this.password = aPassword.toString();
        }
    }

    public void setPassword(String aPassword) {
        if (aPassword != null && !this.isActive) {
            this.password = aPassword;
        }
    }

    public void setProxyHost(Object aProxyHost) {
        if (aProxyHost != null) {
            this.proxyHost = aProxyHost.toString();
        }
    }

    public void setProxyHost(String aProxyHost) {
        if (aProxyHost != null) {
            this.proxyHost = aProxyHost;
        }
    }

    public void setProxyPort(int aProxyPort) {
        this.proxyPort = aProxyPort;
    }

    public void setProxyToken(Object aProxyToken) {
        if (aProxyToken != null) {
            this.proxySecurityToken = aProxyToken.toString();
        }
    }

    public void setTimeoutInt(int aTimeoutVal) throws UniConnectionException {
        if (aTimeoutVal < 0) {
            throw new UniConnectionException("Timeout value must be a positive value", 14022);
        }
        this.timeout = aTimeoutVal;
        if (this.connection != null) {
            try {
                this.connection.setTimeoutSeconds(this.timeout);
            }
            catch (UniRPCConnectionException e) {
                throw new UniConnectionException(e.getErrorCode());
            }
        }
    }

    public void setTransport(int aTransportType) {
        this.transport = 1;
    }

    public void setUserName(Object aUserName) {
        if (aUserName != null && !this.isActive) {
            this.userName = aUserName.toString();
        }
    }

    protected String encrypt(String aString) {
        if (aString == null) {
            return new String();
        }
        byte[] byteArray = aString.getBytes();
        int i = 0;
        while (i < byteArray.length) {
            byteArray[i] = this.getServerVersion() == 1 ? (byte)(byteArray[i] ^ 3) : (byte)(byteArray[i] ^ 4);
            ++i;
        }
        return new String(byteArray);
    }

    public UniRPCPacket getInPacket() {
        return this.inPacket;
    }

    public UniRPCPacket getOutPacket() {
        return this.outPacket;
    }

    public boolean getRPCError() {
        return this.isRPCError;
    }

    public void setRPCError(boolean isRPCError) {
        this.isRPCError = isRPCError;
    }

    protected String getEncoding() {
        return this.encoding;
    }

    protected void setEncoding(String encoding) throws UniConnectionException {
        if (encoding.compareToIgnoreCase(this.encoding) != 0) {
            if (!Charset.isSupported(encoding)) {
                throw new UniConnectionException(82006);
            }
            this.charset = Charset.forName(encoding);
            this.encoding = encoding;
        }
    }

    public void setByteMarks(byte[] nlsMarkBytes) {
        this.uniMarkBytes = nlsMarkBytes;
    }

    protected byte[] getByteMarks() {
        return this.uniMarkBytes;
    }

    public byte getMarkByte(int markIndex) throws UniConnectionException {
        if (markIndex < 0 || markIndex > 5) {
            throw new UniConnectionException("Mark Byte must be between IM-SQLNULL", 14022);
        }
        return this.uniMarkBytes[markIndex];
    }

    public String decode(byte[] bytes) {
        CharBuffer cb = this.charset.decode(ByteBuffer.wrap(bytes));
        return cb.toString();
    }

    public byte[] encode(String string) {
        ByteBuffer bb = this.charset.encode(CharBuffer.wrap(string));
        byte[] ba = new byte[bb.limit()];
        bb.get(ba);
        return ba;
    }
}

