/*
 * Decompiled with CFR 0.152.
 */
package asjava.uniclientlibs;

import asjava.uniclientlibs.UniString;

public class UniByteArrayTokenizer {
    byte[] bytes = null;
    byte delimiter = (byte)32;
    int curPos = 0;
    int maxPos = 0;

    public UniByteArrayTokenizer(byte[] bytes, byte delimiter) {
        this.bytes = bytes;
        this.delimiter = delimiter;
        this.maxPos = bytes.length;
    }

    public int countTokens() {
        int currpos = 0;
        int count = 1;
        while (currpos < this.maxPos) {
            if (this.bytes[currpos++] != this.delimiter) continue;
            ++count;
        }
        return count;
    }

    public boolean hasMoreTokens() {
        if (this.curPos == -1) {
            return false;
        }
        return this.curPos <= this.maxPos;
    }

    public byte[] nextToken() {
        if (!this.hasMoreTokens()) {
            return null;
        }
        int startPos = this.curPos;
        while (this.curPos < this.maxPos && this.bytes[this.curPos] != this.delimiter) {
            ++this.curPos;
        }
        byte[] subvalue = UniString.subByteArray(this.bytes, startPos, this.curPos);
        ++this.curPos;
        return subvalue;
    }

    public void resetTokenizer() {
        this.curPos = 0;
    }
}

