/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.webserver.paye;

import com.selima.fbi.webserver.ResourceResolver;
import com.selima.fbi.webserver.paye.StaxTools;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;

public class StylesheetAnnotation {
    private static final QName ANNOTATION_QNAME = new QName("xalan://com.selima.fbi.webserver.XalanExtension", "annotation");
    String metadataStylesheet;
    String rewriteFromNS;
    String rewriteToNS;

    public String getRewriteFromNS() {
        return this.rewriteFromNS;
    }

    public String getRewriteToNS() {
        return this.rewriteToNS;
    }

    public String getMetadataStylesheet() {
        return this.metadataStylesheet;
    }

    public static StylesheetAnnotation find(ResourceResolver resourceResolver, String stylesheetPath) throws IOException {
        Map<String, String> annotation = StylesheetAnnotation.annotation(resourceResolver, stylesheetPath);
        if (annotation != null) {
            StylesheetAnnotation result = new StylesheetAnnotation();
            result.rewriteFromNS = annotation.get("rewrite_from_ns");
            result.rewriteToNS = annotation.get("rewrite_to_ns");
            result.metadataStylesheet = annotation.get("metadata");
            if (result.metadataStylesheet != null) {
                result.metadataStylesheet = stylesheetPath.replaceAll("[^/]+$", result.metadataStylesheet);
            }
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, String> annotation(ResourceResolver resourceResolver, String path) throws IOException {
        block8: {
            try (InputStream resourceStream = resourceResolver.resourceStream(path);){
                Map<String, String> map;
                XMLEventReader reader = StaxTools.findOnTop(ANNOTATION_QNAME, resourceStream);
                if (reader == null) break block8;
                try {
                    map = StaxTools.getAttributes(reader.nextEvent().asStartElement());
                }
                catch (Throwable throwable) {
                    try {
                        reader.close();
                        throw throwable;
                    }
                    catch (XMLStreamException e) {
                        throw new IOException(e);
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                }
                reader.close();
                return map;
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("metadata=").append(this.metadataStylesheet).append(" rewrite-from-ns=").append(this.rewriteFromNS).append(" rewrite-to-ns=").append(this.rewriteToNS);
        return result.toString();
    }
}

