/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.webserver.paye;

import com.selima.fbi.webserver.paye.CurrentPosition;
import com.selima.fbi.webserver.paye.CuttingRule;
import com.selima.framework.util.logging.LogAPI;
import java.io.FilterReader;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class PreprocessingThread
extends Thread {
    final String fromNamespace;
    final String toNamespace;
    final boolean cuttingEnabled;
    final Set<CuttingRule> pageRules;
    boolean rewritingEnabled;
    final Reader pipedReader;
    final Reader originalReader;
    final PipedWriter pipedWriter;
    Exception failure;

    public PreprocessingThread(Reader reader, String fromNamespace, String toNamespace, Set<CuttingRule> pageRules) throws IOException {
        super("XML Preprocessing Thread");
        this.setPriority(1);
        this.toNamespace = toNamespace;
        this.fromNamespace = fromNamespace;
        this.cuttingEnabled = pageRules != null && !pageRules.isEmpty();
        this.rewritingEnabled = fromNamespace != null && toNamespace != null;
        this.originalReader = reader;
        this.pipedWriter = new PipedWriter();
        this.pipedReader = new FilterReader(new PipedReader(this.pipedWriter)){

            @Override
            public int read() throws IOException {
                if (PreprocessingThread.this.failure != null) {
                    throw new IOException(PreprocessingThread.this.failure);
                }
                return super.read();
            }

            @Override
            public int read(char[] cbuf, int off, int len) throws IOException {
                if (PreprocessingThread.this.failure != null) {
                    throw new IOException(PreprocessingThread.this.failure);
                }
                return super.read(cbuf, off, len);
            }
        };
        this.pageRules = pageRules;
    }

    public Reader getReader() {
        return this.pipedReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        XMLEventReader xmlReader = null;
        XMLEventWriter xmlWriter = null;
        try {
            XMLOutputFactory outFactory = XMLOutputFactory.newInstance();
            XMLInputFactory inFactory = XMLInputFactory.newInstance();
            XMLEventFactory factory = XMLEventFactory.newInstance();
            xmlReader = inFactory.createXMLEventReader(this.originalReader);
            xmlWriter = outFactory.createXMLEventWriter(this.pipedWriter);
            CurrentPosition currentPosition = new CurrentPosition();
            LinkedList<Characters> whiteSpace = new LinkedList<Characters>();
            while (xmlReader.hasNext()) {
                XMLEvent event = xmlReader.nextEvent();
                if (event.isStartElement()) {
                    if (this.rewritingEnabled) {
                        XMLEvent rewritten = PreprocessingThread.rewriteNamespace(factory, this.fromNamespace, this.toNamespace, event.asStartElement());
                        this.rewritingEnabled = event == rewritten;
                        event = rewritten;
                    }
                    currentPosition.elementStarted(event.asStartElement().getName().getLocalPart());
                    if (this.cuttingEnabled && PreprocessingThread.shouldCut(currentPosition, this.pageRules)) {
                        whiteSpace.clear();
                        PreprocessingThread.cutElement(xmlReader, event.asStartElement());
                        currentPosition.elementFinished(event.asStartElement().getName().getLocalPart());
                        continue;
                    }
                } else if (event.isEndElement()) {
                    currentPosition.elementFinished(event.asEndElement().getName().getLocalPart());
                } else if (event.isCharacters()) {
                    whiteSpace.add(event.asCharacters());
                    continue;
                }
                while (!whiteSpace.isEmpty()) {
                    xmlWriter.add((XMLEvent)whiteSpace.remove());
                }
                xmlWriter.add(event);
            }
        }
        catch (XMLStreamException e) {
            LogAPI.logSevere((Throwable)e);
            this.failure = e;
        }
        finally {
            try {
                xmlWriter.close();
            }
            catch (Exception e) {
                LogAPI.logSevere((Throwable)e);
            }
            try {
                this.pipedWriter.close();
            }
            catch (Exception e) {
                LogAPI.logSevere((Throwable)e);
            }
            try {
                xmlReader.close();
            }
            catch (Exception e) {
                LogAPI.logSevere((Throwable)e);
            }
            try {
                this.originalReader.close();
            }
            catch (Exception e) {
                LogAPI.logSevere((Throwable)e);
            }
        }
    }

    static void cutElement(XMLEventReader xmlReader, StartElement currentElement) throws XMLStreamException {
        int i = 1;
        while (i > 0 && xmlReader.hasNext()) {
            XMLEvent nextEvent = xmlReader.nextEvent();
            if (nextEvent.isStartElement() && nextEvent.asStartElement().getName().equals(currentElement.getName())) {
                ++i;
                continue;
            }
            if (!nextEvent.isEndElement() || !nextEvent.asEndElement().getName().equals(currentElement.getName())) continue;
            --i;
        }
    }

    static boolean shouldCut(CurrentPosition currentPosition, Set<CuttingRule> cuttingRules) {
        block0: for (CuttingRule rule : cuttingRules) {
            if (!currentPosition.matches(rule.exclusionPath)) continue;
            for (String path : rule.exceptionsToExclusion) {
                if (!currentPosition.matches(path)) continue;
                break block0;
            }
            return true;
        }
        return false;
    }

    static XMLEvent rewriteNamespace(XMLEventFactory factory, String fromNamespace, String toNamespace, StartElement event) {
        boolean found = false;
        LinkedList<Namespace> namespaces = new LinkedList<Namespace>();
        Iterator<Namespace> it = event.getNamespaces();
        while (it.hasNext()) {
            Namespace ns = it.next();
            if (fromNamespace != null && ns.getNamespaceURI().matches(fromNamespace)) {
                ns = factory.createNamespace(ns.getPrefix(), toNamespace);
                found = true;
            }
            namespaces.add(ns);
        }
        if (found) {
            QName name = event.getName();
            if (fromNamespace != null && name.getNamespaceURI().matches(fromNamespace)) {
                name = new QName(toNamespace, name.getLocalPart(), name.getPrefix());
            }
            event = factory.createStartElement(name, event.asStartElement().getAttributes(), namespaces.iterator());
        }
        return event;
    }
}

