/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.webserver.paye;

import com.selima.fbi.webserver.paye.ParsedRule;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

class CurrentPosition {
    Stack<String> currentPath = new Stack();
    Stack<Map<String, Integer>> currentIndexes = new Stack();
    final Map<String, ParsedRule> parsedRules;
    static final int ELEMENT_NAME_GROUP = 1;
    static final int ORDINAL_GROUP = 3;

    CurrentPosition() {
        this.currentIndexes.add(new HashMap());
        this.parsedRules = new HashMap<String, ParsedRule>();
    }

    void elementStarted(String localName) {
        this.currentPath.push(localName);
        Map<String, Integer> indexes = this.currentIndexes.peek();
        if (indexes.containsKey(localName)) {
            indexes.put(localName, indexes.get(localName) + 1);
        } else {
            indexes.put(localName, 1);
        }
        this.currentIndexes.push(new HashMap());
    }

    void elementFinished(String localName) {
        assert (localName.equals(this.currentPath.peek()));
        this.currentPath.pop();
        this.currentIndexes.pop();
    }

    boolean matches(String path) {
        ParsedRule rule = this.parsedRules.get(path);
        if (rule == null) {
            rule = new ParsedRule(path);
            this.parsedRules.put(path, rule);
        }
        if (rule.elements.length != this.currentPath.size()) {
            return false;
        }
        block4: for (int i = rule.elements.length - 1; i >= 0; --i) {
            String name = rule.elements[i];
            if (!name.equals(this.currentPath.get(i)) && !name.equals("*")) {
                return false;
            }
            switch (rule.indexes[i]) {
                case -2: {
                    int currentIndex;
                    if (name.equals("*")) {
                        currentIndex = 0;
                        for (Integer count : ((Map)this.currentIndexes.get(i)).values()) {
                            currentIndex += count.intValue();
                        }
                    } else {
                        currentIndex = (Integer)((Map)this.currentIndexes.get(i)).get(name);
                    }
                    return rule.lowerBounds[i] <= currentIndex && currentIndex <= rule.upperBounds[i];
                }
                case -1: {
                    continue block4;
                }
                default: {
                    if (name.equals("*")) {
                        int overalNumber = 0;
                        for (Integer count : ((Map)this.currentIndexes.get(i)).values()) {
                            overalNumber += count.intValue();
                        }
                        if (overalNumber == Integer.valueOf(rule.indexes[i])) continue block4;
                        return false;
                    }
                    if (((Integer)((Map)this.currentIndexes.get(i)).get(name)).equals(rule.indexes[i])) continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.currentPath.size(); ++i) {
            result.append('/').append((String)this.currentPath.get(i)).append('[').append(((Map)this.currentIndexes.get(i)).get(this.currentPath.get(i))).append(']');
        }
        return result.toString();
    }
}

