/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.webserver;

import java.net.URL;
import java.text.Collator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PagePart
implements Cloneable,
Comparable<PagePart> {
    public final URL url;
    public final String id;
    private final Map<String, String> keys;
    private String currentKey;

    public PagePart(String name, String id, URL url) {
        this.currentKey = "default-key";
        this.keys = Collections.singletonMap(this.currentKey, name);
        this.url = url;
        this.id = id;
    }

    public PagePart(Map<String, String> keys, String currentKey, String id, URL url) {
        this.currentKey = currentKey;
        this.keys = keys;
        this.url = url;
        this.id = id;
    }

    public String getName() {
        return this.keys.get(this.currentKey);
    }

    public String getCurrentSearchKey() {
        return this.currentKey;
    }

    public PagePart applyKey(String name) {
        assert (this.keys.containsKey(name));
        PagePart result = this.clone();
        result.currentKey = name;
        return result;
    }

    public Set<String> getSearchKeys() {
        return new HashSet<String>(this.keys.keySet());
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PagePart) {
            PagePart otherPart = (PagePart)obj;
            return this.url.equals(otherPart.url);
        }
        return super.equals(obj);
    }

    public String toString() {
        return "Page " + this.id + " (" + this.getName() + ")";
    }

    protected PagePart clone() {
        try {
            return (PagePart)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int compareTo(PagePart part) {
        Collator collator = Collator.getInstance();
        return collator.compare(this.getName(), part.getName());
    }
}

