/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.webserver;

import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.util.NetUtil;
import com.selima.fbi.webserver.MailMessageResource;
import com.selima.fbi.webserver.PagePart;
import com.selima.fbi.webserver.StylesheetRepository;
import com.selima.fbi.webserver.WebServerException;
import com.selima.fbi.webserver.paye.CuttingRule;
import com.selima.fbi.webserver.paye.CuttingRules;
import com.selima.fbi.webserver.paye.DefaultRenderingMetadata;
import com.selima.fbi.webserver.paye.MetadataParser;
import com.selima.fbi.webserver.paye.PreprocessingThread;
import com.selima.fbi.webserver.paye.RenderingMetadata;
import com.selima.fbi.webserver.paye.StylesheetAnnotation;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;

class PAYEMessageResource
extends MailMessageResource {
    long executionTime;
    long numOfExecutions;
    Map<String, RenderingMetadata> renderingMetadata = new HashMap<String, RenderingMetadata>();

    PAYEMessageResource(IPAYEMessage message) throws WebServerException {
        super(message);
    }

    @Override
    Map<String, List<PagePart>> getPages() throws IOException {
        List<String> stylesheets = StylesheetRepository.get(this.message.getFormType(), this.message.getNamespace(), this.message.getTaxYearEnd(), this.message.getIssueDate());
        LinkedHashMap<String, List<PagePart>> result = new LinkedHashMap<String, List<PagePart>>(stylesheets.size());
        for (String stylesheet : stylesheets) {
            RenderingMetadata metadata = this.getRenderingMetadataOf(stylesheet);
            result.put(stylesheet, metadata.getPageParts());
        }
        return result;
    }

    @Override
    String getStylesheetPath(Map<String, Object> params) throws IOException {
        if (params.containsKey("transformation")) {
            return (String)params.get("transformation");
        }
        throw new IOException("HTTP Request lacks stylesheet specification");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeContent(Map<String, Object> params, Writer out) throws IOException {
        GregorianCalendar calendar = new GregorianCalendar();
        if (this.message.getIssueDate() != null) {
            calendar.setTime(this.message.getIssueDate());
            params.put("issueDate.day", calendar.get(5));
            params.put("issueDate.month", calendar.get(2) + 1);
            params.put("issueDate.year", calendar.get(1));
        } else {
            params.put("issueDate.day", "\u00a0");
            params.put("issueDate.month", "\u00a0");
            params.put("issueDate.year", "\u00a0");
        }
        long start = System.currentTimeMillis();
        try {
            super.writeContent(params, out);
        }
        finally {
            long time = System.currentTimeMillis() - start;
            this.executionTime += time;
            ++this.numOfExecutions;
            System.out.println("Content served in " + time + " ms, average " + this.executionTime / this.numOfExecutions);
        }
    }

    @Override
    Reader getReader(Map<String, Object> params) throws IOException {
        Reader reader = super.getReader(params);
        String stylesheet = this.getStylesheetPath(params);
        RenderingMetadata metadata = this.getRenderingMetadataOf(stylesheet);
        if (metadata.isRewritingNS() || metadata.isCuttingXML()) {
            reader = this.preprocessing(reader, metadata, (String)params.get("page"));
        }
        return reader;
    }

    RenderingMetadata getRenderingMetadataOf(String stylesheet) throws IOException {
        RenderingMetadata metadata = this.renderingMetadata.get(stylesheet);
        if (metadata == null) {
            metadata = this.createRenderingMetadata(stylesheet);
            this.renderingMetadata.put(stylesheet, metadata);
        }
        return metadata;
    }

    Reader preprocessing(Reader reader, RenderingMetadata metadata, String page) throws IOException {
        PreprocessingThread pt = new PreprocessingThread(reader, metadata.getRewriteFromNS(), metadata.getRewriteToNS(), metadata.getCuttingRules(page));
        reader = pt.getReader();
        pt.start();
        return reader;
    }

    RenderingMetadata createRenderingMetadata(String styleSheet) throws IOException {
        StylesheetAnnotation annotation = StylesheetAnnotation.find(this.resourceResolver, styleSheet);
        if (annotation != null) {
            String metadataStylesheet = annotation.getMetadataStylesheet();
            if (metadataStylesheet != null) {
                try {
                    PreprocessingThread pt = new PreprocessingThread(super.getReader(Collections.emptyMap()), annotation.getRewriteFromNS(), annotation.getRewriteToNS(), CuttingRules.find(this.resourceResolver, metadataStylesheet));
                    pt.start();
                    StringWriter writer = new StringWriter();
                    this.executor.renderXML(pt.getReader(), metadataStylesheet, writer);
                    ArrayList<PagePart> pages = new ArrayList<PagePart>();
                    HashMap<String, Set<CuttingRule>> rules = new HashMap<String, Set<CuttingRule>>();
                    MetadataParser.parseMetadata(new StringReader(writer.toString()), NetUtil.addURL(this.getURL(), "transformation", styleSheet), rules, pages);
                    return new DefaultRenderingMetadata(annotation.getRewriteFromNS(), annotation.getRewriteToNS(), pages, rules);
                }
                catch (XMLStreamException e) {
                    throw new IOException(e);
                }
            }
            return new DefaultRenderingMetadata(this.message.getSubject(), this.getURL(), annotation.getRewriteFromNS(), annotation.getRewriteToNS());
        }
        return new DefaultRenderingMetadata(this.message.getSubject(), this.getURL());
    }
}

