/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.webserver;

import com.selima.fbi.MailServiceConfig;
import com.selima.fbi.util.RewritingOutputStream;
import com.selima.fbi.webserver.LocalServerResource;
import com.selima.fbi.webserver.WebServerException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.HttpServer;
import org.mortbay.http.SocketListener;
import org.mortbay.util.MultiException;

class LocalServer {
    private static LocalServer server;
    private static String GONE_PAGE;
    private Random random = new Random(System.currentTimeMillis());
    private Map<String, Map<String, LocalServerResource>> resources;
    private SocketListener listener;
    private HttpServer httpServer = new HttpServer();

    LocalServer() {
        this.listener = new SocketListener();
        this.listener.setMaxThreads(12);
        this.httpServer.addListener((HttpListener)this.listener);
        this.resources = new HashMap<String, Map<String, LocalServerResource>>();
    }

    static LocalServer getInstance() {
        if (server == null) {
            server = new LocalServer();
        }
        return server;
    }

    static void destroyInstance() {
        if (server != null) {
            server.shutdown();
        }
        server = null;
    }

    void installResourceContext(String contextName) throws WebServerException {
        if (this.isContextInstalled(contextName)) {
            throw new IllegalArgumentException("Already have " + contextName + " context");
        }
        HttpContext context = new HttpContext();
        context.setContextPath(contextName);
        context.addHandler((HttpHandler)new ResourceHandler());
        this.httpServer.addContext(context);
        this.restartServer();
    }

    URL createResourceURL(String contextName, LocalServerResource resource) {
        HttpContext[] contexts = this.httpServer.getContexts();
        String contextPath = "/" + contextName;
        for (int i = 0; i < contexts.length; ++i) {
            if (!contexts[i].getContextPath().equals(contextPath)) continue;
            String key = this.storeResource(contextName, resource);
            try {
                URL url = new URL("http", "localhost", this.listener.getPort(), "/" + contextName + "?KEY=" + key);
                return url;
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
        }
        throw new IllegalArgumentException("There is not '" + contextName + "' context");
    }

    void deleteResourceURL(String contextName, LocalServerResource resource) {
        Map<String, LocalServerResource> contextResources = this.resources.get(contextName);
        Iterator<Map.Entry<String, LocalServerResource>> it = contextResources.entrySet().iterator();
        while (it.hasNext()) {
            if (it.next().getValue() != resource) continue;
            it.remove();
            break;
        }
    }

    void installClasspathContext(String contextName) throws WebServerException {
        if (this.isContextInstalled(contextName)) {
            throw new IllegalArgumentException("Already have " + contextName + " context");
        }
        HttpContext context = new HttpContext();
        context.setContextPath(contextName);
        context.addHandler((HttpHandler)new ClasspathHandler());
        this.httpServer.addContext(context);
        this.restartServer();
    }

    URL getClasspathURL(String contextName, String resourcePath) {
        try {
            return new URL("http", "localhost", this.listener.getPort(), "/" + contextName + resourcePath);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    void shutdown() {
        try {
            if (this.httpServer.isStarted()) {
                this.httpServer.stop();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    boolean isContextInstalled(String contextName) {
        String contextPath = "/" + contextName;
        for (HttpContext context : this.httpServer.getContexts()) {
            if (!context.getContextPath().equals(contextPath)) continue;
            return true;
        }
        return false;
    }

    URL getContextURL(String contextName) {
        URL result = null;
        if (!this.httpServer.isStarted() || this.isContextInstalled(contextName)) {
            // empty if block
        }
        try {
            result = new URL("http", "localhost", this.listener.getPort(), "/" + contextName);
        }
        catch (MalformedURLException ignore) {
            ignore.printStackTrace();
        }
        return result;
    }

    private String keyGenerator(Object keyedObject) {
        StringBuffer result = new StringBuffer(16);
        result.append(System.currentTimeMillis());
        result.append(keyedObject.hashCode());
        result.append(this.random.nextInt());
        return result.toString();
    }

    private String storeResource(String context, LocalServerResource resource) {
        Map<String, LocalServerResource> contextResources = this.resources.get(context);
        if (contextResources == null) {
            contextResources = new HashMap<String, LocalServerResource>();
            this.resources.put(context, contextResources);
        }
        String key = this.keyGenerator(resource);
        contextResources.put(key, resource);
        return key;
    }

    private LocalServerResource extractResource(String context, String key) {
        LocalServerResource result = null;
        Map<String, LocalServerResource> contextResources = this.resources.get(context);
        if (contextResources != null) {
            result = contextResources.get(key);
        }
        return result;
    }

    private void restartServer() throws WebServerException {
        try {
            if (this.httpServer.isStarted()) {
                this.httpServer.stop();
            }
            this.httpServer.start();
        }
        catch (MultiException e) {
            throw new WebServerException(e);
        }
        catch (InterruptedException e) {
            throw new WebServerException(e);
        }
    }

    static {
        GONE_PAGE = "<html><body><H1>Low Memory</H1>Unable to display page because of low memory conditions</body></html>";
    }

    private static class ClasspathHandler
    extends AbstractHttpHandler {
        private ClasspathHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleTemplate(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
            String mimeType;
            if (pathInContext.endsWith(".xsl")) {
                mimeType = "text/xml";
            } else {
                mimeType = this.getHttpContext().getMimeByExtension(pathInContext);
                if (pathInContext.endsWith(".properties") || pathInContext.endsWith(".xml")) {
                    response.setStatus(401);
                    return;
                }
            }
            response.setContentType(mimeType);
            URL url = MailServiceConfig.getResource(pathInContext.substring(1));
            if (url != null) {
                URLConnection connection = url.openConnection();
                try (InputStream in = connection.getInputStream();){
                    int cnt;
                    response.setDateField("Last-Modified", connection.getLastModified());
                    response.setStatus(200);
                    OutputStream out = response.getOutputStream();
                    if (mimeType.equals("text/html")) {
                        out = new RewritingOutputStream(out, "UTF-8");
                    }
                    byte[] buffer = new byte[4096];
                    while ((cnt = in.read(buffer)) != -1) {
                        out.write(buffer, 0, cnt);
                    }
                    if (mimeType.equals("text/html")) {
                        out.close();
                    }
                    out.flush();
                }
            } else {
                response.setStatus(404);
            }
        }
    }

    private class ResourceHandler
    extends AbstractHttpHandler {
        private ResourceHandler() {
        }

        @Override
        public void handleTemplate(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
            LocalServerResource resource = LocalServer.this.extractResource(this.context.getContextPath().substring(1), request.getParameter("KEY"));
            if (resource == null) {
                response.setStatus(410);
            } else {
                response.setContentType("text/html; CHARSET=UTF-8");
                response.setStatus(200);
            }
            OutputStreamWriter out = new OutputStreamWriter(response.getOutputStream(), "UTF-8");
            if (resource == null) {
                out.write(GONE_PAGE);
            } else {
                response.setDateField("Last-Modified", System.currentTimeMillis());
                resource.getContent(request.getParameterStringArrayMap(), out);
            }
            out.flush();
        }
    }

    private static abstract class AbstractHttpHandler
    implements HttpHandler {
        protected HttpContext context;
        protected boolean started;

        private AbstractHttpHandler() {
        }

        public void start() throws Exception {
            this.started = true;
        }

        public void stop() throws InterruptedException {
            this.started = false;
        }

        public boolean isStarted() {
            return this.started;
        }

        public void initialize(HttpContext context) {
            this.context = context;
        }

        public HttpContext getHttpContext() {
            return this.context;
        }

        public String getName() {
            return this.getClass().getName();
        }

        public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
            if (InetAddress.getByName(request.getRemoteHost()).isLoopbackAddress()) {
                this.handleTemplate(pathInContext, pathParams, request, response);
            } else {
                response.setStatus(401);
            }
            response.commit();
            request.setHandled(true);
        }

        protected abstract void handleTemplate(String var1, String var2, HttpRequest var3, HttpResponse var4) throws HttpException, IOException;
    }
}

