/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.webserver;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.CharBuffer;
import java.util.LinkedList;
import java.util.Queue;

class InjectingReader
extends FilterReader {
    Queue<Reader> readers = new LinkedList<Reader>();

    protected InjectingReader(Reader xmlbody, String prolog, String epilog) throws IOException {
        super(xmlbody);
        CharBuffer firstChars = CharBuffer.allocate(5);
        xmlbody.read(firstChars);
        String prefix = new String(firstChars.array(), 0, firstChars.position());
        if ("<?xml".equals(prefix)) {
            this.readers.add(new StringReader(prefix));
            this.readers.add(new XMLDeclarationReader(xmlbody));
            this.readers.add(new StringReader(prolog));
        } else {
            this.readers.add(new StringReader(prolog));
            this.readers.add(new StringReader(prefix));
        }
        this.readers.add(xmlbody);
        this.readers.add(new StringReader(epilog));
    }

    @Override
    public int read() throws IOException {
        while (!this.readers.isEmpty()) {
            int result = this.readers.peek().read();
            if (result == -1) {
                this.readers.remove();
                continue;
            }
            return result;
        }
        return -1;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int result = 0;
        boolean found = false;
        while (!this.readers.isEmpty() && len > 0) {
            int cnt = this.readers.peek().read(cbuf, off, len);
            if (cnt == -1) {
                this.readers.remove();
                continue;
            }
            found = true;
            result += cnt;
            off += cnt;
            len -= cnt;
        }
        return found ? result : -1;
    }

    static class XMLDeclarationReader
    extends FilterReader {
        boolean stop;

        protected XMLDeclarationReader(Reader in) {
            super(in);
        }

        @Override
        public int read() throws IOException {
            if (this.stop) {
                return -1;
            }
            int result = super.read();
            this.stop = result == 62;
            return result;
        }

        @Override
        public int read(char[] cbuf) throws IOException {
            return this.read(cbuf, 0, cbuf.length);
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int i = 0;
            int j = off;
            while (i < len) {
                int c = this.read();
                if (c == -1) {
                    return i == 0 ? -1 : i;
                }
                cbuf[j] = (char)c;
                ++i;
                ++j;
            }
            return len;
        }
    }
}

