/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    public static Date parseXsdDateTime(String timestamp) throws ParseException {
        Pattern pattern = Pattern.compile("-?(\\d{4}-\\d{2}-\\d{2})T(\\d{2}:\\d{2}:\\d{2})(\\.\\d{3})?(Z|(\\+|-)\\d{2}:\\d{2})?");
        Matcher matcher = pattern.matcher(timestamp);
        if (matcher.matches()) {
            String date = matcher.group(1);
            String time = matcher.group(2);
            String millis = matcher.group(3);
            String zone = matcher.group(4);
            StringBuilder format = new StringBuilder("yyyy-MM-dd hh:mm:ss");
            StringBuilder value = new StringBuilder(date).append(' ').append(time);
            if (millis != null) {
                format.append(".SSS");
                value.append(millis);
            }
            if (zone != null) {
                value.append("GMT");
                value.append("Z".equals(zone) ? "+00:00" : zone);
                format.append("z");
            }
            return new SimpleDateFormat(format.toString()).parse(value.toString());
        }
        throw new ParseException(timestamp, 0);
    }

    public static Date parseMalformedTPVS_MOVDate(String timestamp) throws ParseException {
        Pattern pattern = Pattern.compile("(\\d{4}-\\d{2}-\\d{2})T(\\d{2}:\\d{2}:\\d{2}:\\d{3})");
        Matcher matcher = pattern.matcher(timestamp);
        if (matcher.matches()) {
            String date = matcher.group(1);
            String time = matcher.group(2);
            return new SimpleDateFormat("yyyy-MM-dd hh:ss:mm:SSS").parse(date + " " + time);
        }
        return new SimpleDateFormat("yyyy/MM/dd hh:ss:mm:SSS").parse(timestamp);
    }

    public static CharSequence replace(CharSequence input, Map<String, String> replacements) {
        if (replacements == null || replacements.size() == 0) {
            throw new IllegalArgumentException(String.valueOf(replacements));
        }
        StringBuilder pattern = new StringBuilder();
        for (String key : replacements.keySet()) {
            pattern.append(key).append('|');
        }
        pattern.setLength(pattern.length() - 1);
        Matcher matcher = Pattern.compile(pattern.toString()).matcher(input);
        StringBuffer result = new StringBuffer(input.length() + 16);
        while (matcher.find()) {
            String match = matcher.group();
            matcher.appendReplacement(result, replacements.get(match));
        }
        matcher.appendTail(result);
        return result;
    }

    public static CharSequence loadTemplate(InputStream stream) {
        try {
            int cnt;
            InputStreamReader reader = new InputStreamReader(stream, "UTF-8");
            StringBuilder result = new StringBuilder(4096);
            char[] cbuff = new char[4096];
            while ((cnt = reader.read(cbuff)) > 0) {
                result.append(cbuff, 0, cnt);
            }
            StringBuilder stringBuilder = result;
            return stringBuilder;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static String trimToNull(String value) {
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        return value;
    }

    public static String taxYearString(int taxYearEnd) {
        int doubleDigitStartYear = (taxYearEnd - 1) % 100;
        int doubleDigitEndYear = taxYearEnd % 100;
        return doubleDigitStartYear + "-" + doubleDigitEndYear;
    }
}

