/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.util;

import com.selima.fbi.util.ResourceStorage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.htmlparser.Node;
import org.htmlparser.Tag;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.util.ParserException;

public class RewritingOutputStream
extends PipedOutputStream {
    private Pattern ABSOLUTE_URL_PATTERN = Pattern.compile("\\w+://.+");
    private String server;
    private String path;
    private RewritingThread thread;
    private Map<String, Rewriter> rmap;
    private Map<String, Injector> imap;
    private Map<String, Eraser> emap;
    private ResourceStorage os;

    public RewritingOutputStream(ResourceStorage os, File file) throws IOException {
        this();
        this.os = os;
        this.thread = new RewritingThread(file);
        this.thread.start();
    }

    public RewritingOutputStream(Writer writer) throws IOException {
        this();
        this.thread = new RewritingThread(writer);
        this.thread.start();
    }

    public RewritingOutputStream(OutputStream stream, String encoding) throws IOException {
        this();
        this.thread = new RewritingThread(new OutputStreamWriter(stream, encoding));
        this.thread.start();
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setServer(String server) {
        this.server = server;
    }

    private RewritingOutputStream() {
        this.initRewriters();
    }

    @Override
    public void close() throws IOException {
        super.close();
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    Rewriter getRewriter(Tag tag) {
        return tag.isEndTag() ? (Rewriter)null : this.rmap.get(tag.getTagName());
    }

    Injector getInjector(Tag tag) {
        return tag.isEndTag() ? this.imap.get(tag.getTagName()) : null;
    }

    Eraser getEraser(Tag tag) {
        return tag.isEndTag() ? (Eraser)null : this.emap.get(tag.getTagName());
    }

    void initRewriters() {
        this.rmap = new HashMap<String, Rewriter>();
        CharsetInjector charsetInjector = new CharsetInjector();
        Rewriter[] rw = new Rewriter[]{new StylesheetLinkRewriter(), new ImageRewriter(), new AnchorRewriter(), new DivRewriter(), charsetInjector};
        for (int i = 0; i < rw.length; ++i) {
            this.rmap.put(rw[i].getTagName(), rw[i]);
        }
        this.imap = new HashMap<String, Injector>();
        Injector[] inj = new Injector[]{charsetInjector};
        for (int i = 0; i < inj.length; ++i) {
            this.imap.put(inj[i].getBeforeCloseTagName(), inj[i]);
        }
        this.emap = new HashMap<String, Eraser>();
        Eraser[] ers = new Eraser[]{new JavascriptLinkEraser()};
        for (int i = 0; i < ers.length; ++i) {
            this.emap.put(ers[i].getErasedTagName(), ers[i]);
        }
    }

    String filterURL(String url) {
        if (url == null) {
            return null;
        }
        if ((url = url.replaceAll("&amp;", "&")).startsWith("mailto:")) {
            return url;
        }
        Matcher matcher = this.ABSOLUTE_URL_PATTERN.matcher(url);
        if (!matcher.matches()) {
            if (!url.startsWith("/") && this.path != null) {
                url = this.path + url;
            }
            if (url.startsWith("/") && this.server != null) {
                url = this.server + url;
            }
        }
        if (this.os != null) {
            url = this.os.filteredURL(url);
        }
        return url;
    }

    class JavascriptLinkEraser
    implements Eraser {
        JavascriptLinkEraser() {
        }

        @Override
        public String getErasedTagName() {
            return "A";
        }

        @Override
        public boolean haveToErase(Tag t) {
            String href = t.getAttribute("HREF");
            return href != null && href.startsWith("javascript:");
        }
    }

    class CloseWindowLinkEraser
    implements Eraser {
        CloseWindowLinkEraser() {
        }

        @Override
        public String getErasedTagName() {
            return "A";
        }

        @Override
        public boolean haveToErase(Tag t) {
            String href = t.getAttribute("HREF");
            return href != null && href.indexOf("window.close()") != -1;
        }
    }

    static interface Eraser {
        public String getErasedTagName();

        public boolean haveToErase(Tag var1);
    }

    class CharsetInjector
    implements Injector,
    Rewriter {
        boolean hasRewritten;

        CharsetInjector() {
        }

        @Override
        public String getBeforeCloseTagInjection() {
            return this.hasRewritten ? "" : "<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=UTF-8\">";
        }

        @Override
        public String getBeforeCloseTagName() {
            return "HEAD";
        }

        @Override
        public String getTagName() {
            return "META";
        }

        @Override
        public void rewriteTag(Tag tag) throws MalformedURLException {
            if ("Content-Type".equals(tag.getAttribute("http-equiv"))) {
                tag.setAttribute("CONTENT", "text/html; charset=UTF-8");
                this.hasRewritten = true;
            }
        }
    }

    static interface Injector {
        public String getBeforeCloseTagInjection();

        public String getBeforeCloseTagName();
    }

    class DivRewriter
    implements Rewriter {
        Pattern pattern = Pattern.compile("(.*url\\()([^\\)]+)(\\).*)");

        DivRewriter() {
        }

        @Override
        public String getTagName() {
            return "DIV";
        }

        @Override
        public void rewriteTag(Tag tag) throws MalformedURLException {
            Matcher matcher;
            String attribute = tag.getAttribute("STYLE");
            if (attribute != null && (matcher = this.pattern.matcher(attribute)).matches()) {
                String rewrittenURL = RewritingOutputStream.this.filterURL(matcher.group(2));
                rewrittenURL = rewrittenURL.replace(")", "%29").replace("(", "%28");
                tag.setAttribute("STYLE", matcher.group(1) + rewrittenURL + matcher.group(3));
            }
        }
    }

    class AnchorRewriter
    implements Rewriter {
        AnchorRewriter() {
        }

        @Override
        public String getTagName() {
            return "A";
        }

        @Override
        public void rewriteTag(Tag tag) throws MalformedURLException {
            tag.setAttribute("HREF", RewritingOutputStream.this.filterURL(tag.getAttribute("HREF")));
        }
    }

    class ImageRewriter
    implements Rewriter {
        ImageRewriter() {
        }

        @Override
        public String getTagName() {
            return "IMG";
        }

        @Override
        public void rewriteTag(Tag tag) throws MalformedURLException {
            tag.setAttribute("SRC", RewritingOutputStream.this.filterURL(tag.getAttribute("SRC")));
            tag.removeAttribute("WIDTH");
            tag.removeAttribute("HEIGHT");
        }
    }

    class StylesheetLinkRewriter
    implements Rewriter {
        StylesheetLinkRewriter() {
        }

        @Override
        public String getTagName() {
            return "LINK";
        }

        @Override
        public void rewriteTag(Tag tag) throws MalformedURLException {
            String url = RewritingOutputStream.this.filterURL(tag.getAttribute("HREF"));
            tag.setAttribute("HREF", url);
        }
    }

    static interface Rewriter {
        public String getTagName();

        public void rewriteTag(Tag var1) throws MalformedURLException;
    }

    class RewritingThread
    extends Thread {
        private File file;
        private Writer writer;
        private PipedOutputStream out;
        private PipedInputStream in;

        RewritingThread(File file) throws IOException {
            this(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), "UTF-8"));
            this.file = file;
        }

        RewritingThread(Writer out) throws IOException {
            super("RewritingThread");
            this.setPriority(1);
            this.in = new PipedInputStream(RewritingOutputStream.this);
            this.writer = out;
        }

        OutputStream getOutputStream() {
            return this.out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean error = false;
            try {
                Page page = new Page((InputStream)this.in, "UTF-8");
                Lexer lexer = new Lexer(page);
                Node node = lexer.nextNode();
                while (node != null) {
                    if (node instanceof Tag) {
                        Tag tag = (Tag)node;
                        Eraser ers = RewritingOutputStream.this.getEraser(tag);
                        if (ers != null && ers.haveToErase(tag)) {
                            Tag erasedNode = tag;
                            while (!(erasedNode instanceof Tag && tag.getTagName().equals(erasedNode.getTagName()) && erasedNode.isEndTag())) {
                                erasedNode = lexer.nextNode();
                            }
                        } else {
                            Rewriter rew;
                            Injector inj = RewritingOutputStream.this.getInjector(tag);
                            if (inj != null) {
                                this.writer.write(inj.getBeforeCloseTagInjection());
                            }
                            if ((rew = RewritingOutputStream.this.getRewriter(tag)) != null) {
                                try {
                                    rew.rewriteTag(tag);
                                }
                                catch (MalformedURLException url) {
                                    url.printStackTrace();
                                }
                            }
                            this.writer.write(node.toHtml());
                        }
                    } else {
                        this.writer.write(node.toHtml());
                    }
                    node = lexer.nextNode();
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                error = true;
            }
            catch (ParserException e) {
                e.printStackTrace();
                error = true;
            }
            catch (IOException e) {
                e.printStackTrace();
                error = true;
            }
            finally {
                if (this.file != null) {
                    try {
                        this.writer.close();
                    }
                    catch (IOException e) {}
                    if (error) {
                        this.file.delete();
                    }
                } else {
                    try {
                        this.writer.flush();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }
}

