/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Set;

public class IOUtil {
    public static File uniqueFile(File file, Set<File> usedFiles) {
        if (!usedFiles.contains(file)) {
            return file;
        }
        File dir = file.getParentFile();
        String extension = IOUtil.getExtension(file);
        String baseName = IOUtil.stripExtension(file);
        int j = 2;
        while (usedFiles.contains(file)) {
            file = new File(dir, baseName + '-' + j + extension);
            ++j;
        }
        usedFiles.add(file);
        return file;
    }

    public static String stripExtension(File file) {
        String fileName = file.getName();
        int extensionIndex = fileName.lastIndexOf(46);
        if (extensionIndex > 0 && extensionIndex < fileName.length() - 1) {
            return fileName.substring(0, extensionIndex);
        }
        return fileName;
    }

    public static String getExtension(File file) {
        String fileName = file.getName();
        int extensionIndex = fileName.lastIndexOf(46);
        if (extensionIndex > 0 && extensionIndex < fileName.length() - 1) {
            return fileName.substring(extensionIndex);
        }
        return "";
    }

    public static File setExtension(File file, String extension) {
        String fileName = file.getName();
        int extensionIndex = fileName.lastIndexOf(46);
        if (extensionIndex > 0 && extensionIndex < fileName.length() - 1) {
            return new File(file.getParentFile(), fileName.substring(0, extensionIndex) + extension);
        }
        return new File(file.getParentFile(), fileName + extension);
    }

    public static String idToFile(String id) {
        try {
            return URLEncoder.encode(id, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String fileToId(String fileName) {
        try {
            return URLDecoder.decode(fileName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File src, File dest) throws IOException {
        FileChannel foc = new FileOutputStream(dest).getChannel();
        FileChannel fic = new FileInputStream(src).getChannel();
        try {
            ByteBuffer buffer = ByteBuffer.allocateDirect(8096);
            while (fic.read(buffer) != -1 || buffer.position() > 0) {
                buffer.flip();
                foc.write(buffer);
                buffer.compact();
            }
        }
        finally {
            foc.close();
            fic.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(CharSequence content, String charset, File dest) throws IOException {
        CharsetEncoder encoder = Charset.forName(charset).newEncoder();
        CharBuffer charBuffer = CharBuffer.wrap(content);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8096);
        try (FileChannel channel = new FileOutputStream(dest).getChannel();){
            CoderResult result;
            do {
                if (!(result = encoder.encode(charBuffer, byteBuffer, true)).isOverflow() && !result.isUnderflow()) continue;
                byteBuffer.flip();
                channel.write(byteBuffer);
                byteBuffer.compact();
            } while (result == CoderResult.OVERFLOW);
            if (!result.isUnderflow()) {
                throw new IOException(result.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Reader reader, String charset, File dest) throws IOException {
        CharsetEncoder encoder = Charset.forName(charset).newEncoder();
        CharBuffer charBuffer = CharBuffer.allocate(4096);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8096);
        FileChannel channel = new FileOutputStream(dest).getChannel();
        try {
            boolean eof = false;
            while (true) {
                CoderResult result;
                int c;
                if (reader.ready() && charBuffer.hasRemaining()) {
                    c = reader.read();
                    if (c == -1) {
                        eof = true;
                    } else {
                        charBuffer.put((char)c);
                        continue;
                    }
                }
                if (!reader.ready() && charBuffer.position() == 0) {
                    c = reader.read();
                    if (c == -1) {
                        break;
                    }
                    charBuffer.put((char)c);
                }
                charBuffer.flip();
                do {
                    if (!(result = encoder.encode(charBuffer, byteBuffer, eof)).isOverflow() && !result.isUnderflow()) {
                        throw new IOException(result.toString());
                    }
                    byteBuffer.flip();
                    channel.write(byteBuffer);
                    byteBuffer.compact();
                } while (result == CoderResult.OVERFLOW);
                charBuffer.compact();
                if (eof) break;
            }
        }
        finally {
            channel.close();
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream src, File dest) throws IOException {
        FileOutputStream stream = new FileOutputStream(dest);
        FileChannel channel = stream.getChannel();
        try {
            try {
                ByteBuffer buffer = ByteBuffer.allocateDirect(8096);
                while (true) {
                    if (src.available() > 0 && buffer.hasRemaining()) {
                        buffer.put((byte)src.read());
                        continue;
                    }
                    buffer.flip();
                    channel.write(buffer);
                    buffer.clear();
                    if (src.available() != 0) continue;
                    int lastByte = src.read();
                    if (lastByte != -1) {
                        buffer.put((byte)lastByte);
                        continue;
                    }
                    break;
                }
            }
            finally {
                stream.close();
            }
        }
        finally {
            src.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File source, OutputStream output) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8096);
        try (FileChannel channel = new FileInputStream(source).getChannel();){
            while (channel.read(byteBuffer) > 0) {
                byteBuffer.flip();
                output.write(byteBuffer.array(), byteBuffer.position(), byteBuffer.remaining());
                byteBuffer.rewind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream src, OutputStream output) throws IOException {
        try {
            try {
                int cnt;
                byte[] buffer = new byte[8096];
                while ((cnt = src.read(buffer)) != -1) {
                    output.write(buffer, 0, cnt);
                }
            }
            finally {
                output.close();
            }
        }
        finally {
            src.close();
        }
    }
}

