/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.util;

import com.selima.framework.util.logging.LogAPI;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axis.message.MessageElement;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class DOMUtil {
    static DocumentBuilderFactory factory;

    public static final String toString(Node[] nodes) {
        StringBuffer result = new StringBuffer();
        for (Node node : nodes) {
            result.append(DOMUtil.toString(node));
            result.append("--------------------------------------------------------\n");
        }
        return result.toString();
    }

    public static final String toString(Node node) {
        DOMImplementation impl;
        if (node instanceof MessageElement) {
            MessageElement axisElement = (MessageElement)node;
            try {
                node = axisElement.getAsDOM();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (node.getOwnerDocument() == null && node instanceof Document) {
            Document doc = (Document)node;
            node = doc.getDocumentElement();
        }
        if ((impl = node.getOwnerDocument().getImplementation()).hasFeature("LS", "3.0")) {
            DOMImplementationLS implLS = (DOMImplementationLS)impl.getFeature("LS", "3.0");
            LSSerializer lsSerializer = implLS.createLSSerializer();
            lsSerializer.setNewLine("\n");
            lsSerializer.getDomConfig().setParameter("xml-declaration", true);
            lsSerializer.getDomConfig().setParameter("format-pretty-print", true);
            SerializerOutput serializer = new SerializerOutput();
            lsSerializer.write(node, serializer);
            return serializer.toString();
        }
        LogAPI.logWarning((String)("Incompatible DOMImplementation: " + impl.getClass().getName()));
        return null;
    }

    private static final class SerializerOutput
    implements LSOutput {
        private final ByteArrayOutputStream bytes = new ByteArrayOutputStream();

        private SerializerOutput() {
        }

        @Override
        public OutputStream getByteStream() {
            return this.bytes;
        }

        @Override
        public Writer getCharacterStream() {
            return null;
        }

        @Override
        public String getEncoding() {
            return "UTF-8";
        }

        @Override
        public String getSystemId() {
            return null;
        }

        @Override
        public void setByteStream(OutputStream byteStream) {
        }

        @Override
        public void setCharacterStream(Writer characterStream) {
        }

        @Override
        public void setEncoding(String encoding) {
        }

        @Override
        public void setSystemId(String systemId) {
        }

        public String toString() {
            try {
                return new String(this.bytes.toString("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

