/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.user;

import com.selima.fbi.plugin.IPayrollPlugin;
import com.selima.fbi.plugin.PluginType;
import com.selima.fbi.user.IEmpRefListener;
import com.selima.fbi.user.IUser;
import com.selima.fbi.user.UserRecord;
import com.selima.framework.threading.EventBroadcast;
import com.selima.framework.threading.EventBroadcastFactory;
import java.util.List;
import java.util.ListIterator;

public class UserImpl
extends UserRecord
implements IUser {
    String storeId;
    IPayrollPlugin plugin;
    PluginType defaultPluginType;
    EventBroadcast<IEmpRefListener> listeners = EventBroadcastFactory.createEventBroadcast(IEmpRefListener.class);

    public UserImpl(UserRecord userRecord) {
        super(userRecord);
    }

    public UserImpl() {
    }

    @Override
    public String[] getEmpRef() {
        List<String> list = super.getEmpRefList();
        return list.toArray(new String[list.size()]);
    }

    @Override
    public void addEmpRef(String empRef) {
        this.getEmpRefList().add(empRef);
        ((IEmpRefListener)this.listeners.getListener()).added(this, empRef, super.getEmpRefList().size() - 1);
    }

    @Override
    public void removeEmpRef(String empRef) {
        ListIterator<String> it = super.getEmpRefList().listIterator();
        while (it.hasNext()) {
            String ref = it.next();
            if (!ref.equals(empRef)) continue;
            it.remove();
            ((IEmpRefListener)this.listeners.getListener()).removed(this, ref, it.previousIndex());
        }
    }

    public void setDefaultPluginType(PluginType pluginType) {
        this.defaultPluginType = pluginType;
    }

    @Override
    public IPayrollPlugin getPayrollPlugin() {
        if (this.plugin == null) {
            PluginType type = this.getPluginType();
            try {
                this.plugin = type.pluginClass().newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return this.plugin;
    }

    @Override
    public void addEmpRefListener(IEmpRefListener listener) {
        this.listeners.addListener((Object)listener);
    }

    @Override
    public void removeEmpRefListener(IEmpRefListener listener) {
        this.listeners.removeListener((Object)listener);
    }

    @Override
    public String getStoreSpace() {
        return null;
    }

    @Override
    public String getStoreId() {
        return this.storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    @Override
    public void setPluginType(PluginType pluginType) {
        if (pluginType == this.defaultPluginType) {
            pluginType = null;
        }
        if (pluginType != this.pluginType) {
            super.setPluginType(pluginType);
            this.plugin = null;
        }
    }

    @Override
    public PluginType getPluginType() {
        PluginType result = super.getPluginType();
        if (result == null) {
            result = this.defaultPluginType;
        }
        return result;
    }
}

