/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.logdialog;

import com.selima.fbi.crypto.CryptoUtil;
import com.selima.fbi.ui.common.NullableSpinner;
import com.selima.fbi.ui.logdialog.AbstractForm;
import com.selima.fbi.ui.logdialog.LoginDialogContext;
import com.selima.fbi.user.PayrollServerSpec;
import java.awt.Component;
import java.io.IOException;
import java.util.Arrays;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class UniverseForm
extends AbstractForm {
    public static final String SCREEN = "+----------------------------------------------------------------------------------------------------------+\n| Title BOTH                10 10 15 15                                                                    |\n+----------------------+------------------------------------+----------------------+-----------------------+\n|                      |       UniverseHost                 |    UniverseHostField |   UniversePortField   |\n| GwLogo               |       WEST                         |    HORIZONTAL        |   EAST                |\n|                      |       0 3 5 3                      |     0 3 5 0          |   0 3 5 15            |\n|                      |                                    |     100%             |   0% 0%               |\n| HORIZONTAL           +------------------------------------+----------------------+-----------------------+\n| NORTH                |       UniverseAccount              |    UniverseAccountField                      |\n| 0 10 15 15           |       WEST                         |    HORIZONTAL                                |\n|                      |       0 3 5 3                      |    0 3 5 15                                  |\n|                      |                                    |                                              |\n|                      +------------------------------------+----------------------------------------------+\n|                      |       UniverseUser                 |    UniverseUserField                         |\n|                      |       WEST                         |    HORIZONTAL                                |\n|                      |       0 3 5 3                      |    0 3 5 15                                  |\n|                      |                                    |                                              |\n|                      +------------------------------------+----------------------------------------------+\n|                      |       UniversePassword             |    UniversePasswordField                     |\n|                      |       WEST                         |    HORIZONTAL                                |\n|                      |       0 3 5 3                      |    0 3 5 15                                  |\n|                      |                                    |                                              |\n|                      |                                    |                                              |\n+----------------------+------------------------------------+----------------------------------------------+\n| Back  SOUTHWEST                                           |   Login SOUTHEAST                            |\n|  15 10 10 15  0% 100%                                     |   15 0 10 15   0% 100%                       |\n+-----------------------------------------------------------+----------------------------------------------+";
    JTextField fldUniverseHost;
    JTextField fldUniverseUser;
    JTextField fldUniverseAccount;
    PortSpinner fldPort;
    JPasswordField fldUniversePassword;
    JButton btnBack;
    Preferences prefs;

    public UniverseForm(LoginDialogContext context) {
        super(context, SCREEN);
        String string;
        this.setName("universeForm");
        this.add((Component)new JLabel("Host [port]"), (Object)"UniverseHost");
        this.fldUniverseHost = new JTextField(8);
        this.add(this.fldUniverseHost, "UniverseHostField");
        this.fldPort = new PortSpinner();
        this.add(this.fldPort, "UniversePortField");
        this.add((Component)new JLabel("Account"), (Object)"UniverseAccount");
        this.fldUniverseAccount = new JTextField(8);
        this.add(this.fldUniverseAccount, "UniverseAccountField");
        this.add((Component)new JLabel("User"), (Object)"UniverseUser");
        this.fldUniverseUser = new JTextField(8);
        this.add(this.fldUniverseUser, "UniverseUserField");
        this.add((Component)new JLabel("Password"), (Object)"UniversePassword");
        this.fldUniversePassword = new JPasswordField(8);
        this.add(this.fldUniversePassword, "UniversePasswordField");
        this.btnBack = new JButton("Back");
        this.add(this.btnBack, "Back");
        this.btnBack.addActionListener(new AbstractForm.BackAction());
        this.prefs = "System".equals(Preferences.systemNodeForPackage(this.getClass()).get("store.node", "System")) ? Preferences.systemNodeForPackage(this.getClass()) : Preferences.userNodeForPackage(this.getClass());
        this.fldUniverseHost.setText(this.prefs.get("universe.host", ""));
        this.fldUniverseAccount.setText(this.prefs.get("universe.account", ""));
        this.fldUniverseUser.setText(this.prefs.get("universe.user", ""));
        int port = this.prefs.getInt("universe.port", -1);
        if (port >= 0) {
            this.fldPort.setPort(port);
        }
        if ((string = this.prefs.get("universe.password", "")).length() > 0) {
            this.fldUniversePassword.setText(CryptoUtil.decrypt(string));
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (JComponent field : Arrays.asList(this.fldUniverseHost, this.fldUniverseAccount, this.fldUniversePassword, this.fldUniverseUser, this.fldPort)) {
            field.setEnabled(enabled);
        }
    }

    PayrollServerSpec getUniverseStore() throws IOException {
        String host = this.fldUniverseHost.getText();
        String account = this.fldUniverseAccount.getText();
        String user = this.fldUniverseUser.getText();
        String password = new String(this.fldUniversePassword.getPassword());
        Integer port = this.fldPort.getPort();
        if ("".equals(account)) {
            throw new IOException("Universe Account not specified");
        }
        if ("".equals(user)) {
            throw new IOException("Universe User not specified");
        }
        return new PayrollServerSpec(host, account, user, password, port, null);
    }

    void savePreferences() {
        this.prefs.put("universe.host", this.fldUniverseHost.getText());
        this.prefs.put("universe.account", this.fldUniverseAccount.getText());
        this.prefs.put("universe.user", this.fldUniverseUser.getText());
        this.prefs.put("universe.password", CryptoUtil.encrypt(new String(this.fldUniversePassword.getPassword())));
        Integer port = this.fldPort.getPort();
        if (port != null) {
            this.prefs.putInt("universe.port", port);
        } else {
            this.prefs.remove("universe.port");
        }
    }

    static class PortSpinner
    extends NullableSpinner {
        PortSpinner() {
            super(1, 31438, 65535);
        }

        Integer getPort() {
            return (Integer)this.getValue();
        }

        void setPort(Integer port) {
            this.setValue(port);
        }
    }
}

