/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.logdialog;

import com.selima.fbi.CancelException;
import com.selima.fbi.MailServiceConfig;
import com.selima.fbi.service.MailServiceFactory;
import com.selima.fbi.storage.IStorageFactory;
import com.selima.fbi.storage.Transaction;
import com.selima.fbi.ui.logdialog.AbstractForm;
import com.selima.fbi.ui.logdialog.LoginDialog;
import com.selima.fbi.ui.logdialog.LoginDialogContext;
import com.selima.fbi.user.IUser;
import com.selima.fbi.user.UserManager;
import com.selima.framework.exception.BackendException;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.SwingOperationHandle;
import com.selima.framework.util.logging.LogAPI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboBoxEditor;

public class LoginForm
extends AbstractForm {
    public static final String SCREEN = "+----------------------------------------------------------------+\n| Title BOTH 10 10 15 15                                         |\n+------------+--------------+------------------------------------+\n| GwLogo     | User WEST    | UserComboBox HORIZONTAL            |\n| HORIZONTAL | 0 3 5 3  0%  |  0 3 5 15 100%                     |\n| NORTH      |              |                                    |\n| 0 10 15 15 +--------------+------------------------------------+\n|            | Password     | PasswordField                      |\n|            | WEST         | HORIZONTAL                         |\n|            | 0 3 5 3  0%  | 0 3 5 15  0%                       |\n|            |              |                                    |\n|            +--------------+------------------------------------+\n|            | Service      | ServiceComboBox                    |\n|            | WEST         | HORIZONTAL NORTH                   |\n|            | 0 3 5 3  0%  | 0 3 5 15  0%                       |\n|            |              |                                    |\n+------------+-----+--------+---------------------+--------------+\n| Proxy SOUTH      | Directory SOUTH              | Login        |\n| 20 10 10 3   0%  | 20 5 10 3   0%               | SOUTHEAST    |\n| 100%             | 100%                         | 20 0 10 15   |\n|                  |                              | 100% 100%    |\n+------------------+------------------------------+--------------+";
    JCheckBox chProxy;
    JCheckBox chStorage;
    JPasswordField fldPassword;
    JComboBox cmService;
    UserComboBox cmUser;

    public LoginForm(LoginDialogContext context) {
        super(context, SCREEN);
        this.setName("loginForm");
        this.add((Component)new JLabel("User"), (Object)"User");
        this.add((Component)new JLabel("Service"), (Object)"Service");
        this.add((Component)new JLabel("Password"), (Object)"Password");
        this.chProxy = new JCheckBox("Proxy Settings");
        this.add(this.chProxy, "Proxy");
        this.cmUser = new UserComboBox();
        this.add(this.resizable(this.cmUser), "UserComboBox");
        this.chStorage = new JCheckBox("FBI Storage");
        this.add(this.chStorage, "Directory");
        this.fldPassword = new JPasswordField();
        this.add(this.resizable(this.fldPassword), "PasswordField");
        this.cmService = new ServiceComboBox();
        this.add(this.resizable(this.cmService), "ServiceComboBox");
        this.btnLogin.setAction(new LoginAction());
    }

    <T extends JComponent> T resizable(T component) {
        Dimension size = component.getPreferredSize();
        size.width = 32;
        component.setMinimumSize(size);
        component.setPreferredSize(size);
        return component;
    }

    String getUsername() {
        return this.cmUser.getSelectedUser();
    }

    void setUsername(String text) {
        this.cmUser.setSelectedUser(text);
    }

    String getPassword() {
        return new String(this.fldPassword.getPassword());
    }

    void setPassword(String text) {
        this.fldPassword.setText(text);
    }

    String getAlias() {
        return (String)this.cmService.getSelectedItem();
    }

    void setAlias(String alias) {
        this.cmService.setSelectedItem(alias);
    }

    boolean isProxyChecked() {
        return this.chProxy.isSelected();
    }

    boolean isStorageChecked() {
        return this.chStorage.isSelected();
    }

    class SavePreferencesWork
    implements BackendWork {
        SavePreferencesWork() {
        }

        public String getName() {
            return "Book-keeping Last User";
        }

        public void invokeBackend(BackendOperationHandle handle) throws BackendException, CanceledException, InterruptedException {
            Preferences prefs = Preferences.userNodeForPackage(LoginDialog.class);
            String user = LoginForm.this.cmUser.getSelectedUser();
            if (user != null) {
                try {
                    LoginForm.this.context.getStorageFactory().setOuterSpace((String)LoginForm.this.cmService.getSelectedItem());
                    IUser realUser = new UserManager(LoginForm.this.context.getStorageFactory()).getUser(user);
                    if (realUser != null) {
                        user = realUser.getLogin();
                    }
                }
                catch (IOException e) {
                    LogAPI.logSevere((Throwable)e);
                }
                catch (CancelException e) {
                    throw new CanceledException((Exception)e);
                }
                prefs.put("Last-Accepted-User", user);
            }
        }

        public void invokeSwing(SwingOperationHandle handle) {
        }
    }

    class LoadPreferencesWork
    implements BackendWork {
        LoadPreferencesWork() {
        }

        public String getName() {
            return "Recalling Last Users";
        }

        public void invokeBackend(final BackendOperationHandle handle) throws CanceledException {
            Preferences prefs = Preferences.userNodeForPackage(LoginForm.class);
            final String login = prefs.get("Last-Accepted-User", null);
            final HashSet<String> users = new HashSet<String>();
            handle.setResult((Object)new Result(login, users));
            try {
                final IStorageFactory storageFactory = LoginForm.this.context.getStorageFactory();
                new Transaction(storageFactory).run(new Transaction.InteractionV0(){

                    @Override
                    public void run() throws IOException, CancelException {
                        for (String alias : MailServiceFactory.getAliases(MailServiceConfig.getInitParamaters())) {
                            storageFactory.setOuterSpace(alias);
                            UserManager userManager = new UserManager(storageFactory);
                            for (IUser user : userManager.getUsers()) {
                                String nick = user.getNick();
                                if (nick != null) {
                                    users.add(nick);
                                    if (!user.getLogin().equals(login)) continue;
                                    handle.setResult((Object)new Result(nick, users));
                                    continue;
                                }
                                users.add(user.getLogin());
                            }
                        }
                    }
                });
            }
            catch (IOException e) {
                LogAPI.logSevere((Throwable)e);
            }
            catch (CancelException e) {
                LogAPI.logSevere((Throwable)e);
                throw new CanceledException((Exception)e);
            }
        }

        public void invokeSwing(SwingOperationHandle handle) {
            if (handle.getFailure() != null) {
                LogAPI.logSevere((Throwable)handle.getFailure());
            } else {
                Result result = (Result)handle.getResult();
                if (result != null) {
                    LoginForm.this.cmUser.init(result.lastUser, result.users.toArray(new String[result.users.size()]));
                }
            }
        }

        class Result {
            String lastUser;
            Set<String> users;

            Result(String lastUser, Set<String> users) {
                this.lastUser = lastUser;
                this.users = users;
            }
        }
    }

    class UserComboBox
    extends JComboBox {
        UserComboBox() {
            super(new DefaultComboBoxModel());
            this.setEditable(true);
            this.setEditor(new BasicComboBoxEditor(){
                {
                    this.editor = new JTextField();
                    this.editor.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                }
            });
            super.setBorder(UIManager.getBorder("TextField.border"));
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public void setPreferredSize(Dimension preferredSize) {
            super.setPreferredSize(preferredSize);
        }

        void init(String lastUser, String[] allUsers) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
            String originalUser = ((JTextField)this.editor.getEditorComponent()).getText();
            for (String user : allUsers) {
                model.addElement(user);
            }
            if (originalUser != null && originalUser.length() > 0) {
                model.setSelectedItem(originalUser);
            } else {
                model.setSelectedItem(lastUser);
            }
        }

        public String getSelectedUser() {
            String result = (String)this.getSelectedItem();
            return "".equals(result) ? null : result;
        }

        public void setSelectedUser(String user) {
            this.setSelectedItem(user);
        }
    }

    class ServiceComboBox
    extends JComboBox {
        ServiceComboBox() {
            super(new ServiceComboBoxModel());
            this.setKeySelectionManager(new NoPrefixKeySelectionManager());
            super.setBorder(UIManager.getBorder("TextField.border"));
        }

        class NoPrefixKeySelectionManager
        implements JComboBox.KeySelectionManager {
            NoPrefixKeySelectionManager() {
            }

            public int selectionForKey(char aKey, ComboBoxModel aModel) {
                int start;
                for (start = 0; start < aModel.getSize(); ++start) {
                    if (aModel.getSelectedItem() != aModel.getElementAt(start)) continue;
                    ++start;
                    break;
                }
                int i = start % aModel.getSize();
                int counter = 0;
                while (counter < aModel.getSize()) {
                    String value = (String)aModel.getElementAt(i);
                    if (value != null && value.length() > 0 && (value.charAt(0) == aKey || Character.toLowerCase(value.charAt(0)) == Character.toLowerCase(aKey))) {
                        return i;
                    }
                    ++counter;
                    ++i;
                    i %= aModel.getSize();
                }
                return -1;
            }
        }
    }

    class ServiceComboBoxModel
    extends DefaultComboBoxModel {
        ServiceComboBoxModel() {
            super(MailServiceFactory.getAliases(MailServiceConfig.getInitParamaters()));
        }

        @Override
        public void setSelectedItem(Object anObject) {
            super.setSelectedItem(anObject);
        }
    }

    class LoginAction
    extends AbstractAction {
        LoginAction() {
            super("Login");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (this.isEnabled());
            if (LoginForm.this.cmUser.getSelectedUser() == null) {
                LoginForm.this.context.showErrorText("User credentials not supplied");
                return;
            }
            LoginForm.this.context.nextForm();
        }
    }
}

