/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.logdialog;

import com.selima.fbi.CancelException;
import com.selima.fbi.IMailServiceFacade;
import com.selima.fbi.MailServiceConfig;
import com.selima.fbi.loader.LoaderFactory;
import com.selima.fbi.saver.SaverFactory;
import com.selima.fbi.sender.ISenderDetailsManager;
import com.selima.fbi.sender.ISenderDetailsSource;
import com.selima.fbi.storage.ExtendedStorageFactory;
import com.selima.fbi.storage.IExtendedStorageFactorySPI;
import com.selima.fbi.storage.IStorageFactory;
import com.selima.fbi.storage.Transaction;
import com.selima.fbi.storage.file.FileStorageFactorySPI;
import com.selima.fbi.storage.migration.Migrations;
import com.selima.fbi.storage.migration.OldVersionException;
import com.selima.fbi.storage.transfer.StorageTransfer;
import com.selima.fbi.storage.uv.UvStorageFactorySPI;
import com.selima.fbi.ui.FocusLogger;
import com.selima.fbi.ui.logdialog.AbstractForm;
import com.selima.fbi.ui.logdialog.DirectoryForm;
import com.selima.fbi.ui.logdialog.InstallationCodeForm;
import com.selima.fbi.ui.logdialog.LoginContext;
import com.selima.fbi.ui.logdialog.LoginDialogContext;
import com.selima.fbi.ui.logdialog.LoginForm;
import com.selima.fbi.ui.logdialog.LoginWork;
import com.selima.fbi.ui.logdialog.LoginWorkContext;
import com.selima.fbi.ui.logdialog.ProxyForm;
import com.selima.fbi.ui.logdialog.ProxyFormContext;
import com.selima.fbi.ui.logdialog.UniverseForm;
import com.selima.fbi.user.IProxySettings;
import com.selima.fbi.user.IReferenceManager;
import com.selima.fbi.user.IUserManager;
import com.selima.fbi.user.PayrollServerSpec;
import com.selima.framework.exception.BackendException;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.ISubmitter;
import com.selima.framework.threading.SwingOperationHandle;
import com.selima.framework.util.logging.LogAPI;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.View;

public class LoginDialog
extends JDialog {
    LoginContext context;
    CardPanel cardPanel;
    MessageArea messages;
    DirectoryForm directoryForm;
    LoginForm loginForm;
    ProxyForm proxyForm;
    InstallationCodeForm codeForm;
    UniverseForm universeForm;
    boolean result;

    public LoginDialog(LoginContext context) {
        super(context.getMainWindow(), context.getMainWindow().getTitle(), true);
        this.context = context;
        this.setName("LoginDialog");
        this.setDefaultCloseOperation(1);
        this.messages = new MessageArea();
        this.getContentPane().add((Component)this.messages, "South");
        this.cardPanel = new CardPanel();
        this.loginForm = new LoginForm(new LoginFormContextImpl());
        this.cardPanel.add(this.loginForm);
        this.codeForm = new InstallationCodeForm(new CodeFormContextImpl());
        this.cardPanel.add(this.codeForm);
        this.directoryForm = new DirectoryForm(new DirectoryFormContextImpl());
        this.cardPanel.add(this.directoryForm);
        this.universeForm = new UniverseForm(new UniverseFormContextImpl());
        this.cardPanel.add(this.universeForm);
        this.proxyForm = new ProxyForm(new ProxyFormContextImpl());
        this.cardPanel.add(this.proxyForm);
        this.getContentPane().add((Component)this.cardPanel, "Center");
    }

    public boolean showDialog() {
        this.pack();
        this.setLocationRelativeTo(this.context.getMainWindow());
        BackendWork[] backendWorkArray = new BackendWork[4];
        backendWorkArray[0] = new RedirectLoggingWork();
        backendWorkArray[1] = new StorageFactoryWork();
        backendWorkArray[2] = new RedirectLoggingWork();
        backendWorkArray[3] = new LoginForm.LoadPreferencesWork(this.loginForm);
        this.work(new ShowDefaultContentWork(), false, backendWorkArray);
        this.setVisible(true);
        for (AbstractForm form : Arrays.asList(this.loginForm, this.codeForm, this.directoryForm, this.universeForm, this.proxyForm)) {
            form.detach();
        }
        return this.result;
    }

    void setInputEnabled(boolean state) {
        for (Container container : Arrays.asList(this.loginForm, this.codeForm, this.directoryForm, this.universeForm, this.proxyForm)) {
            container.setEnabled(state);
        }
    }

    void showMessage(String text) {
        Dimension sizeDiff = new Dimension();
        if (this.messages.isVisible()) {
            sizeDiff.height -= this.messages.getHeight();
        }
        this.messages.showMessage(text);
        if (this.messages.isVisible()) {
            Dimension prefSize = this.messages.getPreferredSize();
            sizeDiff.height += prefSize.height;
        }
        Dimension currentSize = this.getSize();
        currentSize.height += sizeDiff.height;
        this.setSize(currentSize);
        this.validate();
    }

    private void focusFirstComponent() {
        Container container = this.getContentPane().getFocusCycleRootAncestor();
        FocusTraversalPolicy policy = container.getFocusTraversalPolicy();
        Component comp = policy.getFirstComponent(container);
        comp.requestFocusInWindow();
    }

    BackendWork createLoginWork(IProxySettings proxySettings) {
        return new LoginWork(new LoginWorkContextImpl(proxySettings));
    }

    private void showErrorText(final String text) {
        Timer timer = new Timer(250, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginDialog.this.showMessage(text);
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    private void showForm(JComponent form) {
        this.cardPanel.show(form);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LoginDialog.this.focusFirstComponent();
            }
        });
    }

    String getStorageFactoryDescription() {
        if (this.directoryForm.isSelectedUniverseStore()) {
            try {
                PayrollServerSpec universe = this.universeForm.getUniverseStore();
                return universe.getHostOrLocalhost() + "(" + universe.getAccount() + ")";
            }
            catch (IOException e) {
                return "Universe server";
            }
        }
        return new File(MailServiceConfig.getBaseDir(), "message-box").getPath();
    }

    ExtendedStorageFactory createStorageFactory() throws IOException, CancelException {
        IExtendedStorageFactorySPI spi;
        File baseDir = this.directoryForm.getDirectory();
        if (!MailServiceConfig.getBaseDir().equals(baseDir)) {
            MailServiceConfig.setBaseDir(baseDir);
        }
        this.directoryForm.savePreferences();
        this.universeForm.savePreferences();
        if (this.directoryForm.isSelectedUniverseStore()) {
            spi = new UvStorageFactorySPI(MailServiceConfig.getInitParamaters(), this.universeForm.getUniverseStore(), new LoaderFactory(), new SaverFactory());
            ((UvStorageFactorySPI)spi).initialize();
        } else {
            spi = new FileStorageFactorySPI(MailServiceConfig.getInitParamaters(), new LoaderFactory(), new SaverFactory());
        }
        ExtendedStorageFactory result = new ExtendedStorageFactory(spi);
        return result;
    }

    private void work(final BackendWork finalWork, final boolean disableControls, final BackendWork ... work) {
        if (disableControls) {
            this.setInputEnabled(false);
        }
        this.context.getSubmitter().submitWork(new BackendWork(){

            public String getName() {
                return work[0].getName();
            }

            public void invokeBackend(BackendOperationHandle handle) throws BackendException, CanceledException, InterruptedException {
                work[0].invokeBackend(handle);
            }

            public void invokeSwing(SwingOperationHandle handle) {
                work[0].invokeSwing(handle);
                if (handle.getFailure() == null && work.length > 1) {
                    LoginDialog.this.work(finalWork, disableControls, Arrays.copyOfRange(work, 1, work.length));
                } else {
                    if (disableControls) {
                        LoginDialog.this.setInputEnabled(true);
                    }
                    if (finalWork != null) {
                        LoginDialog.this.context.getSubmitter().submitWork(finalWork);
                    }
                }
            }
        });
    }

    static class CardPanel
    extends JPanel {
        Component displayedComponent;

        public CardPanel() {
            super(new CardLayout());
            this.setOpaque(true);
        }

        @Override
        public void setLayout(LayoutManager mgr) {
            if (!(mgr instanceof CardLayout)) {
                throw new IllegalArgumentException(String.valueOf(mgr));
            }
            super.setLayout(mgr);
        }

        @Override
        protected void addImpl(Component comp, Object constraints, int index) {
            if (index != -1) {
                throw new IllegalArgumentException(String.valueOf(index));
            }
            if (constraints != null) {
                throw new IllegalArgumentException(String.valueOf(constraints));
            }
            if (comp.getName() == null) {
                throw new IllegalArgumentException("Unnamed component");
            }
            if (this.getComponentCount() == 0) {
                this.displayedComponent = comp;
            }
            super.addImpl(comp, comp.getName(), index);
        }

        void show(Component component) {
            this.displayedComponent = component;
            this.getCardLayout().show(this, component.getName());
            component.repaint();
        }

        Component getDisplayedComponent() {
            return this.displayedComponent;
        }

        private CardLayout getCardLayout() {
            return (CardLayout)super.getLayout();
        }
    }

    class CodeFormContextImpl
    extends LoginDialogContextImpl {
        CodeFormContextImpl() {
        }

        @Override
        public void nextForm() {
            long installationCode = LoginDialog.this.codeForm.getInstallationCode();
            if (!this.valid(installationCode)) {
                this.showErrorText("Invalid installation code. Ask your customer support to obtain a valid code.");
                return;
            }
            super.nextForm();
        }

        private boolean valid(long enteredNumber) {
            try {
                double currentDate = Double.parseDouble(LocalDate.now().format(DateTimeFormatter.ofPattern("ddMMyyyy")));
                double pi = 3.14159;
                long expectedNumber = (long)(currentDate / pi);
                return enteredNumber == expectedNumber;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }

    class UniverseFormContextImpl
    extends LoginDialogContextImpl {
        UniverseFormContextImpl() {
        }

        @Override
        public void nextForm() {
            try {
                LoginDialog.this.universeForm.getUniverseStore();
                super.nextForm();
            }
            catch (IOException e) {
                this.showErrorText(e.getMessage());
                return;
            }
        }
    }

    class DirectoryFormContextImpl
    extends LoginDialogContextImpl {
        DirectoryFormContextImpl() {
        }

        @Override
        public void nextForm() {
            try {
                LoginDialog.this.directoryForm.getDirectory();
                super.nextForm();
            }
            catch (IOException e) {
                this.showErrorText(e.getMessage());
            }
        }
    }

    class ProxyFormContextImpl
    extends LoginDialogContextImpl
    implements ProxyFormContext {
        ProxyFormContextImpl() {
        }

        @Override
        public IUserManager getUserManager() {
            return LoginDialog.this.context.getUserManager();
        }

        @Override
        public String getUsername() {
            return LoginDialog.this.loginForm.getUsername();
        }

        @Override
        public String getServiceAlias() {
            return LoginDialog.this.loginForm.getAlias();
        }
    }

    class LoginWorkContextImpl
    extends LoginDialogContextImpl
    implements LoginWorkContext {
        IProxySettings proxySettings;

        public LoginWorkContextImpl(IProxySettings proxySettings) {
            this.proxySettings = proxySettings;
        }

        @Override
        public void loggedInCallBack(IMailServiceFacade facade) {
            LoginDialog.this.context.setMailService(facade);
            LoginDialog.this.result = true;
            LoginDialog.this.setVisible(false);
        }

        @Override
        public void showProxyForm() {
            LoginDialog.this.showForm(LoginDialog.this.proxyForm);
        }

        @Override
        public void showLoginForm() {
            LoginDialog.this.showForm(LoginDialog.this.loginForm);
        }

        @Override
        public IProxySettings getProxySettings() {
            return this.proxySettings;
        }

        @Override
        public IUserManager getUserManager() {
            return LoginDialog.this.context.getUserManager();
        }

        @Override
        public Component getComponent() {
            return LoginDialog.this;
        }

        @Override
        public String getPassword() {
            return LoginDialog.this.loginForm.getPassword();
        }

        @Override
        public String getUsername() {
            return LoginDialog.this.loginForm.getUsername();
        }

        @Override
        public String getTitle() {
            return LoginDialog.this.getTitle();
        }

        @Override
        public String getAlias() {
            return LoginDialog.this.loginForm.getAlias();
        }

        @Override
        public ISenderDetailsManager getSenderDetailsManager() {
            return LoginDialog.this.context.getSenderDetailsManager();
        }

        @Override
        public ISenderDetailsSource getSenderDetailsSource() {
            return LoginDialog.this.context.getSenderDetailsSource();
        }

        @Override
        public IReferenceManager getReferenceManager() {
            return LoginDialog.this.context.getReferenceManager();
        }
    }

    class LoginFormContextImpl
    extends LoginDialogContextImpl {
        LoginFormContextImpl() {
        }

        @Override
        public void nextForm() {
            if (this.getStorageFactory() != null) {
                this.getStorageFactory().setOuterSpace(LoginDialog.this.loginForm.getAlias());
            }
            super.nextForm();
        }
    }

    class LoginDialogContextImpl
    implements LoginDialogContext {
        LoginDialogContextImpl() {
        }

        @Override
        public void showErrorText(String text) {
            LoginDialog.this.showErrorText(text);
        }

        @Override
        public ISubmitter getSubmitter() {
            return LoginDialog.this.context.getSubmitter();
        }

        @Override
        public IStorageFactory getStorageFactory() {
            return LoginDialog.this.context.getStorageFactory();
        }

        @Override
        public void nextForm() {
            if (LoginDialog.this.loginForm == LoginDialog.this.cardPanel.getDisplayedComponent()) {
                if (LoginDialog.this.loginForm.isStorageChecked()) {
                    LoginDialog.this.showForm(LoginDialog.this.codeForm);
                } else if (LoginDialog.this.loginForm.isProxyChecked()) {
                    LoginDialog.this.showForm(LoginDialog.this.codeForm);
                } else {
                    this.runLoginWork();
                }
            } else if (LoginDialog.this.codeForm == LoginDialog.this.cardPanel.getDisplayedComponent()) {
                if (LoginDialog.this.loginForm.isStorageChecked()) {
                    LoginDialog.this.showForm(LoginDialog.this.directoryForm);
                } else if (LoginDialog.this.loginForm.isProxyChecked()) {
                    LoginDialog.this.showForm(LoginDialog.this.proxyForm);
                }
            } else if (LoginDialog.this.directoryForm == LoginDialog.this.cardPanel.getDisplayedComponent()) {
                if (LoginDialog.this.directoryForm.isSelectedUniverseStore()) {
                    LoginDialog.this.showForm(LoginDialog.this.universeForm);
                } else if (LoginDialog.this.loginForm.isProxyChecked()) {
                    LoginDialog.this.showForm(LoginDialog.this.proxyForm);
                } else {
                    this.runLoginWork();
                }
            } else if (LoginDialog.this.universeForm == LoginDialog.this.cardPanel.getDisplayedComponent()) {
                if (LoginDialog.this.loginForm.isProxyChecked()) {
                    LoginDialog.this.showForm(LoginDialog.this.proxyForm);
                } else {
                    this.runLoginWork();
                }
            } else if (LoginDialog.this.proxyForm == LoginDialog.this.cardPanel.getDisplayedComponent()) {
                this.runLoginWork(LoginDialog.this.proxyForm.getProxySettings());
            }
            this.showErrorText(null);
        }

        @Override
        public void prevForm() {
            if (LoginDialog.this.directoryForm == LoginDialog.this.cardPanel.getDisplayedComponent()) {
                LoginDialog.this.showForm(LoginDialog.this.loginForm);
            } else if (LoginDialog.this.universeForm == LoginDialog.this.cardPanel.getDisplayedComponent()) {
                LoginDialog.this.showForm(LoginDialog.this.directoryForm);
            } else if (LoginDialog.this.proxyForm == LoginDialog.this.cardPanel.getDisplayedComponent()) {
                if (LoginDialog.this.loginForm.isStorageChecked()) {
                    if (LoginDialog.this.directoryForm.isSelectedUniverseStore()) {
                        LoginDialog.this.showForm(LoginDialog.this.universeForm);
                    } else {
                        LoginDialog.this.showForm(LoginDialog.this.directoryForm);
                    }
                } else {
                    LoginDialog.this.showForm(LoginDialog.this.loginForm);
                }
            } else if (LoginDialog.this.codeForm == LoginDialog.this.cardPanel.getDisplayedComponent()) {
                LoginDialog.this.showForm(LoginDialog.this.loginForm);
            }
            this.showErrorText(null);
        }

        private void runLoginWork(IProxySettings proxySettings) {
            BackendWork[] backendWorkArray = new BackendWork[5];
            backendWorkArray[0] = new RedirectLoggingWork();
            backendWorkArray[1] = new StorageFactoryWork();
            backendWorkArray[2] = new RedirectLoggingWork();
            backendWorkArray[3] = new LoginForm.SavePreferencesWork(LoginDialog.this.loginForm);
            backendWorkArray[4] = LoginDialog.this.createLoginWork(proxySettings);
            LoginDialog.this.work(null, true, backendWorkArray);
        }

        private void runLoginWork() {
            this.runLoginWork(null);
        }
    }

    class MessageArea
    extends JTextArea {
        MessageArea() {
            this.setOpaque(false);
            this.setVisible(false);
            this.setLineWrap(true);
            this.setEditable(false);
            this.setFocusable(false);
            this.setWrapStyleWord(true);
            this.setForeground(Color.RED);
            this.setBorder(BorderFactory.createEmptyBorder(2, 15, 15, 15));
        }

        void showMessage(String text) {
            if (text == null || text.length() == 0) {
                this.setVisible(false);
            } else {
                this.setText(text);
                this.setVisible(true);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            Container parent = this.getParent();
            if (parent == null) {
                return super.getPreferredSize();
            }
            Dimension size = this.getSize();
            Insets insets = this.getInsets();
            Insets parentInsets = parent.getInsets();
            size.width = parent.getWidth() - insets.left - insets.right - parentInsets.left - parentInsets.right;
            View view = this.getUI().getRootView(this);
            view.setSize(size.width, Float.MAX_VALUE);
            size.height = (int)view.getPreferredSpan(1);
            size.height += insets.top + insets.bottom;
            size.width += insets.left + insets.right;
            return size;
        }
    }

    class RedirectLoggingWork
    implements BackendWork {
        RedirectLoggingWork() {
        }

        public String getName() {
            return "Redirecting log to the " + MailServiceConfig.getBaseDir().getPath();
        }

        public void invokeBackend(BackendOperationHandle handle) {
            try {
                LogAPI.init((InputStream)MailServiceConfig.getLoggingProperties());
                new FocusLogger();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void invokeSwing(SwingOperationHandle handle) {
        }
    }

    private final class StorageFactoryWork
    implements BackendWork {
        private StorageFactoryWork() {
        }

        public String getName() {
            return "Checking FBI Storage";
        }

        public void invokeBackend(BackendOperationHandle handle) throws CanceledException {
            try {
                final ExtendedStorageFactory futureFactory = LoginDialog.this.createStorageFactory();
                if (LoginDialog.this.context.getStorageFactory() != null) {
                    IExtendedStorageFactorySPI futureSpi;
                    boolean shouldTransfer;
                    ExtendedStorageFactory formerFactory = (ExtendedStorageFactory)LoginDialog.this.context.getStorageFactory();
                    IExtendedStorageFactorySPI formerSpi = formerFactory.getStorageFactorySPI();
                    boolean bl = shouldTransfer = !formerSpi.isSameLocation(futureSpi = futureFactory.getStorageFactorySPI());
                    if (shouldTransfer) {
                        try {
                            shouldTransfer = formerSpi.containsAnyData();
                        }
                        catch (IOException e) {
                            LogAPI.logSevere((Throwable)e);
                        }
                    }
                    if (shouldTransfer) {
                        int messageType;
                        String message;
                        if (futureSpi.containsAnyData()) {
                            message = "<html><div style='width:250px'><p>Do you want to copy current FBI data from </p><p style='margin-top:5px'><b>" + this.wrap(formerFactory.getName(), 40) + "</b></p><p style='color:red;margin-top:5px'><b> replacing all current content of </b></p><p style='margin-top:5px'><b>" + this.wrap(futureFactory.getName(), 40) + "</b>?</p></div></html>";
                            messageType = 2;
                        } else {
                            message = "<html><div style='width:250px'>Do you want to copy current FBI data from <br><p style='margin-top:5px'><b>" + this.wrap(formerFactory.getName(), 40) + "</b></p><p style='margin-top:5px'>to <b>" + this.wrap(futureFactory.getName(), 40) + "</b>?</p></div></html>";
                            messageType = 3;
                        }
                        switch (JOptionPane.showConfirmDialog(LoginDialog.this, message, LoginDialog.this.context.getTitle(), 1, messageType)) {
                            case 2: {
                                throw new CanceledException("Transfer dialog canceled");
                            }
                            case 0: {
                                final ExtendedStorageFactory sourceFactory = new ExtendedStorageFactory(formerSpi);
                                new Transaction(sourceFactory).run(new Transaction.InteractionV0(){

                                    @Override
                                    public void run() throws IOException, CancelException {
                                        new Transaction(futureFactory).run(new Transaction.InteractionV0(){

                                            @Override
                                            public void run() throws IOException, CancelException {
                                                new StorageTransfer(sourceFactory, futureFactory).run();
                                            }
                                        });
                                    }
                                });
                                return;
                            }
                        }
                    }
                }
                new Transaction(futureFactory).run(new Transaction.InteractionV1<OldVersionException>(){

                    @Override
                    public void run() throws IOException, OldVersionException, CancelException {
                        ExtendedStorageFactory fromFactory = new ExtendedStorageFactory(futureFactory.getStorageFactorySPI());
                        Migrations migrations = new Migrations(fromFactory, futureFactory);
                        if (migrations.areNeeded()) {
                            migrations.run();
                        }
                        LoginDialog.this.context.setStorageFactory(futureFactory);
                    }
                });
            }
            catch (IOException e) {
                LogAPI.logSevere((Throwable)e);
                handle.setFailure((Throwable)e);
            }
            catch (OldVersionException e) {
                LogAPI.logWarning((Throwable)e);
                handle.setFailure((Throwable)e);
            }
            catch (CancelException e) {
                LogAPI.logSevere((Throwable)e);
                throw new CanceledException((Exception)e);
            }
        }

        private String wrap(String text, int length) {
            String[] split = text.split(Pattern.quote(File.separator));
            StringBuilder result = new StringBuilder(split[0]);
            int offset = 0;
            for (int i = 1; i < split.length; ++i) {
                if (result.length() - offset > length) {
                    result.append(" ");
                    offset = result.length();
                }
                result.append(File.separator).append(split[i]);
            }
            return result.toString();
        }

        public void invokeSwing(SwingOperationHandle handle) {
            if (handle.getFailure() != null && !(handle.getFailure() instanceof CanceledException)) {
                String message = handle.getFailure().getMessage();
                message = message.substring(message.indexOf(":") + 1);
                LoginDialog.this.showErrorText(message + "\n(" + LoginDialog.this.getStorageFactoryDescription() + ")");
            }
        }
    }

    private class ShowDefaultContentWork
    implements BackendWork {
        private ShowDefaultContentWork() {
        }

        public String getName() {
            return "Loading default page";
        }

        public void invokeBackend(BackendOperationHandle handle) {
        }

        public void invokeSwing(SwingOperationHandle handle) {
            LoginDialog.this.context.showDefaultContent();
        }
    }
}

